/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.UnpackedImageData;
import org.esa.s3tbx.dataio.s3.LonLatFunction;

final class LonLatFunctionOpImage
extends PointOpImage {
    private LonLatFunction function;

    LonLatFunctionOpImage(RenderedImage lonImage, RenderedImage latImage, ImageLayout imageLayout, LonLatFunction function) {
        super(lonImage, latImage, imageLayout, null, true);
        this.function = function;
    }

    protected void computeRect(Raster[] sources, WritableRaster target, Rectangle targetRectangle) {
        int lonDataType = sources[0].getSampleModel().getDataType();
        int latDataType = sources[1].getSampleModel().getDataType();
        int targetDataType = target.getSampleModel().getDataType();
        PixelAccessor lonAcc = new PixelAccessor((RenderedImage)this.getSourceImage(0));
        PixelAccessor latAcc = new PixelAccessor((RenderedImage)this.getSourceImage(1));
        PixelAccessor targetAcc = new PixelAccessor((RenderedImage)((Object)this));
        UnpackedImageData lonPixels = lonAcc.getPixels(sources[0], targetRectangle, lonDataType, false);
        UnpackedImageData latPixels = latAcc.getPixels(sources[1], targetRectangle, lonDataType, false);
        UnpackedImageData targetPixels = targetAcc.getPixels((Raster)target, targetRectangle, targetDataType, true);
        if (lonDataType == 4 && latDataType == 4) {
            if (targetDataType == 4) {
                this.ff(lonPixels, latPixels, targetPixels, targetRectangle);
            } else if (targetDataType == 5) {
                this.fd(lonPixels, latPixels, targetPixels, targetRectangle);
            }
        } else if (lonDataType == 5 && latDataType == 5) {
            if (targetDataType == 4) {
                this.df(lonPixels, latPixels, targetPixels, targetRectangle);
            } else if (targetDataType == 5) {
                this.dd(lonPixels, latPixels, targetPixels, targetRectangle);
            }
        }
        targetAcc.setPixels(targetPixels);
    }

    private void dd(UnpackedImageData lonPixels, UnpackedImageData latPixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int lonLineStride = lonPixels.lineStride;
        int latLineStride = lonPixels.lineStride;
        int lonPixelStride = lonPixels.pixelStride;
        int latPixelStride = lonPixels.pixelStride;
        double[] lonData = lonPixels.getDoubleData(0);
        double[] latData = latPixels.getDoubleData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        double[] targetData = targetPixels.getDoubleData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int lonLineOffset = lonPixels.bandOffsets[0];
        int latLineOffset = latPixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        for (int y = 0; y < h; ++y) {
            int lonPixelOffset = lonLineOffset;
            int latPixelOffset = latLineOffset;
            lonLineOffset += lonLineStride;
            latLineOffset += latLineStride;
            int targetPixelOffset = targetLineOffset;
            targetLineOffset += targetLineStride;
            for (int x = 0; x < w; ++x) {
                double lat;
                double lon = lonData[lonPixelOffset];
                if (lon >= -180.0 && lon <= 180.0 && (lat = latData[latPixelOffset]) >= -90.0 && lat <= 90.0) {
                    targetData[targetPixelOffset] = this.function.getValue(lon, lat);
                }
                lonPixelOffset += lonPixelStride;
                latPixelOffset += latPixelStride;
                targetPixelOffset += targetPixelStride;
            }
        }
    }

    private void df(UnpackedImageData lonPixels, UnpackedImageData latPixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int lonLineStride = lonPixels.lineStride;
        int latLineStride = lonPixels.lineStride;
        int lonPixelStride = lonPixels.pixelStride;
        int latPixelStride = lonPixels.pixelStride;
        double[] lonData = lonPixels.getDoubleData(0);
        double[] latData = latPixels.getDoubleData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        float[] targetData = targetPixels.getFloatData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int lonLineOffset = lonPixels.bandOffsets[0];
        int latLineOffset = latPixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        for (int y = 0; y < h; ++y) {
            int lonPixelOffset = lonLineOffset;
            int latPixelOffset = latLineOffset;
            lonLineOffset += lonLineStride;
            latLineOffset += latLineStride;
            int targetPixelOffset = targetLineOffset;
            targetLineOffset += targetLineStride;
            for (int x = 0; x < w; ++x) {
                double lat;
                double lon = lonData[lonPixelOffset];
                if (lon >= -180.0 && lon <= 180.0 && (lat = latData[latPixelOffset]) >= -90.0 && lat <= 90.0) {
                    targetData[targetPixelOffset] = (float)this.function.getValue(lon, lat);
                }
                lonPixelOffset += lonPixelStride;
                latPixelOffset += latPixelStride;
                targetPixelOffset += targetPixelStride;
            }
        }
    }

    private void fd(UnpackedImageData lonPixels, UnpackedImageData latPixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int lonLineStride = lonPixels.lineStride;
        int latLineStride = lonPixels.lineStride;
        int lonPixelStride = lonPixels.pixelStride;
        int latPixelStride = lonPixels.pixelStride;
        float[] lonData = lonPixels.getFloatData(0);
        float[] latData = latPixels.getFloatData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        double[] targetData = targetPixels.getDoubleData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int lonLineOffset = lonPixels.bandOffsets[0];
        int latLineOffset = latPixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        for (int y = 0; y < h; ++y) {
            int lonPixelOffset = lonLineOffset;
            int latPixelOffset = latLineOffset;
            lonLineOffset += lonLineStride;
            latLineOffset += latLineStride;
            int targetPixelOffset = targetLineOffset;
            targetLineOffset += targetLineStride;
            for (int x = 0; x < w; ++x) {
                float lat;
                float lon = lonData[lonPixelOffset];
                if (lon >= -180.0f && lon <= 180.0f && (lat = latData[latPixelOffset]) >= -90.0f && lat <= 90.0f) {
                    targetData[targetPixelOffset] = this.function.getValue(lon, lat);
                }
                lonPixelOffset += lonPixelStride;
                latPixelOffset += latPixelStride;
                targetPixelOffset += targetPixelStride;
            }
        }
    }

    private void ff(UnpackedImageData lonPixels, UnpackedImageData latPixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int lonLineStride = lonPixels.lineStride;
        int latLineStride = lonPixels.lineStride;
        int lonPixelStride = lonPixels.pixelStride;
        int latPixelStride = lonPixels.pixelStride;
        float[] lonData = lonPixels.getFloatData(0);
        float[] latData = latPixels.getFloatData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        float[] targetData = targetPixels.getFloatData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int lonLineOffset = lonPixels.bandOffsets[0];
        int latLineOffset = latPixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        for (int y = 0; y < h; ++y) {
            int lonPixelOffset = lonLineOffset;
            int latPixelOffset = latLineOffset;
            lonLineOffset += lonLineStride;
            latLineOffset += latLineStride;
            int targetPixelOffset = targetLineOffset;
            targetLineOffset += targetLineStride;
            for (int x = 0; x < w; ++x) {
                float lat;
                float lon = lonData[lonPixelOffset];
                if (lon >= -180.0f && lon <= 180.0f && (lat = latData[latPixelOffset]) >= -90.0f && lat <= 90.0f) {
                    targetData[targetPixelOffset] = (float)this.function.getValue(lon, lat);
                }
                lonPixelOffset += lonPixelStride;
                latPixelOffset += latPixelStride;
                targetPixelOffset += targetPixelStride;
            }
        }
    }
}

