/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.util.XPathHelper;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class EarthExplorerManifest
implements Manifest {
    private final Document doc;
    private final XPathHelper xPathHelper;

    static Manifest createManifest(Document manifestDocument) {
        return new EarthExplorerManifest(manifestDocument);
    }

    private EarthExplorerManifest(Document manifestDocument) {
        this.doc = manifestDocument;
        XPath xPath = XPathFactory.newInstance().newXPath();
        this.xPathHelper = new XPathHelper(xPath);
    }

    @Override
    public final String getDescription() {
        return this.xPathHelper.getString("//File_Description", this.doc);
    }

    @Override
    public final ProductData.UTC getStartTime() {
        String utcString = this.xPathHelper.getString("//Start_Time", this.doc);
        try {
            return ProductData.UTC.parse((String)utcString, (String)"'UTC='yyyy-MM-dd'T'HH:mm:ss");
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    @Override
    public final ProductData.UTC getStopTime() {
        String utcString = this.xPathHelper.getString("//Stop_Time", this.doc);
        try {
            return ProductData.UTC.parse((String)utcString, (String)"'UTC='yyyy-MM-dd'T'HH:mm:ss");
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    @Override
    public final List<String> getFileNames(String schema) {
        String xPath = String.format("//Data_Object_Descriptor[Type='%s']", schema);
        NodeList nodeList = this.xPathHelper.getNodeList(xPath, this.doc);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node dataObjectDescriptorNode = nodeList.item(i);
            fileNames.add(this.xPathHelper.getString("Filename", dataObjectDescriptorNode));
        }
        return fileNames;
    }

    @Override
    public List<String> getFileNames(String[] excluded) {
        return null;
    }

    @Override
    public MetadataElement getMetadata() {
        MetadataElement manifestElement = new MetadataElement("Manifest");
        Node node = this.xPathHelper.getNode("//Earth_Explorer_Header", this.doc);
        manifestElement.addElement(EarthExplorerManifest.convertNodeToMetadataElement(node, new MetadataElement(node.getNodeName())));
        return manifestElement;
    }

    private static MetadataElement convertNodeToMetadataElement(Node sourceNode, MetadataElement targetElement) {
        NodeList childNodes = sourceNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (EarthExplorerManifest.hasElementChildNodes(node)) {
                MetadataElement element = new MetadataElement(node.getNodeName());
                EarthExplorerManifest.convertNodeToMetadataElement(node, element);
                targetElement.addElement(element);
                continue;
            }
            String nodeValue = node.getTextContent();
            ProductData textContent = ProductData.createInstance((String)nodeValue);
            MetadataAttribute attribute = new MetadataAttribute(node.getNodeName(), textContent, true);
            targetElement.addAttribute(attribute);
        }
        return targetElement;
    }

    private static boolean hasElementChildNodes(Node rootNode) {
        NodeList childNodes = rootNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }
}

