/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.s3tbx.dataio.s3.EarthExplorerManifest;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.ProductFactory;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.XfduManifest;
import org.esa.s3tbx.dataio.s3.util.ColorProvider;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.runtime.Config;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractProductFactory
implements ProductFactory {
    private final List<Product> openProductList = new ArrayList<Product>();
    private final Sentinel3ProductReader productReader;
    private final Logger logger;
    private static final Color[] uncertainty_colors = new Color[]{new Color(127, 0, 255), new Color(0, 0, 255), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 127, 0), new Color(255, 0, 0)};
    private final List<String> separatingDimensions;
    private volatile Manifest manifest;
    public static final String LOAD_PROFILE_TIE_POINTS = "s3tbx.reader.loadProfileTiePoints";

    public AbstractProductFactory(Sentinel3ProductReader productReader) {
        this.productReader = productReader;
        this.logger = Logger.getLogger(this.getClass().getSimpleName());
        this.separatingDimensions = new ArrayList<String>();
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected static Band copyBand(Band sourceBand, Product targetProduct, boolean copySourceImage) {
        return ProductUtils.copyBand((String)sourceBand.getName(), (Product)sourceBand.getProduct(), (Product)targetProduct, (boolean)copySourceImage);
    }

    protected static TiePointGrid copyBandAsTiePointGrid(Band sourceBand, Product targetProduct, int subSamplingX, int subSamplingY, float offsetX, float offsetY) {
        MultiLevelImage sourceImage = sourceBand.getGeophysicalImage();
        int w = sourceImage.getWidth();
        int h = sourceImage.getHeight();
        float[] tiePoints = sourceImage.getData().getSamples(0, 0, w, h, 0, new float[w * h]);
        String unit = sourceBand.getUnit();
        TiePointGrid tiePointGrid = new TiePointGrid(sourceBand.getName(), w, h, (double)offsetX, (double)offsetY, (double)subSamplingX, (double)subSamplingY, tiePoints, unit != null && unit.toLowerCase().contains("degree"));
        String description = sourceBand.getDescription();
        tiePointGrid.setDescription(description);
        tiePointGrid.setGeophysicalNoDataValue(sourceBand.getGeophysicalNoDataValue());
        tiePointGrid.setUnit(unit);
        targetProduct.addTiePointGrid(tiePointGrid);
        sourceImage.dispose();
        return tiePointGrid;
    }

    @Override
    public final Product createProduct() throws IOException {
        this.manifest = this.createManifest(this.getInputFile());
        List<String> fileNames = this.getFileNames(this.manifest);
        this.readProducts(fileNames);
        String productName = this.getProductName();
        String productType = productName.substring(0, 12);
        Product masterProduct = this.findMasterProduct();
        int w = this.getSceneRasterWidth(masterProduct);
        int h = masterProduct.getSceneRasterHeight();
        Product targetProduct = new Product(productName, productType, w, h, (ProductReader)this.productReader);
        this.changeTargetProductName(targetProduct);
        targetProduct.setFileLocation(this.getInputFile());
        targetProduct.setNumResolutionsMax(masterProduct.getNumResolutionsMax());
        if (masterProduct.getSceneGeoCoding() instanceof CrsGeoCoding) {
            ProductUtils.copyGeoCoding((Product)masterProduct, (Product)targetProduct);
        }
        targetProduct.getMetadataRoot().addElement(this.manifest.getMetadata());
        this.processProductSpecificMetadata(this.manifest.getMetadata().getElement("metadataSection"));
        for (Product p : this.openProductList) {
            MetadataElement productAttributes = new MetadataElement(p.getName());
            MetadataElement datasetAttributes = new MetadataElement("Dataset_Attributes");
            MetadataElement variableAttributes = new MetadataElement("Variable_Attributes");
            ProductUtils.copyMetadata((MetadataElement)p.getMetadataRoot().getElement("Global_Attributes"), (MetadataElement)datasetAttributes);
            for (MetadataElement element : p.getMetadataRoot().getElement("Variable_Attributes").getElements()) {
                variableAttributes.addElement(element.createDeepClone());
            }
            productAttributes.addElement(datasetAttributes);
            productAttributes.addElement(variableAttributes);
            targetProduct.getMetadataRoot().addElement(productAttributes);
        }
        this.addDataNodes(masterProduct, targetProduct);
        this.addSpecialVariables(masterProduct, targetProduct);
        this.setMasks(targetProduct);
        this.setTimes(targetProduct);
        this.setUncertaintyBands(targetProduct);
        if (targetProduct.getSceneGeoCoding() == null) {
            this.setGeoCoding(targetProduct);
        }
        this.setSceneTransforms(targetProduct);
        this.setBandGeoCodings(targetProduct);
        Product[] sourceProducts = this.openProductList.toArray(new Product[this.openProductList.size()]);
        this.setAutoGrouping(sourceProducts, targetProduct);
        return targetProduct;
    }

    protected void changeTargetProductName(Product targetProduct) {
    }

    protected void setSceneTransforms(Product product) {
    }

    protected void setBandGeoCodings(Product targetProduct) {
    }

    protected void setUncertaintyBands(Product product) {
        Band[] bands;
        for (Band band : bands = product.getBands()) {
            String bandName = band.getName();
            String errorBandName = bandName + "_err";
            String uncertaintyBandName = bandName + "_uncertainty";
            if (product.containsBand(errorBandName)) {
                Band errorBand = product.getBand(errorBandName);
                band.addAncillaryVariable((RasterDataNode)errorBand, new String[]{"error"});
                this.addUncertaintyImageInfo(errorBand);
                continue;
            }
            if (!product.containsBand(uncertaintyBandName)) continue;
            Band uncertaintyBand = product.getBand(uncertaintyBandName);
            band.addAncillaryVariable((RasterDataNode)uncertaintyBand, new String[]{"uncertainty"});
            this.addUncertaintyImageInfo(uncertaintyBand);
        }
    }

    protected void addUncertaintyImageInfo(Band band) {
        double minValue = band.getStx().getMinimum();
        double maxValue = band.getStx().getMaximum();
        double colorDist = (maxValue - minValue) / (double)(uncertainty_colors.length - 1);
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[uncertainty_colors.length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = new ColorPaletteDef.Point(minValue + (double)i * colorDist, uncertainty_colors[i]);
        }
        band.setImageInfo(new ImageInfo(new ColorPaletteDef(points)));
    }

    protected void processProductSpecificMetadata(MetadataElement metadataElement) {
    }

    protected int getSceneRasterWidth(Product masterProduct) {
        return masterProduct.getSceneRasterWidth();
    }

    protected void addSpecialVariables(Product masterProduct, Product targetProduct) throws IOException {
    }

    protected Product findMasterProduct() {
        return this.openProductList.get(0);
    }

    protected final List<Product> getOpenProductList() {
        return Collections.unmodifiableList(this.openProductList);
    }

    protected void setMasks(Product targetProduct) {
        Band[] bands = targetProduct.getBands();
        ColorProvider colorProvider = new ColorProvider();
        for (Band band : bands) {
            String bandName;
            SampleCoding sampleCoding = band.getSampleCoding();
            if (sampleCoding == null || (bandName = band.getName()).endsWith("_index")) continue;
            boolean isFlagBand = band.isFlagBand();
            for (int i = 0; i < sampleCoding.getNumAttributes(); ++i) {
                String sampleName = sampleCoding.getSampleName(i);
                int sampleValue = sampleCoding.getSampleValue(i);
                if ("spare".equals(sampleName)) continue;
                String expression = isFlagBand ? bandName + "." + sampleName : bandName + " == " + sampleValue;
                String maskName = bandName + "_" + sampleName;
                Color maskColor = colorProvider.getMaskColor(sampleName);
                targetProduct.addMask(maskName, expression, expression, maskColor, 0.5);
            }
        }
    }

    private void setTimes(Product targetProduct) {
        Product sourceProduct = this.findMasterProduct();
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
        if (targetProduct.getStartTime() == null) {
            targetProduct.setStartTime(this.manifest.getStartTime());
        }
        if (targetProduct.getEndTime() == null) {
            targetProduct.setEndTime(this.manifest.getStopTime());
        }
    }

    @Override
    public final void dispose() throws IOException {
        for (Product product : this.openProductList) {
            product.dispose();
        }
        this.openProductList.clear();
    }

    protected Band addBand(Band sourceBand, Product targetProduct) {
        return AbstractProductFactory.copyBand(sourceBand, targetProduct, true);
    }

    protected RasterDataNode addSpecialNode(Product masterProduct, Band sourceBand, Product targetProduct) {
        return null;
    }

    protected void setGeoCoding(Product targetProduct) throws IOException {
    }

    protected void configureTargetNode(Band sourceBand, RasterDataNode targetNode) {
    }

    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
        StringBuilder patternBuilder = new StringBuilder();
        for (Product sourceProduct : sourceProducts) {
            if (sourceProduct.getAutoGrouping() == null) continue;
            if (patternBuilder.length() > 0) {
                patternBuilder.append(":");
            }
            patternBuilder.append(sourceProduct.getAutoGrouping());
        }
        targetProduct.setAutoGrouping(patternBuilder.toString());
    }

    protected void addDataNodes(Product masterProduct, Product targetProduct) throws IOException {
        boolean loadProfileTiepoints = Config.instance((String)"s3tbx").load().preferences().getBoolean(LOAD_PROFILE_TIE_POINTS, false);
        int w = targetProduct.getSceneRasterWidth();
        int h = targetProduct.getSceneRasterHeight();
        for (Product sourceProduct : this.openProductList) {
            HashMap<String, String> mapping = new HashMap<String, String>();
            for (Band sourceBand : sourceProduct.getBands()) {
                if (sourceBand.getName().contains("orphan")) continue;
                RasterDataNode targetNode = null;
                if (sourceBand.getRasterWidth() == w && sourceBand.getRasterHeight() == h) {
                    targetNode = this.addBand(sourceBand, targetProduct);
                } else if (loadProfileTiepoints || !this.isProfileNode(sourceBand.getName())) {
                    targetNode = this.addSpecialNode(masterProduct, sourceBand, targetProduct);
                }
                if (targetNode == null) continue;
                this.configureTargetNode(sourceBand, targetNode);
                mapping.put(sourceBand.getName(), targetNode.getName());
            }
            this.copyMasks(sourceProduct, targetProduct, mapping);
        }
    }

    protected final void copyMasks(Product sourceProduct, Product targetProduct, Map<String, String> mapping) {
        ProductNodeGroup<Mask> maskGroup = this.prepareMasksForCopying((ProductNodeGroup<Mask>)sourceProduct.getMaskGroup());
        block0: for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            String name;
            Mask mask = (Mask)maskGroup.get(i);
            Mask.ImageType imageType = mask.getImageType();
            if (imageType != Mask.BandMathsType.INSTANCE || (name = mask.getName()).equals("spare")) continue;
            String expression = Mask.BandMathsType.getExpression((Mask)mask);
            for (String sourceBandName : mapping.keySet()) {
                if (!expression.contains(sourceBandName)) continue;
                String targetBandName = mapping.get(sourceBandName);
                if (!sourceBandName.equals(targetBandName)) {
                    name = name.replaceAll(sourceBandName, targetBandName);
                    expression = expression.replaceAll(sourceBandName, targetBandName);
                }
                String description = sourceProduct.getDisplayName() + "." + mask.getDisplayName();
                targetProduct.addMask(name, expression, description, mask.getImageColor(), mask.getImageTransparency());
                continue block0;
            }
        }
    }

    protected ProductNodeGroup<Mask> prepareMasksForCopying(ProductNodeGroup<Mask> maskGroup) {
        return maskGroup;
    }

    private void readProducts(List<String> fileNames) {
        for (String fileName : fileNames) {
            Product product = null;
            try {
                product = this.readProduct(fileName);
            }
            catch (IOException ioe) {
                this.logger.log(Level.WARNING, "Could not read " + fileName + "due to IOException");
            }
            if (product != null) {
                this.openProductList.add(product);
                continue;
            }
            this.logger.log(Level.WARNING, "Could not find " + fileName);
        }
    }

    protected Product readProduct(String fileName) throws IOException {
        File file = new File(this.getInputFileParentDirectory(), fileName);
        if (!file.exists()) {
            return null;
        }
        ProductReader reader = ProductIO.getProductReaderForInput((Object)file);
        if (reader == null) {
            String msg = MessageFormat.format("Cannot read file ''{0}''. No appropriate reader found.", fileName);
            this.logger.log(Level.SEVERE, msg);
            throw new IOException(msg);
        }
        Product product = reader.readProductNodes((Object)file, null);
        if (product == null) {
            String msg = MessageFormat.format("Cannot read file ''{0}''.", fileName);
            this.logger.log(Level.SEVERE, msg);
            throw new IOException(msg);
        }
        if (product.getNumBands() > 0) {
            product.setNumResolutionsMax(product.getBandAt(0).getSourceImage().getModel().getLevelCount());
        }
        return product;
    }

    protected final File getInputFile() {
        return this.productReader.getInputFile();
    }

    protected final File getInputFileParentDirectory() {
        return this.productReader.getInputFileParentDirectory();
    }

    protected final String getProductName() {
        return FileUtils.getFilenameWithoutExtension((File)this.getInputFileParentDirectory());
    }

    protected void addSeparatingDimensions(String[] suffixesForSeparatingDimensions) {
        for (String suffixForSeparatingDimension : suffixesForSeparatingDimensions) {
            if (this.separatingDimensions.contains(suffixForSeparatingDimension)) continue;
            this.separatingDimensions.add(suffixForSeparatingDimension);
        }
    }

    private boolean isProfileNode(String targetNodeName) {
        for (String suffixForSeparatingDimension : this.separatingDimensions) {
            if (!targetNodeName.contains("_" + suffixForSeparatingDimension + "_")) continue;
            return true;
        }
        return false;
    }

    protected abstract List<String> getFileNames(Manifest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest createManifest(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Document xmlDocument = this.createXmlDocument(inputStream);
            if (file.getName().equals("L1c_Manifest.xml")) {
                Manifest manifest = EarthExplorerManifest.createManifest(xmlDocument);
                return manifest;
            }
            Manifest manifest = XfduManifest.createManifest(xmlDocument);
            return manifest;
        }
    }

    private Document createXmlDocument(InputStream inputStream) throws IOException {
        String msg = "Cannot create document from manifest XML file.";
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            this.getLogger().log(Level.SEVERE, "Cannot create document from manifest XML file.", e);
            throw new IOException("Cannot create document from manifest XML file.", e);
        }
    }
}

