/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.mphchl;

import java.awt.Color;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.util.BitSetter;

public class MphChlUtils {
    private static final String CYANO_FLAG_NAME = "mph_cyano";
    private static final String CYANO_FLAG_DESCRIPTION = "Cyanobacteria dominated waters";
    private static final String FLOATING_FLAG_NAME = "mph_floating";
    private static final String FLOATING_FLAG_DESCRIPTION = "Floating vegetation or cyanobacteria on water surface";
    private static final String ADJACENCY_FLAG_NAME = "mph_adjacency";
    private static final String ADJACENCY_FLAG_DESCRIPTION = "Pixel suspect of adjacency effects";

    public static FlagCoding createMphChlFlagCoding(String flagId) {
        FlagCoding flagCoding = new FlagCoding(flagId);
        flagCoding.addFlag(CYANO_FLAG_NAME, BitSetter.setFlag((int)0, (int)0), CYANO_FLAG_DESCRIPTION);
        flagCoding.addFlag(FLOATING_FLAG_NAME, BitSetter.setFlag((int)0, (int)1), FLOATING_FLAG_DESCRIPTION);
        flagCoding.addFlag(ADJACENCY_FLAG_NAME, BitSetter.setFlag((int)0, (int)2), ADJACENCY_FLAG_DESCRIPTION);
        return flagCoding;
    }

    public static void setupMphChlBitmask(Product mphChlProduct) {
        int index = 0;
        int w = mphChlProduct.getSceneRasterWidth();
        int h = mphChlProduct.getSceneRasterHeight();
        Mask mask = Mask.BandMathsType.create((String)CYANO_FLAG_NAME, (String)CYANO_FLAG_DESCRIPTION, (int)w, (int)h, (String)"mph_chl_flags.mph_cyano", (Color)Color.cyan, (double)0.5);
        mphChlProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)FLOATING_FLAG_NAME, (String)FLOATING_FLAG_DESCRIPTION, (int)w, (int)h, (String)"mph_chl_flags.mph_floating", (Color)Color.green, (double)0.5);
        mphChlProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)ADJACENCY_FLAG_NAME, (String)ADJACENCY_FLAG_DESCRIPTION, (int)w, (int)h, (String)"mph_chl_flags.mph_adjacency", (Color)Color.red, (double)0.5);
        mphChlProduct.getMaskGroup().add(index, (ProductNode)mask);
    }

    public static int encodeFlags(boolean cyano_flag, boolean floating_flag, boolean adj_flag) {
        int flag = 0;
        if (cyano_flag) {
            flag |= 1;
        }
        if (floating_flag) {
            flag |= 2;
        }
        if (adj_flag) {
            flag |= 4;
        }
        return flag;
    }

    public static double computeChlExponential(double mph) {
        double exponent = 35.79 * mph;
        return 22.44 * Math.exp(exponent);
    }

    public static double computeChlPolynomial(double mph) {
        double mph_sq = mph * mph;
        double mph_p3 = mph_sq * mph;
        double mph_p4 = mph_sq * mph_sq;
        return 5.2392E9 * mph_p4 - 1.9524E8 * mph_p3 + 2464900.0 * mph_sq + 4017.2 * mph + 1.9726;
    }

    public static boolean isCyano(double SICF_peak, double SIPF_peak, double BAIR_peak) {
        return SICF_peak < 0.0 && SIPF_peak > 0.0 && BAIR_peak > 0.002;
    }

    public static boolean isCyano(double SICF_peak, double SIPF_peak) {
        return SICF_peak < 0.0 && SIPF_peak > 0.0;
    }

    public static void setToInvalid(WritableSample[] targetSamples, boolean exportMph) {
        targetSamples[0].set(Double.NaN);
        targetSamples[1].set(0.0);
        targetSamples[2].set(0.0);
        targetSamples[3].set(0.0);
        targetSamples[4].set(0.0);
        if (exportMph) {
            targetSamples[5].set(Double.NaN);
        }
    }

    public static double computeMph(double rBr_Max, double r_7, double r_14, double wl_max, double wl_7, double wl_14) {
        return rBr_Max - r_7 - (r_14 - r_7) * (wl_max - wl_7) / (wl_14 - wl_7);
    }
}

