/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.mphchl;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConvolveDescriptor;
import org.esa.s3tbx.mphchl.MphChlBasisOp;
import org.esa.s3tbx.mphchl.MphChlMerisOp;
import org.esa.s3tbx.mphchl.MphChlOlciOp;
import org.esa.s3tbx.mphchl.Sensor;
import org.esa.s3tbx.olci.radiometry.rayleigh.RayleighCorrectionOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.converters.BooleanExpressionConverter;

@OperatorMetadata(alias="MphChl", version="1.0", authors="Mark William Matthews, Daniel Odermatt, Tom Block, Olaf Danne", copyright="(c) 2013, 2014, 2017 by Brockmann Consult", description="This operator computes maximum peak height of chlorophyll (MPH/CHL).")
public class MphChlOp
extends Operator {
    @Parameter(defaultValue="", description="Expression defining pixels considered for processing. If not set, all valid pixels over water are processed.", converter=BooleanExpressionConverter.class)
    private String validPixelExpression;
    @Parameter(defaultValue="1000.0", description="Maximum chlorophyll, arithmetically higher values are capped.")
    private double cyanoMaxValue;
    @Parameter(defaultValue="500.0", description="Chlorophyll threshold, above which all cyanobacteria dominated waters are 'float.")
    private double chlThreshForFloatFlag;
    @Parameter(defaultValue="false", description="Switch to true to write 'mph' band.")
    boolean exportMph;
    @Parameter(defaultValue="false", description="Switch to true to apply a 3x3 low-pass filter on the result.")
    boolean applyLowPassFilter;
    @SourceProduct(description="L1b or Rayleigh corrected product", label="OLCI or MERIS L1b or Rayleigh corrected product")
    private Product sourceProduct;

    public void initialize() throws OperatorException {
        Product mphChlProduct = this.createMphChlPixelProduct();
        if (this.applyLowPassFilter) {
            this.setTargetProduct(this.createFilteredProduct(mphChlProduct));
        } else {
            this.setTargetProduct(mphChlProduct);
        }
    }

    private Product createFilteredProduct(Product mphChlProduct) {
        Product filteredProduct = new Product(mphChlProduct.getName(), mphChlProduct.getProductType(), mphChlProduct.getSceneRasterWidth(), mphChlProduct.getSceneRasterHeight());
        ProductUtils.copyMetadata((Product)mphChlProduct, (Product)filteredProduct);
        ProductUtils.copyGeoCoding((Product)mphChlProduct, (Product)filteredProduct);
        ProductUtils.copyFlagCodings((Product)mphChlProduct, (Product)filteredProduct);
        ProductUtils.copyFlagBands((Product)mphChlProduct, (Product)filteredProduct, (boolean)true);
        ProductUtils.copyMasks((Product)mphChlProduct, (Product)filteredProduct);
        filteredProduct.setStartTime(mphChlProduct.getStartTime());
        filteredProduct.setEndTime(mphChlProduct.getEndTime());
        for (int i = 0; i < mphChlProduct.getNumTiePointGrids(); ++i) {
            TiePointGrid srcTPG = mphChlProduct.getTiePointGridAt(i);
            if (filteredProduct.containsTiePointGrid(srcTPG.getName())) continue;
            filteredProduct.addTiePointGrid(srcTPG.cloneTiePointGrid());
        }
        for (Band b : mphChlProduct.getBands()) {
            if (b.isFlagBand()) continue;
            if (b.getName().equals("chl")) {
                KernelJAI jaiKernel = this.getJaiKernel();
                RenderingHints rh = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                MultiLevelImage sourceImage = b.getSourceImage();
                RenderedOp filteredImage = ConvolveDescriptor.create((RenderedImage)sourceImage, (KernelJAI)jaiKernel, (RenderingHints)rh);
                ProductUtils.copyBand((String)b.getName(), (Product)mphChlProduct, (Product)filteredProduct, (boolean)false);
                filteredProduct.getBand(b.getName()).setSourceImage((RenderedImage)filteredImage);
                continue;
            }
            if (filteredProduct.containsBand(b.getName())) continue;
            ProductUtils.copyBand((String)b.getName(), (Product)mphChlProduct, (Product)filteredProduct, (boolean)true);
        }
        return filteredProduct;
    }

    private KernelJAI getJaiKernel() {
        Kernel lowPassKernel = new Kernel(3, 3, 0.0625, new double[]{1.0, 2.0, 1.0, 2.0, 4.0, 2.0, 1.0, 2.0, 1.0});
        double[] data = lowPassKernel.getKernelData(null);
        float[] scaledData = new float[data.length];
        double factor = lowPassKernel.getFactor();
        for (int i = 0; i < data.length; ++i) {
            scaledData[i] = (float)(data[i] * factor);
        }
        return new KernelJAI(lowPassKernel.getWidth(), lowPassKernel.getHeight(), lowPassKernel.getXOrigin(), lowPassKernel.getYOrigin(), scaledData);
    }

    private Product createMphChlPixelProduct() {
        MphChlBasisOp mphChlOp = null;
        Sensor sensor = MphChlOp.getSensorType(this.sourceProduct);
        switch (sensor) {
            case OLCI: {
                mphChlOp = new MphChlOlciOp();
                break;
            }
            case MERIS_3RD: 
            case MERIS_4TH: {
                mphChlOp = new MphChlMerisOp();
            }
        }
        if (MphChlOp.isValidL1bSourceProduct(this.sourceProduct, sensor)) {
            RayleighCorrectionOp rayleighCorrectionOp = new RayleighCorrectionOp();
            rayleighCorrectionOp.setSourceProduct(this.sourceProduct);
            rayleighCorrectionOp.setParameterDefaultValues();
            rayleighCorrectionOp.setParameter("computeTaur", (Object)false);
            rayleighCorrectionOp.setParameter("sourceBandNames", (Object)sensor.getRequiredRadianceBandNames());
            mphChlOp.setSourceProduct(rayleighCorrectionOp.getTargetProduct());
        } else if (MphChlOp.isValidBrrSourceProduct(this.sourceProduct, sensor)) {
            mphChlOp.setSourceProduct(this.sourceProduct);
        } else {
            throw new OperatorException("Input product not supported - must be " + sensor.getName() + " L1b or Rayleigh corrected BRR product");
        }
        mphChlOp.setParameterDefaultValues();
        if (this.validPixelExpression != null && this.validPixelExpression.length() > 0) {
            mphChlOp.setParameter("validPixelExpression", this.validPixelExpression);
        } else {
            mphChlOp.setParameter("validPixelExpression", sensor.getValidPixelExpression());
        }
        mphChlOp.setParameter("cyanoMaxValue", this.cyanoMaxValue);
        mphChlOp.setParameter("chlThreshForFloatFlag", this.chlThreshForFloatFlag);
        mphChlOp.setParameter("exportMph", this.exportMph);
        return mphChlOp.getTargetProduct();
    }

    static Sensor getSensorType(Product sourceProduct) {
        boolean isMeris4th;
        boolean isMeris3rd;
        boolean isOlci;
        boolean bl = isOlci = MphChlOp.isValidL1bSourceProduct(sourceProduct, Sensor.OLCI) || MphChlOp.isValidBrrSourceProduct(sourceProduct, Sensor.OLCI);
        if (isOlci) {
            return Sensor.OLCI;
        }
        boolean bl2 = isMeris3rd = MphChlOp.isValidL1bSourceProduct(sourceProduct, Sensor.MERIS_3RD) || MphChlOp.isValidBrrSourceProduct(sourceProduct, Sensor.MERIS_3RD) && sourceProduct.containsBand("l1_flags");
        if (isMeris3rd) {
            return Sensor.MERIS_3RD;
        }
        boolean bl3 = isMeris4th = MphChlOp.isValidL1bSourceProduct(sourceProduct, Sensor.MERIS_4TH) || MphChlOp.isValidBrrSourceProduct(sourceProduct, Sensor.MERIS_4TH) && sourceProduct.containsBand("quality_flags");
        if (isMeris4th) {
            return Sensor.MERIS_4TH;
        }
        throw new OperatorException("Source product not applicable to this operator.\nOnly OLCI and MERIS are supported");
    }

    static boolean isValidL1bSourceProduct(Product sourceProduct, Sensor sensor) {
        for (String bandName : sensor.getRequiredRadianceBandNames()) {
            if (sourceProduct.containsBand(bandName)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidBrrSourceProduct(Product sourceProduct, Sensor sensor) {
        String[] requiredBrrBands;
        for (String bandName : requiredBrrBands = sensor.getRequiredBrrBandNames()) {
            if (sourceProduct.containsBand(bandName)) continue;
            return false;
        }
        return true;
    }

    static Sensor getSensorFromBrrSourceProduct(String[] sourceBands) {
        Sensor[] sensors;
        for (Sensor sensor : sensors = new Sensor[]{Sensor.OLCI, Sensor.MERIS_3RD, Sensor.MERIS_4TH}) {
            boolean containsBand = false;
            for (String requiredBandName : sensor.getRequiredBrrBandNames()) {
                containsBand = false;
                for (String sourceBandName : sourceBands) {
                    if (!sourceBandName.equals(requiredBandName)) continue;
                    containsBand = true;
                }
                if (!containsBand) break;
            }
            if (!containsBand) continue;
            return sensor;
        }
        return null;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MphChlOp.class);
        }
    }
}

