/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.mphchl;

import org.esa.s3tbx.mphchl.MphChlBasisOp;
import org.esa.s3tbx.mphchl.MphChlConstants;
import org.esa.s3tbx.mphchl.MphChlUtils;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;

@OperatorMetadata(alias="MphChlOlci", version="1.0", internal=true, authors="Mark William Matthews, Daniel Odermatt, Tom Block, Olaf Danne", copyright="(c) 2013, 2014, 2017 by Brockmann Consult", description="Computes maximum peak height of chlorophyll for OLCI. Implements OLCI-specific parts.")
public class MphChlOlciOp
extends MphChlBasisOp {
    private static final int BRR_7_IDX = 0;
    private static final int BRR_8_IDX = 1;
    private static final int BRR_10_IDX = 2;
    private static final int BRR_11_IDX = 3;
    private static final int BRR_12_IDX = 4;
    private static final int BRR_18_IDX = 5;

    @Override
    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        if (!this.isSampleValid(x, y)) {
            MphChlUtils.setToInvalid(targetSamples, this.exportMph);
            return;
        }
        double r_7 = sourceSamples[0].getDouble();
        double r_8 = sourceSamples[1].getDouble();
        double r_10 = sourceSamples[2].getDouble();
        double r_11 = sourceSamples[3].getDouble();
        double r_12 = sourceSamples[4].getDouble();
        double r_18 = sourceSamples[5].getDouble();
        double maxBrr_0 = r_10;
        double maxLambda_0 = this.sensorWvls[9];
        if (r_11 > maxBrr_0) {
            maxBrr_0 = r_11;
            maxLambda_0 = this.sensorWvls[10];
        }
        double maxBrr_1 = maxBrr_0;
        double maxLambda_1 = maxLambda_0;
        if (r_12 > maxBrr_1) {
            maxBrr_1 = r_12;
            maxLambda_1 = this.sensorWvls[11];
        }
        double ndvi = (r_18 - r_8) / (r_18 + r_8);
        double SIPF_peak = r_8 - r_7 - (r_10 - r_7) * this.ratioP;
        double SICF_peak = r_10 - r_8 - (r_11 - r_8) * this.ratioC;
        double BAIR_peak = r_11 - r_8 - (r_18 - r_8) * this.ratioB;
        double mph_0 = MphChlUtils.computeMph(maxBrr_0, r_8, r_18, maxLambda_0, this.sensorWvls[7], this.sensorWvls[17]);
        double mph_1 = MphChlUtils.computeMph(maxBrr_1, r_8, r_18, maxLambda_1, this.sensorWvls[7], this.sensorWvls[17]);
        boolean floating_flag = false;
        boolean adj_flag = false;
        boolean cyano_flag = false;
        int immersed_cyano = 0;
        int floating_cyano = 0;
        int floating_vegetation = 0;
        boolean calculatePolynomial = false;
        boolean calculateExponential = false;
        if (maxLambda_1 != (double)this.sensorWvls[11]) {
            if (MphChlUtils.isCyano(SICF_peak, SIPF_peak, BAIR_peak)) {
                cyano_flag = true;
                calculateExponential = true;
            } else {
                calculatePolynomial = true;
            }
        } else {
            if (mph_1 >= 0.02 || ndvi >= 0.2) {
                floating_flag = true;
                adj_flag = false;
                if (MphChlUtils.isCyano(SICF_peak, SIPF_peak)) {
                    cyano_flag = true;
                    calculateExponential = true;
                } else {
                    cyano_flag = false;
                    floating_vegetation = 1;
                }
            }
            if (mph_1 < 0.02 && ndvi < 0.2) {
                floating_flag = false;
                adj_flag = true;
                cyano_flag = false;
                calculatePolynomial = true;
            }
        }
        double mph_chl = Double.NaN;
        if (calculatePolynomial) {
            mph_chl = MphChlUtils.computeChlPolynomial(mph_0);
        }
        if (calculateExponential) {
            mph_chl = MphChlUtils.computeChlExponential(mph_1);
            if (mph_chl < this.chlThreshForFloatFlag) {
                immersed_cyano = 1;
            } else {
                floating_flag = true;
                floating_cyano = 1;
            }
        }
        if (mph_chl > this.cyanoMaxValue) {
            mph_chl = this.cyanoMaxValue;
        }
        targetSamples[0].set(mph_chl);
        targetSamples[1].set(MphChlUtils.encodeFlags(cyano_flag, floating_flag, adj_flag));
        targetSamples[2].set(immersed_cyano);
        targetSamples[3].set(floating_cyano);
        targetSamples[4].set(floating_vegetation);
        if (this.exportMph) {
            targetSamples[5].set(mph_0);
        }
    }

    @Override
    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "rBRR_07");
        sampleConfigurer.defineSample(1, "rBRR_08");
        sampleConfigurer.defineSample(2, "rBRR_10");
        sampleConfigurer.defineSample(3, "rBRR_11");
        sampleConfigurer.defineSample(4, "rBRR_12");
        sampleConfigurer.defineSample(5, "rBRR_18");
    }

    @Override
    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        this.sensorWvls = MphChlConstants.OLCI_WAVELENGHTS;
        this.ratioP = (this.sensorWvls[7] - this.sensorWvls[6]) / (this.sensorWvls[9] - this.sensorWvls[6]);
        this.ratioC = (this.sensorWvls[9] - this.sensorWvls[7]) / (this.sensorWvls[10] - this.sensorWvls[7]);
        this.ratioB = (this.sensorWvls[10] - this.sensorWvls[7]) / (this.sensorWvls[17] - this.sensorWvls[7]);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MphChlOlciOp.class);
        }
    }
}

