/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.mphchl;

import java.awt.Rectangle;
import org.esa.s3tbx.mphchl.MphChlUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.converters.BooleanExpressionConverter;

@OperatorMetadata(alias="MphChlBasis", version="1.0", internal=true, authors="Mark William Matthews, Daniel Odermatt, Tom Block, Olaf Danne", copyright="(c) 2013, 2014, 2017 by Brockmann Consult", description="Computes maximum peak height of chlorophyll. Basis class, contains sensor-independent parts.")
public class MphChlBasisOp
extends PixelOperator {
    @SourceProduct(alias="Name")
    Product sourceProduct;
    @Parameter(description="Expression defining pixels considered for processing.", converter=BooleanExpressionConverter.class)
    String validPixelExpression;
    @Parameter(defaultValue="1000.0", description="Maximum chlorophyll, arithmetically higher values are capped.")
    double cyanoMaxValue;
    @Parameter(defaultValue="350.0", description="Chlorophyll threshold, above which all cyanobacteria dominated waters are 'float.")
    double chlThreshForFloatFlag;
    @Parameter(defaultValue="false", description="Switch to true to write 'mph' band.")
    boolean exportMph;
    float[] sensorWvls;
    VirtualBandOpImage invalidOpImage;
    double ratioP;
    double ratioC;
    double ratioB;

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "chl");
        sampleConfigurer.defineSample(1, "mph_chl_flags");
        sampleConfigurer.defineSample(2, "immersed_cyanobacteria");
        sampleConfigurer.defineSample(3, "floating_cyanobacteria");
        sampleConfigurer.defineSample(4, "floating_vegetation");
        if (this.exportMph) {
            sampleConfigurer.defineSample(5, "mph");
        }
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        Band chlBand = productConfigurer.addBand("chl", 30);
        chlBand.setUnit("mg/m^3");
        chlBand.setGeophysicalNoDataValue(Double.NaN);
        chlBand.setNoDataValue(Double.NaN);
        chlBand.setNoDataValueUsed(true);
        Band immersedCyanoBand = productConfigurer.addBand("immersed_cyanobacteria", 10);
        immersedCyanoBand.setNoDataValue(0.0);
        immersedCyanoBand.setNoDataValueUsed(true);
        productConfigurer.addBand("floating_cyanobacteria", 10);
        productConfigurer.addBand("floating_vegetation", 10);
        if (this.exportMph) {
            Band mphBand = productConfigurer.addBand("mph", 30);
            mphBand.setUnit("dl");
            mphBand.setGeophysicalNoDataValue(Double.NaN);
            mphBand.setNoDataValue(Double.NaN);
            mphBand.setNoDataValueUsed(true);
        }
        Band flagBand = productConfigurer.addBand("mph_chl_flags", 10);
        super.configureTargetProduct(productConfigurer);
        Product targetProduct = productConfigurer.getTargetProduct();
        FlagCoding flagCoding = MphChlUtils.createMphChlFlagCoding("mph_chl_flags");
        targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        flagBand.setSampleCoding((SampleCoding)flagCoding);
        MphChlUtils.setupMphChlBitmask(targetProduct);
        Product sourceProduct = productConfigurer.getSourceProduct();
        ProductUtils.copyFlagBands((Product)sourceProduct, (Product)targetProduct, (boolean)true);
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
    }

    protected void prepareInputs() throws OperatorException {
        if (StringUtils.isNullOrEmpty((String)this.validPixelExpression)) {
            return;
        }
        if (!this.sourceProduct.isCompatibleBandArithmeticExpression(this.validPixelExpression)) {
            String message = String.format("The given expression '%s' is not compatible with the source product.", this.validPixelExpression);
            throw new OperatorException(message);
        }
        this.invalidOpImage = VirtualBandOpImage.builder((String)this.validPixelExpression, (Product)this.sourceProduct).dataType(30).fillValue((Number)Float.valueOf(0.0f)).tileSize(this.sourceProduct.getPreferredTileSize()).mask(false).level(ResolutionLevel.MAXRES).create();
    }

    boolean isSampleValid(int x, int y) {
        return this.invalidOpImage == null || this.invalidOpImage.getData(new Rectangle(x, y, 1, 1)).getSample(x, y, 0) != 0;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MphChlBasisOp.class);
        }
    }
}

