/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.mphchl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.esa.s3tbx.mphchl.MphChlOlciOp;
import org.esa.s3tbx.mphchl.OlciBrrProduct;
import org.esa.s3tbx.mphchl.Sensor;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MphChlOlciOpAcceptanceTest {
    private File testOutDirectory;

    @Before
    public void setUp() {
        this.testOutDirectory = new File("output");
        if (!this.testOutDirectory.mkdirs()) {
            Assert.fail((String)("unable to create test directory: " + this.testOutDirectory));
        }
    }

    @After
    public void tearDown() {
        if (this.testOutDirectory != null && !FileUtils.deleteTree((File)this.testOutDirectory)) {
            Assert.fail((String)("Unable to delete test directory: " + this.testOutDirectory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComputeMphChlProduct() throws IOException {
        Product brrProduct = OlciBrrProduct.create();
        MphChlOlciOp mphChlOp = new MphChlOlciOp();
        mphChlOp.setSourceProduct(brrProduct);
        mphChlOp.setParameterDefaultValues();
        mphChlOp.setParameter("applyLowPassFilter", (Object)false);
        mphChlOp.setParameter("validPixelExpression", (Object)Sensor.OLCI.getValidPixelExpression());
        Product mphChlProduct = mphChlOp.getTargetProduct();
        Product savedProduct = null;
        try {
            String targetProductPath = this.testOutDirectory.getAbsolutePath() + File.separator + "OLCI_MPHCHL.dim";
            ProductIO.writeProduct((Product)mphChlProduct, (String)targetProductPath, (String)"BEAM-DIMAP");
            savedProduct = ProductIO.readProduct((String)targetProductPath);
            Assert.assertNotNull((Object)savedProduct);
            Band chlBand = savedProduct.getBand("chl");
            Assert.assertNotNull((Object)chlBand);
            Assert.assertEquals((double)1.5443997383117676, (double)chlBand.getSampleFloat(0, 0), (double)1.0E-8);
            Assert.assertEquals((double)0.6783487796783447, (double)chlBand.getSampleFloat(1, 0), (double)1.0E-8);
            Assert.assertEquals((double)25.435853958129883, (double)chlBand.getSampleFloat(0, 1), (double)1.0E-8);
            Assert.assertEquals((double)Double.NaN, (double)chlBand.getSampleFloat(1, 1), (double)1.0E-8);
            Band flagBand = savedProduct.getBand("mph_chl_flags");
            Assert.assertNotNull((Object)flagBand);
            Assert.assertEquals((long)0L, (long)flagBand.getSampleInt(0, 0));
            Assert.assertEquals((long)0L, (long)flagBand.getSampleInt(1, 0));
            Assert.assertEquals((long)1L, (long)flagBand.getSampleInt(0, 1));
            Assert.assertEquals((long)0L, (long)flagBand.getSampleInt(1, 1));
            Band immersed_cyanobacteria = savedProduct.getBand("immersed_cyanobacteria");
            Assert.assertNotNull((Object)immersed_cyanobacteria);
            Assert.assertEquals((long)0L, (long)immersed_cyanobacteria.getSampleInt(0, 0));
            Assert.assertEquals((long)0L, (long)immersed_cyanobacteria.getSampleInt(1, 0));
            Assert.assertEquals((long)1L, (long)immersed_cyanobacteria.getSampleInt(0, 1));
            Assert.assertEquals((long)0L, (long)immersed_cyanobacteria.getSampleInt(1, 1));
            Band floating_cyanobacteria = savedProduct.getBand("floating_cyanobacteria");
            Assert.assertNotNull((Object)floating_cyanobacteria);
            Assert.assertEquals((long)0L, (long)floating_cyanobacteria.getSampleInt(0, 0));
            Assert.assertEquals((long)0L, (long)floating_cyanobacteria.getSampleInt(1, 0));
            Assert.assertEquals((long)0L, (long)floating_cyanobacteria.getSampleInt(0, 1));
            Assert.assertEquals((long)0L, (long)floating_cyanobacteria.getSampleInt(1, 1));
            Band floating_vegetation = savedProduct.getBand("floating_vegetation");
            Assert.assertNotNull((Object)floating_vegetation);
            Assert.assertEquals((long)0L, (long)floating_vegetation.getSampleInt(0, 0));
            Assert.assertEquals((long)0L, (long)floating_vegetation.getSampleInt(1, 0));
            Assert.assertEquals((long)0L, (long)floating_vegetation.getSampleInt(0, 1));
            Assert.assertEquals((long)0L, (long)floating_vegetation.getSampleInt(1, 1));
            Band mphBand = savedProduct.getBand("mph");
            Assert.assertNull((Object)mphBand);
            Band l1_flagband = savedProduct.getBand("quality_flags");
            Assert.assertNotNull((Object)l1_flagband);
            Assert.assertEquals((long)2L, (long)l1_flagband.getSampleInt(0, 0));
            Assert.assertEquals((long)0L, (long)l1_flagband.getSampleInt(1, 0));
            Assert.assertEquals((long)0L, (long)l1_flagband.getSampleInt(0, 1));
            Assert.assertEquals((long)16L, (long)l1_flagband.getSampleInt(1, 1));
        }
        finally {
            if (savedProduct != null) {
                savedProduct.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComputeMphChlProduct_withMph() throws IOException {
        Product brrProduct = OlciBrrProduct.create();
        MphChlOlciOp mphChlOp = new MphChlOlciOp();
        mphChlOp.setSourceProduct(brrProduct);
        mphChlOp.setParameterDefaultValues();
        mphChlOp.setParameter("exportMph", (Object)true);
        mphChlOp.setParameter("validPixelExpression", (Object)Sensor.OLCI.getValidPixelExpression());
        Product mphChlProduct = mphChlOp.getTargetProduct();
        Product savedProduct = null;
        try {
            String targetProductPath = this.testOutDirectory.getAbsolutePath() + File.separator + "OLCI_MPHCHL.dim";
            ProductIO.writeProduct((Product)mphChlProduct, (String)targetProductPath, (String)"BEAM-DIMAP");
            savedProduct = ProductIO.readProduct((String)targetProductPath);
            Assert.assertNotNull((Object)savedProduct);
            Band mphBand = savedProduct.getBand("mph");
            Assert.assertNotNull((Object)mphBand);
            Assert.assertEquals((double)-1.1474395432742313E-4, (double)mphBand.getSampleFloat(0, 0), (double)1.0E-8);
            Assert.assertEquals((double)-4.521883383858949E-4, (double)mphBand.getSampleFloat(1, 0), (double)1.0E-8);
            Assert.assertEquals((double)0.003501386847347021, (double)mphBand.getSampleFloat(0, 1), (double)1.0E-8);
        }
        finally {
            if (savedProduct != null) {
                savedProduct.dispose();
            }
        }
    }

    @Test
    public void testWithFaultyValidPixelExpression() {
        Product brrProduct = OlciBrrProduct.create();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("validPixelExpression", "extremely INVALID");
        try {
            GPF.createProduct((String)"MphChlOlci", params, (Product)brrProduct);
            Assert.fail((String)"OperatorException expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }
}

