/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.attribute;

import org.esa.s3tbx.dataio.modis.ModisGlobalAttributes;
import org.esa.s3tbx.dataio.modis.attribute.DaacAttributes;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFVariables;
import org.junit.Assert;
import org.junit.Test;
import ucar.nc2.Dimension;

public class DaacAttributesTest {
    @Test
    public void testInheritance() {
        DaacAttributes daacAttributes = new DaacAttributes(new NetCDFVariables());
        Assert.assertTrue((boolean)(daacAttributes instanceof ModisGlobalAttributes));
    }

    @Test
    public void testIsImappFormat() {
        DaacAttributes daacAttributes = new DaacAttributes(new NetCDFVariables());
        Assert.assertFalse((boolean)daacAttributes.isImappFormat());
    }

    @Test
    public void testIsWidthDimension() {
        Dimension dimension = new Dimension("Max_EV_frames", 34);
        Assert.assertTrue((boolean)DaacAttributes.isWidthDimension((Dimension)dimension));
        dimension = new Dimension("MODIS_Grid_16DAY_1km_VI/Data Fields/XDim", 34);
        Assert.assertTrue((boolean)DaacAttributes.isWidthDimension((Dimension)dimension));
        dimension = new Dimension("Swath/Data Fields/Number_of_samples_per_record", 34);
        Assert.assertTrue((boolean)DaacAttributes.isWidthDimension((Dimension)dimension));
        dimension = new Dimension("ist_quatsch", 34);
        Assert.assertFalse((boolean)DaacAttributes.isWidthDimension((Dimension)dimension));
    }

    @Test
    public void testIsHeightDimension() {
        Dimension dimension = new Dimension("10*nscans", 838);
        Assert.assertTrue((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
        dimension = new Dimension("20*nscans", 838);
        Assert.assertTrue((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
        dimension = new Dimension("MODIS_Grid_16DAY_1km_VI/Data Fields/YDim", 838);
        Assert.assertTrue((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
        dimension = new Dimension("Swath/Data Fields/Number_of_records", 838);
        Assert.assertTrue((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
        dimension = new Dimension("ausgedacht", 838);
        Assert.assertFalse((boolean)DaacAttributes.isHeightDimension((Dimension)dimension));
    }
}

