/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import org.esa.s3tbx.dataio.modis.ModisDaacUtils;
import org.junit.Assert;
import org.junit.Test;

public class ModisDaacUtilsTest_correctAmpersandWrap {
    @Test
    public void testStandardString() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)" any\n standard\r String\n\r without & wrap  ");
        Assert.assertEquals((Object)" any\n standard\r String\n\r without & wrap  ", (Object)corrected);
    }

    @Test
    public void testAmpersandWithoutWrap() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)"   dkjhaf & da\n   lsmf\n");
        Assert.assertEquals((Object)"   dkjhaf & da\n   lsmf\n", (Object)corrected);
    }

    @Test
    public void testAmpersandWithWrap() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)"   FistPartAnd&\n   SecondPart");
        Assert.assertEquals((Object)"   FistPartAndSecondPart", (Object)corrected);
    }

    @Test
    public void testLeaveSpecialCharactersUnchanged() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)"\u00df\u00c4\u00d6\u00dc?#~@|<>\u20ac\u00b5}][{");
        Assert.assertEquals((Object)"\u00df\u00c4\u00d6\u00dc?#~@|<>\u20ac\u00b5}][{", (Object)corrected);
    }

    @Test
    public void testConcrete() {
        String corrected = ModisDaacUtils.correctAmpersandWrap((String)"    OBJECT                 = LOCALGRANULEID\n      NUM_VAL              = 1\n      VALUE                = \"/mnt/juggle//TERRA/MOD_SS.MOD13A2.A2000&\n          049.cs_bartonbe.005.2006257073624.hdf\"\n    END_OBJECT             = LOCALGRANULEID");
        Assert.assertEquals((Object)"    OBJECT                 = LOCALGRANULEID\n      NUM_VAL              = 1\n      VALUE                = \"/mnt/juggle//TERRA/MOD_SS.MOD13A2.A2000049.cs_bartonbe.005.2006257073624.hdf\"\n    END_OBJECT             = LOCALGRANULEID", (Object)corrected);
    }
}

