/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import org.esa.s3tbx.dataio.modis.ModisConstants;
import org.junit.Assert;
import org.junit.Test;

public class ModisConstantsTest {
    private static float[] expWavelength = new float[]{645.0f, 858.5f, 469.0f, 555.0f, 1240.0f, 1640.0f, 2130.0f, 412.5f, 443.0f, 488.0f, 531.0f, 551.0f, 667.0f, 678.0f, 748.0f, 869.5f, 905.0f, 936.0f, 940.0f, 3750.0f, 3959.0f, 3959.0f, 4050.0f, 4465.5f, 4515.5f, 1375.0f, 6715.0f, 7325.0f, 8550.0f, 9730.0f, 11030.0f, 12020.0f, 13335.0f, 13635.0f, 13935.0f, 14235.0f};
    private static float[] expBandwidth = new float[]{50.0f, 35.0f, 20.0f, 20.0f, 20.0f, 24.0f, 50.0f, 15.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 15.0f, 30.0f, 10.0f, 50.0f, 180.0f, 60.0f, 60.0f, 60.0f, 65.0f, 67.0f, 30.0f, 360.0f, 300.0f, 300.0f, 300.0f, 500.0f, 500.0f, 300.0f, 300.0f, 300.0f, 300.0f};

    @Test
    public void testFilePropertyConstants() {
        Assert.assertEquals((Object)".hdf", (Object)".hdf");
        Assert.assertEquals((Object)"MODIS HDF4 Data Products", (Object)"MODIS HDF4 Data Products");
        Assert.assertEquals((Object)"MODIS", (Object)"MODIS");
    }

    @Test
    public void testMetadataKeyConstants() {
        Assert.assertEquals((Object)"Number of Day mode scans", (Object)"Number of Day mode scans");
        Assert.assertEquals((Object)"Number of Night mode scans", (Object)"Number of Night mode scans");
        Assert.assertEquals((Object)"CoreMetadata\\.0", (Object)"CoreMetadata\\.0");
        Assert.assertEquals((Object)"StructMetadata\\.0", (Object)"StructMetadata\\.0");
        Assert.assertEquals((Object)"GROUP", (Object)"GROUP");
        Assert.assertEquals((Object)"END_GROUP", (Object)"END_GROUP");
        Assert.assertEquals((Object)"Dimension", (Object)"Dimension");
        Assert.assertEquals((Object)"DimensionMap", (Object)"DimensionMap");
        Assert.assertEquals((Object)"GeoField", (Object)"GeoField");
        Assert.assertEquals((Object)"DataField", (Object)"DataField");
        Assert.assertEquals((Object)"DimensionName", (Object)"DimensionName");
        Assert.assertEquals((Object)"Size", (Object)"Size");
        Assert.assertEquals((Object)"OBJECT", (Object)"OBJECT");
        Assert.assertEquals((Object)"END_OBJECT", (Object)"END_OBJECT");
        Assert.assertEquals((Object)"GeoDimension", (Object)"GeoDimension");
        Assert.assertEquals((Object)"DataDimension", (Object)"DataDimension");
        Assert.assertEquals((Object)"Offset", (Object)"Offset");
        Assert.assertEquals((Object)"Increment", (Object)"Increment");
        Assert.assertEquals((Object)"GeoFieldName", (Object)"GeoFieldName");
        Assert.assertEquals((Object)"DataType", (Object)"DataType");
        Assert.assertEquals((Object)"DimList", (Object)"DimList");
        Assert.assertEquals((Object)"DataFieldName", (Object)"DataFieldName");
        Assert.assertEquals((Object)"band_names", (Object)"band_names");
        Assert.assertEquals((Object)"valid_range", (Object)"valid_range");
        Assert.assertEquals((Object)"_FillValue", (Object)"_FillValue");
        Assert.assertEquals((Object)"GLOBAL_METADATA", (Object)"GLOBAL_METADATA");
        Assert.assertEquals((Object)"LOCALGRANULEID", (Object)"LOCALGRANULEID");
        Assert.assertEquals((Object)"SHORTNAME", (Object)"SHORTNAME");
        Assert.assertEquals((Object)"HDFEOSVersion", (Object)"HDFEOSVersion");
        Assert.assertEquals((Object)"RANGEBEGINNINGDATE", (Object)"RANGEBEGINNINGDATE");
        Assert.assertEquals((Object)"RANGEBEGINNINGTIME", (Object)"RANGEBEGINNINGTIME");
        Assert.assertEquals((Object)"RANGEENDINGDATE", (Object)"RANGEENDINGDATE");
        Assert.assertEquals((Object)"RANGEENDINGTIME", (Object)"RANGEENDINGTIME");
    }

    @Test
    public void testWavelengthsAndBandwidths() {
        Assert.assertEquals((long)expBandwidth.length, (long)ModisConstants.BAND_WIDTHS.length);
        Assert.assertEquals((long)expWavelength.length, (long)ModisConstants.BAND_CENTER_WAVELENGTHS.length);
        Assert.assertEquals((long)ModisConstants.BAND_WIDTHS.length, (long)ModisConstants.BAND_CENTER_WAVELENGTHS.length);
        for (int n = 0; n < ModisConstants.BAND_CENTER_WAVELENGTHS.length; ++n) {
            Assert.assertEquals((double)expBandwidth[n], (double)ModisConstants.BAND_WIDTHS[n], (double)1.0E-6);
            Assert.assertEquals((double)expWavelength[n], (double)ModisConstants.BAND_CENTER_WAVELENGTHS[n], (double)1.0E-6);
        }
    }

    @Test
    public void testImappConstants() {
        Assert.assertEquals((Object)"DAYNIGHTFLAG", (Object)"DAYNIGHTFLAG");
        Assert.assertEquals((Object)"Day", (Object)"Day");
        Assert.assertEquals((Object)"long_name", (Object)"long_name");
    }

    @Test
    public void testScalingConstants() {
        Assert.assertEquals((Object)"exp", (Object)"exp");
        Assert.assertEquals((Object)"lin", (Object)"lin");
        Assert.assertEquals((Object)"lin_inv", (Object)"lin_inv");
        Assert.assertEquals((Object)"sli", (Object)"sli");
        Assert.assertEquals((Object)"p10", (Object)"p10");
    }
}

