/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.merisl3;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.dataio.merisl3.ISINGrid;
import org.esa.s3tbx.dataio.merisl3.MerisL3ProductReaderPlugIn;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.netcdf.util.MetadataUtils;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class MerisL3ProductReader
extends AbstractProductReader {
    public static final String COL_INDEX_BAND_NAME = "col_index";
    private NetcdfFile _netcdfFile;
    private Product _product;
    private ISINGrid _grid;
    private int _sceneRasterWidth;
    private int _sceneRasterHeight;
    private RowInfo[] _rowInfos;
    private Map<Band, VariableMetadata> bandMap;

    public MerisL3ProductReader(MerisL3ProductReaderPlugIn readerPlugIn) {
        super((ProductReaderPlugIn)readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        String path = this.getInput().toString();
        this._netcdfFile = NetcdfFileOpener.open((Object)path);
        if (this._netcdfFile == null) {
            throw new IOException("Could not open NetCDF file " + path);
        }
        this.bandMap = new HashMap<Band, VariableMetadata>(10);
        try {
            this._grid = new ISINGrid(ISINGrid.detectRowCount(path));
            this._sceneRasterWidth = this._grid.getRowCount() * 2;
            this._sceneRasterHeight = this._grid.getRowCount();
            File productFile = new File(path);
            this._product = new Product(FileUtils.getFilenameWithoutExtension((File)productFile), "L3_ENV_MER", this._sceneRasterWidth, this._sceneRasterHeight, (ProductReader)this);
            MetadataUtils.readNetcdfMetadata((NetcdfFile)this._netcdfFile, (MetadataElement)this._product.getMetadataRoot());
            this.addBand("mean");
            this.addBand("stdev");
            this.addBand("min");
            this.addBand("max");
            this.addBand("count");
            this._product.addBand(this.createColumnIndexBand());
            this._product.setQuicklookBandName("mean");
            this._product.setFileLocation(productFile);
            if (this._product.getNumBands() == 0) {
                throw new IOException("No bands found.");
            }
            this.initGeoCoding();
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        return this._product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        block20: {
            VariableMetadata variableMetadata;
            if (sourceStepX != 1 || sourceStepY != 1) {
                throw new IOException("Sub-sampling is not supported by this product reader.");
            }
            if (sourceWidth != destWidth || sourceHeight != destHeight) {
                throw new IllegalStateException("sourceWidth != destWidth || sourceHeight != destHeight");
            }
            Variable idxVariable = this._netcdfFile.getRootGroup().findVariable("idx");
            short[] rasterData = (short[])destBuffer.getElems();
            if (this._rowInfos == null) {
                this._rowInfos = this.createRowInfos();
            }
            boolean readColIndex = (variableMetadata = this.bandMap.get(destBand)) == null;
            int height = this._sceneRasterHeight;
            int width = this._sceneRasterWidth;
            ISINGrid grid = this._grid;
            pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceHeight);
            try {
                if (readColIndex) {
                    for (int y = sourceOffsetY; y < sourceOffsetY + sourceHeight; ++y) {
                        if (pm.isCanceled()) {
                            break block20;
                        }
                        int rowIndex = height - 1 - y;
                        for (int x = sourceOffsetX; x < sourceOffsetX + sourceWidth; ++x) {
                            double lon = (double)x * 360.0 / (double)width;
                            int colIndex = grid.getColIndex(rowIndex, lon);
                            int rasterIndex = sourceWidth * (y - sourceOffsetY) + (x - sourceOffsetX);
                            rasterData[rasterIndex] = (short)colIndex;
                        }
                        pm.worked(1);
                    }
                    break block20;
                }
                Variable binVariable = variableMetadata.variable;
                Number fillValueN = MerisL3ProductReader.getAttributeNumericValue(binVariable, "_FillValue");
                short fillValue = fillValueN != null ? fillValueN.shortValue() : (short)0;
                int[] lineOffsets = new int[1];
                int[] lineLengths = new int[1];
                Arrays.fill(rasterData, fillValue);
                for (int y = sourceOffsetY; y < sourceOffsetY + sourceHeight; ++y) {
                    short[] binValues;
                    int[] idxValues;
                    if (pm.isCanceled()) {
                        break;
                    }
                    int rowIndex = height - 1 - y;
                    RowInfo rowInfo = this._rowInfos[rowIndex];
                    if (rowInfo == null) continue;
                    int lineOffset = rowInfo.offset;
                    int lineLength = rowInfo.length;
                    lineOffsets[0] = lineOffset;
                    lineLengths[0] = lineLength;
                    try {
                        NetcdfFile netcdfFile = this._netcdfFile;
                        synchronized (netcdfFile) {
                            idxValues = (int[])idxVariable.read(lineOffsets, lineLengths).getStorage();
                            binValues = (short[])binVariable.read(lineOffsets, lineLengths).getStorage();
                        }
                    }
                    catch (InvalidRangeException e) {
                        throw new IOException("Format problem.");
                    }
                    int lineIndex0 = 0;
                    for (int x = sourceOffsetX; x < sourceOffsetX + sourceWidth; ++x) {
                        double lon = (double)x * 360.0 / (double)width;
                        int binIndex = grid.getBinIndex(rowIndex, lon);
                        int lineIndex = -1;
                        for (int i = lineIndex0; i < lineLength; ++i) {
                            if (idxValues[i] < binIndex) continue;
                            if (idxValues[i] == binIndex) {
                                lineIndex = i;
                            }
                            lineIndex0 = i;
                            break;
                        }
                        if (lineIndex < 0) continue;
                        int rasterIndex = sourceWidth * (y - sourceOffsetY) + (x - sourceOffsetX);
                        rasterData[rasterIndex] = binValues[lineIndex];
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        }
    }

    public void close() throws IOException {
        super.close();
        if (this._netcdfFile != null) {
            this._netcdfFile.close();
            this._netcdfFile = null;
        }
        this.bandMap.clear();
        this._product = null;
        this._grid = null;
        this._rowInfos = null;
    }

    private Band createColumnIndexBand() {
        Band colIndexBand = new Band(COL_INDEX_BAND_NAME, 21, this._sceneRasterWidth, this._sceneRasterHeight);
        colIndexBand.setDescription("Zero-based column index in the global ISIN grid");
        return colIndexBand;
    }

    private void initGeoCoding() throws IOException {
        float pixelX = 0.0f;
        float pixelY = 0.0f;
        float easting = -180.0f;
        float northing = 90.0f;
        float pixelSizeX = 360.0f / (float)this._sceneRasterWidth;
        float pixelSizeY = 180.0f / (float)this._sceneRasterHeight;
        try {
            this._product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, this._sceneRasterWidth, this._sceneRasterHeight, (double)easting, (double)northing, (double)pixelSizeX, (double)pixelSizeY, (double)pixelX, (double)pixelY));
        }
        catch (FactoryException e) {
            throw new IOException(e);
        }
        catch (TransformException e) {
            throw new IOException(e);
        }
    }

    private void dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowInfo[] createRowInfos() throws IOException {
        int[] idxValues;
        ISINGrid grid = this._grid;
        RowInfo[] binLines = new RowInfo[this._sceneRasterHeight];
        Variable idxVariable = this._netcdfFile.getRootGroup().findVariable("idx");
        NetcdfFile netcdfFile = this._netcdfFile;
        synchronized (netcdfFile) {
            idxValues = (int[])idxVariable.read().getStorage();
        }
        Point gridPoint = new Point();
        int lastBinIndex = -1;
        int lastRowIndex = -1;
        int lineOffset = 0;
        int lineLength = 0;
        for (int i = 0; i < idxValues.length; ++i) {
            int binIndex = idxValues[i];
            if (binIndex < lastBinIndex) {
                throw new IOException("Unrecognized level-3 format. Bins numbers expected to appear in ascending order.");
            }
            lastBinIndex = binIndex;
            grid.getGridPoint(binIndex, gridPoint);
            int rowIndex = gridPoint.y;
            if (rowIndex != lastRowIndex) {
                if (lineLength > 0) {
                    binLines[lastRowIndex] = new RowInfo(lineOffset, lineLength);
                }
                lineOffset = i;
                lineLength = 0;
            }
            ++lineLength;
            lastRowIndex = rowIndex;
        }
        if (lineLength > 0) {
            binLines[lastRowIndex] = new RowInfo(lineOffset, lineLength);
        }
        return binLines;
    }

    private void addBand(String varName) {
        VariableMetadata variableMetadata = this.getVariableMetadata(varName);
        if (variableMetadata != null) {
            Band band = new Band(variableMetadata.name, 11, this._sceneRasterWidth, this._sceneRasterHeight);
            band.setDescription(variableMetadata.description);
            band.setScalingOffset(variableMetadata.scalingOffset);
            band.setScalingFactor(variableMetadata.scalingFactor);
            band.setLog10Scaled(variableMetadata.log10Scaled);
            band.setNoDataValue(variableMetadata.fillValue);
            band.setNoDataValueUsed(variableMetadata.fillValue != Double.NaN);
            this._product.addBand(band);
            this.bandMap.put(band, variableMetadata);
        }
    }

    private VariableMetadata getVariableMetadata(String varName) {
        String stringValue;
        Variable variable = this._netcdfFile.getRootGroup().findVariable(varName);
        if (variable == null) {
            return null;
        }
        String description = stringValue = MerisL3ProductReader.getAttributeStringValue(variable, "long_name");
        Number numericValue = MerisL3ProductReader.getAttributeNumericValue(variable, "_FillValue");
        double fillValue = numericValue != null ? numericValue.doubleValue() : Double.NaN;
        numericValue = MerisL3ProductReader.getAttributeNumericValue(variable, "scale_factor");
        double scale = numericValue != null ? numericValue.doubleValue() : 1.0;
        numericValue = MerisL3ProductReader.getAttributeNumericValue(variable, "add_offset");
        double offset = numericValue != null ? numericValue.doubleValue() : 0.0;
        stringValue = MerisL3ProductReader.getAttributeStringValue(variable, "scaling_equation");
        boolean logScaled = stringValue != null && stringValue.equals("value=10**(offset+code*gain)");
        return new VariableMetadata(variable, varName, description, fillValue, scale, offset, logScaled);
    }

    private static Number getAttributeNumericValue(Variable variable, String attributeName) {
        Attribute att = variable.findAttribute(attributeName);
        return att != null ? (Number)att.getNumericValue() : (Number)null;
    }

    private static String getAttributeStringValue(Variable variable, String attributeName) {
        Attribute att = variable.findAttribute(attributeName);
        return att != null ? att.getStringValue() : null;
    }

    private static final class RowInfo {
        final int offset;
        final int length;

        public RowInfo(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }

    private static class VariableMetadata {
        final Variable variable;
        final String name;
        final String description;
        final double fillValue;
        final double scalingFactor;
        final double scalingOffset;
        final boolean log10Scaled;

        public VariableMetadata(Variable variable, String name, String description, double fillValue, double scale, double offset, boolean logScaled) {
            this.variable = variable;
            this.name = name;
            this.description = description;
            this.fillValue = fillValue;
            this.scalingFactor = scale;
            this.scalingOffset = offset;
            this.log10Scaled = logScaled;
        }
    }
}

