/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.merisl3;

import java.io.File;
import org.esa.snap.core.util.io.SnapFileFilter;

public class MerisL3FileFilter
extends SnapFileFilter {
    public MerisL3FileFilter() {
        super("L3_ENV_MER", ".nc", "MERIS Binned Level-3 (netCDF) Data Product");
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (super.accept(file)) {
            return MerisL3FileFilter.isMerisBinnedL3Name(file.getName());
        }
        return false;
    }

    public static boolean isMerisBinnedL3Name(String name) {
        return name.startsWith("L3_ENV_MER_") && name.indexOf("_GLOB_SI_") != -1 && name.endsWith(".nc");
    }
}

