/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.merisl3;

import java.awt.Point;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ISINGrid {
    public static final double RE = 6378.137;
    public static final int DEFAULT_ROW_COUNT = 2160;
    private final int rowCount;
    private final double binSize;
    private final double deltaLat;
    private final double[] lats;
    private final double[] deltaLons;
    private final int[] rowLength;
    private final int[] binOffsets;
    private final int totalBinCount;

    public ISINGrid(int rowCount) {
        this.rowCount = rowCount;
        this.binSize = 20037.508342789242 / (double)rowCount;
        this.deltaLat = 180.0 / (double)rowCount;
        this.lats = new double[rowCount];
        this.deltaLons = new double[rowCount];
        this.rowLength = new int[rowCount];
        this.binOffsets = new int[rowCount];
        int binCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            this.lats[i] = -90.0 + ((double)i + 0.5) * this.deltaLat;
            this.rowLength[i] = (int)(0.5 + 40075.016685578485 * Math.cos(Math.toRadians(this.lats[i])) / this.binSize);
            this.deltaLons[i] = 360.0 / (double)this.rowLength[i];
            this.binOffsets[i] = i == 0 ? 0 : this.binOffsets[i - 1] + this.rowLength[i - 1];
            binCount += this.rowLength[i];
        }
        this.totalBinCount = binCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public double getBinSize() {
        return this.binSize;
    }

    public double getDeltaLat() {
        return this.deltaLat;
    }

    public int getTotalBinCount() {
        return this.totalBinCount;
    }

    public double getLat(int rowIndex) {
        return this.lats[rowIndex];
    }

    public double getDeltaLon(int rowIndex) {
        return this.deltaLons[rowIndex];
    }

    public int getRowLength(int rowIndex) {
        return this.rowLength[rowIndex];
    }

    public int getBinOffset(int rowIndex) {
        return this.binOffsets[rowIndex];
    }

    public int getRowIndex(int binIndex) {
        int[] binOffsets = this.binOffsets;
        int totalBinCount = this.totalBinCount;
        int iL = 0;
        int iU = this.rowCount - 1;
        if (binIndex < 0 || binIndex >= totalBinCount) {
            return -1;
        }
        do {
            int iM;
            if (binIndex < binOffsets[iM = (iL + iU - 1) / 2]) {
                iU = iM;
                continue;
            }
            if (binIndex >= binOffsets[iM + 1]) {
                iL = iM + 1;
                continue;
            }
            return iM;
        } while (iL != iU);
        return iL;
    }

    public Point getGridPoint(int binIndex, Point gridPoint) {
        int rowIndex = this.getRowIndex(binIndex);
        gridPoint.x = rowIndex == -1 ? -1 : binIndex - this.binOffsets[rowIndex];
        gridPoint.y = rowIndex;
        return gridPoint;
    }

    public int getBinIndex(Point gridPoint) {
        int colIndex = gridPoint.x;
        int rowIndex = gridPoint.y;
        if (rowIndex >= 0 && rowIndex < this.rowCount && colIndex >= 0 && colIndex < this.rowLength[rowIndex]) {
            return this.binOffsets[rowIndex] + colIndex;
        }
        return -1;
    }

    public int getColIndex(int rowIndex, double lon) {
        return (int)(lon / this.getDeltaLon(rowIndex) + 0.5);
    }

    public int getBinIndex(int rowIndex, double lon) {
        int colIndex = this.getColIndex(rowIndex, lon);
        return this.getBinOffset(rowIndex) + colIndex;
    }

    public static int detectRowCount(String productName) {
        String binSize2;
        String binSize1;
        Pattern p = Pattern.compile(".*_(\\d{4})x(\\d{4})_.*");
        Matcher m = p.matcher(productName);
        if (m.matches() && m.groupCount() == 2 && (binSize1 = m.group(1)).equals(binSize2 = m.group(2))) {
            int binSize = Integer.parseInt(binSize1);
            return (int)Math.round(2.0037508342789244E7 / (double)binSize);
        }
        return 2160;
    }
}

