/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.merisl3;

import org.esa.s3tbx.dataio.merisl3.ISINGrid;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.dataop.maptransf.Datum;

public class ISINGeoCoding
extends AbstractGeoCoding {
    private ISINGrid _grid;

    public ISINGeoCoding(ISINGrid grid) {
        this._grid = grid;
    }

    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        return false;
    }

    public boolean isCrossingMeridianAt180() {
        return false;
    }

    public boolean canGetPixelPos() {
        return true;
    }

    public boolean canGetGeoPos() {
        return true;
    }

    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        pixelPos = pixelPos == null ? new PixelPos() : pixelPos;
        pixelPos.x = -1.0;
        pixelPos.y = -1.0;
        int rowIndex = (int)((90.0 - geoPos.lat) * (double)this._grid.getRowCount() / 180.0);
        if (rowIndex >= 0 && rowIndex < this._grid.getRowCount()) {
            int colIndex = (int)((180.0 + geoPos.lon) / this._grid.getDeltaLon(rowIndex));
            int rowLength = this._grid.getRowLength(rowIndex);
            if (colIndex >= 0 && colIndex < rowLength) {
                pixelPos.x = this._grid.getRowCount() - rowLength / 2 + colIndex;
                pixelPos.y = rowIndex;
            }
        }
        return pixelPos;
    }

    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        geoPos = geoPos == null ? new GeoPos() : geoPos;
        geoPos.lat = -1.0;
        geoPos.lon = -1.0;
        int rowIndex = (int)pixelPos.y;
        if (rowIndex >= 0 && rowIndex < this._grid.getRowCount()) {
            int rowLength = this._grid.getRowLength(rowIndex);
            double colIndex = pixelPos.x - (double)this._grid.getRowCount() + (double)(rowLength / 2);
            if (colIndex >= 0.0 && colIndex < (double)rowLength) {
                geoPos.lat = 90.0 - 180.0 * pixelPos.y / (double)this._grid.getRowCount();
                geoPos.lon = (float)(colIndex * this._grid.getDeltaLon(rowIndex) - 180.0);
            }
        }
        return geoPos;
    }

    public Datum getDatum() {
        return Datum.WGS_84;
    }

    public void dispose() {
        this._grid = null;
    }
}

