/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.ui;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyPane;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.ui.DefaultIOParametersPanel;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.ui.AppContext;

class RadiometryForm
extends JTabbedPane {
    private final AppContext appContext;
    private final OperatorSpi operatorSpi;
    private final PropertySet propertySet;
    private final TargetProductSelector targetProductSelector;
    private final DefaultIOParametersPanel ioParamPanel;
    private BindingContext processingParamBindingContext;

    RadiometryForm(AppContext appContext, OperatorSpi operatorSpi, PropertySet propertySet, TargetProductSelector targetProductSelector) {
        this.appContext = appContext;
        this.operatorSpi = operatorSpi;
        this.propertySet = propertySet;
        this.targetProductSelector = targetProductSelector;
        this.ioParamPanel = this.createIOParamTab();
        this.addTab("I/O Parameters", (Component)this.ioParamPanel);
        this.addTab("Processing Parameters", this.createProcessingParamTab());
        PropertyContainer targetProductPC = targetProductSelector.getModel().getValueContainer();
        FormatChangeListener formatChangeListener = new FormatChangeListener();
        targetProductPC.addPropertyChangeListener("formatName", (PropertyChangeListener)formatChangeListener);
        targetProductPC.addPropertyChangeListener("saveToFileSelected", (PropertyChangeListener)formatChangeListener);
        this.updateEnabledState(this.isSaveToEnvisatFormatSelected());
    }

    public void prepareShow() {
        this.ioParamPanel.initSourceProductSelectors();
    }

    public void prepareHide() {
        this.ioParamPanel.releaseSourceProductSelectors();
    }

    public Product getSourceProduct() {
        return ((SourceProductSelector)this.ioParamPanel.getSourceProductSelectorList().get(0)).getSelectedProduct();
    }

    private DefaultIOParametersPanel createIOParamTab() {
        DefaultIOParametersPanel ioPanel = new DefaultIOParametersPanel(this.appContext, this.operatorSpi.getOperatorDescriptor(), this.targetProductSelector);
        ArrayList sourceProductSelectorList = ioPanel.getSourceProductSelectorList();
        if (!sourceProductSelectorList.isEmpty()) {
            SourceProductSelector sourceProductSelector = (SourceProductSelector)sourceProductSelectorList.get(0);
            sourceProductSelector.addSelectionChangeListener((SelectionChangeListener)new SourceProductChangeListener());
        }
        return ioPanel;
    }

    private JScrollPane createProcessingParamTab() {
        PropertyPane parametersPane = new PropertyPane(this.propertySet);
        this.processingParamBindingContext = parametersPane.getBindingContext();
        JPanel parametersPanel = parametersPane.createPanel();
        parametersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        return new JScrollPane(parametersPanel);
    }

    private void updateEnabledState(boolean isEnvisatFormatSelected) {
        Binding binding = this.processingParamBindingContext.getBinding("doRadToRefl");
        for (JComponent component : binding.getComponents()) {
            component.setEnabled(!isEnvisatFormatSelected);
        }
    }

    private boolean isSaveToEnvisatFormatSelected() {
        PropertyContainer targetProductPC = this.targetProductSelector.getModel().getValueContainer();
        String formatName = (String)targetProductPC.getProperty("formatName").getValue();
        boolean isEnvisatFormatSelected = "ENVISAT".equals(formatName);
        boolean isSaveToFileSelected = (Boolean)targetProductPC.getProperty("saveToFileSelected").getValue();
        return isEnvisatFormatSelected && isSaveToFileSelected;
    }

    private class FormatChangeListener
    implements PropertyChangeListener {
        private FormatChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean saveToEnvisatFormatSelected = RadiometryForm.this.isSaveToEnvisatFormatSelected();
            RadiometryForm.this.updateEnabledState(saveToEnvisatFormatSelected);
            if (saveToEnvisatFormatSelected) {
                RadiometryForm.this.propertySet.setValue("doRadToRefl", (Object)false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String message = "When selecting ENVISAT as target format, the radiance to reflectance conversion can not be performed.\nThe parameter is now deselected and disabled.";
                        JOptionPane.showMessageDialog(RadiometryForm.this, "When selecting ENVISAT as target format, the radiance to reflectance conversion can not be performed.\nThe parameter is now deselected and disabled.");
                    }
                });
            }
        }
    }

    private class SourceProductChangeListener
    extends AbstractSelectionChangeListener {
        private static final String TARGET_PRODUCT_NAME_SUFFIX = "_radiometry";

        private SourceProductChangeListener() {
        }

        public void selectionChanged(SelectionChangeEvent event) {
            String productName = "";
            Product selectedProduct = (Product)event.getSelection().getSelectedValue();
            if (selectedProduct != null) {
                productName = FileUtils.getFilenameWithoutExtension((String)selectedProduct.getName());
            }
            TargetProductSelectorModel targetProductSelectorModel = RadiometryForm.this.targetProductSelector.getModel();
            targetProductSelectorModel.setProductName(productName + TARGET_PRODUCT_NAME_SUFFIX);
        }
    }
}

