/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.ui;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.meris.radiometry.ui.RadiometryForm;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.ArrayUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

class RadiometryDialog
extends SingleTargetProductDialog {
    private final String alias;
    private final OperatorParameterSupport parameterSupport;
    private final RadiometryForm form;

    RadiometryDialog(String alias, AppContext appContext, String title, String helpId) {
        super(appContext, title, 24, helpId, TargetProductSelectorModel.createEnvisatTargetProductSelectorModel());
        this.alias = alias;
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(alias);
        this.parameterSupport = new OperatorParameterSupport(operatorSpi.getOperatorDescriptor());
        this.form = new RadiometryForm(appContext, operatorSpi, this.parameterSupport.getPropertySet(), this.getTargetProductSelector());
        OperatorMenu operatorMenu = new OperatorMenu((Component)this.getJDialog(), operatorSpi.getOperatorDescriptor(), this.parameterSupport, appContext, helpId);
        this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
    }

    protected Product createTargetProduct() throws Exception {
        Product sourceProduct = this.form.getSourceProduct();
        Product radioCorrProduct = GPF.createProduct((String)this.alias, (Map)this.parameterSupport.getParameterMap(), (Product)sourceProduct);
        if (this.isEnvisatFormatSelected() && this.getTargetProductSelector().getModel().isSaveToFileSelected()) {
            HashMap<String, File> n1Parameters = new HashMap<String, File>();
            n1Parameters.put("patchedFile", this.getTargetProductSelector().getModel().getProductFile());
            HashMap<String, Product> sourceProductMap = new HashMap<String, Product>();
            sourceProductMap.put("n1", this.form.getSourceProduct());
            sourceProductMap.put("input", radioCorrProduct);
            return GPF.createProduct((String)"Meris.N1Patcher", n1Parameters, sourceProductMap);
        }
        return radioCorrProduct;
    }

    protected void onApply() {
        if (this.validateUserInput()) {
            super.onApply();
        }
    }

    private boolean validateUserInput() {
        if (this.isEnvisatFormatSelected()) {
            ProductReader productReader = this.form.getSourceProduct().getProductReader();
            boolean isEnvisatSource = false;
            if (productReader != null) {
                Object[] formatNames = productReader.getReaderPlugIn().getFormatNames();
                boolean bl = isEnvisatSource = ArrayUtils.getElementIndex((Object)"ENVISAT", (Object[])formatNames) != -1;
            }
            if (!isEnvisatSource) {
                String msg = "If ENVISAT is selected as output format, the source product must be in the same format.";
                Dialogs.showError((String)"Invalid Settings", (String)"If ENVISAT is selected as output format, the source product must be in the same format.");
                return false;
            }
        }
        return true;
    }

    private boolean isEnvisatFormatSelected() {
        return "ENVISAT".equals(this.getTargetProductSelector().getModel().getFormatName());
    }

    public int show() {
        this.form.prepareShow();
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.form.prepareHide();
        super.hide();
    }
}

