/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import java.io.File;
import java.io.IOException;
import org.esa.s3tbx.dataio.landsat.geotiff.Landsat8Metadata;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatLegacyMetadata;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatMetadata;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatMetadataFactory;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatReprocessedMetadata;
import org.junit.Assert;
import org.junit.Test;

public class LandsatMetadataFactoryTest {
    @Test
    public void testCreate_L1_MSS_reproc() throws Exception {
        File testFile = new File(this.getClass().getResource("test_L1_MSS_MTL.txt").getFile());
        LandsatMetadata landsatMetadata = LandsatMetadataFactory.create((File)testFile);
        Assert.assertTrue((boolean)(landsatMetadata instanceof LandsatReprocessedMetadata));
    }

    @Test
    public void testCreate_L3_MSS_reproc() throws Exception {
        File testFile = new File(this.getClass().getResource("test_L3_MSS_MTL.txt").getFile());
        LandsatMetadata landsatMetadata = LandsatMetadataFactory.create((File)testFile);
        Assert.assertTrue((boolean)(landsatMetadata instanceof LandsatReprocessedMetadata));
    }

    @Test
    public void testCreate_5_reproc() throws Exception {
        File testFile = new File(this.getClass().getResource("test_5_reproc_MTL.txt").getFile());
        LandsatMetadata landsatMetadata = LandsatMetadataFactory.create((File)testFile);
        Assert.assertTrue((boolean)(landsatMetadata instanceof LandsatReprocessedMetadata));
    }

    @Test
    public void testCreate_7_reproc() throws Exception {
        File testFile = new File(this.getClass().getResource("test_7_reproc_MTL.txt").getFile());
        LandsatMetadata landsatMetadata = LandsatMetadataFactory.create((File)testFile);
        Assert.assertTrue((boolean)(landsatMetadata instanceof LandsatReprocessedMetadata));
    }

    @Test
    public void testCreate_8() throws Exception {
        File testFile = new File(this.getClass().getResource("test_L8_MTL.txt").getFile());
        LandsatMetadata landsatMetadata = LandsatMetadataFactory.create((File)testFile);
        Assert.assertTrue((boolean)(landsatMetadata instanceof Landsat8Metadata));
    }

    @Test
    public void testCreate_Legacy() throws Exception {
        File testFile = new File(this.getClass().getResource("test_L7_MTL.txt").getFile());
        LandsatMetadata landsatMetadata = LandsatMetadataFactory.create((File)testFile);
        Assert.assertTrue((boolean)(landsatMetadata instanceof LandsatLegacyMetadata));
    }

    @Test(expected=IllegalStateException.class)
    public void testFail() throws IOException {
        File testFile = new File(this.getClass().getResource("test_broken_MTL.txt").getFile());
        LandsatMetadataFactory.create((File)testFile);
    }
}

