/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatLegacyMetadata;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Test;

public class LandsatLegacyMetadataTest {
    @Test
    public void testReadMetadata_L5() throws IOException {
        InputStream stream = LandsatLegacyMetadataTest.class.getResourceAsStream("test_MTL.txt");
        InputStreamReader reader = new InputStreamReader(stream);
        LandsatLegacyMetadata landsatMetadata = new LandsatLegacyMetadata((Reader)reader);
        MetadataElement element = landsatMetadata.getMetaDataElementRoot();
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"L1_METADATA_FILE", (Object)element.getName());
        MetadataElement[] childElements = element.getElements();
        Assert.assertEquals((long)8L, (long)childElements.length);
        MetadataElement firstChild = childElements[0];
        Assert.assertEquals((Object)"METADATA_FILE_INFO", (Object)firstChild.getName());
        Assert.assertEquals((long)0L, (long)firstChild.getElements().length);
        MetadataAttribute[] attributes = firstChild.getAttributes();
        Assert.assertEquals((long)9L, (long)attributes.length);
        MetadataAttribute originAttr = attributes[0];
        Assert.assertEquals((Object)"ORIGIN", (Object)originAttr.getName());
        Assert.assertEquals((Object)"ascii", (Object)originAttr.getData().getTypeString());
        Assert.assertEquals((Object)"Image courtesy of the U.S. Geological Survey", (Object)originAttr.getData().getElemString());
        Assert.assertTrue((boolean)landsatMetadata.isLandsatTM());
        Assert.assertFalse((boolean)landsatMetadata.isLandsatETM_Plus());
        Assert.assertEquals((Object)"Landsat5_TM_L1T", (Object)landsatMetadata.getProductType());
        ProductData.UTC cTime = landsatMetadata.getCenterTime();
        Assert.assertNotNull((Object)cTime);
        Assert.assertEquals((Object)"14-SEP-2003 09:55:12.228000", (Object)cTime.format());
        Dimension panchromaticDim = landsatMetadata.getPanchromaticDim();
        Assert.assertNull((Object)panchromaticDim);
        Dimension thermalDim = landsatMetadata.getThermalDim();
        Assert.assertNotNull((Object)thermalDim);
        Assert.assertEquals((double)7461.0, (double)thermalDim.getHeight(), (double)1.0E-8);
        Assert.assertEquals((double)8401.0, (double)thermalDim.getWidth(), (double)1.0E-8);
        Dimension reflectanceDim = landsatMetadata.getReflectanceDim();
        Assert.assertNotNull((Object)reflectanceDim);
        Assert.assertEquals((double)7461.0, (double)reflectanceDim.getHeight(), (double)1.0E-8);
        Assert.assertEquals((double)8401.0, (double)reflectanceDim.getWidth(), (double)1.0E-8);
    }

    @Test
    public void testReadMetadata_L7() throws IOException {
        InputStream stream = LandsatLegacyMetadataTest.class.getResourceAsStream("test_MTL_L7.txt");
        InputStreamReader reader = new InputStreamReader(stream);
        LandsatLegacyMetadata landsatMetadata = new LandsatLegacyMetadata((Reader)reader);
        MetadataElement elementRoot = landsatMetadata.getMetaDataElementRoot();
        Assert.assertNotNull((Object)elementRoot);
        Assert.assertEquals((Object)"L1_METADATA_FILE", (Object)elementRoot.getName());
        MetadataElement[] childElements = elementRoot.getElements();
        Assert.assertEquals((long)8L, (long)childElements.length);
        MetadataElement firstChild = childElements[0];
        Assert.assertEquals((Object)"METADATA_FILE_INFO", (Object)firstChild.getName());
        Assert.assertEquals((long)0L, (long)firstChild.getElements().length);
        MetadataAttribute[] attributes = firstChild.getAttributes();
        Assert.assertEquals((long)9L, (long)attributes.length);
        MetadataAttribute originAttr = attributes[0];
        Assert.assertEquals((Object)"ORIGIN", (Object)originAttr.getName());
        Assert.assertEquals((Object)"ascii", (Object)originAttr.getData().getTypeString());
        Assert.assertEquals((Object)"Image courtesy of the U.S. Geological Survey", (Object)originAttr.getData().getElemString());
        Assert.assertFalse((boolean)landsatMetadata.isLandsatTM());
        Assert.assertTrue((boolean)landsatMetadata.isLandsatETM_Plus());
        Assert.assertEquals((Object)"Landsat7_ETM+_L1T", (Object)landsatMetadata.getProductType());
        ProductData.UTC cTime = landsatMetadata.getCenterTime();
        Assert.assertNotNull((Object)cTime);
        Assert.assertEquals((Object)"15-JAN-2006 08:45:02.587000", (Object)cTime.format());
        Dimension panchromaticDim = landsatMetadata.getPanchromaticDim();
        Assert.assertNotNull((Object)panchromaticDim);
        Assert.assertEquals((double)14001.0, (double)panchromaticDim.getHeight(), (double)1.0E-8);
        Assert.assertEquals((double)15541.0, (double)panchromaticDim.getWidth(), (double)1.0E-8);
        Dimension thermalDim = landsatMetadata.getThermalDim();
        Assert.assertNotNull((Object)thermalDim);
        Assert.assertEquals((double)7001.0, (double)thermalDim.getHeight(), (double)1.0E-8);
        Assert.assertEquals((double)7771.0, (double)thermalDim.getWidth(), (double)1.0E-8);
        Dimension reflectanceDim = landsatMetadata.getReflectanceDim();
        Assert.assertNotNull((Object)reflectanceDim);
        Assert.assertEquals((double)7001.0, (double)reflectanceDim.getHeight(), (double)1.0E-8);
        Assert.assertEquals((double)7771.0, (double)reflectanceDim.getWidth(), (double)1.0E-8);
    }
}

