/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import java.io.File;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatGeotiffReader;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatGeotiffReaderPlugin;
import org.esa.snap.core.dataio.ProductReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LandsatGeotiffReaderPluginTest {
    private LandsatGeotiffReaderPlugin plugin;

    @Before
    public void setUp() throws Exception {
        this.plugin = new LandsatGeotiffReaderPlugin();
    }

    @Test
    public void testIsLandsatMSSFilename() throws Exception {
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsatMSSFilename((String)"LM11870291976166ESA00_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsatMSSFilename((String)"LM32170241982254XXX01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsatMSSFilename((String)"LM42310081982267ESA00_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsatMSSFilename((String)"LM52010241984295AAA03_MTL.txt"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsatMSSFilename((String)"LT40140341983030XXX13_MTL.txt"));
    }

    @Test
    public void testIsLandsat4Filename() throws Exception {
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat4Filename((String)"LT40140341983030XXX13_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat4Filename((String)"LT40140341982315PAC00_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat4Filename((String)"LT41160361989137XXX02_MTL.txt"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat4Filename((String)"LT40140341982315PAC00_B1.TIF"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat4Filename((String)"LT51920342011274MPS00.tgz"));
    }

    @Test
    public void testIsLandsat5Filename() throws Exception {
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat5Filename((String)"LT51231232013068GSI01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat5Filename((String)"LT51231232013068GSI01_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat5Filename((String)"LT51920342011274MPS00.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat5Filename((String)"LT51231232013068GSI01_B3.txt"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat5Filename((String)"L5196030_03020031023_MTL.txt"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat5Filename((String)"LT71920342011274MPS00.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat5Filename((String)"LT51920342011274MPS00.tgz"));
    }

    @Test
    public void testIsLandsat7Filename() throws Exception {
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat7Filename((String)"LE71890342011277ASN00_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat7Filename((String)"LE71890342011277ASN00_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat7Filename((String)"LE71890342011277ASN00.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat7Filename((String)"LE71890342011277ASN00_B3.txt"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat7Filename((String)"L71890342011277ASN00.txt"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat7Filename((String)"LE81890342011277ASN00_MTL.txt"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat7Filename((String)"LE71890342011277ASN00.tgz"));
    }

    @Test
    public void testIsLandsat8Filename() throws Exception {
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat8Filename((String)"LT82270322013068LGN01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat8Filename((String)"LT82270322013068LGN01_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat8Filename((String)"LC82160332013191LGN00.tar.gz"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat8Filename((String)"LO82160332013191LGN00.tar.gz"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat8Filename((String)"LT82160332013191LGN00.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat8Filename((String)"L8196030_03020031023_MTL.txt"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat8Filename((String)"LT52160332013191LGN00.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat8Filename((String)"LT82160332013191LGN00.tgz"));
    }

    @Test
    public void testIsLandsat5LegacyFilename() throws Exception {
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename((String)"LT51960300302003GSI01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename((String)"LT51960300302003GSI01_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename((String)"L5196030_03020031023_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename((String)"L5196030_03020031023_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename((String)"LT51960302003296MTI01.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename((String)"L51950302003257MTI01.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename((String)"LT72160332013191LGN00.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename((String)"LT82160332013191LGN00.tgz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename((String)"LT82160332013191LGN00.dat"));
    }

    @Test
    public void testIsLandsat7LegacyFilename() throws Exception {
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename((String)"LE71960300302003GSI01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename((String)"LE71960300302003GSI01_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename((String)"L71196030_03020031023_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename((String)"L71196030_03020031023_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename((String)"LE71960302003296ASN01.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename((String)"L71950302003257MTI01.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename((String)"LE52160332013191LGN00.tar.gz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename((String)"LE72160332013191LGN00.tgz"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename((String)"LE72160332013191LGN00.dat"));
    }

    @Test
    public void testGetInputTypes() throws Exception {
        Assert.assertArrayEquals((Object[])new Class[]{String.class, File.class}, (Object[])this.plugin.getInputTypes());
    }

    @Test
    public void testCreateReaderInstance() throws Exception {
        ProductReader productReader = this.plugin.createReaderInstance();
        Assert.assertNotNull((Object)productReader);
        Assert.assertTrue((boolean)(productReader instanceof LandsatGeotiffReader));
    }

    @Test
    public void testGetFormatNames() throws Exception {
        Assert.assertArrayEquals((Object[])new String[]{"LandsatGeoTIFF"}, (Object[])this.plugin.getFormatNames());
    }

    @Test
    public void testGetDefaultFileExtensions() throws Exception {
        Assert.assertArrayEquals((Object[])new String[]{".txt", ".TXT", ".gz"}, (Object[])this.plugin.getDefaultFileExtensions());
    }

    @Test
    public void testGetDescription() throws Exception {
        Assert.assertEquals((Object)"Landsat Data Products (GeoTIFF)", (Object)this.plugin.getDescription(null));
    }

    @Test
    public void testGetProductFileFilter() throws Exception {
        Assert.assertNotNull((Object)this.plugin.getProductFileFilter());
    }

    @Test
    public void testIsMetadataFile() throws Exception {
        File positiveFile1 = new File(this.getClass().getResource("test_L8_MTL.txt").getFile());
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isMetadataFile((File)positiveFile1));
        File positiveFile2 = new File(this.getClass().getResource("test_legacy_L5_WithTrailingWhiteSpace_MTL.txt").getFile());
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isMetadataFile((File)positiveFile2));
        File negativeFile = new File(this.getClass().getResource("test_MTL_L7.txt").getFile());
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isMetadataFile((File)negativeFile));
    }
}

