/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import java.awt.Dimension;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.esa.s3tbx.dataio.landsat.geotiff.Landsat8Metadata;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Landsat8MetadataTest {
    private Landsat8Metadata metadata;

    @Before
    public void setUp() throws Exception {
        this.metadata = new Landsat8Metadata((Reader)new FileReader(new File(this.getClass().getResource("test_L8_MTL.txt").getFile())));
    }

    @Test
    public void testGetCenterTime() throws Exception {
        ProductData.UTC expected = ProductData.UTC.parse((String)"2013-04-12 10:55:46.338", (String)"yyyy-MM-dd HH:mm:ss");
        Assert.assertEquals((long)expected.getAsDate().getTime(), (long)this.metadata.getCenterTime().getAsDate().getTime());
    }

    @Test
    public void testDimensions() throws Exception {
        Assert.assertEquals((Object)new Dimension(15301, 14901), (Object)this.metadata.getPanchromaticDim());
        Assert.assertEquals((Object)new Dimension(7651, 7451), (Object)this.metadata.getReflectanceDim());
        Assert.assertEquals((Object)new Dimension(7651, 7451), (Object)this.metadata.getThermalDim());
    }

    @Test
    public void testGetProductType() throws Exception {
        Assert.assertEquals((Object)"LANDSAT_8_OLI_TIRS_L1GT", (Object)this.metadata.getProductType());
    }

    @Test
    public void testGetScalingFactor() throws Exception {
        Assert.assertEquals((double)0.012838, (double)this.metadata.getScalingFactor("1"), (double)1.0E-7);
        Assert.assertEquals((double)3.342E-4, (double)this.metadata.getScalingFactor("11"), (double)1.0E-7);
    }

    @Test
    public void testGetScalingOffset() throws Exception {
        Assert.assertEquals((double)-64.18855, (double)this.metadata.getScalingOffset("1"), (double)1.0E-7);
        Assert.assertEquals((double)0.1, (double)this.metadata.getScalingOffset("11"), (double)1.0E-7);
    }

    @Test
    public void testGetSpectralInputString() throws Exception {
        System.setProperty("s3tbx.landsat.readAs", "reflectance");
        Assert.assertEquals((Object)"REFLECTANCE", (Object)Landsat8Metadata.getSpectralInputString());
        System.setProperty("s3tbx.landsat.readAs", "radiance");
        Assert.assertEquals((Object)"RADIANCE", (Object)Landsat8Metadata.getSpectralInputString());
    }
}

