/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.server;

import org.esa.s3tbx.insitu.server.InsituQuery;
import org.esa.s3tbx.insitu.server.InsituResponse;
import org.esa.s3tbx.insitu.server.InsituServerException;
import org.esa.s3tbx.insitu.server.InsituServerRunnable;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressUtils;

public interface InsituServer {
    public String getName();

    public InsituResponse query(InsituQuery var1) throws InsituServerException;

    public static void runWithProgress(InsituServerRunnable runnable) throws InsituServerException {
        ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)runnable, (String)"In-Situ Data Access", (ProgressHandle)runnable.getHandle().getProgressHandle(), (boolean)true, (int)50, (int)1000);
        if (runnable.getException() != null) {
            Exception exception = runnable.getException();
            throw new InsituServerException("Query not successful. Exception occured:" + exception.getMessage(), exception);
        }
        InsituResponse response = runnable.getResponse();
        if (InsituResponse.STATUS_CODE.NOK.equals((Object)response.getStatus())) {
            StringBuilder sb = new StringBuilder();
            sb.append("Query not successful. Server responded with failure(s): \n");
            response.getFailureReasons().forEach(sb::append);
            throw new InsituServerException(sb.toString());
        }
    }
}

