package org.esa.s3tbx.fub.wew.util;

public class NN_YellowSubstance {

    // Intercept and slope for input layer for run38_C2_040_nn
    private final static double[][] nodes_input_scale_run38 = new double[][]{
                {+4.165613e-02, +1.161141e-02},
                {+3.520922e-02, +1.063655e-02},
                {+2.920890e-02, +1.050014e-02},
                {+2.699925e-02, +1.067745e-02},
                {+2.323022e-02, +1.168311e-02},
                {+1.756687e-02, +1.029800e-02},
                {+1.578185e-02, +9.680653e-03},
                {+1.385503e-02, +8.916489e-03},
                {+1.205271e-02, +8.339596e-03},
                {+1.165659e-02, +8.278706e-03},
                {+1.021741e-02, +7.993566e-03},
                {+9.918990e-03, +7.898822e-03},
                {+1.500000e+00, +6.362889e+00},
                {+9.800000e+02, +6.666667e+01},
                {+2.468300e-01, +8.368545e-01},
                {-6.613120e-01, +1.469582e+00},
                {-6.613120e-01, +1.469582e+00},
                {+7.501110e-01, +2.776545e-01},
    };
    // Eigenvectors (columnwise) for input PCA layer for run38_C2_040_nn
    private final static double[][] nodes_input_pca_evec_run38 = new double[][]{
                {
                            +2.987128e-02, +5.012741e-02, +3.128965e-01, -1.839117e-01,
                            -2.515101e-01, +9.537556e-02, +1.951132e-01, +3.835905e-01,
                            +3.698127e-01, +4.917117e-01, +3.975757e-01, +2.658838e-01,
                },
                {
                            -5.467707e-02, -9.609455e-02, -5.433896e-01, +3.477573e-01,
                            +3.148865e-01, -2.348693e-01, -2.474436e-01, -1.222517e-01,
                            +1.379598e-01, +3.895818e-01, +3.001649e-01, +2.831469e-01,
                },
                {
                            +5.511071e-02, +9.537394e-02, +4.899910e-01, +1.294779e-01,
                            +1.992049e-01, +3.495089e-01, -1.366492e-01, -5.284581e-01,
                            -3.203669e-01, +8.524382e-02, +2.723258e-01, +2.952426e-01,
                },
                {
                            -5.043848e-02, -8.021983e-02, -3.734165e-01, -5.319926e-01,
                            -3.811867e-01, -1.143003e-01, +1.394639e-01, -2.015440e-01,
                            -4.233631e-01, -8.591241e-02, +2.770852e-01, +2.945050e-01,
                },
                {
                            +2.542997e-02, +2.890051e-02, +8.615620e-02, +4.112196e-01,
                            +9.125980e-02, -1.586412e-01, +1.778534e-01, +5.287141e-01,
                            -3.604252e-01, -4.281583e-01, +2.928888e-01, +2.798537e-01,
                },
                {
                            -6.014826e-02, -4.504145e-02, -3.723890e-02, -4.821022e-01,
                            +5.228052e-01, +1.858608e-01, -1.765293e-01, +1.121151e-01,
                            +3.642503e-01, -4.309576e-01, +8.159340e-02, +2.896239e-01,
                },
                {
                            +3.159947e-02, +3.288428e-02, +7.374523e-02, +2.090286e-01,
                            -5.792314e-01, -7.770485e-02, -5.489796e-01, -9.887578e-02,
                            +3.167300e-01, -3.258197e-01, -4.081011e-02, +2.965549e-01,
                },
                {
                            +1.228259e-01, +3.778724e-02, -1.834374e-01, +2.580923e-01,
                            -6.941688e-02, +1.819798e-01, +6.804890e-01, -3.267829e-01,
                            +3.559505e-01, -1.904504e-01, -1.519540e-01, +2.989569e-01,
                },
                {
                            +4.132860e-01, +3.888447e-01, +1.906697e-01, -1.821823e-01,
                            +1.670982e-01, -6.149707e-01, +2.337064e-02, -6.504560e-02,
                            -3.170422e-02, +1.108576e-01, -3.135619e-01, +2.931648e-01,
                },
                {
                            -7.187661e-01, -3.439119e-01, +2.773039e-01, +9.006392e-03,
                            +3.519847e-02, -2.808168e-01, +1.097280e-01, -5.093635e-02,
                            -2.032478e-02, +8.593365e-02, -3.154047e-01, +2.934479e-01,
                },
                {
                            +4.655721e-01, -6.232449e-01, -3.053205e-02, -1.261999e-03,
                            -6.364665e-03, +2.502512e-01, -9.915259e-02, +1.981671e-01,
                            -1.774697e-01, +1.683296e-01, -3.743372e-01, +2.866153e-01,
                },
                {
                            -2.569052e-01, +5.562720e-01, -2.553637e-01, +1.894313e-02,
                            -3.769187e-02, +4.265914e-01, -1.136805e-01, +2.515104e-01,
                            -1.995428e-01, +1.797651e-01, -3.817992e-01, +2.854936e-01,
                },
    };
    // Input connection weights for run38_C2_040_nn
    private final static double[][] nodes_hidden_weights_run38 = new double[][]{
                {
                            -2.265821e+00, -7.312980e-01, +1.269876e+00, +8.434433e-01,
                            +1.180587e+00, +7.099967e+00, +4.453023e+00, -6.155079e+00,
                            +9.524696e-01, -8.609284e-01, -2.616493e+00, -1.887282e+00,
                            +2.512316e-01, +7.268088e-01, +4.604026e+00, +7.581567e-01,
                            -3.452707e+00, +2.530834e+00, -7.937155e-01, +6.628550e-01,
                            +1.265965e+00, +9.513419e-02, -4.091106e+00, +7.050664e-01,
                            -8.937032e-02, -1.825850e+00, +2.316954e-01, -3.787749e-01,
                            +9.583250e-01, +1.306824e+00, -2.466240e+00, +7.183571e-01,
                            +1.458961e+00, -6.565806e-01, +8.199522e-01, +1.041675e+00,
                            -1.045802e+00, +2.018173e+00, +2.128025e+00, +2.443701e+00,
                },
                {
                            -1.484961e-01, -3.009478e-01, -1.279053e+00, +1.398040e+00,
                            -2.161949e-01, -1.402750e+01, -4.264152e-02, +2.772113e+00,
                            -2.422754e-02, +2.995928e-01, -3.811085e-01, -5.118964e-01,
                            +1.445893e+00, +1.757450e+00, -1.679915e-01, -5.276013e-02,
                            +7.759839e-01, +1.054366e+00, -3.596998e-01, -2.631254e+00,
                            +5.215334e-01, -1.099924e+00, +1.911391e+00, -1.190972e+00,
                            -1.048692e+00, +1.690868e+00, +1.813420e+00, -9.169842e-01,
                            +7.470106e-02, +4.097556e-01, -4.977185e-01, -1.036004e+00,
                            +1.573217e+00, -2.927977e-02, -3.102255e-01, +4.457899e-01,
                            -7.102661e-02, -1.216038e+00, +1.087202e+00, +6.390060e-01,
                },
                {
                            +2.072097e+01, +1.028265e+01, -5.204595e+00, +1.078236e+01,
                            -2.303693e+01, -2.462376e+02, -2.804529e+01, +7.336192e+01,
                            -7.347033e+00, -9.561291e+00, +3.369248e+01, +3.759255e+01,
                            -1.254059e+01, +6.897287e+00, -6.163670e+01, -1.693907e+01,
                            +4.178477e+01, -3.015420e+01, +2.922811e+00, -5.809627e-01,
                            -1.569624e+01, +4.408150e+00, +5.994796e+01, -4.682354e+00,
                            +9.904208e+00, +1.285708e+01, -9.663927e+00, +8.406556e+00,
                            -3.350497e+00, -1.917143e+01, +3.264977e+01, +1.508598e+01,
                            -1.941114e+01, +3.277677e+01, -2.234647e+01, -1.538020e+01,
                            -1.398236e+01, -2.499919e+01, -4.849136e+00, -1.541145e+01,
                },
                {
                            +2.275696e+00, -2.552552e-01, -4.310137e-01, +2.587886e+00,
                            +6.339139e-01, -1.442130e-01, +1.329699e+00, +2.987865e+01,
                            -1.335912e+00, +1.913675e-01, +1.864924e+00, +5.672972e+00,
                            +2.174622e-01, +9.827049e-01, -8.659465e-01, -1.007890e-01,
                            +9.296448e+00, -4.143338e-01, +1.579996e-01, +1.474326e+00,
                            -1.850310e+00, +2.618747e-01, +1.858948e+01, -1.872019e+00,
                            -4.195331e-01, +8.854744e-01, -1.087518e+00, +5.091045e-01,
                            +1.958248e+00, +7.125126e-01, +2.372243e+00, +4.022052e-01,
                            +1.826892e+00, +6.122478e+00, +1.911061e+00, -3.489425e-01,
                            -1.815721e+00, +2.827345e-01, -1.419342e-01, +3.929255e-01,
                },
                {
                            +5.679663e+00, +3.688683e+00, +1.388795e+00, +3.044286e+00,
                            -5.092742e+00, -1.511425e+01, -6.932217e+00, +3.929104e+00,
                            +2.452342e-01, +7.485456e-01, +1.886830e+01, +1.259215e+01,
                            +5.996110e-02, +2.143416e+00, -5.035635e+01, -1.334449e+00,
                            +1.057061e+01, -5.108800e+00, +1.057135e+00, +3.163567e+00,
                            +1.129125e+00, +3.397505e+00, +1.414307e+01, +2.596773e+00,
                            +4.575185e+00, +4.562778e+00, +5.888398e-01, +3.454172e+00,
                            +7.527879e-01, +1.565656e-01, +6.660061e+00, +4.639081e+00,
                            -2.248611e+00, +1.012484e+01, -4.432968e+00, +7.827691e-01,
                            +1.125740e+00, +4.373540e+00, +2.709804e+00, -2.593428e+00,
                },
                {
                            +3.605116e+01, +1.847414e+01, -1.048181e+01, +2.037414e+01,
                            -4.448846e+01, -9.182433e+01, -5.219890e+01, +1.756810e+02,
                            -1.407595e+01, -1.568120e+01, +9.930898e+01, +1.061952e+02,
                            -2.381686e+01, +7.632071e+00, -1.480911e+02, -3.737108e+01,
                            +7.481573e+01, -6.607714e+01, +1.099216e+01, +1.816100e-01,
                            -2.603630e+01, +1.049015e+01, +1.257892e+02, -7.577672e+00,
                            +1.723784e+01, +2.722327e+01, -1.876836e+01, +1.793296e+01,
                            -6.730528e+00, -3.298000e+01, +4.950343e+01, +2.581075e+01,
                            -3.620963e+01, +5.930269e+01, -3.937078e+01, -3.159532e+01,
                            -1.935232e+01, -3.754994e+01, -1.076111e+01, -3.258632e+01,
                },
                {
                            -3.171483e+00, -1.329668e+00, +2.118353e-01, -1.536053e-01,
                            +3.882446e+00, +2.802003e+01, +3.786248e+00, -3.372050e+01,
                            +3.509809e+00, +2.718811e+00, -1.914622e+01, -1.518579e+01,
                            +1.295243e+00, -1.921433e+00, +4.148516e+01, +4.808244e+00,
                            -5.765715e+00, +7.431309e+00, -2.238113e+00, +1.471975e+00,
                            +5.717442e-01, -7.937123e-01, -1.817808e+01, +3.740857e-01,
                            -3.243303e+00, -2.032409e+00, +2.621260e+00, +1.081609e+00,
                            +2.771631e-01, +3.626459e+00, -2.288584e+00, -5.215362e-01,
                            +1.858422e+00, -2.744479e+00, +1.849133e+00, +1.227191e+00,
                            +5.381834e+00, +1.135645e+00, +8.589492e-01, +4.585185e+00,
                },
                {
                            -2.691513e+01, -1.593102e+01, +7.479997e+00, -1.578431e+01,
                            +3.167894e+01, -8.478576e+00, +3.895294e+01, -2.495335e+02,
                            +1.329025e+01, +1.460943e+01, -9.317937e+01, -1.067190e+02,
                            +1.932124e+01, -8.627948e+00, +1.297841e+02, +3.256833e+01,
                            -7.816817e+01, +5.699426e+01, -1.055786e+01, -2.152705e+00,
                            +1.765259e+01, -9.374507e+00, -1.517031e+02, +4.700750e+00,
                            -1.652985e+01, -1.942673e+01, +1.590149e+01, -1.126900e+01,
                            +2.350012e+00, +1.490112e+01, -4.015457e+01, -1.854843e+01,
                            +2.544662e+01, -5.982003e+01, +2.573264e+01, +2.468124e+01,
                            +3.437185e+01, +1.389788e+01, +5.256301e+00, +2.880612e+01,
                },
                {
                            +1.115055e+01, +1.107101e+01, -6.382865e+00, +1.239444e+01,
                            -2.328802e+01, -5.387412e+01, -2.199014e+01, -2.220814e+02,
                            -2.492255e+00, -8.674975e+00, -1.157865e+02, -1.358557e+02,
                            -9.544888e+00, +7.185172e+00, +1.318494e+02, -9.983890e+00,
                            -7.963263e+01, -1.321794e+01, +1.140767e+00, -4.883741e-01,
                            -2.605782e+01, +6.059395e+00, -1.528750e+02, -4.027396e+00,
                            +5.814506e+00, +1.083288e+01, -4.572285e+00, +1.501467e+01,
                            -1.867739e+00, -3.706873e+01, -2.949291e+01, +9.989855e+00,
                            -2.145997e+01, -5.253382e+01, -2.321569e+01, -1.316490e+01,
                            -3.566783e+00, -5.378861e+01, -7.787374e+00, -1.042205e+01,
                },
                {
                            -1.303402e+01, -1.060816e+01, -2.043419e+00, -1.094437e+01,
                            +1.423224e+01, -1.235160e+02, +1.326838e+01, +1.030006e+01,
                            -1.769483e+00, +2.434753e+00, +3.179869e+01, +3.322021e+01,
                            -6.058616e-03, -8.175334e+00, -8.141977e+01, +4.501977e-01,
                            -2.184347e+01, -2.103798e+00, -8.313560e+00, -5.100059e+00,
                            +1.205523e+00, -7.976401e+00, -1.109107e+01, -3.258446e+00,
                            -9.872882e+00, -1.124530e+01, +2.451880e+00, -9.479190e+00,
                            -1.548602e+00, +3.195058e+00, -2.026841e+01, -1.215601e+01,
                            +1.030602e+01, -2.046705e+01, +1.451761e+01, +3.007928e+00,
                            +7.889363e+00, +4.462252e-01, -2.044493e+00, +7.350884e-01,
                },
                {
                            +8.361997e+00, +5.350011e+00, +3.131528e+00, +2.745111e+00,
                            -9.100388e+00, +4.772429e+01, -7.736058e+00, +3.523431e+01,
                            +3.355648e+00, +2.191999e+00, +4.857333e+00, +6.391905e+00,
                            +5.357543e+00, -6.122143e-01, +3.946063e+00, +9.444089e-01,
                            +1.862206e+01, +8.924255e-01, +9.694762e-01, -5.105033e-01,
                            +8.195784e+00, -1.014533e+00, +3.013897e+01, +4.538102e-01,
                            +4.141733e+00, +6.785918e+00, +2.539748e+00, +3.354833e+00,
                            -6.212909e-01, +1.915295e+01, +1.070706e+01, +7.413427e+00,
                            -5.361369e+00, +1.427947e+01, -9.421035e+00, -6.153624e-01,
                            -1.301761e+01, +2.029717e+01, +5.423040e+00, +1.938793e+00,
                },
                {
                            +2.337485e+00, +1.398823e+00, -3.177708e-01, +1.048841e+00,
                            -2.107624e+00, +8.355258e+00, -1.954715e+00, -5.476620e-01,
                            -5.975598e-01, -1.039198e+00, -1.863548e+00, -2.021532e+00,
                            -3.555139e-01, +8.140993e-01, +5.724306e+00, -9.354746e-01,
                            +1.646130e+00, -7.573791e-01, +1.098811e+00, +8.442653e-02,
                            -1.574958e-02, +5.071858e-01, +2.150799e+00, +2.879668e-01,
                            +1.254040e+00, +1.639159e+00, -1.105651e+00, +6.620879e-01,
                            +8.449030e-02, +1.273778e+00, +1.772146e+00, +1.862226e+00,
                            -1.383751e+00, +1.747988e+00, -2.272284e+00, -8.934063e-01,
                            +7.035729e+00, +1.264287e+00, -4.935281e-02, -7.390460e-01,
                },
                {
                            +2.469688e+00, +8.579939e-01, +2.439566e+00, +7.431309e-01,
                            +3.511016e-01, +5.363152e+00, -5.311686e-01, +5.071677e+00,
                            +1.049975e+00, +2.352001e+00, +4.658797e+00, +4.749278e+00,
                            +1.859285e+00, +2.501783e+00, -1.625142e-02, +1.953543e+00,
                            +5.822778e-01, +2.812656e+00, -1.844435e+00, -2.127334e-01,
                            +8.190116e-02, -3.697675e-01, -8.699825e-01, -6.356913e-01,
                            +1.340803e+00, +1.343685e-01, -2.181188e-01, -6.183142e-01,
                            +1.769501e+00, +3.161730e+00, +8.709615e+00, +2.469814e+00,
                            +2.493518e+00, +6.432214e+00, -1.557430e+00, +1.220107e+00,
                            +3.186806e+00, +2.450414e+00, +5.391391e-01, +2.619649e+00,
                },
                {
                            +3.628523e+00, +5.124858e-01, -1.924850e+00, -6.923369e-01,
                            -8.473368e-01, +7.218011e+00, -2.123090e+00, +2.772145e+00,
                            -5.939972e-01, +3.884385e-01, -4.506409e-01, -2.557341e+00,
                            +1.831151e+00, -7.942920e-02, +9.291992e-01, +5.887746e-01,
                            +3.381160e+00, +1.157685e+00, +1.250846e+00, -2.269335e-02,
                            +8.561532e-01, -7.207569e-01, +3.329721e+00, +9.667252e-01,
                            +3.360454e-01, +2.491554e+00, +2.897041e-01, -4.981374e-01,
                            -5.042846e-01, +2.690844e+00, +4.008450e+00, +2.622349e+00,
                            -1.111745e+00, +4.780027e+00, -1.372079e+00, -1.464729e+00,
                            +1.126129e-01, +2.465142e+00, -3.110736e-01, +1.298705e+00,
                },
                {
                            +1.869436e+00, -3.735535e-02, -1.518800e+00, -2.269448e+00,
                            -6.574776e-01, +8.432164e+01, -3.751700e+00, +3.645815e+01,
                            +6.712583e-01, +2.049975e-01, +9.443460e+00, +1.324356e+01,
                            +5.388682e-01, -1.578099e+00, -1.507446e+00, -2.674967e-03,
                            +4.427547e+01, +8.631734e-01, +4.248612e-01, +1.547786e+00,
                            +1.153235e+00, -9.133372e-02, +4.915923e+01, -4.232292e-01,
                            +1.671666e+00, +1.266045e+00, +2.587757e+00, +2.247705e+00,
                            +9.046090e-01, +3.025273e+00, +2.021224e+01, +1.326182e+00,
                            -1.471381e+00, +3.148452e+01, -1.319403e+00, -4.834144e-01,
                            +3.350748e+00, +3.717800e+00, -3.504928e-02, -1.083432e+00,
                },
                {
                            +1.098238e+01, +4.085102e+00, +1.124361e+00, +4.342685e+00,
                            -2.730283e+00, +1.155269e+01, -6.665784e+00, +2.954000e+01,
                            +9.147094e-01, +2.209707e+00, +1.254853e+01, +1.305853e+01,
                            +2.061570e-01, +2.340390e+00, -2.351568e+00, -6.089755e-01,
                            +2.524422e+01, -4.206849e+00, +1.546493e+00, +1.476272e+00,
                            +1.087701e+00, -3.373741e-02, +3.013538e+01, +2.028772e+00,
                            +4.684729e+00, +5.760694e+00, +1.118754e+00, +3.303246e+00,
                            +2.132375e+00, +1.436242e+00, +1.783087e+01, +7.611907e+00,
                            +5.195948e-02, +2.199092e+01, -4.601152e+00, -1.262586e+00,
                            +3.262984e+00, +1.358564e+00, +1.755395e+00, -5.064405e-01,
                },
                {
                            +5.022521e+00, +1.522156e+00, +1.702339e-01, +3.122145e-01,
                            -3.410249e+00, +2.094000e+01, -4.180591e+00, +1.073347e+01,
                            -8.528297e-01, +2.951383e-01, +3.767863e+00, +6.177448e+00,
                            -1.256235e+00, +1.008661e+00, +1.994185e+00, -1.927580e+00,
                            +8.390907e+00, -7.041588e-01, +6.871741e-01, +6.393519e-01,
                            -2.415470e-01, +1.930420e+00, +9.993052e+00, -1.798573e+00,
                            -6.911025e-01, +2.367102e+00, +5.753740e-03, +2.989609e+00,
                            +5.569111e-01, +1.377592e+00, +8.441106e+00, +1.009440e+00,
                            -1.408276e+00, +7.615203e+00, -2.881657e+00, -1.524515e+00,
                            +1.127642e+00, -3.060601e-01, -9.403839e-01, -4.707188e-01,
                },
                {
                            +5.526560e+00, +3.134465e+00, +1.335595e+00, +9.531748e-01,
                            -8.965663e-01, +3.349961e-01, -3.866109e+00, +1.116614e+01,
                            +1.807353e+00, +6.119544e-01, +6.349189e+00, +7.225989e+00,
                            +1.434992e+00, +1.354830e+00, -3.255212e+00, -3.947049e-01,
                            +1.711050e+01, -2.884861e+00, +1.588820e+00, +1.419964e+00,
                            +2.067423e+00, +2.710956e+00, +1.711029e+01, +1.728673e+00,
                            +2.886698e+00, +4.285232e+00, +2.225397e+00, +2.390907e+00,
                            +1.636091e+00, +3.805864e+00, +1.112855e+01, +5.016024e+00,
                            -4.514309e-01, +1.429692e+01, -3.001155e+00, +9.006612e-01,
                            +3.454529e+00, +4.408843e+00, +1.036628e+00, -1.710328e-01,
                },
                {
                            +3.234985e-01, -9.591889e-01, +2.207668e+00, +3.711809e-02,
                            -4.265389e-01, +2.286731e+00, +1.762214e+00, -4.494565e-01,
                            -5.982876e-01, -3.328332e-02, -9.650386e-01, -1.017496e+00,
                            +1.053419e+00, +3.088162e-02, +3.070681e-01, -1.301553e+00,
                            -3.259966e-01, +1.095333e+00, -8.999613e-02, -8.512937e-01,
                            -2.806764e-01, -1.153844e+00, -1.274015e+00, +1.005432e+00,
                            -7.983571e-01, +5.490254e-01, -1.987318e+00, +9.737239e-01,
                            +2.643529e-01, +4.866056e-01, +1.504913e-01, +2.392403e+00,
                            +1.009845e+00, -1.391422e-01, -4.548126e-01, +1.031506e+00,
                            -4.595136e-01, +2.275585e-01, -3.036588e-01, +1.114060e+00,
                },
    };
    // Output connection weights from KOH file for run38_C2_040_nn
    private final static double[][] nodes_output_weights_run38 = new double[][]{
                {-1.027912e+01,},
                {-5.192022e+00,},
                {+4.352206e+00,},
                {-5.196440e+00,},
                {+1.510855e+01,},
                {+1.144646e+02,},
                {+1.724954e+01,},
                {-6.347385e+01,},
                {+5.332780e+00,},
                {+6.636708e+00,},
                {-2.231490e+01,},
                {-2.726620e+01,},
                {+8.326938e+00,},
                {-1.818381e+00,},
                {+4.137374e+01,},
                {+1.180842e+01,},
                {-3.002938e+01,},
                {+1.927728e+01,},
                {-1.897392e+00,},
                {+9.838744e-01,},
                {+1.091452e+01,},
                {-2.390348e+00,},
                {-4.814390e+01,},
                {+3.474093e+00,},
                {-4.115273e+00,},
                {-6.922282e+00,},
                {+6.674974e+00,},
                {-4.689401e+00,},
                {+2.994887e+00,},
                {+1.505115e+01,},
                {-1.840819e+01,},
                {-6.894830e+00,},
                {+1.270031e+01,},
                {-2.186951e+01,},
                {+1.402909e+01,},
                {+1.008017e+01,},
                {+1.558944e+01,},
                {+1.841951e+01,},
                {+4.483876e+00,},
                {+1.072083e+01,},
                {+5.650157e+00,},
    };
    // Intercept and slope for output layer for run38_C2_040_nn
    private final static double[][] nodes_output_scale_run38 = new double[][]{
                {-2.300000e+00, 2.875000e+00}
    };
    // Output offset factors for run38_C2_040_nn
    private final static double[] nodes_output_scale_off_run38 = new double[]{
                1.000000e-01,
    };
    // Output scale flags for run38_C2_040_nn
    private final static int[] nodes_output_scale_flag_run38 = new int[]{
                0,
    };
    // Output limits (min/max) from training data set for run38_C2_040_nn
    private final static double[][] nodes_output_scale_limits_run38 = new double[][]{
                {-2.300000e+00, +0.000000e+00,}
    };

    public static int compute(final float[][] in,
                              final int getNumNodesInput,
                              final float[][] out,
                              final int getNumNodesOutput,
                              final int width,
                              final int[] mask,
                              final int errmask,
                              final float[] a) {
        // (c) M. Schaale, WeW, 2002-2006
        final int rcheck[];
        final int nodes_input = 18;
        final int nodes_output = 1;
        final int nodes_input_bias = 1;
        final int nodes_input_pca = 1;
        final int nodes_hidden = 40;
        final int nodes_hidden_bias = 1;
        final double nodes_hidden_temperature = 1.000000;
        final double t_input = nodes_hidden_temperature / (double) (nodes_input);
        final double t_hidden = nodes_hidden_temperature / (double) (nodes_hidden);
        final double[] vt;
        final double[] vt1;
        //double limexp = -Math.log(Float.MIN_VALUE), dh, dhr, dhe, dhmax=Float.MAX_VALUE, expo;

        // Return dimensions on request
        if (getNumNodesInput <= 0) {
            return (nodes_input);
        }
        if (getNumNodesOutput <= 0) {
            return (nodes_output);
        }

        // Crude compatibility checks
        if (getNumNodesInput != nodes_input) {
            return (-1);
        }
        if (getNumNodesOutput != nodes_output) {
            return (-2);
        }

        vt = new double[nodes_input + nodes_input_bias];
        vt1 = new double[nodes_hidden + nodes_hidden_bias];

        // Range check ??
        rcheck = new int[width];
        for (int x = 0; x < width; x++) {
            rcheck[x] = 0;
            if (a[x] < 0.0f) {
                rcheck[x] = 1;
            }
            a[x] = 1.0f;
        }

        for (int x = 0; x < width; x++) {
            if (mask[x] == 0) {
                // Check input range
                if (rcheck[x] != 0) {
                    for (int i = 0; i < nodes_input && a[x] > 0.0f; i++) {
                        if ((in[i][x] < (float) NN_General.NODES_INPUT_SCALE_LIMITS[i][0]) || (in[i][x] > (float) NN_General.NODES_INPUT_SCALE_LIMITS[i][1])) {
                            a[x] -= 3.0f;
                        }
                    }
                    if (a[x] < 0.0f) {
                        mask[x] |= errmask;
                    }
                }

                //if(mask[x] == 0) {
                // Apply input transformation
                for (int i = 0; i < nodes_input; i++) {
                    if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -1) {
                        in[i][x] = (float) Math.log((double) in[i][x]);
                    }
                    if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -2) {
                        in[i][x] = (float) Math.exp((double) in[i][x]);
                    }
                }

                // Apply input scale layer parameters
                for (int i = 0; i < nodes_input; i++) {
                    in[i][x] = (float) NN_General.NODES_INPUT_SCALE_OFF[i] + (in[i][x] - (float) nodes_input_scale_run38[i][0]) / (float) nodes_input_scale_run38[i][1];
                }

                // Apply input PCA layer parameters
                if (nodes_input_pca != 0) {
                    for (int i = 0; i < nodes_input; i++) {
                        vt[i] = (double) in[i][x];
                        if (NN_General.NODES_INPUT_SCALE_FLAG[i] == 1) {
                            vt[i] = 0.0;
                            for (int j = 0; j < nodes_input; j++) {
                                if (NN_General.NODES_INPUT_SCALE_FLAG[j] == 1) {
                                    vt[i] += (double) in[j][x] * nodes_input_pca_evec_run38[j][i];
                                }
                            }
                        }
                    }
                    for (int i = 0; i < nodes_input; i++) {
                        in[i][x] = (float) vt[i];
                    }
                }

                // Pump through the first layer
                for (int i = 0; i < nodes_input; i++) {
                    vt[i] = (double) in[i][x];
                }
                for (int i = nodes_input; i < nodes_input + nodes_input_bias; i++) {
                    vt[i] = 1.0;
                }

                for (int i = 0; i < nodes_hidden; i++) {
                    vt1[i] = 0.0;
                    for (int j = 0; j < nodes_input + nodes_input_bias; j++) {
                        vt1[i] += vt[j] * nodes_hidden_weights_run38[j][i];
                    }
                }
                // Pump through sigmoid
                for (int i = 0; i < nodes_hidden; i++) {
                    vt1[i] = 1.0 / (1.0 + Math.exp(-t_input * vt1[i]));
                }

                // Pump through the second layer
                for (int i = nodes_hidden; i < nodes_hidden + nodes_hidden_bias; i++) {
                    vt1[i] = 1.0f;
                }
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = 0.0f;
                    for (int j = 0; j < nodes_hidden + nodes_hidden_bias; j++) {
                        out[i][x] += (float) (vt1[j] * nodes_output_weights_run38[j][i]);
                    }
                }
                for (int i = 0; i < nodes_output; i++) {
                    // Pump through sigmoid
                    out[i][x] = (float) (1.0 / (1.0 + Math.exp(-t_hidden * out[i][x])));
                    // Apply output scale layer parameters
                    out[i][x] = (float) nodes_output_scale_run38[i][0] + (out[i][x] - (float) nodes_output_scale_off_run38[i]) * (float) nodes_output_scale_run38[i][1];

                    // Apply output transformation
                    if (nodes_output_scale_flag_run38[i] == -1) {
                        out[i][x] = (float) Math.log((double) out[i][x]);
                    }
                    if (nodes_output_scale_flag_run38[i] == -2) {
                        out[i][x] = (float) Math.exp((double) out[i][x]);
                    }
                }

                // Check output range
                if (rcheck[x] != 0) {
                    for (int i = 0; i < nodes_output && a[x] >= -2.0f; i++) {
                        if ((out[i][x] < (float) nodes_output_scale_limits_run38[i][0]) || (out[i][x] > (float) nodes_output_scale_limits_run38[i][1])) {
                            a[x] -= 20.0f;
                        }
                    }
                    if (a[x] < 0.0f) {
                        mask[x] |= errmask;
                    }
                }

                //} // mask
            } // mask
        } // x
        return 0;
    }
}
