package org.esa.s3tbx.fub.wew.util;

public class NN_TSM {

    // Intercept and slope for input layer for run39_C2_080_nn
    private final static double[][] nodes_input_scale_run39 = new double[][]{
                {+4.165626e-02, +1.161143e-02},
                {+3.520903e-02, +1.063651e-02},
                {+2.920866e-02, +1.050014e-02},
                {+2.699918e-02, +1.067744e-02},
                {+2.323030e-02, +1.168309e-02},
                {+1.756670e-02, +1.029799e-02},
                {+1.578191e-02, +9.680616e-03},
                {+1.385501e-02, +8.916464e-03},
                {+1.205261e-02, +8.339618e-03},
                {+1.165650e-02, +8.278698e-03},
                {+1.021733e-02, +7.993577e-03},
                {+9.918949e-03, +7.898820e-03},
                {+1.500000e+00, +6.362889e+00},
                {+9.800000e+02, +6.666667e+01},
                {+2.468300e-01, +8.368545e-01},
                {-6.613120e-01, +1.469582e+00},
                {-6.613120e-01, +1.469582e+00},
                {+7.501110e-01, +2.776545e-01},
    };
    // Eigenvectors (columnwise) for input PCA layer for run39_C2_080_nn
    private final static double[][] nodes_input_pca_evec_run39 = new double[][]{
                {
                            +3.030646e-02, +4.990876e-02, +3.128123e-01, -1.842190e-01,
                            -2.513797e-01, +9.538573e-02, +1.951190e-01, +3.835894e-01,
                            +3.698123e-01, +4.917106e-01, +3.975749e-01, +2.658831e-01,
                },
                {
                            -5.552917e-02, -9.565797e-02, -5.431954e-01, +3.482490e-01,
                            +3.146494e-01, -2.348827e-01, -2.474442e-01, -1.222479e-01,
                            +1.379611e-01, +3.895831e-01, +3.001657e-01, +2.831475e-01,
                },
                {
                            +5.598141e-02, +9.481888e-02, +4.900537e-01, +1.291934e-01,
                            +1.992491e-01, +3.494936e-01, -1.366924e-01, -5.284610e-01,
                            -3.203657e-01, +8.524408e-02, +2.723256e-01, +2.952424e-01,
                },
                {
                            -5.117450e-02, -7.966258e-02, -3.737462e-01, -5.318503e-01,
                            -3.810696e-01, -1.142772e-01, +1.395136e-01, -2.015426e-01,
                            -4.233636e-01, -8.591203e-02, +2.770854e-01, +2.945053e-01,
                },
                {
                            +2.569358e-02, +2.863349e-02, +8.645135e-02, +4.111902e-01,
                            +9.114593e-02, -1.586442e-01, +1.778414e-01, +5.287130e-01,
                            -3.604257e-01, -4.281582e-01, +2.928889e-01, +2.798539e-01,
                },
                {
                            -6.058641e-02, -4.454571e-02, -3.769220e-02, -4.818906e-01,
                            +5.229458e-01, +1.858861e-01, -1.765448e-01, +1.121190e-01,
                            +3.642496e-01, -4.309570e-01, +8.159291e-02, +2.896239e-01,
                },
                {
                            +3.192693e-02, +3.268587e-02, +7.398770e-02, +2.087469e-01,
                            -5.793053e-01, -7.776389e-02, -5.489588e-01, -9.887996e-02,
                            +3.167307e-01, -3.258202e-01, -4.081065e-02, +2.965558e-01,
                },
                {
                            +1.232582e-01, +3.651965e-02, -1.831944e-01, +2.582317e-01,
                            -6.950327e-02, +1.820014e-01, +6.804780e-01, -3.267826e-01,
                            +3.559499e-01, -1.904502e-01, -1.519548e-01, +2.989575e-01,
                },
                {
                            +4.172159e-01, +3.844972e-01, +1.905789e-01, -1.822934e-01,
                            +1.672969e-01, -6.149912e-01, +2.340766e-02, -6.504580e-02,
                            -3.170411e-02, +1.108579e-01, -3.135614e-01, +2.931637e-01,
                },
                {
                            -7.224088e-01, -3.363836e-01, +2.771402e-01, +8.815814e-03,
                            +3.517729e-02, -2.807592e-01, +1.097266e-01, -5.093173e-02,
                            -2.032554e-02, +8.593423e-02, -3.154054e-01, +2.934479e-01,
                },
                {
                            +4.590879e-01, -6.280603e-01, -3.032013e-02, -1.221827e-03,
                            -6.519634e-03, +2.502223e-01, -9.914526e-02, +1.981608e-01,
                            -1.774700e-01, +1.683298e-01, -3.743368e-01, +2.866146e-01,
                },
                {
                            -2.509924e-01, +5.588953e-01, -2.554863e-01, +1.911668e-02,
                            -3.763345e-02, +4.265937e-01, -1.137180e-01, +2.515140e-01,
                            -1.995437e-01, +1.797657e-01, -3.817994e-01, +2.854934e-01,
                },
    };
    // Input connection weights for run39_C2_080_nn
    private final static double[][] nodes_hidden_weights_run39 = new double[][]{
                {
                            -1.028640e+00, +3.273034e-01, +1.450230e+00, +1.850634e+00,
                            -9.856938e-01, +5.441931e-01, +2.119227e+00, -7.843528e-01,
                            +5.139969e-01, -9.630165e-01, -7.358352e-02, +9.185026e-01,
                            +5.290683e+00, +9.091678e-01, +3.620018e-01, +8.854066e-01,
                            -1.445607e+00, +3.755990e-02, -5.034639e-01, +5.141245e-01,
                            -4.724502e-01, +7.845047e-01, -1.058256e+00, +8.798043e-01,
                            +8.173088e-01, -1.224477e+00, -9.910309e-01, +5.094386e-01,
                            +4.306520e-01, -2.221714e-01, -2.395146e+00, +1.503358e+00,
                            +5.239866e-01, +1.778775e+00, -1.268965e+00, -4.029132e-01,
                            -1.586325e+00, -4.030003e-01, +1.358356e+00, +8.788674e-01,
                            -6.219935e-01, +5.768160e-01, -4.358268e-02, +6.259568e-01,
                            -5.719956e-01, -1.165170e+00, -9.640183e-01, +5.428737e-01,
                            -4.366238e-01, +4.735517e-01, -2.494671e-01, -6.655799e-01,
                            +1.589269e+00, +8.133234e-02, -1.307171e+00, +2.791493e+00,
                            +8.769181e-02, -2.073229e+00, +3.643110e-01, +1.789362e+00,
                            -1.081592e-01, -1.714342e+00, -1.570524e+00, +3.845745e-01,
                            +1.076707e+00, +5.557213e-01, +2.064193e-01, +1.443529e+00,
                            -6.455161e-02, -2.844217e-01, -1.029348e+00, -4.754765e-01,
                            +7.271122e-01, +8.562564e-01, -9.465616e-01, +3.721402e-01,
                            -5.829101e-02, -1.205841e+00, +6.081762e-01, -4.098553e-01,
                },
                {
                            -1.513662e-01, -1.412420e-01, -1.355359e+00, +1.580120e+00,
                            -3.491726e-01, -5.441911e-01, -4.757158e-02, +1.358662e+00,
                            -7.719129e-02, +3.256148e-01, -6.179655e-01, -7.913457e-01,
                            +1.291487e+00, +1.865813e+00, +1.312444e+00, +1.729584e-01,
                            -5.829416e-01, +6.819526e-01, -2.636668e-01, -2.615658e+00,
                            +4.543323e-01, -9.717481e-01, +1.345715e-02, -1.218729e+00,
                            -9.060318e-01, +1.867180e+00, +1.705147e+00, -7.802880e-01,
                            +5.914770e-02, +2.559791e-01, -1.098360e+00, -9.302036e-01,
                            +1.377203e+00, -8.399954e-01, -3.570192e-01, +2.746445e-01,
                            -3.505855e-03, -1.372853e+00, +1.097033e+00, +4.438565e-01,
                            -1.185879e-01, +4.849250e-01, +9.559125e-01, +1.524073e-01,
                            -8.691744e-01, -5.459470e-01, -8.253153e-01, -1.363966e-01,
                            -6.217844e-01, -5.164209e-01, -2.476145e-01, -1.159885e+00,
                            +8.113868e-01, -1.626468e+00, +1.603318e+00, +1.181425e+00,
                            -6.378908e-01, -7.126339e-01, -1.457644e-01, +1.641874e+00,
                            -3.791535e-01, -1.892753e+00, -8.176998e-01, +6.507391e-01,
                            +6.779729e-01, -2.044225e+00, +4.614784e-01, -1.208596e-02,
                            -7.519335e-01, -4.293145e-01, -7.622466e-01, +8.738293e-02,
                            -4.939852e-01, +6.653093e-01, +6.130260e-01, +6.028420e-01,
                            +9.527184e-01, -1.509421e+00, -1.321201e+00, +1.446165e-01,
                },
                {
                            +7.107071e-01, -4.987100e-01, -1.031347e+00, +6.631881e-01,
                            +1.370709e+00, -4.111377e+00, +1.023866e+00, +9.085061e-01,
                            -3.561266e-01, -1.756233e+00, -1.128304e+00, +2.606159e-01,
                            -1.951462e+01, +2.971860e+00, +4.017389e-01, -2.721159e+00,
                            -4.446399e-02, -6.089693e-01, -1.293759e+00, +4.276523e-02,
                            +7.283584e-01, -8.824133e-01, +1.008613e+00, -1.697539e+00,
                            +9.204667e-01, +3.166942e-01, +1.294861e-01, -5.347721e-01,
                            +4.248439e-01, +1.432067e-01, +4.291277e+00, +1.562832e+00,
                            -1.793363e+00, -1.592543e+00, +1.651411e+00, -1.671116e-03,
                            -8.169024e-01, -2.180657e-01, +1.374536e+00, +9.392562e-01,
                            +6.109760e-01, -4.934626e-01, +2.681007e-01, -4.485983e-01,
                            +1.370646e+00, -1.435785e+00, -9.618746e-01, -1.903451e+00,
                            -1.508730e+00, -7.185509e-01, +2.081986e+00, -1.697802e+00,
                            +3.972071e-01, +3.309597e-01, -1.020784e+00, -4.627172e+00,
                            +5.506887e-01, +7.282418e-01, +1.085633e+00, +1.510299e+00,
                            +1.071759e+00, -3.684537e-01, +1.087223e+00, +1.352990e+00,
                            +8.403855e-02, +1.454523e+00, +1.686699e-01, -3.059338e-01,
                            -3.451367e-01, -8.203987e-01, +3.024044e+00, +7.079532e-01,
                            -6.850714e-02, -8.129181e-01, +5.161046e-01, +3.130742e-01,
                            -1.316258e-01, +1.930693e+00, +4.858416e-01, -7.376671e-01,
                },
                {
                            -7.762396e-02, +6.227359e-01, +4.341908e+00, +3.206713e+00,
                            -2.188759e+00, +7.882429e+00, -3.054329e-01, -1.792776e+00,
                            +3.843426e-01, +4.191176e+00, -2.019327e+00, -6.305718e-01,
                            +5.770045e+01, -9.820923e-01, -8.067748e-01, +1.477471e+01,
                            -1.134736e+00, +2.840463e+00, -1.321009e+00, +1.629766e-01,
                            -4.107762e+00, +1.644833e+00, -2.780101e+00, +1.706493e+00,
                            +1.019608e-01, -2.683397e+00, -3.762907e+00, +1.413559e+00,
                            +1.836276e-02, +2.943215e+00, -1.036286e+01, -2.243308e+00,
                            +5.905794e+00, +4.149498e+00, -9.176546e-01, -9.121519e-01,
                            +1.041608e+00, -1.667465e+00, -2.119316e+00, +1.644846e-01,
                            -2.023599e+00, +8.867444e-01, -1.710568e+00, -2.581954e+00,
                            -2.771907e+00, -2.043817e+00, -2.167880e+00, -6.429396e-02,
                            +2.786401e+00, +1.778788e+00, -1.424264e+00, -1.953928e+00,
                            +2.400017e+00, +1.296091e+00, -2.337355e+00, +3.235111e+00,
                            -2.555179e+00, -1.032419e+00, +1.349651e+00, +1.126638e-01,
                            -1.040495e+00, +2.159661e+00, -7.299529e-01, -4.176107e+00,
                            +1.101193e+00, -1.429352e+00, +1.810645e+00, +2.538473e+00,
                            +9.533013e-01, +3.356308e+00, -5.987496e+00, +8.938388e-01,
                            -1.400090e+00, +6.335884e-01, -3.956538e+00, +1.831205e-01,
                            -1.137888e+00, -7.579974e-01, -3.646068e+00, +2.490107e+00,
                },
                {
                            +5.407537e-01, +3.225077e-01, -1.195118e+00, -9.209585e-03,
                            -5.515351e-01, -1.823319e+00, -6.573718e-01, +2.061948e+00,
                            -2.834533e-01, -2.421928e-01, +5.000776e-01, -4.738606e-01,
                            -4.074080e+00, +7.223543e-01, +1.917774e-01, +2.847430e+00,
                            +4.607697e-01, -7.730550e-01, -8.958312e-01, +2.335453e+00,
                            +1.475993e+00, +1.724258e+00, +1.989218e+00, +4.825041e-01,
                            +1.517378e+00, +2.300138e+00, +5.703946e-01, +1.458527e+00,
                            -3.233997e-02, -1.333537e+00, +4.954449e+00, +1.443462e+00,
                            -2.149797e+00, +4.658920e-01, +7.429065e-01, +1.400349e+00,
                            -1.067723e+00, +1.979800e+00, +2.131769e+00, -1.945057e+00,
                            +1.698011e+00, +2.206188e-01, +8.111503e-01, +9.760413e-01,
                            -1.677718e+00, +6.835501e-01, +2.110476e+00, -1.963312e-01,
                            -1.033981e+00, +6.509496e-02, -1.911383e-01, +7.595630e-01,
                            +5.972295e-01, -6.882876e-01, +1.851074e+00, -4.738149e+00,
                            -5.585422e-01, +1.000982e+00, +7.346752e-02, +5.850136e-02,
                            -4.339274e-01, -5.074688e-01, +8.159048e-01, +1.755665e+00,
                            +9.913584e-02, +1.076926e+00, -8.606169e-01, +8.442020e-01,
                            -1.164629e+00, -5.455661e-01, +5.209866e+00, -1.561608e+00,
                            +2.984425e+00, -3.071805e-01, +1.268603e+00, +1.152527e+00,
                            +9.750946e-01, -4.695968e-01, +1.492485e-01, +5.413353e-01,
                },
                {
                            -4.111478e+00, +9.860810e-01, +1.328753e+01, +2.436145e+00,
                            -5.468512e+00, +1.648101e+01, -5.232090e+00, -7.354170e+00,
                            +6.839494e+00, +1.576588e+01, -2.130263e+00, -3.305749e+00,
                            +8.636438e+01, -7.346375e+00, -4.713102e+00, +3.415950e+01,
                            -4.895496e+00, +8.014635e+00, -2.478626e+00, -3.465616e+00,
                            -4.132648e+00, +4.957179e+00, -4.503455e+00, +1.070192e+01,
                            +2.428137e+00, -6.509274e+00, -9.658916e+00, +2.671412e+00,
                            -6.709060e+00, +7.822658e+00, -3.082878e+01, -5.827442e+00,
                            +1.388321e+01, +1.197477e+01, -4.794949e+00, -1.309176e+00,
                            +8.752268e+00, -5.887034e+00, -6.282693e+00, +7.391378e-02,
                            -2.803486e+00, +5.359119e+00, -4.635070e+00, -5.162092e+00,
                            -6.283190e+00, -5.921765e+00, -6.351967e+00, -3.960878e+00,
                            +1.190987e+01, +6.417547e+00, -5.404250e+00, -3.639157e+00,
                            +7.404305e+00, +8.335506e+00, -6.231016e+00, +1.684628e+01,
                            -4.267122e+00, -3.974711e+00, +1.443708e+00, -1.655544e+00,
                            -1.256148e+00, +9.233847e+00, -7.356833e+00, -6.627114e+00,
                            +5.788129e+00, -4.135643e+00, +6.230348e+00, +1.020335e+01,
                            +4.169735e+00, +9.652097e+00, -1.275852e+01, +6.548829e+00,
                            -4.221786e+00, +6.103588e+00, -6.041092e+00, -2.000523e+00,
                            -4.946797e+00, -6.245307e+00, -6.751211e+00, +3.558194e+00,
                },
                {
                            -4.063347e+00, +1.892127e+00, +5.641768e+00, +2.465293e+00,
                            -1.946999e+00, +8.167302e+00, -1.999968e+00, -5.044397e+00,
                            +4.029574e+00, +8.452600e+00, -2.431684e+00, -3.222912e+00,
                            +3.297318e+01, -4.250467e+00, -1.687580e+00, +1.188009e+01,
                            -5.191894e-01, +3.914913e+00, -2.458869e+00, -1.243346e-01,
                            -6.043478e+00, +2.149151e+00, -4.820219e+00, +4.829615e+00,
                            -1.017795e-01, -5.690404e+00, -2.682749e+00, +2.948072e+00,
                            -3.038706e+00, +4.034020e+00, -2.122466e+01, -2.916359e+00,
                            +6.908819e+00, +7.259174e+00, -4.680390e+00, -1.740042e+00,
                            +4.326658e+00, -4.453294e+00, -3.866313e+00, +6.617756e-01,
                            -2.443606e+00, +2.268698e+00, -4.027297e+00, -2.763399e+00,
                            -4.522260e+00, -1.993286e+00, -4.120534e+00, -7.157414e-01,
                            +4.045464e+00, +2.228764e+00, -5.011538e+00, -3.537691e+00,
                            +1.593213e+00, +3.181492e+00, -4.304257e+00, +1.409592e+01,
                            -2.147154e+00, -1.369212e+00, -1.004619e+00, -1.396837e+00,
                            -1.054845e+00, +3.603155e+00, -4.210173e+00, -7.025674e+00,
                            +1.704426e+00, -2.332328e+00, +3.925208e+00, +4.845739e+00,
                            +1.499455e+00, +4.886853e+00, -7.589726e+00, +3.471988e+00,
                            -2.723701e+00, +3.243072e+00, -4.319954e+00, +3.362255e-01,
                            -3.438054e+00, -2.316236e+00, -6.693070e+00, +3.044091e+00,
                },
                {
                            -6.147025e-01, -7.226155e-01, +7.099229e+00, -6.954497e-01,
                            +1.636326e+00, +1.461316e+01, +1.573823e+00, -1.745396e+00,
                            -8.483863e-01, +6.847863e+00, -1.202765e+00, +1.685428e+00,
                            +6.937821e+01, +1.548805e+00, +1.826795e+00, +1.542060e+01,
                            +6.564782e-01, -4.140233e+00, +1.481884e+00, +5.566636e-01,
                            -7.747134e-01, -1.453937e+00, -2.373691e+00, +2.747360e+00,
                            -1.688034e+00, -7.280803e+00, +3.186169e+00, +1.355979e-01,
                            +1.520299e+00, -4.620399e+00, -4.245459e+01, -1.988969e+00,
                            +6.448956e+00, +1.263444e+00, -3.803375e+00, -4.256859e-01,
                            -1.326386e+00, -3.717073e-02, -1.375702e+00, +6.056919e-01,
                            -1.361652e+00, -1.326205e+00, +1.386105e+00, +1.479149e+00,
                            -7.186177e-01, +9.709089e-02, -2.255897e+00, +1.673587e+00,
                            -3.173054e+00, -1.880666e+00, -8.073879e-01, +1.713125e+00,
                            -2.891011e+00, +5.030514e-01, -4.242791e+00, +3.223316e+01,
                            +8.228428e-01, +1.342370e+00, -3.629054e-01, +2.227386e+00,
                            +6.214462e-01, -4.035555e+00, -2.984075e+00, -7.177989e+00,
                            -3.079872e+00, +1.690334e+00, +1.948633e-02, -5.617353e+00,
                            -1.482218e+00, -3.522802e+00, -1.310520e+01, -2.233889e+00,
                            -1.247562e-01, -2.169668e+00, -1.492896e+00, -1.151376e+00,
                            -4.875574e-01, +4.548420e-01, -4.608017e+00, -3.492397e+00,
                },
                {
                            -7.676233e+00, -2.099720e+00, +2.506844e+01, -1.696885e+00,
                            -3.524554e+00, +4.443758e+01, -8.297911e-01, -1.736607e+01,
                            +6.757512e-01, +9.371397e+00, -2.975999e+00, -1.392712e+00,
                            -9.187932e+01, -3.291607e+00, +1.213669e+00, +2.584294e+01,
                            -7.968557e-01, -9.809002e-01, -1.926156e+00, -3.007228e-01,
                            -1.079624e+01, -2.914749e+00, -1.723936e+01, +1.524559e+01,
                            -2.228372e+00, -2.551307e+01, +1.224843e+00, -1.001511e+00,
                            +1.478333e+00, -2.423707e+00, -4.191687e+01, -1.694231e+01,
                            +2.634527e+01, +1.636721e+01, -5.604570e+00, -3.669323e-01,
                            +1.159508e+00, -5.312253e+00, -7.391905e+00, +1.182460e+00,
                            -7.463729e+00, -2.476199e+00, -4.490124e+00, +2.113884e+00,
                            -1.104806e+01, -4.965501e+00, -1.362059e+01, -1.145157e+00,
                            -2.705824e+00, -2.783081e+00, -9.360642e+00, +7.133185e-01,
                            -1.402998e+00, +4.892941e+00, -1.692367e+01, +5.194911e+01,
                            -2.975311e+00, -4.083529e+00, -7.629231e-01, -2.177320e+00,
                            -1.064935e+00, -3.616789e-01, -1.064793e+01, -2.901962e+01,
                            -3.010000e+00, -5.700440e+00, -8.031030e-01, -8.596565e+00,
                            -3.303827e+00, -6.007184e+00, -3.632454e+01, -4.760644e+00,
                            -7.406937e-01, -2.122352e-01, -1.323181e+01, -5.929065e-01,
                            -9.217285e+00, -5.406741e+00, -2.280784e+01, +1.135054e+00,
                },
                {
                            +8.291358e+00, -1.004173e+01, +1.957223e+01, -2.658252e+00,
                            +9.636527e+00, +3.355964e+01, +5.701524e+00, -5.832507e+00,
                            -1.494833e+01, -3.416466e+01, +4.929083e+00, +5.204349e+00,
                            -1.573745e+02, -1.442399e-01, +2.299665e+00, -6.177890e+01,
                            +1.958858e+00, -5.072369e+00, +1.217968e+00, -7.753251e-01,
                            +1.322831e+01, -3.275862e+00, +4.128959e+00, +1.089347e+01,
                            -4.279474e+00, -9.950483e+00, -1.183050e+01, -1.522401e+01,
                            -1.617905e-02, -1.081354e+00, +8.835788e+01, -6.137470e-01,
                            +1.746461e+01, +8.445068e+00, +1.777472e+01, +2.137866e-01,
                            +2.211863e+00, +9.564369e+00, +1.184998e+01, +1.796683e-01,
                            +5.021122e+00, -4.112635e+00, +2.860984e+00, +6.237879e+00,
                            +6.235407e+00, +4.111607e+00, +4.764628e+00, +4.208476e+00,
                            -2.476379e+00, -1.410406e+00, +1.191089e+01, +4.005244e+00,
                            -3.444561e+00, -2.538424e+00, +1.905333e-01, -3.283273e+01,
                            +4.179701e+00, +5.312255e+00, -9.921808e-01, -2.802907e-01,
                            +1.042764e+00, -6.835824e+00, +1.487412e+01, +7.055853e+00,
                            +1.665080e-01, -1.549118e-01, -1.669674e+01, +2.888052e+00,
                            -3.101948e+00, -3.090365e+00, -2.499126e+00, -2.639177e+00,
                            +9.749999e+00, -1.064873e+01, -1.033954e+00, -3.546012e+00,
                            +5.221563e+00, -9.310549e+00, +7.640431e+00, -4.880867e+00,
                },
                {
                            +6.733712e+00, +4.537154e+00, -9.089794e+00, +4.343091e+00,
                            -2.827602e-01, -8.253601e+00, -2.242396e+00, +1.048913e+01,
                            +5.704419e+00, +2.118842e+00, -1.016424e+00, -2.173887e+00,
                            +6.463124e+01, -8.498792e-02, -3.109241e+00, +4.218453e+01,
                            -2.223435e+00, +7.176433e+00, -2.059980e+00, -1.869379e+00,
                            +5.648009e+00, +3.939255e+00, +9.982566e+00, -7.421070e+00,
                            +5.325809e+00, +1.351965e+01, -3.095293e+00, +4.859943e+00,
                            -4.658389e+00, +1.445019e+01, -1.981835e+01, +1.053659e+01,
                            -1.011427e+01, -7.930146e+00, +5.997236e-01, -2.133208e-01,
                            +4.858994e-01, +2.001809e+00, +5.414326e+00, -5.268777e-01,
                            +5.043309e+00, +7.692229e+00, +1.310841e+00, -4.901385e+00,
                            +6.813241e+00, +1.433493e+00, +9.151952e+00, -6.523100e-01,
                            +7.096129e+00, +7.175983e+00, +4.264324e+00, -4.747308e+00,
                            +5.826045e+00, -1.567729e+00, +1.120266e+01, -1.419859e+01,
                            +1.129634e+00, +6.723353e-01, +2.714055e-01, -3.432290e-01,
                            +1.063938e+00, +7.218638e+00, +5.790783e+00, +1.450458e+01,
                            +9.394670e+00, +2.477658e+00, +6.526001e+00, +1.224759e+01,
                            +6.827596e+00, +1.134604e+01, +2.126379e+01, +1.262694e+01,
                            -2.104113e+00, +7.564218e+00, +9.408858e+00, +4.530832e-01,
                            +7.311638e+00, +2.134646e+00, +1.294808e+01, +3.946217e+00,
                },
                {
                            +5.338196e-02, +4.634211e-01, -9.310503e-01, +7.397123e-01,
                            -3.428113e-01, -1.807961e+00, -1.057854e-01, +5.560322e-01,
                            +2.646176e-01, +1.318115e+01, -2.778279e-02, -2.775304e-01,
                            +1.097651e+01, +6.351651e-01, +1.708656e-01, +4.340022e+00,
                            +5.514464e-02, +7.102168e-01, +1.356455e-01, +5.157073e-02,
                            -4.795812e-01, +2.283716e-01, +5.764353e-01, -5.814183e-01,
                            +2.202747e-01, +8.448938e-01, +8.378996e-01, +7.537339e-01,
                            -2.966051e-02, +1.028515e+00, -4.937495e+00, +6.364199e-01,
                            -7.584349e-01, -2.840548e-01, -6.238548e-01, +1.983442e+00,
                            -8.091146e-02, -4.961247e-01, -6.777866e-01, +3.558826e-01,
                            -1.357723e-03, +6.103896e-01, +2.677708e-01, -4.687808e-01,
                            +1.315603e-01, +1.433599e-01, +1.495384e-01, +9.216937e-02,
                            +6.901541e-01, +2.114138e-01, -2.869359e-01, -1.853858e-01,
                            +5.336776e-01, +5.106291e-02, +3.087997e-01, +3.628099e+00,
                            +3.160974e-01, +1.960341e-01, +2.962496e-01, -1.102870e-01,
                            -1.117404e+00, +6.795782e-01, -4.419985e-01, +2.451708e-01,
                            +6.382098e-01, +7.107745e-01, +3.992725e-01, +8.863263e-01,
                            +3.864293e-01, +8.853133e-01, -1.107776e+00, +6.864734e-01,
                            -3.932107e-01, +4.452412e-01, +4.789896e-01, +4.910907e-02,
                            +8.671582e-02, +1.232569e+00, +7.237399e-02, +1.648006e-01,
                },
                {
                            +1.830509e+00, +1.318733e-01, -1.494859e+00, +1.300582e+00,
                            +1.405917e-01, -2.158315e+00, +1.180338e+00, +3.688906e+00,
                            +1.278238e-01, +1.196418e+01, +1.827566e+00, +7.084174e-01,
                            +7.580585e+00, +4.575537e+00, +1.626506e+00, +2.178703e+00,
                            -3.414717e-01, -2.135050e-01, -5.230270e-01, +8.682612e-01,
                            -7.173595e-01, -8.059945e-01, +3.950594e+00, -5.149857e+00,
                            +6.209105e-01, +1.559531e+00, +2.637236e+00, -9.974931e-01,
                            +2.477954e+00, +4.970768e-02, +1.250335e+00, +3.827616e+00,
                            -1.455764e+00, -3.306997e+00, -1.483128e+00, +2.068288e-01,
                            -1.313683e+00, +4.600376e-01, +1.205782e+00, +1.522822e+00,
                            +1.730343e+00, -9.434625e-01, +1.173195e+00, +1.311357e+00,
                            +3.074514e+00, +1.217432e+00, +1.617501e+00, +2.128302e+00,
                            -9.671883e-01, -8.426823e-01, +5.498269e-01, +6.543424e-01,
                            +6.359701e-01, -5.406398e-01, +1.913158e+00, -9.829539e-01,
                            +1.205369e+00, +6.450543e-01, +8.119066e-01, +2.458279e+00,
                            -6.599979e-03, -2.133889e-01, +1.947732e-01, +1.142345e-01,
                            -6.523230e-01, +3.460003e+00, +3.468637e-01, -5.880261e-01,
                            +9.090570e-02, -2.737845e-01, +6.644548e-01, -6.391881e-01,
                            +1.247666e+00, +1.466306e+00, +3.689650e+00, +4.149817e-01,
                            +3.172354e+00, +5.405377e+00, +1.607006e+00, -5.740986e-01,
                },
                {
                            +2.640694e+00, -3.140073e-01, -5.103260e+00, -7.317924e-01,
                            -4.038456e-01, +3.987217e-01, -4.592411e-01, +3.218122e+00,
                            -3.495403e-01, +2.357311e+00, -3.555055e-01, -1.019734e+00,
                            +8.945170e+00, +4.556632e-01, +1.806462e+00, +6.770195e+00,
                            +1.087796e+00, +2.178936e+00, +1.531114e+00, +2.015063e-01,
                            +8.630561e-01, -8.007429e-01, +2.396030e+00, -2.247521e+00,
                            -5.311102e-01, +4.694883e+00, +1.658097e+00, -9.494332e-01,
                            -1.001475e+00, +2.343774e+00, +2.887957e+00, +4.057385e+00,
                            -4.030913e+00, -2.049890e+00, -4.827554e-01, -1.820504e+00,
                            -1.971082e-01, -2.092669e-01, +3.525952e-01, +1.047139e+00,
                            +1.187431e+00, +1.046007e+00, +1.192408e+00, -1.948878e+00,
                            +1.619399e+00, +1.176467e+00, +1.762047e+00, +1.359441e+00,
                            +1.321678e+00, -4.846436e-01, -1.345841e+00, -2.353995e-01,
                            +5.092087e-01, -1.873571e+00, +4.698430e+00, -1.781725e-01,
                            +2.348054e+00, +2.311716e+00, +4.358009e-01, -2.190884e-01,
                            +1.076630e-01, +2.484361e+00, +1.311288e+00, +4.518410e+00,
                            +1.418976e+00, +3.328067e+00, -4.513044e-01, +2.694472e+00,
                            +4.840999e-03, +2.431208e+00, -1.746286e+00, +2.280715e-01,
                            -5.161564e-01, +3.680515e-01, +2.199142e+00, -1.553135e-01,
                            +1.523080e+00, +4.018511e+00, +2.414243e+00, -1.850311e-01,
                },
                {
                            +8.073792e+00, -3.508476e+00, -2.382793e+01, -4.154170e+00,
                            +7.208023e+00, -2.785493e+01, +5.211186e+00, +1.593214e+01,
                            -3.426143e+00, +4.066162e+00, +7.562752e+00, +4.141473e+00,
                            +9.022609e+01, +7.026833e+00, +5.920400e+00, +1.968624e+01,
                            +3.676406e+00, -7.490682e+00, +5.516861e+00, +6.361498e+00,
                            +9.805670e+00, -5.225524e+00, +1.073059e+01, -1.919358e+01,
                            -1.463815e+00, +1.690648e+01, +1.433787e+01, -6.440561e-02,
                            +7.252646e+00, -4.803939e+00, -1.778234e+01, +1.349489e+01,
                            -2.306633e+01, -2.010117e+01, +6.463083e+00, +6.142401e-01,
                            -1.161195e+01, +9.331916e+00, +8.525952e+00, -3.809957e-01,
                            +1.151734e+01, -6.031258e+00, +8.218426e+00, +4.352666e+00,
                            +1.100475e+01, +8.265921e+00, +1.114264e+01, +5.032129e+00,
                            -9.656488e+00, -5.518794e+00, +7.747561e+00, +5.199196e+00,
                            -7.413525e+00, -1.272505e+01, +1.542212e+01, -5.804841e+00,
                            +6.224639e+00, +6.967466e+00, -2.041288e-01, -2.356811e-01,
                            +1.377681e+00, -7.075467e+00, +7.505109e+00, +1.314457e+01,
                            -4.973233e+00, +9.758621e+00, -3.460840e+00, -9.792554e+00,
                            -3.063532e+00, -7.598477e+00, +1.529541e+01, -5.884531e+00,
                            +4.772458e+00, -3.567406e+00, +1.286738e+01, +6.426378e-01,
                            +1.061014e+01, +1.204248e+01, +1.153341e+01, -4.230638e+00,
                },
                {
                            +1.011676e+01, -1.110730e+00, -1.755928e+01, +2.635584e+00,
                            +7.000262e+00, -2.411216e+01, +6.116018e+00, +1.440935e+01,
                            -1.872577e+00, +4.684581e+00, +5.676786e+00, +2.422895e+00,
                            +1.341053e+01, +7.029678e+00, +5.533219e+00, -1.245908e+00,
                            +1.454253e+00, -2.817385e+00, +2.870106e+00, +2.912728e+00,
                            +9.169914e+00, -3.672344e+00, +1.243489e+01, -1.252150e+01,
                            -2.361414e-01, +1.847795e+01, +6.327286e+00, -5.446475e-01,
                            +4.126514e+00, -9.202047e-01, -7.473300e+00, +1.462712e+01,
                            -1.667613e+01, -1.260912e+01, +6.764418e+00, +4.983864e-02,
                            -5.843360e+00, +5.907275e+00, +8.866029e+00, +9.142414e-01,
                            +9.368072e+00, +4.696032e-01, +6.990384e+00, +2.882905e+00,
                            +1.055887e+01, +5.827017e+00, +1.128397e+01, +5.228642e+00,
                            -2.161305e+00, -1.602108e+00, +1.004425e+01, +3.945145e+00,
                            -2.038405e+00, -6.241516e+00, +1.431854e+01, -1.821287e+01,
                            +6.445075e+00, +5.019635e+00, +1.189316e+00, +1.434825e+00,
                            +2.460805e-01, -2.981356e+00, +9.353168e+00, +1.895868e+01,
                            +1.065724e-01, +8.616109e+00, -1.768693e+00, +3.352798e-01,
                            -3.354534e-01, -3.748839e-01, +2.302538e+01, +4.518397e-01,
                            +3.261335e+00, -1.475701e+00, +1.247696e+01, +2.907939e+00,
                            +1.006894e+01, +9.639229e+00, +1.717139e+01, -2.243676e+00,
                },
                {
                            +5.479183e+00, -1.305227e+00, -9.953253e+00, -9.265733e-01,
                            +1.701079e+00, -1.367371e+01, +2.619478e+00, +8.332322e+00,
                            -2.252093e+00, +6.455764e+00, +2.800763e+00, +3.392997e+00,
                            +2.983029e+01, +4.527999e+00, +2.741980e+00, +7.892876e+00,
                            +3.066952e+00, -1.187405e+00, +2.740246e+00, +2.876335e+00,
                            +4.193316e+00, -9.721033e-01, +7.266235e+00, -9.904804e+00,
                            -3.296724e+00, +9.516911e+00, +5.551584e+00, +1.003427e+00,
                            +3.284963e+00, -1.017867e+00, -1.981972e+00, +5.360139e+00,
                            -1.009195e+01, -8.510015e+00, +2.347901e+00, +1.290694e-03,
                            -4.173282e+00, +2.983568e+00, +3.172338e+00, +1.052532e+00,
                            +3.272977e+00, -5.599350e-01, +4.045052e+00, +2.819906e+00,
                            +5.188849e+00, +4.196385e+00, +6.247102e+00, +1.486216e+00,
                            -2.061010e+00, -4.098316e+00, +4.012152e+00, +3.355398e+00,
                            -1.992096e+00, -4.948700e+00, +5.600868e+00, -4.019789e+00,
                            +4.388783e+00, +4.615736e+00, -1.526054e+00, +7.858629e-01,
                            +1.202618e+00, -2.379762e+00, +4.377397e+00, +7.368104e+00,
                            -1.132498e+00, +5.177159e+00, -2.171323e-01, -4.039821e+00,
                            -1.531520e+00, -2.469372e+00, +9.039371e+00, -1.633688e+00,
                            +1.710964e+00, -1.517216e+00, +6.735516e+00, +8.190565e-01,
                            +6.143662e+00, +6.186527e+00, +6.929580e+00, -1.845401e+00,
                },
                {
                            +5.655281e+00, -5.474563e-01, -1.146856e+01, +3.171068e-01,
                            +4.036591e+00, -1.556587e+01, +3.969625e+00, +1.104352e+01,
                            +7.012260e-01, +1.112405e+01, +3.190647e+00, +2.931252e+00,
                            +1.938203e-01, +4.357134e+00, +1.172682e+00, +9.608564e+00,
                            +3.200678e+00, -5.179715e-01, +2.636964e+00, +2.515579e+00,
                            +6.347820e+00, +9.294084e-01, +8.373701e+00, -7.676174e+00,
                            -3.544827e-01, +1.471671e+01, +5.992246e+00, -8.049290e-01,
                            +2.510651e+00, +2.339835e+00, -2.307162e+00, +1.013700e+01,
                            -1.232581e+01, -7.439453e+00, +2.951442e+00, +1.944543e+00,
                            -4.232266e+00, +4.834068e+00, +5.615529e+00, +1.048042e+00,
                            +7.150208e+00, +1.274740e-01, +5.379114e+00, +1.344092e+00,
                            +5.441534e+00, +5.066245e+00, +9.920047e+00, +3.183811e+00,
                            +2.039011e+00, +1.717012e+00, +5.062809e+00, +5.430166e-01,
                            -1.651764e+00, -1.269895e+00, +1.113880e+01, -6.129809e+00,
                            +3.837815e+00, +3.992042e+00, +9.584884e-02, +2.523199e+00,
                            +4.451477e-01, +4.782338e-01, +5.624941e+00, +1.044904e+01,
                            +9.397913e-02, +3.573355e+00, -5.595700e-02, +1.613003e+00,
                            +2.188484e-01, +2.280278e+00, +1.503378e+01, +3.418800e+00,
                            +3.132179e+00, -8.279861e-01, +1.002372e+01, +2.023451e+00,
                            +6.707838e+00, +6.967385e+00, +9.193814e+00, -1.255324e+00,
                },
                {
                            +3.451114e-01, -9.802359e-01, +2.078351e+00, +2.605871e-02,
                            -3.635275e-01, +2.219193e+00, +1.826062e+00, -4.193107e-01,
                            -5.830390e-01, +1.777046e-02, -9.993011e-01, -1.060674e+00,
                            +3.915143e+00, +6.013179e-02, +3.775353e-01, -1.089239e+00,
                            -3.478954e-01, +1.133769e+00, -8.900879e-02, -8.517134e-01,
                            -2.296221e-01, -1.172945e+00, -1.234560e+00, +9.118137e-01,
                            -8.198795e-01, +6.240238e-01, -1.905496e+00, +9.565720e-01,
                            +2.731420e-01, +4.912085e-01, +1.651377e-01, +2.448041e+00,
                            +9.321811e-01, -2.699914e-01, -3.806816e-01, +1.072583e+00,
                            -5.002164e-01, +3.209545e-01, -2.637818e-01, +1.160337e+00,
                            +2.305867e-01, +7.310093e-01, +2.208905e-01, +1.723846e+00,
                            +2.386335e-01, +1.400005e+00, -1.178744e-01, -3.030411e-01,
                            +2.272383e-01, +1.463380e+00, +1.180537e+00, -2.051269e+00,
                            +1.413416e+00, +1.232940e+00, +6.045038e-01, -1.030456e+00,
                            -1.963751e+00, -1.470617e+00, +5.286313e-01, +4.164621e-02,
                            +5.841069e-01, -1.243177e+00, -8.386297e-02, +2.435309e+00,
                            -2.746280e-01, -1.162998e+00, -2.108996e+00, -1.401231e+00,
                            +1.352175e-01, -2.035369e+00, -1.435502e+00, -9.679518e-01,
                            +5.397961e-01, -6.349177e-01, -2.067512e-01, -1.582229e+00,
                            -6.982567e-02, +7.912094e-01, -4.906165e-01, +5.784472e-01,
                },
    };
    // Output connection weights from KOH file for run39_C2_080_nn
    private final static double[][] nodes_output_weights_run39 = new double[][]{
                {-5.669656e+00,},
                {+3.130231e+00,},
                {+3.573236e+01,},
                {+3.019328e+00,},
                {-5.763418e+00,},
                {+6.168781e+01,},
                {-4.692912e+00,},
                {-1.323132e+01,},
                {+5.937366e+00,},
                {+2.230954e+01,},
                {-4.450063e+00,},
                {-3.424416e+00,},
                {+1.519456e+02,},
                {-5.814347e+00,},
                {-4.583418e+00,},
                {+4.028491e+01,},
                {-3.115890e+00,},
                {+8.564333e+00,},
                {-3.435397e+00,},
                {-3.435988e+00,},
                {-7.620337e+00,},
                {+4.561136e+00,},
                {-8.853918e+00,},
                {+1.985886e+01,},
                {+2.749105e+00,},
                {-1.976451e+01,},
                {-1.043931e+01,},
                {+2.281220e+00,},
                {-5.918178e+00,},
                {+9.507173e+00,},
                {-5.471448e+01,},
                {-1.039111e+01,},
                {+3.465474e+01,},
                {+2.051415e+01,},
                {-7.200848e+00,},
                {-5.132160e-01,},
                {+8.653513e+00,},
                {-6.246770e+00,},
                {-6.195360e+00,},
                {-5.082660e-01,},
                {-6.281495e+00,},
                {+5.905231e+00,},
                {-5.301845e+00,},
                {-4.963099e+00,},
                {-7.507510e+00,},
                {-5.236133e+00,},
                {-8.144489e+00,},
                {-3.338085e+00,},
                {+1.144201e+01,},
                {+6.542197e+00,},
                {-6.608939e+00,},
                {-4.832664e+00,},
                {+7.059961e+00,},
                {+9.087248e+00,},
                {-1.154834e+01,},
                {+3.542155e+01,},
                {-4.343641e+00,},
                {-4.573209e+00,},
                {+3.349311e-01,},
                {-7.958422e-01,},
                {-8.877248e-01,},
                {+9.495857e+00,},
                {-7.287066e+00,},
                {-1.645647e+01,},
                {+6.034534e+00,},
                {-5.997689e+00,},
                {+5.772654e+00,},
                {+1.393864e+01,},
                {+4.182245e+00,},
                {+1.176804e+01,},
                {-2.676565e+01,},
                {+9.256895e+00,},
                {-4.307285e+00,},
                {+5.571597e+00,},
                {-9.296066e+00,},
                {-7.214952e-01,},
                {-6.782744e+00,},
                {-8.339615e+00,},
                {-1.217481e+01,},
                {+3.890761e+00,},
                {+1.653445e+00,},
    };
    // Intercept and slope for output layer for run39_C2_080_nn
    private final static double[][] nodes_output_scale_run39 = new double[][]{
                {-1.300000e+00, 3.750000e+00}
    };
    // Output offset factors for run39_C2_080_nn
    private final static double[] nodes_output_scale_off_run39 = new double[]{
                1.000000e-01,
    };
    // Output scale flags for run39_C2_080_nn
    private final static int[] nodes_output_scale_flag_run39 = new int[]{
                0,
    };
    // Output limits (min/max) from training data set for run39_C2_080_nn
    private final static double[][] nodes_output_scale_limits_run39 = new double[][]{
                {-1.300000e+00, +1.700000e+00,}
    };

    public static int compute(final float[][] in,
                              final int getNumNodesInput,
                              final float[][] out,
                              final int getNumNodesOutput,
                              final int width,
                              final int[] mask,
                              final int errmask,
                              final float[] a) {
        // (c) M. Schaale, WeW, 2002-2006
        final int rcheck[];
        final int nodes_input = 18;
        final int nodes_output = 1;
        final int nodes_input_bias = 1;
        final int nodes_input_pca = 1;
        final int nodes_hidden = 80;
        final int nodes_hidden_bias = 1;
        final double nodes_hidden_temperature = 1.000000;
        final double t_input = nodes_hidden_temperature / (double) (nodes_input);
        final double t_hidden = nodes_hidden_temperature / (double) (nodes_hidden);
        final double[] vt;
        final double[] vt1;
        //double limexp = -Math.log(Float.MIN_VALUE), dh, dhr, dhe, dhmax=Float.MAX_VALUE, expo;

        // Return dimensions on request
        if (getNumNodesInput <= 0) {
            return (nodes_input);
        }
        if (getNumNodesOutput <= 0) {
            return (nodes_output);
        }

        // Crude compatibility checks
        if (getNumNodesInput != nodes_input) {
            return (-1);
        }
        if (getNumNodesOutput != nodes_output) {
            return (-2);
        }

        vt = new double[nodes_input + nodes_input_bias];
        vt1 = new double[nodes_hidden + nodes_hidden_bias];

        // Range check ??
        rcheck = new int[width];
        for (int x = 0; x < width; x++) {
            rcheck[x] = 0;
            if (a[x] < 0.0f) {
                rcheck[x] = 1;
            }
            a[x] = 1.0f;
        }

        for (int x = 0; x < width; x++) {
            if (mask[x] == 0) {
                // Check input range
                if (rcheck[x] != 0) {
                    for (int i = 0; i < nodes_input && a[x] > 0.0f; i++) {
                        if ((in[i][x] < (float) NN_General.NODES_INPUT_SCALE_LIMITS[i][0]) || (in[i][x] > (float) NN_General.NODES_INPUT_SCALE_LIMITS[i][1])) {
                            a[x] -= 3.0f;
                        }
                    }
                    if (a[x] < 0.0f) {
                        mask[x] |= errmask;
                    }
                }

                //if(mask[x] == 0) {
                // Apply input transformation
                for (int i = 0; i < nodes_input; i++) {
                    if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -1) {
                        in[i][x] = (float) Math.log((double) in[i][x]);
                    }
                    if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -2) {
                        in[i][x] = (float) Math.exp((double) in[i][x]);
                    }
                }

                // Apply input scale layer parameters
                for (int i = 0; i < nodes_input; i++) {
                    in[i][x] = (float) NN_General.NODES_INPUT_SCALE_OFF[i] + (in[i][x] - (float) nodes_input_scale_run39[i][0]) / (float) nodes_input_scale_run39[i][1];
                }

                // Apply input PCA layer parameters
                if (nodes_input_pca != 0) {
                    for (int i = 0; i < nodes_input; i++) {
                        vt[i] = (double) in[i][x];
                        if (NN_General.NODES_INPUT_SCALE_FLAG[i] == 1) {
                            vt[i] = 0.0;
                            for (int j = 0; j < nodes_input; j++) {
                                if (NN_General.NODES_INPUT_SCALE_FLAG[j] == 1) {
                                    vt[i] += (double) in[j][x] * nodes_input_pca_evec_run39[j][i];
                                }
                            }
                        }
                    }
                    for (int i = 0; i < nodes_input; i++) {
                        in[i][x] = (float) vt[i];
                    }
                }

                // Pump through the first layer
                for (int i = 0; i < nodes_input; i++) {
                    vt[i] = (double) in[i][x];
                }
                for (int i = nodes_input; i < nodes_input + nodes_input_bias; i++) {
                    vt[i] = 1.0;
                }

                for (int i = 0; i < nodes_hidden; i++) {
                    vt1[i] = 0.0;
                    for (int j = 0; j < nodes_input + nodes_input_bias; j++) {
                        vt1[i] += vt[j] * nodes_hidden_weights_run39[j][i];
                    }
                }
                // Pump through sigmoid
                for (int i = 0; i < nodes_hidden; i++) {
                    vt1[i] = 1.0 / (1.0 + Math.exp(-t_input * vt1[i]));
                }

                // Pump through the second layer
                for (int i = nodes_hidden; i < nodes_hidden + nodes_hidden_bias; i++) {
                    vt1[i] = 1.0f;
                }
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = 0.0f;
                    for (int j = 0; j < nodes_hidden + nodes_hidden_bias; j++) {
                        out[i][x] += (float) (vt1[j] * nodes_output_weights_run39[j][i]);
                    }
                }
                // Pump through sigmoid
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = (float) (1.0 / (1.0 + Math.exp(-t_hidden * out[i][x])));
                }

                // Apply output scale layer parameters
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = (float) nodes_output_scale_run39[i][0] + (out[i][x] - (float) nodes_output_scale_off_run39[i]) * (float) nodes_output_scale_run39[i][1];
                }

                // Apply output transformation
                for (int i = 0; i < nodes_output; i++) {
                    if (nodes_output_scale_flag_run39[i] == -1) {
                        out[i][x] = (float) Math.log((double) out[i][x]);
                    }
                    if (nodes_output_scale_flag_run39[i] == -2) {
                        out[i][x] = (float) Math.exp((double) out[i][x]);
                    }
                }

                // Check output range
                if (rcheck[x] != 0) {
                    for (int i = 0; i < nodes_output && a[x] >= -2.0f; i++) {
                        if ((out[i][x] < (float) nodes_output_scale_limits_run39[i][0]) || (out[i][x] > (float) nodes_output_scale_limits_run39[i][1])) {
                            a[x] -= 20.0f;
                        }
                    }
                    if (a[x] < 0.0f) {
                        mask[x] |= errmask;
                    }
                }

                //} // mask
            } // mask
        } // x
        return 0;
    }
}
