package org.esa.s3tbx.fub.wew.util;

public class NN_CHL {

    // Intercept and slope for input layer for run46_C2_100_nn
    private final static double[][] nodes_input_scale_run46 = new double[][]{
                {+4.165578e-02, +1.161174e-02},
                {+3.520901e-02, +1.063665e-02},
                {+2.920864e-02, +1.050035e-02},
                {+2.699881e-02, +1.067741e-02},
                {+2.323033e-02, +1.168310e-02},
                {+1.756723e-02, +1.029849e-02},
                {+1.578173e-02, +9.680594e-03},
                {+1.385489e-02, +8.916431e-03},
                {+1.205267e-02, +8.339760e-03},
                {+1.165661e-02, +8.278790e-03},
                {+1.021728e-02, +7.993388e-03},
                {+9.918789e-03, +7.898618e-03},
                {+1.500000e+00, +6.362889e+00},
                {+9.800000e+02, +6.666667e+01},
                {+2.468300e-01, +8.368545e-01},
                {-6.613120e-01, +1.469582e+00},
                {-6.613120e-01, +1.469582e+00},
                {+7.501110e-01, +2.776545e-01},
    };
    // Eigenvectors (columnwise) for input PCA layer for run46_C2_100_nn
    private final static double[][] nodes_input_pca_evec_run46 = new double[][]{
                {
                            +3.720327e-02, -6.549362e-03, +2.900080e-01, -2.011320e-01,
                            -2.636388e-01, +1.000999e-01, +1.988870e-01, +3.842379e-01,
                            +3.697517e-01, +4.917516e-01, +3.975768e-01, +2.658775e-01,
                },
                {
                            -7.429894e-02, +1.068907e-02, -5.029083e-01, +3.833335e-01,
                            +3.383938e-01, -2.430734e-01, -2.542390e-01, -1.231907e-01,
                            +1.379914e-01, +3.895950e-01, +3.001655e-01, +2.831438e-01,
                },
                {
                            +7.845022e-02, -1.058433e-02, +5.055317e-01, +7.206815e-02,
                            +1.937728e-01, +3.558653e-01, -1.338966e-01, -5.287648e-01,
                            -3.204458e-01, +8.516721e-02, +2.723260e-01, +2.952431e-01,
                },
                {
                            -7.074016e-02, +1.181506e-02, -4.342866e-01, -4.750146e-01,
                            -3.953407e-01, -1.178391e-01, +1.415893e-01, -2.009202e-01,
                            -4.232329e-01, -8.591454e-02, +2.770834e-01, +2.945049e-01,
                },
                {
                            +3.123067e-02, -1.055081e-02, +1.309456e-01, +3.964930e-01,
                            +1.079823e-01, -1.593584e-01, +1.748466e-01, +5.287397e-01,
                            -3.604911e-01, -4.281425e-01, +2.928995e-01, +2.798530e-01,
                },
                {
                            -6.070631e-02, +3.621924e-02, -8.247021e-02, -4.983808e-01,
                            +5.022736e-01, +1.867040e-01, -1.768700e-01, +1.115609e-01,
                            +3.642774e-01, -4.309476e-01, +8.158333e-02, +2.896247e-01,
                },
                {
                            +3.657514e-02, -1.518169e-02, +9.115503e-02, +2.231538e-01,
                            -5.746984e-01, -7.423916e-02, -5.464398e-01, -9.883767e-02,
                            +3.168623e-01, -3.258191e-01, -4.080405e-02, +2.965555e-01,
                },
                {
                            +9.185909e-02, -1.000179e-01, -1.570246e-01, +2.811340e-01,
                            -5.121132e-02, +1.760552e-01, +6.799967e-01, -3.263152e-01,
                            +3.558768e-01, -1.904168e-01, -1.519412e-01, +2.989599e-01,
                },
                {
                            +5.039719e-01, -2.352205e-01, +2.160997e-01, -2.123316e-01,
                            +1.521358e-01, -6.111421e-01, +2.233613e-02, -6.475601e-02,
                            -3.176413e-02, +1.108682e-01, -3.135614e-01, +2.931657e-01,
                },
                {
                            -6.049851e-01, +5.385982e-01, +2.386558e-01, -1.836866e-02,
                            +3.274459e-02, -2.786882e-01, +1.092206e-01, -5.053360e-02,
                            -2.032057e-02, +8.590607e-02, -3.154111e-01, +2.934483e-01,
                },
                {
                            -3.997149e-01, -6.664546e-01, -5.252006e-02, +6.949377e-03,
                            -4.719049e-03, +2.494778e-01, -9.866458e-02, +1.978459e-01,
                            -1.774924e-01, +1.683270e-01, -3.743445e-01, +2.866168e-01,
                },
                {
                            +4.332827e-01, +4.453712e-01, -2.355489e-01, +4.329192e-02,
                            -3.259577e-02, +4.245090e-01, -1.132328e-01, +2.511418e-01,
                            -1.995074e-01, +1.797701e-01, -3.817864e-01, +2.854951e-01,
                },
    };
    // Input connection weights for run46_C2_100_nn
    private final static double[][] nodes_hidden_weights_run46 = new double[][]{
                {
                            -5.127986e-01, +5.872741e-01, +4.411426e-01, +1.344507e+00,
                            -7.758738e-01, -7.235078e-01, +2.421909e+00, +1.923607e-02,
                            +2.095671e-01, -1.854303e+00, +3.067815e-01, +7.324489e-01,
                            -1.439929e+00, +9.445596e-01, +2.732355e-01, -4.106890e+00,
                            -1.738242e+00, -8.901453e-01, +4.079534e-01, +4.458184e-01,
                            -6.862928e-01, +8.213179e-01, -2.992510e-01, +5.181425e-01,
                            +1.144172e+00, +1.385928e+00, -8.248739e-01, +5.189461e-01,
                            +5.226253e-01, -7.908759e-01, +1.647220e+00, +2.149709e+00,
                            -1.716757e+00, +1.433486e+00, -1.394956e+00, -1.465779e+00,
                            -1.882348e+00, -2.427909e-01, +1.556440e+00, -1.333128e+00,
                            -1.773270e-01, +5.495471e-01, +4.280278e-01, +2.961606e-01,
                            -5.747508e-02, -7.513083e-01, -4.005250e-01, -1.173682e+00,
                            -5.821932e-01, -1.474722e-01, -1.536111e-01, -1.052891e+00,
                            +1.410916e+00, +3.333437e-02, -9.930057e-01, +1.529344e+00,
                            +1.895313e-01, -3.366092e-01, +2.864338e-01, +2.209214e+00,
                            -5.772508e-01, -1.957571e+00, -1.591362e+00, +4.745838e-01,
                            +1.171258e-01, +5.930325e-01, -1.926282e-01, +6.576979e-01,
                            -3.836553e+00, -2.504783e-01, -5.312367e-01, -5.237725e-01,
                            +4.766606e-01, +3.678577e-01, -4.312671e-01, +5.830966e-01,
                            +4.766510e-01, -8.505184e-01, +7.696922e-01, -4.072182e-01,
                            -9.390821e-01, -4.210852e-02, -1.456445e+00, +5.233867e-01,
                            -1.134155e+00, +1.603893e+00, +5.073252e-01, +1.211945e+00,
                            -4.888498e-01, +1.004863e+00, -5.684740e-01, -1.310794e+00,
                            +7.515390e-01, -7.107704e-01, +1.563250e+00, -1.522923e+00,
                            +3.047624e+00, -1.534142e-01, +1.955046e+00, +7.811737e-01,
                },
                {
                            -3.086223e-02, +2.346106e-02, -1.442910e+00, +1.426404e+00,
                            -3.596204e-01, -6.021846e-01, -8.177614e-03, +1.555150e+00,
                            -1.042204e-01, +1.950469e-01, -5.406290e-01, -9.378908e-01,
                            +1.064399e+00, +1.795686e+00, +1.227751e+00, -2.803651e+00,
                            -7.341231e-01, +3.705561e-01, +3.165067e-01, -2.708519e+00,
                            +1.924795e-01, -8.950356e-01, +1.903615e-01, -1.114939e+00,
                            -6.840401e-01, +3.588653e+00, +1.692587e+00, -7.687381e-01,
                            +2.051575e-02, +1.095054e-01, +1.169622e+00, -8.381531e-01,
                            +5.216980e-01, -7.104531e-01, -5.496677e-01, -9.004661e-02,
                            +2.875932e-02, -1.431424e+00, +1.078108e+00, -6.814132e+00,
                            -4.054059e-02, +5.498323e-01, +1.074416e+00, -3.113689e-02,
                            -8.042992e-01, -4.523238e-01, -7.276333e-01, -1.650421e+00,
                            -5.204643e-01, -6.879292e-01, -3.433933e-01, -1.402490e+00,
                            +8.376524e-01, -1.479028e+00, +1.559910e+00, +1.178643e+00,
                            -6.795714e-01, +5.303804e-01, -1.744758e-01, +1.821641e+00,
                            -6.060833e-01, -1.845941e+00, -9.743568e-01, +4.165528e-01,
                            +3.324597e-01, -2.143277e+00, +3.869756e-01, -1.984425e-01,
                            -3.202465e+00, -2.122254e-01, -9.261276e-01, +1.632761e-01,
                            -6.692447e-01, +5.372459e-01, +6.795959e-01, +6.631287e-01,
                            +1.068918e+00, -1.477327e+00, -1.476734e+00, +2.204985e-01,
                            +1.924559e-01, -1.004765e+00, -1.166832e+00, -1.050871e-01,
                            +1.313884e-02, -2.106215e+00, -4.745361e-01, +1.237264e+00,
                            -1.644034e-01, +8.202621e-01, -1.283196e+00, -4.136712e-01,
                            -4.603846e-01, +3.425888e-01, -1.494976e+00, +5.236935e-02,
                            +5.415043e-01, +1.604839e-01, -4.934537e-01, +4.298064e-01,
                },
                {
                            +1.352883e+00, +1.349450e+00, -7.073170e-01, -8.075720e-01,
                            +7.229500e-01, -2.487171e+00, +8.516108e-01, +1.975422e+00,
                            -7.762858e-03, -9.210697e-01, -8.756055e-01, -1.425222e+00,
                            -3.197115e+00, +1.603326e+00, -9.992384e-01, -1.899149e+01,
                            -1.839617e+00, -2.634727e+00, +3.753211e+00, -1.025298e+00,
                            -2.232048e+00, +3.269269e-01, +2.075636e+00, +1.308576e-01,
                            +3.213572e+00, +1.843426e+01, -1.051487e+00, +5.627586e-03,
                            -5.392435e-01, -4.783201e-01, +2.267913e+01, +1.931319e+00,
                            -9.181037e+00, +3.571902e-01, -7.726832e-01, -3.425769e+00,
                            +2.206560e-01, -1.185817e+00, +5.164191e-01, -5.670884e+01,
                            +8.590321e-01, +5.531543e-01, +7.509177e-01, -2.669284e+00,
                            +1.568891e+00, -1.077539e+00, -5.654035e-01, -1.812088e+01,
                            +3.288304e-01, -1.696227e+00, +6.271689e-01, -4.325982e+00,
                            +1.263076e+00, +2.373747e+00, -2.000674e+00, -2.826190e+00,
                            -2.602996e-01, +1.316487e+01, +8.694284e-01, +2.852845e+00,
                            -1.046052e+00, +1.020440e+00, -9.124451e-01, -1.342345e+00,
                            -2.647766e+00, +1.453673e-01, -1.467640e-02, -9.782002e-01,
                            -2.898477e+01, +2.066114e+00, +5.446665e-01, +2.136242e+00,
                            -2.159251e+00, -1.480626e+00, +5.354950e-01, +7.263461e-01,
                            +3.839321e-01, +1.577012e+00, -1.419213e+00, +4.027827e-01,
                            -1.844903e+00, -1.365434e-01, -1.921733e-01, +5.711406e-02,
                            -1.548073e+00, +4.671999e+00, +2.048477e-01, -1.058281e+00,
                            +2.586571e-01, -2.050824e+00, +2.404677e-01, -2.104983e+00,
                            -4.304744e-01, -8.998591e-02, -1.435968e+00, +1.562596e+00,
                            +2.343436e+01, -3.132435e-01, -1.821600e+00, -6.299615e-01,
                },
                {
                            +5.588117e+00, +5.771654e+00, -5.196276e+00, -3.425856e+00,
                            -9.725067e-01, -2.946342e+00, +2.151807e+00, +7.320869e+00,
                            -1.713146e+00, -1.754712e+00, +1.867271e+00, -4.763624e+00,
                            -8.704128e+00, -2.469006e+00, -3.392507e+00, -3.004741e+01,
                            -6.064856e+00, -8.773853e+00, +1.219746e+01, -1.738451e+00,
                            -1.040658e+01, +3.553547e+00, +6.040166e+00, +5.467470e-01,
                            +6.131941e+00, +2.889395e+01, -3.383471e+00, +2.281311e+00,
                            -2.460507e-01, -3.289957e+00, +2.105227e+01, +4.221361e+00,
                            -2.170537e+01, +3.214825e+00, -5.674147e+00, -1.498797e+01,
                            -3.604725e-01, -1.416430e+00, -1.482997e+00, -1.751848e+01,
                            +2.543166e+00, +1.981895e+00, +3.365135e+00, -8.710091e+00,
                            +2.238295e+00, +2.482517e+00, +3.763151e+00, -3.442835e+01,
                            +3.875528e+00, -5.425309e+00, -2.521564e+00, -8.868567e+00,
                            +1.611753e+00, +3.654951e+00, -5.326183e-01, -4.411193e+00,
                            -2.656364e+00, +2.172192e+01, +3.424946e-01, +5.793386e+00,
                            -8.577917e+00, +1.862482e+00, -3.739266e+00, -7.274971e+00,
                            -1.227419e+01, -2.764753e+00, -1.786645e+00, -5.892830e+00,
                            -5.374416e+01, +7.519266e+00, -4.080158e+00, +2.281967e+00,
                            -6.818449e+00, -4.771087e+00, +9.972876e-01, +2.593331e+00,
                            +4.536029e+00, +2.315063e+00, -4.769114e+00, +4.068366e+00,
                            -9.239391e+00, -2.601215e+00, -5.065892e-01, +6.001852e-01,
                            -6.759643e-01, +8.211049e+00, +4.374670e-01, +3.129493e-02,
                            -2.745959e+00, -1.003424e+01, +6.336873e-01, -6.364903e+00,
                            +1.550542e+00, +5.407603e+00, +1.369259e+00, +9.080230e-01,
                            +5.667294e+01, -5.104580e+00, -4.236973e+00, +2.598948e+00,
                },
                {
                            -1.834918e+00, -1.144287e+00, +2.532951e+00, +3.489994e+00,
                            -6.074476e-01, +2.178933e+00, -1.358945e+00, -1.751544e-01,
                            +3.936138e-01, +1.195904e+00, -9.915487e-01, +1.637291e+00,
                            +1.487020e+00, +2.283435e+00, +2.237770e+00, -1.087652e+01,
                            +3.657340e+00, +1.581503e+00, +1.267863e+00, +3.981416e+00,
                            +2.564868e+00, +2.163323e-01, -1.036495e+00, +4.077188e-01,
                            +7.820607e-01, +9.839235e+00, +1.857150e+00, +7.918916e-01,
                            +9.408977e-01, +8.952003e-01, +1.896678e+01, -1.145519e+00,
                            -4.845967e+00, +3.990709e-01, +2.751350e+00, +8.827563e+00,
                            -1.356885e+00, +2.203841e+00, +2.130471e+00, -8.415093e+01,
                            -1.832100e-01, -8.968477e-01, -1.180663e+00, +3.891321e+00,
                            -4.119871e+00, -9.510443e-01, -4.711037e-01, -1.082164e+01,
                            -2.472510e+00, +2.881717e+00, +6.749327e-01, +3.577859e+00,
                            +1.760674e-02, -1.880931e+00, +8.027223e-01, +1.730537e+00,
                            -6.596847e-02, +6.965985e+00, +5.609655e-01, -1.928382e+00,
                            +2.168380e+00, -1.417131e+00, +2.420148e+00, +2.210628e+00,
                            +3.113947e+00, +2.446620e+00, +5.889618e-01, +3.752061e+00,
                            +5.353685e+00, -1.138828e+00, +2.947213e+00, -2.925341e+00,
                            +5.731029e+00, +1.827308e+00, -8.747456e-01, +8.462647e-02,
                            -1.399136e+00, -1.011960e+00, +4.553246e-01, -7.131851e-01,
                            +1.569227e+00, +1.740112e+00, +4.387566e-01, -1.680268e-01,
                            +2.313564e+00, +8.446504e-01, +2.247418e-01, +1.015277e+00,
                            +1.550954e-01, +2.112951e+00, +1.712803e+00, +2.360776e+00,
                            +9.686406e-02, -1.714227e+00, +8.272943e-01, -3.504066e-01,
                            -1.518886e+01, +3.116717e+00, +4.366713e+00, -1.326136e+00,
                },
                {
                            -3.306327e+00, -7.735957e+00, +5.599158e+00, +8.364865e+00,
                            +1.505144e+00, +4.627226e+00, -1.055382e+00, -3.738263e+00,
                            +1.638105e+00, +3.670702e+00, -2.730946e-01, +5.955596e+00,
                            +5.259044e+00, +2.569160e+00, +5.267802e+00, -1.592109e+01,
                            +6.311599e+00, +5.184847e+00, +4.555474e+00, +4.400404e+00,
                            +8.968072e+00, -3.916720e+00, -5.316667e+00, -2.889037e+00,
                            -3.974865e+00, +4.228981e+01, +2.341423e+00, -1.585713e+00,
                            +1.896613e+00, +5.389801e+00, +1.570447e+01, -4.030313e+00,
                            +2.976446e+00, -2.677845e+00, +9.830899e+00, +9.498944e+00,
                            -1.545731e+00, +1.886329e+00, +1.129100e+00, -6.906606e+01,
                            -2.936392e-01, -3.081717e+00, -3.250263e+00, +8.282053e+00,
                            -4.461303e+00, -3.771111e+00, -4.443964e+00, -9.106223e+00,
                            -2.962334e+00, +6.637461e+00, +4.550842e+00, +9.634565e+00,
                            -1.980642e+00, -4.269017e+00, +5.076793e-01, +2.426823e+00,
                            +2.130142e+00, +2.434254e+01, +2.131048e+00, -5.735264e+00,
                            +6.559469e+00, -3.378582e+00, +4.881039e+00, +7.012393e+00,
                            +1.178352e+01, +5.347425e+00, +3.501809e+00, +5.438690e+00,
                            -3.651983e+01, -3.807065e+00, +1.051661e+00, -4.078433e+00,
                            +8.041446e+00, +4.946906e+00, -3.015761e+00, -3.530601e+00,
                            -3.348852e+00, -2.608221e-01, +4.376321e+00, -4.361954e+00,
                            +7.655452e+00, +2.573621e+00, +6.618983e-01, -4.639479e+00,
                            +1.157284e+00, -4.084773e+00, -3.705652e+00, +2.792275e+00,
                            +5.053955e+00, +8.151063e+00, +3.896389e-01, +6.623966e+00,
                            -3.672256e+00, -3.945537e+00, +1.175464e-02, -4.425615e-01,
                            +2.647739e+01, +6.844576e+00, +7.112192e+00, -1.684655e+00,
                },
                {
                            -1.429539e+01, -1.743680e+01, +1.444826e+01, +2.271308e+01,
                            +3.405113e+00, +1.195405e+01, -2.363062e+00, -1.899253e+01,
                            +2.213098e+00, +7.039115e+00, -8.229271e+00, +1.597428e+01,
                            +2.401051e+01, +1.056072e+01, +1.457076e+01, +9.306738e+01,
                            +2.173676e+01, +2.643192e+01, -3.252790e+01, +1.211482e+01,
                            +2.240733e+01, -1.161126e+01, -1.986157e+01, -1.004499e+01,
                            -2.063285e+01, -7.787376e+01, +8.068388e+00, -3.345641e+00,
                            +6.727478e+00, +1.524128e+01, -8.340353e+01, -1.157728e+01,
                            +5.237169e+01, -9.140374e+00, +2.116543e+01, +3.921345e+01,
                            -4.358436e+00, +4.449519e+00, +3.598048e+00, +1.266280e+02,
                            -8.666273e+00, -9.159225e+00, -1.294036e+01, +2.252607e+01,
                            -1.094987e+01, -9.087220e+00, -1.308875e+01, +8.036578e+01,
                            -1.454801e+01, +1.738453e+01, +9.846357e+00, +2.455227e+01,
                            -6.635566e+00, -1.713705e+01, +2.220991e+00, +1.034912e+01,
                            +5.835941e+00, -5.683740e+01, +2.015926e+00, -1.742133e+01,
                            +2.308331e+01, -1.002476e+01, +1.734479e+01, +1.995593e+01,
                            +3.291195e+01, +1.171488e+01, +8.306674e+00, +1.864292e+01,
                            +1.609648e+02, -1.945371e+01, +8.918959e+00, -1.096417e+01,
                            +2.138430e+01, +1.389167e+01, -9.422063e+00, -5.572433e+00,
                            -1.269006e+01, -2.077660e+00, +1.171534e+01, -9.472145e+00,
                            +2.392121e+01, +3.775932e+00, +2.252352e+00, -9.444231e+00,
                            +3.681731e+00, -2.028355e+01, -1.231658e+00, +4.677825e+00,
                            +1.027687e+01, +2.754918e+01, -6.901098e-01, +1.427828e+01,
                            -1.043590e+01, -1.623627e+01, -9.078479e-01, -5.132616e+00,
                            -1.415259e+02, +2.065318e+01, +1.854206e+01, -8.880925e+00,
                },
                {
                            -8.565353e-01, -1.272805e+00, +2.651477e-01, -1.429737e+00,
                            -2.109381e-01, -1.214878e+00, -1.696926e-01, -2.000853e+00,
                            -3.779667e-01, +1.196745e+00, -2.096670e+00, +1.033227e+00,
                            +3.235448e+00, -4.705734e-03, -8.868623e-01, +1.135299e+02,
                            -1.953699e+00, +2.240431e+00, -1.431527e+01, -1.399302e+00,
                            +3.423341e+00, +3.908022e-01, -1.136156e+00, -1.694068e-01,
                            -4.622261e+00, -6.775519e+01, -4.463461e-01, +1.023714e+00,
                            -1.167196e+00, -3.149421e+00, -1.127578e+02, +2.658637e-01,
                            +1.880389e+01, -1.447741e+00, -2.369795e+00, -1.354774e+01,
                            +2.853332e-01, -9.719453e-01, -1.280875e+00, +1.375854e+02,
                            -1.886171e+00, +6.505643e-01, +3.585852e-01, +3.050753e-03,
                            +3.824904e-01, -1.213900e+00, -1.410695e+00, +3.490693e+01,
                            +2.642717e-02, -4.825277e-01, -3.325215e-01, +1.689085e+00,
                            -1.337276e-01, +4.052961e-01, -9.105567e-01, +6.198885e-01,
                            -1.538776e-01, -4.356550e+01, -2.286596e-01, +1.252615e+00,
                            +1.831145e+00, -1.350863e+00, -1.799220e+00, +7.108380e-02,
                            +2.563186e+00, +4.851800e-01, +3.253613e-01, -2.226355e+00,
                            +5.340136e+01, -3.520195e+00, +4.655041e-01, -2.798297e-01,
                            -1.100260e+00, -6.853272e-01, +3.287781e-01, -3.050158e-01,
                            -5.917823e-01, -1.424656e-01, -5.322437e-01, -2.431320e+00,
                            +2.695874e+00, -1.121621e+00, -1.460533e-01, -2.496175e-01,
                            -1.408669e+00, -2.181731e+00, -1.016933e+00, -7.698706e-01,
                            +6.252892e-02, +2.711806e+00, -1.074213e+00, +3.291167e-01,
                            -3.212154e-01, -7.409858e-01, -5.802168e-01, -2.707439e-01,
                            -7.532172e+01, -1.029958e+00, -2.427787e+00, -6.418096e-01,
                },
                {
                            -3.683146e+00, -1.137055e-01, +1.093676e-01, -1.353721e+00,
                            -1.642487e+00, -1.522378e+00, -2.811397e-01, -6.262838e+00,
                            -1.643361e-01, +2.186965e-02, -1.751594e+00, +1.223722e+00,
                            +6.979795e+00, +1.953514e+00, +8.597751e-01, +1.488089e+02,
                            -1.645612e+00, +6.149414e+00, -1.724702e+01, -1.390202e+00,
                            +5.123547e-01, -3.007276e+00, -5.381632e-01, -4.261878e+00,
                            -5.321834e+00, -6.910213e+01, +8.249323e-01, +1.081270e+00,
                            +1.169538e+00, -4.481871e-01, -5.028622e+01, -1.898090e+00,
                            +2.695106e+00, -2.769352e+00, -1.634349e+00, -1.445991e+01,
                            -2.691027e+00, -8.068964e-01, -2.293761e+00, -7.907432e+01,
                            -3.355834e+00, -1.717174e+00, -3.096676e+00, -2.976102e+00,
                            -1.300087e+00, -4.073879e+00, -4.871341e+00, +2.401336e+01,
                            -4.522872e+00, -1.548514e+00, -5.641333e-01, -8.381326e-02,
                            -2.115211e-01, -4.189013e+00, -2.562534e-01, +1.055080e+00,
                            +3.493386e-01, -4.658295e+01, -6.419651e-02, -2.089368e+00,
                            +1.696185e+00, -3.359055e+00, +4.073677e-01, +1.697881e+00,
                            -4.355837e+00, -2.569014e-01, -8.018155e-01, -4.385417e+00,
                            +9.979734e+01, -9.063401e+00, -2.694557e+00, -4.314368e+00,
                            -6.252127e-01, +3.106923e+00, -1.075608e+00, +2.439463e+00,
                            -3.756226e+00, +4.298554e-01, -5.508144e-01, -7.886537e-01,
                            +2.745297e+00, -1.134057e+00, +4.952866e-01, -2.912815e+00,
                            -4.594947e-01, -8.635502e+00, +2.056294e-01, -1.625712e+00,
                            +7.590871e-01, +2.535946e-01, -4.941935e-02, +7.109369e-01,
                            -2.190778e+00, -3.375707e+00, -1.308337e+00, -1.132995e+00,
                            -2.412103e+02, -1.848320e+00, -1.713615e+00, -2.661104e-01,
                },
                {
                            -3.392520e+00, -1.425146e+01, +4.583967e+00, -1.597082e-01,
                            +2.769598e+00, +3.357221e+00, +6.993336e-02, -1.228999e+01,
                            -1.548610e+00, +1.327137e+00, -3.296424e+00, +5.764402e+00,
                            +1.456153e+01, +1.304904e+00, +2.202561e+00, -1.141838e+02,
                            +8.331220e-01, +1.292648e+01, -1.818887e+01, +7.747151e-01,
                            +1.419277e+01, -2.954723e+00, -1.467080e+01, -1.351679e+00,
                            -1.399743e+01, -2.341388e+01, +1.480504e+00, -5.224564e+00,
                            +2.273477e+00, +2.241954e+00, +1.226620e+02, -9.392466e+00,
                            +2.637569e+01, -3.682375e+00, +9.994820e+00, +1.103284e+01,
                            +2.640785e-01, +3.381726e+00, +9.017737e-01, -1.475907e+02,
                            -1.494215e+00, -3.056333e+00, -2.031282e+00, +1.231342e+01,
                            -2.329169e+00, -2.049791e+00, -3.003882e+00, +4.001229e+01,
                            -4.582237e+00, +5.479842e+00, +1.046687e+00, +1.101248e+01,
                            -8.208399e-02, -6.621889e+00, +2.715683e-01, +4.082793e+00,
                            +9.402208e-01, -1.967874e+01, -3.187995e-01, -9.654532e+00,
                            +1.125889e+01, -1.866193e+00, +2.847841e+00, +3.748204e+00,
                            +1.893611e+01, +1.195535e+00, +4.246589e-01, +2.053682e+00,
                            +4.914061e+00, -1.370717e+01, -3.670801e-01, -3.474021e+00,
                            +8.946075e+00, -1.440488e-01, -4.738106e+00, -8.774341e+00,
                            -3.504615e+00, -2.808668e+00, +5.248463e-02, -2.943622e+00,
                            +1.423132e+01, +2.821801e+00, -1.411170e+00, -3.501495e-01,
                            -8.905475e-01, -1.206785e+01, -2.402384e+00, +3.600397e+00,
                            +4.137450e+00, +1.513138e+01, +5.680113e-01, +3.020561e+00,
                            -5.237590e-01, -9.330059e+00, -1.498492e-01, -5.334831e-01,
                            +7.639960e+01, +9.313674e+00, +2.668227e+00, -4.496312e+00,
                },
                {
                            +2.074557e+00, +1.691501e+00, +1.496361e+00, +9.390691e+00,
                            +6.782545e-01, +1.881046e+00, -1.299656e+00, +4.819483e+00,
                            +1.249177e+00, +2.685183e+00, -1.843165e+00, +3.030032e-01,
                            -3.612973e+00, -4.391717e-01, +5.378270e+00, +2.300949e+01,
                            +8.203108e+00, -3.892040e+00, +1.261047e+01, +6.653288e+00,
                            -2.942088e+00, -2.828006e+00, +4.619567e-01, -1.686906e+00,
                            +5.077454e+00, +3.076857e+01, +3.118330e+00, -1.486392e+00,
                            +2.351664e+00, +1.152325e+01, -3.539993e+01, +7.270691e-01,
                            -9.027430e+00, -8.707408e-01, +8.819555e-01, +1.296885e+01,
                            -1.882358e+00, +2.624880e+00, +5.298423e+00, +6.063804e+01,
                            -5.353298e-01, -7.500148e-01, -5.353779e-01, +9.006185e-01,
                            -2.459405e+00, -9.936161e-01, +8.414442e-01, -5.489459e+00,
                            +7.609594e-01, +3.619462e+00, +2.704998e+00, -2.018402e+00,
                            -2.349747e+00, +2.001028e+00, +2.258791e+00, -3.823281e-02,
                            +3.228426e+00, +2.546947e+01, +1.243099e+00, +8.209361e-01,
                            -1.512475e+00, +2.189308e+00, +3.878181e+00, +3.032652e+00,
                            -7.290010e-01, +4.553001e+00, +3.914922e+00, +7.654790e+00,
                            -1.719498e+01, +5.559928e+00, +8.462929e+00, +2.916806e+00,
                            +1.852727e+00, +5.017204e+00, -6.697068e-01, -5.823900e-01,
                            +1.510194e+00, -1.520450e+00, +3.993659e+00, -5.095174e-01,
                            -2.961852e+00, +3.186920e+00, +2.327640e+00, -1.280291e+00,
                            -2.839373e-01, +4.299108e+00, -2.019851e-01, +4.086106e+00,
                            +2.761997e+00, -1.591856e+00, +2.453970e-01, +3.016075e+00,
                            -1.430378e+00, +3.125543e+00, +3.088860e-01, -9.534749e-01,
                            +7.609602e+00, +3.166507e-01, +8.920992e+00, +2.615876e-01,
                },
                {
                            -1.395406e-02, +1.138117e+00, +3.970610e-03, +1.304513e+00,
                            -7.232909e-01, +1.056709e-01, -1.292130e+00, +1.208120e+00,
                            +7.579986e-01, -1.502032e-01, -6.561609e-01, -6.091535e-01,
                            -1.565854e+00, +3.198395e+00, +7.315935e-01, +7.363048e+00,
                            +7.332617e-01, -1.349533e+00, +1.671779e+00, +6.624227e-01,
                            -1.205840e+00, +3.450307e-02, +1.381775e+00, -7.616761e-02,
                            +1.256339e+00, +2.525274e+00, +8.743837e-01, -3.307374e-01,
                            +1.025400e+00, +1.051202e+00, -8.810384e+00, +7.795610e-01,
                            -8.432046e-01, +8.352669e-02, -7.396431e-01, +1.051925e+01,
                            +4.123034e-01, -1.982141e-01, +4.409221e-01, +1.113050e+01,
                            -2.723862e-01, +3.140333e-02, -9.171481e-01, -6.463670e-01,
                            +2.154704e-02, +1.363431e-01, +4.737920e-02, -1.337138e+00,
                            +3.121849e-01, -1.721974e-01, +5.284876e-01, -6.042436e-01,
                            -1.310655e-01, +8.464705e-01, -9.067360e-01, -2.048852e-01,
                            -1.649080e-01, +2.580942e+00, +5.354367e-01, +8.581642e-01,
                            -1.184210e+00, -2.507707e+00, +6.494223e-02, -2.478160e-01,
                            -1.069078e+00, +9.126305e-01, +9.370098e-02, +1.008340e+00,
                            -1.748332e+00, +1.393308e+00, +2.090588e+00, -2.589129e-01,
                            -7.313439e-01, +5.167233e-01, +1.829200e-01, -2.216310e-01,
                            +3.894123e-01, +7.864162e-01, +2.427254e+00, -2.080491e-01,
                            -1.050990e+00, -2.089033e-01, +1.335798e-01, -2.908286e-01,
                            +2.543334e+00, +1.368892e+00, -2.997627e-01, +3.950833e-01,
                            -7.308372e-02, -1.187642e+00, -3.841550e-01, +6.763153e-02,
                            -1.708159e-01, +8.809779e-01, -6.852583e-01, -1.536501e+00,
                            -4.082247e+00, -6.325670e-01, +1.173356e+00, -2.961746e-01,
                },
                {
                            +3.460117e+00, +4.348739e+00, -4.369323e-01, +7.414432e-01,
                            +9.155872e-02, -2.220241e+00, +1.046217e+00, +6.661813e+00,
                            +5.142606e-01, +3.210036e-01, +2.115863e+00, -3.429734e+00,
                            -6.374058e+00, +1.828723e+00, -8.176332e-01, +6.163972e+00,
                            -2.443857e+00, -6.718975e+00, +6.584433e+00, -1.333566e+00,
                            -6.247021e+00, +1.771559e+00, +5.222761e+00, +1.062925e+00,
                            +7.371109e+00, -4.226371e+00, -2.224833e+00, +4.812533e-01,
                            +3.519909e-01, -5.647940e-01, -2.267486e+00, +4.271010e+00,
                            -3.590032e+00, +2.602937e+00, -4.142928e+00, +8.133478e+00,
                            +2.232455e+00, -8.993057e-01, +1.074784e-01, +6.234947e+00,
                            +2.535436e+00, +1.589485e+00, +1.215743e+00, -2.178550e+00,
                            +3.468935e+00, +2.181423e+00, +2.571832e+00, +5.611044e+00,
                            +2.503018e+00, -1.961376e+00, -1.621901e+00, -4.259810e+00,
                            +2.141898e+00, +4.827095e+00, -4.990435e-01, -2.175932e+00,
                            -1.139387e+00, +2.657871e+00, +2.480623e-01, +5.147534e+00,
                            -4.908335e+00, +3.801594e-01, -2.432226e+00, -2.683820e+00,
                            -4.387501e+00, -1.328824e-01, -8.888114e-01, -3.644544e-01,
                            -3.557758e+00, +6.592669e+00, +1.654979e+00, +3.174813e+00,
                            -2.195598e+00, -9.046417e-02, +2.958037e+00, +1.124680e+00,
                            +4.781672e+00, +1.995378e+00, +1.347059e-03, +2.333805e+00,
                            -4.147695e+00, -1.583056e+00, -1.894084e+00, +2.790721e+00,
                            +6.228548e-02, +6.770367e+00, +9.833810e-01, +1.050078e+00,
                            -2.169461e+00, -3.941941e+00, -2.811117e-01, -1.193185e+00,
                            +2.528802e+00, +6.574355e+00, +4.612021e-01, -7.554476e-02,
                            -2.981055e+00, -3.300789e+00, -1.441608e+00, +3.646039e+00,
                },
                {
                            +3.986224e+00, +2.740437e+00, -4.065297e+00, -7.474611e-01,
                            -1.836047e-02, -3.278482e+00, +3.857413e-01, +4.685664e+00,
                            -6.531413e-01, -9.416956e-01, +6.895335e-01, -3.568116e+00,
                            -3.881570e+00, -9.981751e-01, +3.286032e-01, +5.339200e+00,
                            +4.776851e-01, -4.429964e+00, +4.455369e+00, -9.555197e-01,
                            -3.879034e+00, +6.770133e-01, +2.339298e+00, +2.572292e+00,
                            +4.553796e+00, -1.315534e+00, -9.652743e-01, +7.509790e-02,
                            -1.758421e+00, +7.225199e-02, -2.272367e+00, +3.475300e+00,
                            +8.961282e-01, +2.826068e+00, -1.832354e+00, -4.583802e-01,
                            +1.456926e+00, -1.250956e+00, -6.205192e-01, +5.968356e+00,
                            +1.799562e+00, +2.317206e+00, +1.829112e+00, -3.320154e+00,
                            +1.486634e+00, +2.268087e+00, +2.200975e+00, +5.376057e+00,
                            +2.727862e+00, -2.205996e+00, -2.874850e+00, -3.609048e+00,
                            +5.630840e-01, +2.556994e+00, +9.771296e-01, -2.914879e+00,
                            +7.274909e-01, +1.401976e+00, -1.163725e-01, +2.410114e+00,
                            -3.208306e+00, +1.373852e+00, -8.083346e-01, -6.050500e-01,
                            -1.024593e+00, +5.392958e-01, -1.788020e+00, -7.366214e-02,
                            -1.201879e+00, +5.279998e+00, -1.894436e+00, +2.104269e+00,
                            -2.103212e+00, -1.468556e+00, +1.129783e+00, +7.847288e-01,
                            +2.673771e+00, +1.980956e+00, -4.780065e-01, +1.609312e+00,
                            -4.878313e+00, +4.676363e-01, -1.571547e+00, +1.269370e-01,
                            +1.730308e+00, +5.544688e+00, +1.538685e+00, -4.115024e-01,
                            -1.737252e+00, -3.096973e+00, +1.629192e+00, -2.055648e+00,
                            +1.684080e+00, +3.045180e+00, +1.780810e-01, -3.447178e-01,
                            -7.304253e-01, -1.379454e+00, +4.270972e-01, +2.614602e+00,
                },
                {
                            +2.793699e+00, +7.622503e+00, -4.660497e+00, -3.948676e+00,
                            +2.701604e-01, -3.753833e+00, -4.425319e-01, +1.342667e+01,
                            +6.406477e-01, -8.262659e-01, +2.675761e+00, -4.763819e+00,
                            -1.356542e+01, -2.757097e+00, -1.550115e+00, +6.506215e+00,
                            -2.447142e+00, -1.367552e+01, +2.814056e+01, +5.193030e-01,
                            -1.099192e+01, +1.975408e+00, +6.475821e+00, +1.339983e+00,
                            +1.542375e+01, +5.523456e+01, +1.492621e+00, +2.966943e+00,
                            -9.939972e-02, -1.185200e-01, -1.597767e+01, +4.825660e+00,
                            -3.534433e+01, +1.108843e+00, -5.219376e+00, -3.212383e-01,
                            +1.202471e+00, +1.087420e+00, -2.555819e-01, +8.464280e+01,
                            +4.285394e+00, +6.926531e-01, +1.922483e+00, -6.564580e+00,
                            +2.814913e+00, +2.556135e+00, +2.841899e+00, -4.755319e+01,
                            +3.705801e+00, -2.578448e+00, -2.540785e+00, -9.364042e+00,
                            +5.855801e-01, +4.452853e+00, +2.093399e+00, -3.433465e+00,
                            -1.496094e+00, +4.295851e+01, -2.583597e-01, +3.724420e+00,
                            -8.459043e+00, +1.493113e+00, -3.788572e+00, -3.341800e+00,
                            -1.373350e+01, -1.076203e+00, -1.305589e+00, -2.050422e+00,
                            -4.020737e+01, +1.512262e+01, -1.478691e-01, +3.401549e+00,
                            -5.042671e+00, -8.576118e-01, +2.120236e+00, +4.865088e-01,
                            +4.473651e+00, +5.662060e-02, -2.389390e+00, +3.287161e+00,
                            -1.309622e+01, -1.220056e-01, +5.954930e-01, +1.696253e+00,
                            +1.271522e+00, +1.272370e+01, +2.455502e-01, -1.956570e+00,
                            -1.643361e+00, -1.087928e+01, +4.298243e-02, -1.788123e+00,
                            +1.644463e+00, +7.562836e+00, -5.328839e-01, +9.903111e-01,
                            +1.296856e+01, -5.859347e+00, -1.662378e+00, +3.101759e+00,
                },
                {
                            +3.382723e+00, +3.493813e+00, -1.365268e-01, +5.822044e+00,
                            +2.284215e+00, +1.648481e+00, +1.913679e+00, +6.362020e+00,
                            +1.261664e+00, +9.107042e-01, +7.093813e-01, -2.348760e+00,
                            -6.913200e+00, +1.411155e+00, +3.160777e+00, +1.223432e+01,
                            +1.424152e+00, -6.054330e+00, +1.444658e+01, +1.099506e+00,
                            -4.640552e+00, -1.398788e+00, +2.451530e+00, +2.063766e+00,
                            +7.414336e+00, +3.124858e+01, +1.168788e+00, +8.713698e-01,
                            +1.093252e+00, +9.189707e-01, -1.755914e+01, +3.200715e+00,
                            -7.749667e+00, +1.685354e+00, -2.844769e-02, +1.247190e+01,
                            +1.101776e+00, -5.178554e-01, +1.486991e+00, +1.927882e+01,
                            +2.162505e+00, +2.342911e+00, +6.933700e-01, +9.489447e-01,
                            +7.779703e-01, +8.873526e-01, +1.604297e+00, -1.984929e+01,
                            +1.816166e+00, +1.005000e+00, +2.272119e+00, -9.345206e-01,
                            +3.787552e-01, +3.888147e+00, +2.930639e-01, -1.188067e+00,
                            +6.351073e-01, +2.339360e+01, +1.064942e+00, +1.554477e+00,
                            -4.075995e+00, -3.763185e-01, +8.328371e-01, +1.091036e+00,
                            -1.719453e+00, +1.635852e+00, +1.721610e-01, +3.586581e+00,
                            -2.742064e+01, +8.038473e+00, +2.324507e+00, +2.778735e+00,
                            -7.743672e-01, +7.299844e-01, +1.017407e+00, +7.123955e-01,
                            +2.895312e+00, +7.016122e-01, +3.650473e+00, +1.730128e+00,
                            -3.233771e+00, +2.779894e-01, +1.228348e-01, +4.975302e-01,
                            -2.920457e-01, +6.023657e+00, +8.348048e-01, +1.834934e+00,
                            +3.867797e-01, -3.151733e+00, -2.559424e-01, +8.655474e-01,
                            +1.845901e-02, +3.862460e+00, +1.295929e+00, +1.538358e+00,
                            +1.702287e+01, +1.030245e+00, +3.303493e+00, -4.408159e-01,
                },
                {
                            +5.117130e+00, +6.058349e+00, -3.342086e+00, -3.018066e+00,
                            -1.271472e+00, -2.840104e+00, +6.094103e-01, +8.864309e+00,
                            -4.018845e-01, -9.488258e-01, +1.776390e+00, -3.564531e+00,
                            -1.076531e+01, -1.543830e+00, -2.505391e+00, +7.788655e+00,
                            -1.943871e+00, -8.041384e+00, +1.192494e+01, -1.442265e+00,
                            -8.214111e+00, +4.015705e+00, +7.005883e+00, +8.255138e-01,
                            +6.974320e+00, +3.389781e+00, -1.189041e+00, +3.152249e+00,
                            -1.129338e+00, -1.103745e+00, -1.571591e+01, +2.585181e+00,
                            -1.176063e+01, +2.121915e+00, -5.228600e+00, +2.396761e+00,
                            +2.166011e+00, -1.482563e+00, -1.165740e+00, +3.501361e+01,
                            +1.749817e+00, +3.820375e+00, +2.643836e+00, -4.588231e+00,
                            +3.080442e+00, +3.311162e+00, +4.338276e+00, -1.261039e+01,
                            +5.179358e+00, -5.121369e+00, -1.878643e+00, -6.089384e+00,
                            +1.996005e+00, +4.798058e+00, -1.709813e+00, -3.689564e+00,
                            -2.717510e-01, +9.673836e+00, -2.192898e+00, +4.456011e+00,
                            -6.523572e+00, +1.804549e+00, -2.958822e+00, -3.991930e+00,
                            -8.508660e+00, -1.575004e+00, -5.737193e-01, -3.328092e+00,
                            -8.569592e+00, +9.651597e+00, +5.419388e-02, +4.232025e+00,
                            -5.549121e+00, -2.260747e+00, +2.794271e+00, +1.108601e+00,
                            +5.530581e+00, +2.523378e-01, -9.450519e-01, +3.382658e+00,
                            -9.461094e+00, -1.601780e+00, -1.429512e+00, +2.433040e+00,
                            +5.683110e-01, +9.430979e+00, +7.995350e-01, +4.545601e-01,
                            -3.101347e+00, -8.762598e+00, +2.553259e-02, -4.500863e+00,
                            +1.442787e+00, +4.585981e+00, -3.110943e-01, +2.619152e+00,
                            +2.709402e+00, -7.150436e+00, -1.527965e+00, +2.836808e+00,
                },
                {
                            +2.147769e+00, +2.897424e+00, -1.131809e-01, +2.153954e+00,
                            +1.801512e+00, -5.132508e-01, +1.937796e+00, +5.643219e+00,
                            +2.326994e+00, -3.874764e-01, +4.816359e-01, -8.554713e-01,
                            -3.207163e+00, +5.235803e-01, -6.571176e-01, -3.261026e+00,
                            +3.285111e+00, -4.464391e+00, +1.224506e+01, +8.830299e-01,
                            -1.863671e+00, +2.545182e+00, +8.955870e-01, +2.728912e+00,
                            +5.569784e+00, +3.081553e+01, +2.196338e+00, +1.134207e+00,
                            +5.785025e-01, +2.304837e+00, -8.885468e+00, +2.596961e+00,
                            -7.663393e+00, +2.512415e+00, -1.202429e-01, +2.331728e+01,
                            +5.030406e-02, +6.720720e-01, +9.730315e-01, +3.272611e+00,
                            +3.142854e+00, +1.677645e+00, +1.718661e+00, +3.928948e-01,
                            +1.886988e-03, +2.481252e+00, +4.336162e+00, -4.221834e+00,
                            +3.452577e+00, +2.385324e+00, -2.883706e-01, -2.666954e+00,
                            -4.916309e-01, +5.247405e+00, +1.539545e+00, -2.400874e+00,
                            -4.409809e-01, +2.456683e+01, -3.077250e-01, +2.913814e+00,
                            -1.935181e+00, +4.645559e-02, +6.505910e-01, -2.381964e-01,
                            +6.709288e-01, -1.783981e+00, +4.670951e-01, +1.639326e+00,
                            -6.920802e+00, +6.466471e+00, +2.266229e+00, +4.957048e+00,
                            +8.161193e-01, +7.483184e-04, +2.753275e+00, +8.753385e-01,
                            +2.797968e+00, +1.012230e+00, +7.067858e-01, +1.980497e+00,
                            -2.780553e+00, +1.274830e+00, +2.090197e+00, +7.289414e-01,
                            +1.145766e+00, +4.867256e+00, -6.751814e-01, +2.531027e+00,
                            -5.300686e-01, -1.213717e+00, -1.166065e+00, +4.154928e-01,
                            +1.283466e+00, +5.233963e+00, +2.092253e+00, +5.535932e-01,
                            +8.429589e+00, -1.043357e+00, +2.436384e+00, +4.639569e-01,
                },
                {
                            +3.082067e-01, -9.801579e-01, +2.239483e+00, +3.099812e-02,
                            -3.924983e-01, +2.385817e+00, +1.827991e+00, -5.013620e-01,
                            -5.659168e-01, -3.076079e-02, -1.026257e+00, -1.071697e+00,
                            +1.101676e+00, +3.952565e-02, +3.712403e-01, -1.311231e+00,
                            -3.541783e-01, +1.144234e+00, -8.978659e-02, -8.659158e-01,
                            -2.812429e-01, -1.175849e+00, -1.317094e+00, +1.020091e+00,
                            -8.197817e-01, +5.467497e-01, -1.967725e+00, +9.889849e-01,
                            +2.665662e-01, +4.975046e-01, +1.632433e-01, +2.407735e+00,
                            +1.073026e+00, -1.793302e-01, -4.211858e-01, +1.085389e+00,
                            -4.691859e-01, +2.947169e-01, -3.077160e-01, +1.030270e+00,
                            +1.925430e-01, +7.417465e-01, +1.954220e-01, +1.733651e+00,
                            +1.947799e-01, +1.386866e+00, -1.787020e-01, -3.184311e-01,
                            +2.459541e-01, +1.484355e+00, +1.150561e+00, -2.067786e+00,
                            +1.437030e+00, +1.280350e+00, +5.490345e-01, -8.834740e-01,
                            -1.999200e+00, -1.471570e+00, +5.363150e-01, +3.912594e-02,
                            +5.857609e-01, -1.246479e+00, -1.329826e-01, +2.392338e+00,
                            -2.689821e-01, -1.205691e+00, -2.112616e+00, -1.402535e+00,
                            +1.160252e-01, -2.030774e+00, -1.544992e+00, -9.701426e-01,
                            +5.339326e-01, -6.303475e-01, -2.736332e-01, -1.594521e+00,
                            -1.179365e-01, +7.449095e-01, -5.719760e-01, +5.902363e-01,
                            +2.200573e-01, -5.336633e-01, -1.020168e+00, -3.940564e-01,
                            +5.607218e-02, -1.566568e+00, -3.599421e-01, +7.684572e-01,
                            -1.875955e-01, +7.851294e-01, -1.226189e+00, -1.852845e-01,
                            +9.392875e-01, +9.886471e-01, +8.400441e-01, -1.657109e+00,
                            +8.292500e-01, +6.291445e-01, +1.855838e+00, +7.817575e-01,
                },
    };
    // Output connection weights from KOH file for run46_C2_100_nn
    private final static double[][] nodes_output_weights_run46 = new double[][]{
                {-6.498447e+00,},
                {-1.118659e+01,},
                {+7.141798e+00,},
                {+1.183873e+01,},
                {+1.074817e+00,},
                {+6.018702e+00,},
                {-1.659096e+00,},
                {-1.294222e+01,},
                {+1.108248e+00,},
                {+2.588811e+00,},
                {-3.945664e+00,},
                {+7.842213e+00,},
                {+1.751283e+01,},
                {+5.781366e+00,},
                {+6.755374e+00,},
                {+1.031202e+02,},
                {+1.054735e+01,},
                {+1.755498e+01,},
                {-3.344264e+01,},
                {+5.427427e+00,},
                {+1.579636e+01,},
                {-5.690646e+00,},
                {-1.218132e+01,},
                {-3.819303e+00,},
                {-1.405099e+01,},
                {-1.024496e+02,},
                {+3.808777e+00,},
                {-2.790082e+00,},
                {+3.091351e+00,},
                {+7.491806e+00,},
                {-1.038401e+02,},
                {-6.768819e+00,},
                {+8.126829e+01,},
                {-4.358685e+00,},
                {+1.158635e+01,},
                {+5.666190e+01,},
                {-2.149229e+00,},
                {+1.987789e+00,},
                {+2.270336e+00,},
                {+2.295486e+02,},
                {-3.967822e+00,},
                {-4.168178e+00,},
                {-5.674131e+00,},
                {+1.322929e+01,},
                {-5.542926e+00,},
                {-4.399619e+00,},
                {-5.841908e+00,},
                {+1.407293e+02,},
                {-6.590737e+00,},
                {+8.866014e+00,},
                {+4.868539e+00,},
                {+1.497621e+01,},
                {-3.066182e+00,},
                {-7.876665e+00,},
                {+4.323621e-01,},
                {+4.690368e+00,},
                {+2.086550e+00,},
                {-7.048853e+01,},
                {+1.185709e+00,},
                {-8.954231e+00,},
                {+1.322306e+01,},
                {-4.733339e+00,},
                {+7.853796e+00,},
                {+9.012911e+00,},
                {+2.464163e+01,},
                {+5.141197e+00,},
                {+3.237874e+00,},
                {+9.671219e+00,},
                {+1.795104e+02,},
                {-1.461349e+01,},
                {+5.070764e+00,},
                {-5.087717e+00,},
                {+1.137190e+01,},
                {+5.909729e+00,},
                {-4.362403e+00,},
                {-3.661368e+00,},
                {-6.275244e+00,},
                {-1.339217e+00,},
                {+6.661096e+00,},
                {-4.852365e+00,},
                {+1.705250e+01,},
                {+1.975917e+00,},
                {+1.271128e+00,},
                {-3.967096e+00,},
                {+1.674895e+00,},
                {-1.374497e+01,},
                {-1.476553e+00,},
                {+2.474969e+00,},
                {+4.930406e+00,},
                {+1.764274e+01,},
                {-6.230274e-01,},
                {+6.893806e+00,},
                {-4.209852e+00,},
                {-8.861739e+00,},
                {-5.257071e-01,},
                {-2.555179e+00,},
                {-1.081074e+02,},
                {+1.114230e+01,},
                {+9.943105e+00,},
                {-4.742949e+00,},
                {+2.818717e+00,},
    };
    // Intercept and slope for output layer for run46_C2_100_nn
    private final static double[][] nodes_output_scale_run46 = new double[][]{
                {-1.300000e+00, 3.750000e+00}
    };
    // Output offset factors for run46_C2_100_nn
    private final static double[] nodes_output_scale_off_run46 = new double[]{
                1.000000e-01,
    };
    // Output scale flags for run46_C2_100_nn
    private final static int[] nodes_output_scale_flag_run46 = new int[]{
                0,
    };
    // Output limits (min/max) from training data set for run46_C2_100_nn
    private final static double[][] nodes_output_scale_limits_run46 = new double[][]{
                {-1.300000e+00, +1.700000e+00,}
    };

    public static int compute(final float[][] in,
                              final int getNumNodesInput,
                              final float[][] out,
                              final int getNumNodesOutput,
                              final int width,
                              final int[] mask,
                              final int errmask,
                              final float[] a) {
        // (c) M. Schaale, WeW, 2002-2006
        final int rcheck[];
        final int nodes_input = 18;
        final int nodes_output = 1;
        final int nodes_input_bias = 1;
        final int nodes_input_pca = 1;
        final int nodes_hidden = 100;
        final int nodes_hidden_bias = 1;
        final double nodes_hidden_temperature = 1.000000;
        final double t_input = nodes_hidden_temperature / (double) (nodes_input);
        final double t_hidden = nodes_hidden_temperature / (double) (nodes_hidden);
        final double[] vt;
        final double[] vt1;
        //double limexp = -Math.log(Float.MIN_VALUE), dh, dhr, dhe, dhmax=Float.MAX_VALUE, expo;

        // Return dimensions on request
        if (getNumNodesInput <= 0) {
            return (nodes_input);
        }
        if (getNumNodesOutput <= 0) {
            return (nodes_output);
        }

        // Crude compatibility checks
        if (getNumNodesInput != nodes_input) {
            return (-1);
        }
        if (getNumNodesOutput != nodes_output) {
            return (-2);
        }

        vt = new double[nodes_input + nodes_input_bias];
        vt1 = new double[nodes_hidden + nodes_hidden_bias];

        // Range check ??
        rcheck = new int[width];
        for (int x = 0; x < width; x++) {
            rcheck[x] = 0;
            if (a[x] < 0.0f) {
                rcheck[x] = 1;
            }
            a[x] = 1.0f;
        }

        for (int x = 0; x < width; x++) {
            if (mask[x] == 0) {
                // Check input range
                if (rcheck[x] != 0) {
                    for (int i = 0; i < nodes_input && a[x] > 0.0f; i++) {
                        if ((in[i][x] < (float) NN_General.NODES_INPUT_SCALE_LIMITS[i][0]) || (in[i][x] > (float) NN_General.NODES_INPUT_SCALE_LIMITS[i][1])) {
                            a[x] -= 3.0f;
                        }
                    }
                    if (a[x] < 0.0f) {
                        mask[x] |= errmask;
                    }
                }

                //if(mask[x] == 0) {
                // Apply input transformation
                for (int i = 0; i < nodes_input; i++) {
                    if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -1) {
                        in[i][x] = (float) Math.log((double) in[i][x]);
                    }
                    if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -2) {
                        in[i][x] = (float) Math.exp((double) in[i][x]);
                    }
                }

                // Apply input scale layer parameters
                for (int i = 0; i < nodes_input; i++) {
                    in[i][x] = (float) NN_General.NODES_INPUT_SCALE_OFF[i] + (in[i][x] - (float) nodes_input_scale_run46[i][0]) / (float) nodes_input_scale_run46[i][1];
                }

                // Apply input PCA layer parameters
                if (nodes_input_pca != 0) {
                    for (int i = 0; i < nodes_input; i++) {
                        vt[i] = (double) in[i][x];
                        if (NN_General.NODES_INPUT_SCALE_FLAG[i] == 1) {
                            vt[i] = 0.0;
                            for (int j = 0; j < nodes_input; j++) {
                                if (NN_General.NODES_INPUT_SCALE_FLAG[j] == 1) {
                                    vt[i] += (double) in[j][x] * nodes_input_pca_evec_run46[j][i];
                                }
                            }
                        }
                    }
                    for (int i = 0; i < nodes_input; i++) {
                        in[i][x] = (float) vt[i];
                    }
                }

                // Pump through the first layer
                for (int i = 0; i < nodes_input; i++) {
                    vt[i] = (double) in[i][x];
                }
                for (int i = nodes_input; i < nodes_input + nodes_input_bias; i++) {
                    vt[i] = 1.0;
                }

                for (int i = 0; i < nodes_hidden; i++) {
                    vt1[i] = 0.0;
                    for (int j = 0; j < nodes_input + nodes_input_bias; j++) {
                        vt1[i] += vt[j] * nodes_hidden_weights_run46[j][i];
                    }
                }
                // Pump through sigmoid
                for (int i = 0; i < nodes_hidden; i++) {
                    vt1[i] = 1.0 / (1.0 + Math.exp(-t_input * vt1[i]));
                }

                // Pump through the second layer
                for (int i = nodes_hidden; i < nodes_hidden + nodes_hidden_bias; i++) {
                    vt1[i] = 1.0f;
                }
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = 0.0f;
                    for (int j = 0; j < nodes_hidden + nodes_hidden_bias; j++) {
                        out[i][x] += (float) (vt1[j] * nodes_output_weights_run46[j][i]);
                    }
                }
                // Pump through sigmoid
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = (float) (1.0 / (1.0 + Math.exp(-t_hidden * out[i][x])));
                }

                // Apply output scale layer parameters
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = (float) nodes_output_scale_run46[i][0] + (out[i][x] - (float) nodes_output_scale_off_run46[i]) * (float) nodes_output_scale_run46[i][1];
                }

                // Apply output transformation
                for (int i = 0; i < nodes_output; i++) {
                    if (nodes_output_scale_flag_run46[i] == -1) {
                        out[i][x] = (float) Math.log((double) out[i][x]);
                    }
                    if (nodes_output_scale_flag_run46[i] == -2) {
                        out[i][x] = (float) Math.exp((double) out[i][x]);
                    }
                }

                // Check output range
                if (rcheck[x] != 0) {
                    for (int i = 0; i < nodes_output && a[x] >= -2.0f; i++) {
                        if ((out[i][x] < (float) nodes_output_scale_limits_run46[i][0]) || (out[i][x] > (float) nodes_output_scale_limits_run46[i][1])) {
                            a[x] -= 20.0f;
                        }
                    }
                    if (a[x] < 0.0f) {
                        mask[x] |= errmask;
                    }
                }

                //} // mask
            } // mask
        } // x
        return 0;
    }
}
