package org.esa.s3tbx.fub.wew.util;

public class NN_AtmCorr {

    // Input limits (min/max) from training data set for run19_C2_080_nn
    private final static double[][] nodes_input_scale_limits_run19 = new double[][]{
                {+1.706000e-02, +8.206540e-02,},
                {+1.398190e-02, +7.971700e-02,},
                {+1.005190e-02, +8.197300e-02,},
                {+8.568320e-03, +8.207000e-02,},
                {+5.727510e-03, +9.049200e-02,},
                {+3.913480e-03, +8.503200e-02,},
                {+3.357980e-03, +8.011580e-02,},
                {+2.780180e-03, +7.740390e-02,},
                {+2.320470e-03, +6.779030e-02,},
                {+2.077070e-03, +6.768030e-02,},
                {+1.478170e-03, +6.414750e-02,},
                {+1.364670e-03, +6.337550e-02,},
                {+1.500000e+00, +7.226600e+00,},
                {+9.800000e+02, +1.040000e+03,},
                {+2.468300e-01, +9.999990e-01,},
                {-6.613120e-01, +6.613120e-01,},
                {-6.613120e-01, +6.613120e-01,},
                {+7.501110e-01, +1.000000e+00,},
    };
    // Intercept and slope for input layer for run19_C2_080_nn
    private final static double[][] nodes_input_scale_run19 = new double[][]{
                {+4.162870e-02, +1.159250e-02},
                {+3.518430e-02, +1.061470e-02},
                {+2.917400e-02, +1.046540e-02},
                {+2.695010e-02, +1.063440e-02},
                {+2.315390e-02, +1.162060e-02},
                {+1.750450e-02, +1.023960e-02},
                {+1.573000e-02, +9.633650e-03},
                {+1.381390e-02, +8.880190e-03},
                {+1.202790e-02, +8.331090e-03},
                {+1.163130e-02, +8.269160e-03},
                {+1.019730e-02, +7.990310e-03},
                {+9.899540e-03, +7.895780e-03},
                {+1.500000e+00, +6.362902e+00},
                {+9.800000e+02, +6.666667e+01},
                {+2.468300e-01, +8.368551e-01},
                {-6.613120e-01, +1.469581e+00},
                {-6.613120e-01, +1.469581e+00},
                {+7.501110e-01, +2.776544e-01},
    };
    // Eigenvectors (columnwise) for input PCA layer for run19_C2_080_nn
    private final static double[][] nodes_input_pca_evec_run19 = new double[][]{
                {
                            +3.839968e-02, -5.795430e-03, +2.936752e-01, -1.970490e-01,
                            -2.621877e-01, +1.020704e-01, +1.971422e-01, +3.847185e-01,
                            +3.696410e-01, +4.875228e-01, +4.031800e-01, +2.655508e-01,
                },
                {
                            -7.574958e-02, +9.095699e-03, -5.090752e-01, +3.755209e-01,
                            +3.357601e-01, -2.453652e-01, -2.537639e-01, -1.240111e-01,
                            +1.373729e-01, +3.867677e-01, +3.045643e-01, +2.829700e-01,
                },
                {
                            +7.756098e-02, -9.644410e-03, +5.023366e-01, +8.219521e-02,
                            +1.900543e-01, +3.564176e-01, -1.355077e-01, -5.296065e-01,
                            -3.228147e-01, +8.284239e-02, +2.730596e-01, +2.952286e-01,
                },
                {
                            -6.940777e-02, +1.164883e-02, -4.251432e-01, -4.845530e-01,
                            -3.899850e-01, -1.221815e-01, +1.498897e-01, -1.983748e-01,
                            -4.242593e-01, -8.908135e-02, +2.756226e-01, +2.945729e-01,
                },
                {
                            +3.115004e-02, -1.090089e-02, +1.245841e-01, +3.999202e-01,
                            +1.073568e-01, -1.543082e-01, +1.678783e-01, +5.320897e-01,
                            -3.585184e-01, -4.324692e-01, +2.879316e-01, +2.799014e-01,
                },
                {
                            -6.203859e-02, +3.639299e-02, -7.471088e-02, -4.970290e-01,
                            +5.021169e-01, +1.896437e-01, -1.804743e-01, +1.073524e-01,
                            +3.658537e-01, -4.315155e-01, +7.783198e-02, +2.896779e-01,
                },
                {
                            +3.769634e-02, -1.530799e-02, +8.799652e-02, +2.180529e-01,
                            -5.790995e-01, -8.679074e-02, -5.406439e-01, -1.067142e-01,
                            +3.179683e-01, -3.247522e-01, -4.395948e-02, +2.966163e-01,
                },
                {
                            +9.350434e-02, -9.804870e-02, -1.626535e-01, +2.819435e-01,
                            -4.967403e-02, +1.833249e-01, +6.807183e-01, -3.210521e-01,
                            +3.535317e-01, -1.873556e-01, -1.537926e-01, +2.990464e-01,
                },
                {
                            +5.102600e-01, -2.227111e-01, +2.213709e-01, -2.069868e-01,
                            +1.615624e-01, -6.079879e-01, +3.064455e-02, -6.297363e-02,
                            -3.145488e-02, +1.140794e-01, -3.123403e-01, +2.932053e-01,
                },
                {
                            -6.175027e-01, +5.235152e-01, +2.409296e-01, -1.317678e-02,
                            +3.525015e-02, -2.768373e-01, +1.129996e-01, -4.809047e-02,
                            -2.055771e-02, +8.938190e-02, -3.144802e-01, +2.934773e-01,
                },
                {
                            -3.836933e-01, -6.759210e-01, -5.449608e-02, +2.886295e-03,
                            -8.450625e-03, +2.478089e-01, -1.043672e-01, +1.973832e-01,
                            -1.763203e-01, +1.718467e-01, -3.725625e-01, +2.866633e-01,
                },
                {
                            +4.219903e-01, +4.558795e-01, -2.370318e-01, +3.961677e-02,
                            -3.777402e-02, +4.228497e-01, -1.219905e-01, +2.498650e-01,
                            -1.982806e-01, +1.832973e-01, -3.799382e-01, +2.855441e-01,
                },
    };
    // Input connection weights for run19_C2_080_nn
    private final static double[][] nodes_hidden_weights_run19 = new double[][]{
                {
                            +7.293590e+00, +9.264650e+00, -5.187230e+00, +1.078150e+01,
                            -1.448670e+01, -3.021160e+01, -5.535660e+00, -1.708580e+00,
                            -1.412400e+01, -1.620270e+01, -1.908680e+01, -4.552610e+01,
                            +5.369610e+01, +2.680570e+01, -5.649720e+00, -3.504490e+00,
                            -3.557740e+01, +3.835290e+00, -1.551340e+01, -6.008080e+00,
                            -9.171960e+00, -2.145100e+01, +7.083650e+00, -1.614410e+01,
                            -7.746740e+00, +3.585750e+00, -7.896760e+00, -3.795690e+01,
                            +1.672380e+01, -2.711630e+01, +1.258110e+02, -2.369860e+01,
                            -1.074520e+01, -3.316250e+01, -1.736010e+00, +9.579300e+01,
                            -5.831320e-01, -8.090130e+00, -1.420590e+01, +1.224460e+01,
                            -2.427530e+00, +6.991880e+01, -1.260380e+01, -2.973280e+00,
                            +8.464970e+00, +7.753830e+00, -3.677790e+00, -1.389340e+01,
                            -1.175710e+01, -7.199020e+00, +4.566460e+00, +1.383930e+01,
                            +7.840280e+00, -2.958540e+00, -1.796770e+00, +1.175880e+01,
                            -5.579490e+00, +6.704960e+00, +1.555780e+01, -8.515630e+01,
                            +1.727690e+00, +1.659220e+01, +2.175140e+00, -1.668870e+01,
                            -2.150960e+01, +7.602040e+00, -2.064720e+01, +1.054990e+01,
                            -3.145670e+01, -2.113160e+01, +1.456250e+01, -6.777540e+00,
                            -6.720500e+00, -3.357790e+01, +3.294750e+00, -1.163400e+01,
                            +1.622220e+01, +1.152340e+01, +8.044820e-01, -1.176300e+01,
                },
                {
                            -2.339750e+00, -1.274990e+00, -2.292310e+00, +2.252230e+00,
                            -2.015440e+00, +6.363450e-01, -2.171110e+00, +4.483980e+00,
                            -1.439570e+00, +5.775460e+00, -6.628540e+00, -1.590150e+00,
                            +4.167460e+01, +2.351050e-01, +1.580260e+00, -1.648270e+00,
                            +5.741790e+00, -6.731990e-01, +5.708770e+00, -3.177600e+00,
                            -2.666360e+00, +3.212830e+01, -5.833280e-02, -2.710050e+00,
                            -3.867850e+00, -2.384360e+00, -2.007150e+00, +5.646420e+00,
                            +1.405340e+00, -3.618020e+00, +1.461890e+01, -1.104950e+01,
                            +1.361450e-01, -5.546580e+00, -6.096450e-01, +8.023560e-01,
                            +1.438590e+00, -3.818910e+00, -1.103720e-01, +1.527500e+01,
                            -2.620450e+00, +2.560740e+01, -1.782070e+00, -2.376780e-01,
                            -8.553320e-01, +2.976090e+00, -5.688560e+00, -6.363820e+00,
                            -3.555240e+00, -5.341420e+00, -3.960180e+00, +8.395510e+00,
                            -1.280450e+00, -3.272940e+00, -1.206140e+00, -1.464970e+01,
                            -9.434990e-01, +1.016330e+01, +3.783830e+00, +2.765580e+01,
                            -2.963690e+00, -1.999400e+01, -7.016060e+00, -3.179030e+00,
                            -3.612010e+00, -1.139650e+00, -1.781810e+00, -1.962940e-01,
                            -6.966690e+00, -5.567170e+00, -6.693000e-01, -1.606140e+00,
                            -3.557680e+00, -1.233880e+00, +3.275800e+00, -8.652380e-01,
                            +5.958020e+00, +1.676990e+00, +2.711160e+00, -3.200580e+00,
                },
                {
                            +7.724580e+01, -6.164410e+01, +2.684770e+01, +2.111030e+01,
                            +6.776580e-02, -4.054380e+01, +9.495950e+00, -4.987970e+01,
                            +5.851190e+01, +6.159760e+00, +4.233690e+01, +6.352260e+01,
                            -1.734680e+02, -1.284660e+02, +1.798560e+01, +2.795650e+01,
                            +1.266800e+02, +1.652590e+00, +1.306020e+01, +2.840000e+01,
                            +3.408010e+00, +3.671460e+02, +5.577070e+00, +2.677800e+01,
                            +1.984900e+01, +3.322360e+00, +8.371140e+01, +2.377290e+02,
                            +5.959340e+01, +6.358970e+01, -1.399070e+02, +4.390240e+01,
                            +1.955410e+01, +1.212560e+01, +6.818890e+00, -1.120390e+02,
                            +6.637500e-01, +5.100750e+00, +1.520690e+01, +1.746980e+02,
                            +8.774390e+00, -1.611140e+02, +1.973800e+01, +1.364080e+01,
                            +1.068880e+01, +2.056210e+01, +6.068870e+01, +1.283500e+02,
                            +3.044860e+01, +2.074510e+01, +2.171740e+01, +1.606520e+02,
                            +1.515850e+00, +2.850080e+01, +1.443790e+01, -1.218710e+01,
                            +2.422990e+01, +1.216860e+02, +5.526360e+01, +6.489150e+01,
                            +8.924770e+00, -2.329520e+02, -1.378250e+02, +1.866470e+01,
                            -1.447630e+02, +1.201080e+01, +7.952290e+01, +1.296900e+01,
                            +1.522950e+02, +4.701120e+01, -6.283570e+00, +6.268910e+00,
                            +2.916840e+01, +3.337530e+01, +3.191510e+01, +1.566590e+01,
                            +5.963830e+00, +3.691990e+01, -1.144750e+02, +4.449100e+01,
                },
                {
                            +3.168580e+01, -6.705170e+00, +2.342760e+01, -7.944220e+00,
                            -2.436290e+01, -2.333370e+00, +1.784110e+00, -2.747540e+02,
                            -2.721820e+00, -2.234540e+01, -2.508040e-01, +2.400210e+01,
                            -2.059410e+01, -1.099610e+02, -6.032540e+00, +2.606610e-01,
                            +2.380910e+01, -2.517890e+01, +7.388910e+01, -2.076550e+01,
                            -3.436230e-01, +1.837690e+02, -6.813810e+00, -1.686310e+01,
                            -2.030150e+01, -3.204990e+01, +3.489800e+01, +8.499460e+01,
                            -1.743830e+01, +5.828810e+00, +2.472200e+02, +8.199750e+00,
                            -1.211530e+01, -6.789540e+00, -4.566660e+00, -1.443460e+01,
                            -6.724160e+01, +9.303150e+00, -1.341910e+01, +3.325330e+01,
                            -2.482610e+01, -7.352720e+01, +7.484190e+00, -9.512300e+00,
                            -3.156700e+00, -1.695430e+01, +8.157790e+00, -3.184810e+00,
                            +5.324830e+00, +1.528340e+01, -2.205060e+01, +3.947900e+01,
                            -2.004520e+01, +3.288040e+00, -2.252410e+01, +3.529910e+01,
                            +1.792130e+01, -9.282940e+01, +2.789940e+01, +2.120660e+02,
                            -2.408020e+01, +2.737840e+01, -3.457030e+01, -1.236830e+01,
                            +1.250380e+00, +6.545880e+00, +3.112890e+00, -2.053660e+01,
                            +6.790270e+01, -9.280750e+00, -1.773910e+01, -4.393600e-01,
                            +1.034130e+01, +2.548930e-01, -3.287680e+01, +1.831730e+00,
                            +1.521150e+01, -3.642270e+01, +6.024320e+01, -1.054550e+00,
                },
                {
                            +4.279290e+01, -4.594430e+01, +3.217200e+01, +3.691450e+00,
                            +6.455990e+00, -6.031770e+01, +7.629990e+00, -4.025400e+01,
                            +5.183260e+01, +7.274280e+00, +3.081810e+01, +3.812030e+01,
                            -1.196700e+02, -1.392530e+02, +9.016790e+00, +1.479080e+01,
                            +9.658910e+01, +1.888020e+01, +5.154150e+01, +3.315080e+01,
                            +8.812410e+00, +5.703210e+01, +4.683570e+01, +3.729550e+01,
                            +2.728680e+01, +1.536240e+01, +8.078050e+01, +1.922350e+02,
                            +7.797800e+01, +2.313180e+01, -2.371390e+01, +3.677350e+01,
                            +3.012440e+01, +5.863040e+00, +1.350610e+01, +4.268610e+01,
                            -2.824880e+00, -3.801160e+00, +3.668140e+00, +6.834860e+01,
                            +5.072260e+00, -1.375910e+01, -5.083830e+00, +1.123210e+01,
                            +6.586350e+01, -8.117310e+00, +3.981410e+01, +7.371450e+01,
                            +2.556890e+01, +1.697260e+01, -6.393800e+00, +4.157190e+01,
                            +4.199690e+01, +1.147680e+01, +1.211490e+01, -3.243460e+01,
                            +2.619730e+01, +4.367520e+01, -1.480640e+01, +8.830280e+01,
                            +3.276030e+01, -1.170610e+02, -4.519100e+01, -4.964050e+00,
                            -7.630000e+01, +1.075110e+01, +3.358220e+01, +2.118190e+01,
                            +1.085060e+02, +3.368140e+01, +6.580570e+01, +9.028820e-01,
                            +5.935760e+00, +3.509370e+01, +7.841700e+00, +2.500570e+01,
                            +1.980400e+01, -2.857350e+01, +1.229800e+02, +2.903950e+01,
                },
                {
                            -6.168870e+01, +2.933560e+01, +1.628700e+01, -9.281480e+01,
                            -3.546750e+00, +7.244910e+00, -4.343770e+01, -4.778340e+02,
                            -3.514000e+01, +4.342130e+00, +1.383900e+01, +3.110040e+01,
                            +1.288050e+02, -6.137020e+01, -8.586690e+00, -2.490470e+01,
                            +6.482480e+01, -2.321460e+01, +1.263040e+02, -4.377870e+01,
                            +8.143630e+01, +1.401810e+02, +4.015940e+00, -1.102380e+00,
                            -5.881260e+00, -5.127340e+01, -1.250990e+01, -1.423630e+02,
                            -6.853210e+01, -6.416560e-01, +1.422060e+02, +1.636310e+01,
                            -4.471730e+00, +2.722860e+01, +1.023970e+01, -1.283290e+02,
                            -1.388930e+02, +6.385130e+01, -1.036050e+01, +7.714620e+01,
                            -1.033920e+01, +1.411280e+01, +2.670090e+01, -1.026740e+01,
                            -3.302270e+00, -8.739150e+01, -5.221900e+01, -6.218800e+01,
                            +6.536370e+00, +2.517050e+01, +2.011410e+01, +1.275270e+02,
                            +2.302330e+00, -1.928050e+01, -1.972160e+01, +8.168880e+01,
                            +1.357080e+01, -9.320610e+01, -6.303740e+00, +3.657480e+02,
                            -3.858540e+01, -1.908650e+01, -2.098720e+01, -2.212470e+00,
                            -2.425220e+01, -4.093400e+01, -4.092040e+00, -3.225710e+00,
                            +5.436610e+01, -2.805900e+01, -8.660050e+00, -1.526960e+01,
                            +1.038350e+01, -1.016840e+01, -1.157070e+02, +3.358900e+01,
                            -1.156450e+01, -1.241750e+02, -2.525920e+02, -1.427530e+01,
                },
                {
                            +1.674400e+01, +3.740620e+01, +5.852950e+01, -1.515710e+01,
                            +2.400560e+01, +1.880520e+01, +1.993580e+00, +3.648120e+01,
                            +1.247200e+01, -3.003070e+01, +5.067440e+01, +8.031750e+01,
                            +1.407360e+01, +4.060450e+01, +7.483870e+00, +3.593360e+01,
                            -2.171290e+01, -5.559320e+01, -8.569930e+01, +3.500930e+01,
                            +3.298350e+01, -7.554540e+01, +3.726850e+01, +5.316710e+01,
                            +4.831940e+01, +2.175170e+01, +2.643880e+01, -1.389670e+02,
                            -8.611080e+01, +6.534610e+01, -1.908220e+01, +7.319020e+01,
                            +3.940720e+01, +1.875910e+00, +6.526890e+01, -8.419510e+01,
                            -3.916780e+00, +1.251410e+01, +5.602110e+01, -4.088980e+01,
                            +3.388660e+01, -1.238180e+02, -4.309360e+00, +3.939010e+01,
                            +3.601470e+01, -1.660960e+00, +2.630640e+01, +1.117890e+01,
                            +2.803480e+01, +3.620540e+01, +2.958560e+01, -1.687360e+01,
                            -1.495630e+01, -5.483710e+00, +1.414960e+01, +8.100620e+01,
                            +3.785470e+01, -1.023540e+00, +8.908260e+01, -7.063690e+01,
                            -4.208630e+01, -3.101190e-01, -3.920880e+00, +2.372780e+01,
                            +2.043740e+01, +6.988070e+00, +4.838290e+00, +1.794210e+01,
                            +7.829100e+01, +1.718610e+01, +3.460350e+01, -6.199360e+00,
                            +2.877600e+01, -1.227500e+01, +6.273160e+00, +7.266990e+01,
                            +5.198690e+01, -2.711060e+01, -1.664250e+02, +2.688040e+01,
                },
                {
                            -7.607660e+01, +7.902130e+01, -5.426840e+01, -3.686500e+01,
                            +6.751360e+01, -2.755700e+01, -4.196600e+01, +3.192050e+02,
                            +2.099560e+01, +5.824800e+01, +4.370390e+01, +1.119120e+02,
                            +5.542090e+01, +1.080150e+02, -8.767860e-01, -7.007670e+01,
                            -3.534350e+01, +3.462990e+01, +9.325430e-01, -4.699770e+01,
                            +5.413760e+01, -6.278510e+01, +3.627030e+01, +1.674150e+01,
                            -3.180290e+00, +1.049940e+01, -6.057960e+01, -1.607800e+02,
                            -3.936260e+01, -3.806750e+01, -5.387720e+01, +1.296410e+02,
                            -4.969240e+00, -5.307350e+01, +1.027770e+02, -7.768160e+01,
                            +4.289290e+01, +4.128110e+01, +1.080210e+01, -2.934000e+01,
                            +5.138860e+01, -1.815880e+00, +4.921410e+01, +2.338320e+00,
                            +1.736350e+02, -6.337930e+00, -2.150620e+01, -1.930460e+01,
                            +9.302790e+00, +3.539640e+01, +2.232070e+02, +2.428740e+01,
                            +1.053160e+02, +1.147980e+01, +6.802320e+01, +3.655620e+01,
                            -3.774930e+00, -1.863020e-02, +7.630300e+01, -1.884710e+02,
                            +7.840170e+01, +3.127620e+01, +4.081730e+01, +1.216870e+02,
                            +2.381540e+01, +1.351490e+01, -9.337230e+00, -2.008550e+01,
                            -3.361610e+01, +5.231850e+01, +7.563000e+01, +3.623500e+00,
                            +9.146390e+00, -2.219790e+01, -4.978270e+01, -9.952120e+00,
                            -2.848200e+01, -3.337330e+01, -8.010630e+01, +9.998550e+00,
                },
                {
                            -2.315210e+01, +5.581390e+01, -8.201220e+00, -8.350540e+01,
                            +5.882720e+00, -4.771990e+00, +6.288850e+01, +2.051960e+02,
                            +3.108190e+00, +1.213820e+01, -1.661450e+01, +9.472190e+00,
                            +1.820620e+01, +1.361310e+01, +7.648270e+01, +2.515420e+01,
                            -9.099340e+01, -8.334800e+01, -9.928060e+00, -2.726710e+01,
                            +3.585990e+01, +5.665250e+01, +6.187760e+00, -9.773440e+01,
                            -2.012800e+01, +1.856180e+01, -3.455120e+01, -5.538180e+01,
                            +1.209160e+02, +3.346200e+01, -4.816420e+01, -2.748540e+01,
                            -3.680340e+01, -2.777120e+01, +5.211230e+01, -1.310250e+01,
                            +4.493130e+01, +6.922830e+00, +2.632240e+01, -3.532980e+01,
                            +1.735880e+01, -3.017460e+01, -1.934020e+00, +2.710120e+01,
                            +8.823660e+01, +2.302280e+01, +1.864470e+01, +1.177400e+01,
                            -3.121400e+01, -2.215830e+01, +7.161030e+01, -4.918950e+01,
                            -3.418720e+01, -2.390050e+01, +2.774510e+01, +1.273100e+01,
                            +3.239780e+01, +1.910030e+02, +3.549500e+01, -4.951830e+01,
                            -3.196530e+01, +2.737520e+01, +1.573250e+01, -7.827690e+00,
                            +6.331860e+01, +3.350970e+01, -1.796780e+01, -2.613080e+01,
                            -1.855570e+01, +1.944400e-01, +3.077940e+01, -8.794190e+01,
                            -2.083490e+01, -3.584010e+00, -1.525470e+01, -6.401600e+01,
                            +2.298810e+01, +1.259860e+01, -5.109800e+01, -9.844870e+00,
                },
                {
                            -3.681880e+01, +2.901190e+01, +4.011370e+01, +1.485390e+01,
                            +1.229780e+01, -4.560520e+00, +9.441780e+00, +2.898000e+01,
                            -6.389570e+00, +4.731560e+00, -9.674400e+00, -1.149560e+00,
                            +1.455360e+01, +3.210870e+01, +1.737910e+01, +2.724660e+01,
                            +1.428380e+02, +4.172510e+00, +6.304260e+01, +4.026260e+01,
                            +3.623860e+01, +8.458160e+01, +6.111820e+01, +5.046050e+01,
                            +3.731080e+01, -3.975330e-01, -2.711580e+01, -3.107590e+01,
                            +1.660160e+02, -1.446480e+01, -1.369550e+01, -5.519420e+00,
                            +3.908170e+01, -3.859350e+01, +1.487370e+01, -1.113320e+01,
                            +1.045040e+01, -2.916920e+00, -2.751310e+00, +1.917000e+00,
                            -7.477340e-01, +4.200070e+01, -5.658530e+00, +2.366210e+00,
                            +5.007030e+01, +1.141120e+02, +5.711160e-01, -1.568890e+00,
                            -1.188580e+01, -1.571970e+01, +6.928740e+00, -1.216400e+01,
                            +2.554470e+01, -1.368730e+01, +1.008680e+01, +4.871920e+00,
                            +1.833980e+01, +1.478690e+02, +3.933410e+01, +1.482840e+01,
                            -2.128090e-02, +2.050140e+01, +3.620430e+01, +3.807240e+00,
                            +2.476920e+01, +9.313460e+01, -1.744770e+01, +3.830370e+01,
                            -1.535370e+01, -8.298000e-01, +6.831800e+01, -4.082840e+01,
                            -1.519810e+01, -1.977930e+01, +8.167700e+01, +2.926220e+01,
                            +3.832270e+01, +1.583540e+02, +1.950460e+01, -9.921910e+00,
                },
                {
                            -7.348540e+00, +7.647380e+01, -4.251470e+01, +3.235630e+00,
                            +1.005720e+01, +4.707100e+00, +4.833220e+01, -3.735560e+01,
                            +5.225190e+00, +2.459850e+01, +1.961810e+00, +1.872870e+01,
                            +1.687690e+01, -2.291580e+01, -6.018390e+00, -3.810150e+01,
                            -2.537060e+01, +3.265330e+01, +4.122080e+00, -8.723760e+00,
                            -6.571560e+00, -2.146470e+01, -4.745810e+00, -1.846760e+01,
                            -4.177160e+00, +2.103610e+00, -2.733540e+01, -4.888000e+01,
                            -4.837050e+01, +8.916370e+00, -4.208440e+01, +3.818010e+00,
                            -4.212010e+00, +2.018310e+01, +1.916500e+01, -1.313490e+01,
                            -1.569800e+01, +2.957670e+00, +9.603600e+00, -3.921640e+01,
                            +3.513900e+00, -6.194620e+01, +5.357530e+00, +7.979110e-01,
                            -1.066360e+01, -2.309390e+01, +2.280840e+01, +6.978810e+00,
                            -1.687430e+01, -1.269670e+01, -1.036380e+01, -4.200250e+01,
                            +2.036570e+01, -1.766980e+01, +5.864990e+00, +1.367740e+01,
                            -4.425330e+01, -6.526350e+01, +2.192790e+01, +7.240730e+00,
                            +5.825910e+00, +1.242160e+01, -1.265110e+01, +1.026350e+01,
                            +4.293600e+01, -7.402770e+00, -1.614210e+01, +9.424810e-01,
                            -1.611090e+01, +4.140920e+00, -1.201170e+01, +2.362690e+01,
                            -1.490860e+01, +7.895630e+00, -1.263090e+01, -2.678280e+01,
                            -1.499160e+01, -3.904470e+01, -7.361360e+01, -1.506330e+00,
                },
                {
                            -2.164190e+01, -6.172000e+00, -8.544270e+00, -1.064700e+00,
                            +7.991160e+00, +1.270450e+00, -1.317820e+01, -1.064750e+00,
                            -1.642820e+00, +2.315090e+00, -3.640370e+00, +4.515820e+00,
                            +4.456490e+00, -4.678330e-01, -4.100460e+00, -8.359660e+00,
                            -7.943550e+00, +3.801930e+00, -1.921020e+00, -4.915790e+00,
                            -1.064010e+01, -2.940380e+00, -7.759540e+00, -4.616710e+00,
                            -2.946960e+00, -2.102570e+00, -9.289610e+00, -7.580580e+00,
                            -1.041360e+01, -4.595460e-01, -1.175260e+00, -2.421350e+00,
                            -5.197770e+00, -3.483860e+00, -3.548500e+00, -4.745330e+00,
                            -1.456990e+01, -3.183350e+00, +3.905970e+00, +6.882630e+00,
                            +1.513470e+00, +4.135910e+01, -2.597610e+00, -2.155020e-02,
                            -6.126260e+00, -8.246930e+00, -5.532260e+00, -2.998370e+00,
                            -8.140800e+00, -6.228500e+00, -2.847260e+00, +3.867530e+00,
                            -6.099100e+00, -4.479420e+00, -9.209470e+00, +1.627670e-01,
                            -9.146610e+00, -9.721660e+00, +1.360150e+01, -2.612450e-01,
                            +6.577590e-01, +4.108620e+00, -3.096930e+00, +2.770080e+00,
                            -1.526450e+00, -7.929780e+00, -7.496110e+00, +6.945240e+00,
                            -2.100030e+00, -3.221340e+00, -8.116420e+00, +1.579280e+00,
                            -6.697840e+00, -1.546750e+01, -5.780100e+00, -6.163990e+00,
                            -4.012870e+00, -1.083360e+01, +2.920090e+01, -3.715950e+00,
                },
                {
                            -6.479980e+00, +1.991270e+01, +4.735670e-01, -2.891170e+00,
                            +1.685690e+01, +2.371340e+00, +3.184200e+01, -1.292970e+00,
                            -2.211850e+00, +5.738300e-01, -1.294360e+01, +6.827370e+00,
                            -2.227880e+00, +9.934420e-01, +1.126790e-02, +4.238760e+00,
                            -4.508110e+00, +5.042910e+00, -3.529270e+00, -8.987320e+00,
                            -6.303140e-01, -8.224950e-02, +3.468100e+00, -7.411140e+00,
                            -4.902690e+00, -3.268090e+01, +1.260360e+00, -9.804880e+00,
                            -2.490150e+00, -1.615790e+01, -5.421790e+00, -1.066430e+00,
                            -7.507650e+00, +9.935070e+00, +2.427770e+00, -1.926140e+00,
                            -6.110510e+00, +1.449440e+00, +5.271600e+00, -1.740420e+01,
                            +2.006560e+00, -7.162230e+00, -9.340730e+00, -3.590190e+00,
                            +2.018010e+00, -5.097530e+00, -6.554260e+00, +2.700920e+00,
                            -6.677230e+00, -6.935170e-01, +7.696040e-01, +1.220730e+00,
                            -3.714850e+00, +4.137940e+00, -1.005310e+01, -5.486230e+00,
                            -1.039520e+01, -6.671300e+00, -5.834150e+00, +2.243570e+00,
                            +5.368590e+00, +4.143610e+00, -4.196050e+00, +7.630680e-01,
                            +1.405220e+01, +1.791740e+00, -6.313060e+00, +1.731000e+01,
                            +7.521170e-01, -9.746140e+00, +2.570740e+00, -1.068890e+00,
                            -7.762550e+00, +1.418250e+01, +7.900250e+00, -2.702270e+00,
                            -6.482510e+00, -7.731710e+00, +3.079120e+00, -1.005110e+01,
                },
                {
                            +3.559920e+00, -9.859720e+00, -1.725700e-01, +2.997390e-01,
                            +7.318660e-01, +1.533710e+00, -8.534920e-01, -6.802780e-01,
                            -2.061030e+00, -5.446640e+00, -3.439650e+00, -6.732870e+00,
                            -3.352310e+00, -2.177940e+00, +2.815190e+00, +3.017480e+00,
                            -3.651910e+00, +4.290350e+00, -1.916460e+00, -7.352580e-01,
                            +1.983020e+00, -3.595250e+00, +3.951640e+00, +2.901120e+00,
                            +1.769020e+00, -1.744760e+00, +7.733020e+00, +1.029910e+01,
                            -4.677100e+00, -3.777620e+00, +4.416040e+00, -2.067600e+00,
                            -1.970090e+00, +3.577900e+00, +4.666350e+00, +3.952870e+00,
                            +6.613850e+00, +8.118650e-01, +6.488930e+00, +1.308200e+00,
                            -1.277940e+01, -2.854060e+00, +4.513030e+00, +2.048230e+00,
                            -5.388080e-01, -1.915180e+00, +9.923810e-01, +8.443010e-01,
                            +4.731330e+00, +3.995990e+00, -4.870300e+00, +2.427880e+00,
                            +3.378060e+00, -9.789890e-01, -3.156920e+00, -1.728730e+00,
                            +1.753430e+00, -3.719920e+00, -5.424080e+00, +1.721770e+00,
                            -2.084030e+00, -2.174150e+00, -1.437840e+00, -4.914990e+00,
                            -3.478490e+00, -1.212550e+00, +2.929070e+00, -1.920920e+00,
                            +3.664370e-01, +2.993290e+00, -4.164100e+00, +5.847310e-01,
                            +1.976190e+00, +4.314090e+00, -1.784290e+00, -4.085390e+00,
                            -1.609080e+00, -2.368170e+00, +3.737180e+00, -4.387710e+00,
                },
                {
                            +3.029720e+01, +4.192610e+01, +3.943940e+00, +1.629570e+01,
                            +1.803950e+01, -3.862210e+01, +2.712350e+01, -1.389600e+02,
                            +2.151480e+01, -2.649790e+01, +3.267430e+01, +1.560490e+01,
                            -1.090360e+02, -3.832540e+01, +1.753810e+01, +1.497810e+01,
                            -6.660730e+01, +5.584150e+01, -4.543490e+01, +1.873760e+01,
                            +2.672100e+01, -1.014270e+02, +1.168030e+02, +8.753200e+00,
                            +2.596100e+01, +2.821640e+01, +2.227400e+01, -5.129470e+01,
                            -1.328140e+02, +2.420690e+01, +2.436040e+02, +3.388600e+01,
                            +1.490620e+01, -7.430330e+00, +8.838550e+01, -1.524230e+02,
                            -2.111220e+02, +2.507250e+01, +1.538420e+01, +4.202890e+01,
                            +2.800340e+01, -2.548710e+02, +1.518410e+01, +2.015790e+01,
                            +1.492950e+02, +1.350630e+01, +7.113500e+01, +3.839290e+01,
                            +3.010720e+01, +2.296360e+01, +1.058840e+02, +1.192140e+02,
                            +1.022080e+02, +1.186950e+01, +4.490880e+01, +1.041450e+02,
                            +7.559440e+00, -1.384530e+02, +2.088500e+01, +3.562730e+01,
                            +2.746550e+01, -9.727320e+01, -2.139480e+01, +2.584710e+01,
                            -8.630720e+01, +5.533140e+01, +2.038910e+01, +3.988470e+01,
                            -1.751190e+01, +3.262730e+01, +3.001050e+02, +1.198960e+01,
                            +2.827590e+01, +1.060370e+01, -1.168770e+01, +9.489950e+00,
                            +9.245450e+01, -4.235970e+01, +1.052390e+02, +2.529800e+01,
                },
                {
                            -7.169890e+00, +8.835340e+01, -9.313430e+00, -2.305990e-02,
                            +2.757730e+01, +2.184690e+01, -2.075330e+01, -1.626230e+01,
                            +1.542000e+01, -3.926990e+00, +1.204190e+01, +3.977010e+01,
                            -2.637190e+01, -5.429630e+01, +9.634330e+00, +1.398670e+01,
                            +4.671240e+00, +3.629330e+01, +7.184610e+00, +1.181080e+01,
                            +1.320810e+01, +7.214100e+00, +5.641850e+01, +1.065870e+01,
                            +1.608650e+01, +5.090030e+01, +5.090630e+00, -1.776350e+01,
                            +3.717350e+01, +2.775340e+01, -1.707090e+02, +1.385820e+01,
                            +1.219190e+01, +2.534350e+01, +4.984700e+01, +5.921690e+01,
                            -4.527140e+01, +1.091380e+01, +2.520510e+01, -5.488090e+00,
                            +2.083390e+01, -6.194690e+01, +1.964960e+01, +1.230860e+01,
                            +3.139930e+01, +4.658180e+01, -8.936910e+01, -5.259270e+01,
                            +3.881040e+00, +8.700620e+00, +9.262750e+00, +4.117570e+01,
                            +5.325580e+01, +7.361600e+00, +4.077510e+01, -1.527210e+02,
                            -1.182530e+00, -9.116740e+00, -5.547780e+01, -1.670680e+00,
                            +9.224660e+00, -1.407300e+02, -1.560210e+01, +2.294960e+01,
                            -1.242540e+01, +6.903340e+01, +1.881340e+01, +1.124850e+01,
                            -2.936790e+01, +2.778610e+01, +1.337830e+01, -8.786270e+00,
                            +6.209480e+00, +4.539640e+01, -3.281610e+00, +3.592060e+00,
                            -5.112660e+00, +2.608400e+01, +3.626190e+01, +1.198730e+01,
                },
                {
                            +1.191060e+01, +4.175540e+00, -1.375980e+01, +3.944690e+00,
                            +1.570650e+00, -8.875310e+00, +1.020810e+01, -1.003840e+01,
                            +2.716300e+00, -2.047730e+01, +6.768420e-02, +1.239040e+00,
                            +1.071240e+02, +2.481600e+00, +2.888470e-01, +3.453180e-01,
                            -2.079540e+01, +2.390200e+01, -1.618680e+00, -2.958430e+00,
                            +1.909300e+00, -8.849710e+00, +4.297710e+00, -2.530740e+01,
                            -2.884220e+00, +2.419860e+01, -1.116450e+01, -3.363150e+00,
                            -1.818500e+01, -6.774670e+00, -6.717500e-01, -7.414140e+00,
                            -6.115320e+00, +2.257160e+00, +2.035510e+01, +5.023040e+00,
                            -8.217940e+00, -5.949560e+00, +2.418770e+00, -2.077950e+01,
                            +1.632030e+00, -2.782300e+01, -4.116200e+00, +5.950670e+00,
                            +1.088590e+00, -6.521610e+00, -1.249330e+01, +2.267400e+02,
                            -3.037680e+00, -1.410090e+00, -2.807980e+00, -8.370330e+01,
                            -1.007750e+00, +8.285650e+00, +1.357370e+01, -1.716130e+01,
                            -1.369360e+01, -3.973360e+01, -1.260910e+01, -3.286200e+00,
                            +2.614480e+00, +3.541270e+01, -4.132220e+01, +4.297920e-01,
                            +3.785990e+01, +1.161380e+01, +1.300690e+01, -1.508520e+00,
                            +8.014490e+01, +1.775110e+00, +3.227720e+00, +4.034630e+00,
                            -3.851780e-01, +1.406620e+01, +1.599560e+00, -1.410830e+01,
                            -1.706860e+01, -1.490530e+01, +2.440110e+01, +6.084220e+00,
                },
                {
                            +5.817680e+01, +1.205320e+01, +1.837280e+00, -1.360920e+00,
                            -4.345350e+01, -8.546430e+00, +2.358510e+01, -9.620760e+00,
                            +5.974850e-02, +1.399250e+01, -2.634680e+00, -2.529280e+01,
                            +2.639950e+01, +8.969610e+00, -5.692420e+00, -2.632480e+00,
                            +1.935090e+01, +1.052210e+01, +1.893590e+01, -5.689100e+00,
                            -1.428680e+01, +1.758100e+01, -1.973860e+00, -7.405070e+00,
                            -1.828930e+01, -2.166140e+01, +4.146130e+01, +1.072860e+02,
                            +3.027220e+01, +5.377310e+00, -1.306430e+01, -9.447030e+00,
                            -4.647140e+00, -2.745200e+01, +1.769420e+00, +1.209660e+02,
                            -3.895150e+01, -9.766500e-01, -1.863670e+01, -4.043200e+00,
                            -1.516150e+01, +1.033390e+02, -1.590010e-01, +4.194190e+00,
                            +6.559220e+00, +1.788960e+01, +7.557410e+01, -7.990290e+01,
                            +1.909620e+01, +1.416140e+01, -8.163480e+00, -3.224710e+01,
                            +1.592560e+01, +1.827590e+01, -1.075070e+01, +3.891450e+01,
                            +1.112050e+00, +1.025340e+01, +4.849940e+01, +1.020680e+01,
                            -8.759680e+00, +3.959510e+01, -7.961250e+00, -2.531760e+01,
                            +2.723580e+01, +1.363470e+01, +1.477820e+01, +3.312170e+00,
                            +2.685200e+01, -2.099070e+01, +1.122580e+01, +1.326370e+01,
                            +1.506870e+01, -3.994980e+01, +1.352200e+01, +9.183000e+00,
                            +3.743580e+01, +1.550180e+01, +1.185730e+01, +5.720480e+00,
                },
                {
                            -1.861420e+00, -2.332050e+00, +8.524430e-01, -1.489290e+00,
                            -2.580810e+00, +1.271990e+00, +1.094890e+00, -2.110590e+00,
                            -1.306600e+00, -3.313350e+00, -1.760160e+00, -6.839830e-01,
                            -1.876550e+00, -1.027290e+00, -3.223720e+00, -2.895030e+00,
                            -1.107000e+00, -4.668990e-01, -3.146840e+00, -2.595680e+00,
                            -2.759370e+00, -5.641270e+00, -1.484540e+00, +4.935770e-01,
                            -2.857360e+00, -1.506310e+00, -4.187170e+00, +1.261350e+00,
                            -1.195640e+00, -1.899200e-02, -8.475610e-02, +2.082830e+00,
                            -2.198030e-01, -1.452820e-01, -2.494450e+00, +9.194460e-01,
                            -1.597680e+00, -1.810200e+00, -1.969370e+00, +1.369580e-01,
                            -1.742330e+00, -2.057740e+00, -1.343750e+00, -1.651300e+00,
                            -1.647600e+00, +7.408290e-01, -4.529060e-01, +8.326830e-02,
                            -5.397330e-01, +9.430480e-01, -8.827140e-01, -2.589150e+00,
                            -1.105600e-01, -5.328270e-01, -1.527490e+00, -2.760930e+00,
                            -3.535340e+00, -2.224940e+00, -6.468480e-01, +8.509740e-01,
                            -8.550250e-01, -3.346820e-01, -1.082710e+00, -9.437170e-02,
                            -3.061180e+00, -1.411340e+00, -2.108580e+00, -1.915700e+00,
                            +2.195260e-01, -2.729360e+00, -1.499930e+00, -1.682750e+00,
                            -1.216030e-01, -5.094920e-01, -1.834630e+00, -2.209320e+00,
                            -3.145740e+00, -4.534840e-01, +2.437370e-03, -1.378920e-01,
                },
    };
    // Output connection weights from KOH file for run19_C2_080_nn
    private final static double[][] nodes_output_weights_run19 = new double[][]{
                {
                            -5.591530e-01, -5.964970e-01, -7.140640e-01, -2.341320e-01,
                            +1.211690e+00, +1.028610e+00, +1.118210e+00, -1.093810e+00,
                            +6.780590e+01, +8.158930e+01, +6.809960e+01, +5.182650e+01,
                },
                {
                            -6.633480e+00, -1.351020e+00, +2.835810e+00, +3.179640e+00,
                            +2.498490e+00, +4.311870e-01, +8.790610e-01, +1.763900e+00,
                            +4.702760e+01, +5.312610e+01, +4.699000e+01, +4.063510e+01,
                },
                {
                            -5.973070e+00, -2.942750e+00, -2.240020e+00, -2.391440e+00,
                            +4.117140e+00, +1.240620e+01, +7.242450e+00, +1.330020e+01,
                            -1.663390e+01, -1.893160e+01, -1.999880e+01, -2.178440e+01,
                },
                {
                            +2.471020e+00, +4.552020e+00, +4.301070e+00, +7.510210e+00,
                            +1.879040e-01, -3.261060e+01, -2.907590e+01, -4.472930e+01,
                            +1.510940e+01, +6.643000e+00, -4.207310e+00, -1.935010e+01,
                },
                {
                            -8.777960e+00, -4.664960e+00, -6.630630e+00, -9.378350e+00,
                            -9.891580e+00, -6.981820e+00, -8.627390e+00, -1.698030e+00,
                            -2.147700e+01, -2.870480e+01, -2.515290e+01, -1.877400e+01,
                },
                {
                            +1.590040e+01, +5.344380e+01, +9.710300e+01, +1.111710e+02,
                            +1.026910e+02, +5.589440e+01, +5.079850e+01, +3.565250e+01,
                            +6.284640e+00, +1.323420e+01, +1.704650e+01, +2.077100e+01,
                },
                {
                            +6.828980e+00, +7.423660e+00, +5.037060e+00, +2.404220e+00,
                            +3.966470e-01, +2.739870e+00, +1.718250e+00, +1.123580e+00,
                            -1.006730e+01, -1.316200e+01, -1.479310e+01, -1.715140e+01,
                },
                {
                            -1.874230e+02, -1.599700e+02, -1.215110e+02, -8.945420e+01,
                            -2.153350e+01, +3.749500e+01, +4.203790e+01, +4.078580e+01,
                            -3.624630e+01, -3.957950e+01, -3.587560e+01, -3.212530e+01,
                },
                {
                            +1.404110e+01, +1.457800e+01, +7.722370e+00, +8.301380e+00,
                            +6.140050e+00, -1.390120e+01, -1.205190e+01, -2.738900e+01,
                            -1.530230e+01, -1.964220e+01, -2.209710e+01, -2.567260e+01,
                },
                {
                            +5.224100e+01, +3.909080e+01, +3.518560e+01, +3.420210e+01,
                            +3.080960e+01, +2.182130e+01, +2.406300e+01, +1.361880e+01,
                            +1.123270e+01, +1.073690e+01, +1.007000e+01, +6.230960e+00,
                },
                {
                            -1.072900e+00, +1.296050e+00, +4.780860e+00, +3.646680e-01,
                            -4.968740e+00, -4.749030e+00, -9.438700e+00, +1.116980e+01,
                            -2.944100e+01, -3.240070e+01, -2.413510e+01, -1.526320e+01,
                },
                {
                            +3.641420e+01, +3.037330e+01, +2.422840e+01, +1.620350e+01,
                            +9.299840e+00, +3.430680e+00, +2.376740e+00, +6.478600e+00,
                            -3.218870e+01, -3.613690e+01, -3.582210e+01, -3.412150e+01,
                },
                {
                            +4.102990e+01, +3.473610e+01, +3.056090e+01, +2.910370e+01,
                            +2.301510e+01, +1.539040e+01, +1.661260e+01, +8.355470e+00,
                            +1.599650e+02, +1.842160e+02, +1.877500e+02, +1.927040e+02,
                },
                {
                            -6.589070e+01, -4.688070e+01, -1.522840e+01, +4.108490e+00,
                            +2.022210e+01, +8.827390e+00, +2.102280e+00, +3.816260e+00,
                            +7.048440e+01, +8.662850e+01, +8.666420e+01, +8.675320e+01,
                },
                {
                            +6.722910e+00, +7.640250e-01, -1.119570e+01, -1.566430e+01,
                            -2.424900e+01, -4.544830e-01, +5.507350e+00, +1.610640e+01,
                            -5.629010e+00, -5.173680e+00, -5.413620e+00, -1.000620e+01,
                },
                {
                            -1.257500e+01, -1.109610e+01, -5.463520e+00, -4.697570e+00,
                            -5.989590e+00, -7.252510e+00, -7.630280e+00, -6.959710e+00,
                            -5.517420e+00, -1.109210e+01, -1.504550e+01, -2.036360e+01,
                },
                {
                            +7.170460e+01, +6.393250e+01, +4.315820e+01, +2.407000e+01,
                            -1.460970e+01, -3.994410e+01, -3.232430e+01, -3.578140e+01,
                            -5.548370e+01, -5.173060e+01, -3.660010e+01, -1.875720e+01,
                },
                {
                            -8.661990e+00, -6.147310e+00, -9.646920e+00, -6.738850e+00,
                            -4.700250e+00, -2.340050e+01, -2.281220e+01, -5.387220e+01,
                            -3.318460e+00, -1.352780e+00, -1.033850e+00, -2.649530e+00,
                },
                {
                            +7.472000e+01, +7.136750e+01, +4.772250e+01, +3.514790e+01,
                            +5.212990e+01, +9.404980e+01, +9.027020e+01, +8.682520e+01,
                            +1.777340e+01, +2.362290e+01, +2.089370e+01, +2.051950e+01,
                },
                {
                            +7.141510e+00, +4.386870e+00, -1.637900e+00, -4.967550e+00,
                            -1.706500e+01, -1.437610e+01, -1.131900e+01, -1.189140e+01,
                            -1.054510e+01, -1.724640e+01, -1.928060e+01, -2.232910e+01,
                },
                {
                            -1.941190e+01, -1.498400e+01, -1.029010e+01, -9.071820e+00,
                            -4.252710e+00, -3.715860e+00, -5.305260e+00, -5.477510e+00,
                            -1.904080e+01, -8.898840e+00, +2.100140e+00, +1.804930e+01,
                },
                {
                            +2.268980e+02, +1.695900e+02, +9.759380e+01, +5.914300e+01,
                            +3.157330e+01, +5.930880e+00, -1.094310e+00, -8.360090e+00,
                            -8.730130e+00, -2.512360e+00, +4.913350e+00, +1.304510e+01,
                },
                {
                            -2.488500e+01, -2.352400e+01, -1.974690e+01, -2.115690e+01,
                            -2.546580e+01, -2.541090e+01, -2.902950e+01, -2.246740e+01,
                            +1.777130e+01, +1.904160e+01, +1.569340e+01, +1.339100e+01,
                },
                {
                            +8.005810e+00, +9.202830e+00, +8.595730e+00, +1.069300e+01,
                            -4.302510e+00, -2.829600e+01, -2.364330e+01, -3.548950e+01,
                            -3.166770e+01, -2.916580e+01, -2.024080e+01, -8.377620e+00,
                },
                {
                            -1.457610e-01, -2.583240e+00, -5.248440e+00, -9.188700e+00,
                            -8.303200e+00, -1.186750e+00, +9.713580e-01, -3.672430e+00,
                            -2.265040e+01, -2.088050e+01, -1.617720e+01, -9.507970e+00,
                },
                {
                            +2.743380e+00, +1.655750e+00, -2.053650e+00, -3.556410e+00,
                            -5.962650e+00, -1.145400e+01, -1.360870e+01, -1.550440e+01,
                            -1.993740e+01, -2.865400e+01, -3.067540e+01, -3.378290e+01,
                },
                {
                            -7.756950e+00, -6.295690e+00, -3.432600e+00, -3.145060e+00,
                            -3.342920e+00, -7.781430e+00, -1.080840e+01, -7.099300e+00,
                            -4.880280e+01, -5.269220e+01, -4.890430e+01, -4.449530e+01,
                },
                {
                            -2.913740e+01, -2.049900e+01, -1.711630e+01, -1.856670e+01,
                            -1.806050e+01, -1.293170e+01, -1.064940e+01, -1.177710e+01,
                            -1.722750e+02, -1.937060e+02, -1.744170e+02, -1.533240e+02,
                },
                {
                            -8.586090e+01, -7.243300e+01, -5.795970e+01, -4.848350e+01,
                            -4.075720e+01, -3.139260e+01, -2.837570e+01, -3.012880e+01,
                            +4.347300e+00, +3.344530e-01, -5.410580e+00, -1.251730e+01,
                },
                {
                            +3.138650e+00, +3.937840e+00, +5.923140e+00, +7.644850e+00,
                            +1.607300e+01, +3.668600e+01, +3.300070e+01, +4.137130e+01,
                            -1.437630e+01, -1.970600e+01, -2.587350e+01, -3.573810e+01,
                },
                {
                            -2.747140e+01, -1.172500e+01, +4.974500e-02, +1.598680e+00,
                            +3.932290e+00, +5.261130e+00, +7.062220e+00, +5.255410e+00,
                            +1.624980e+02, +1.786500e+02, +1.712960e+02, +1.618060e+02,
                },
                {
                            +7.903040e-01, -3.010940e+00, +6.317250e+00, +1.056300e+01,
                            +8.441010e+00, -1.443070e+01, -2.030420e+01, -1.873950e+01,
                            -4.726150e+01, -3.799330e+01, -2.403340e+01, -1.093970e+01,
                },
                {
                            +7.662330e+00, +5.961080e+00, +5.984510e+00, +6.089150e+00,
                            +3.299220e+00, -6.667160e+00, -6.213650e+00, -7.442800e+00,
                            -1.839240e+01, -1.273460e+01, -9.706250e+00, -6.196090e+00,
                },
                {
                            -1.403710e+00, +1.286620e+01, +1.995380e+01, +1.929400e+01,
                            +1.946520e+01, +1.935820e+01, +1.712960e+01, +1.810210e+01,
                            -2.852960e+01, -2.821810e+01, -2.798670e+01, -2.775110e+01,
                },
                {
                            -2.383210e+01, -2.172440e+01, -2.402700e+01, -2.321270e+01,
                            -1.743130e+01, +1.109200e+01, +1.879990e+01, +3.987040e+01,
                            -7.781980e+00, -1.293490e+00, +1.658710e+00, +6.440890e+00,
                },
                {
                            +3.992560e+01, +2.813080e+01, +2.087060e+01, +2.087790e+01,
                            +1.917040e+01, +1.711320e+01, +1.424030e+01, +1.650650e+01,
                            +2.141270e+02, +2.357640e+02, +2.154800e+02, +1.946570e+02,
                },
                {
                            -2.472620e+01, -4.472520e+01, -5.629230e+01, -5.732940e+01,
                            -5.245730e+01, -4.682040e+01, -4.868120e+01, -5.069430e+01,
                            -8.418440e+00, -8.683200e+00, -1.440780e+01, -2.040570e+01,
                },
                {
                            -1.217400e+00, -8.619120e-01, -2.280760e+00, -1.821130e+00,
                            +1.956710e+00, +1.356960e+01, +1.947220e+01, +5.934130e+00,
                            -1.704390e+01, -8.022350e+00, -5.482840e-01, +1.036660e+01,
                },
                {
                            +2.493520e+00, -8.130880e+00, -1.162770e+01, -9.574230e+00,
                            -3.612310e+00, +1.701810e+01, +1.672470e+01, +2.767680e+01,
                            -2.054630e+01, -2.294560e+01, -1.912210e+01, -1.946680e+01,
                },
                {
                            +2.654830e+01, +2.377940e+01, +1.519650e+01, +1.042910e+01,
                            +7.470310e+00, +1.028510e+01, +7.302780e+00, +3.136150e+00,
                            +6.300140e+01, +6.523170e+01, +5.885400e+01, +5.234920e+01,
                },
                {
                            -1.080170e+01, -1.147530e+01, -1.587830e+01, -1.559480e+01,
                            -1.393380e+01, -7.733240e-01, +9.127270e-01, +7.134230e+00,
                            -1.592830e+01, -1.460080e+01, -1.326820e+01, -1.097930e+01,
                },
                {
                            +4.269720e-01, +3.998980e+00, +5.649490e+00, +5.102870e+00,
                            +5.345290e+00, +7.120210e+00, +6.787360e+00, +5.313870e+00,
                            +8.114840e+01, +9.894230e+01, +8.083860e+01, +6.167850e+01,
                },
                {
                            +2.882470e+00, -2.669890e+00, -1.813260e+00, +2.356380e+00,
                            +1.224160e+01, +1.392080e+01, +1.872970e+01, +3.289800e+00,
                            -1.762900e+01, -1.454600e+01, -9.305850e+00, -3.918350e+00,
                },
                {
                            +7.644100e+00, -4.023740e+00, -1.612630e+01, -1.829140e+01,
                            -1.608760e+01, +9.144570e+00, +1.271960e+01, +2.752980e+01,
                            -5.898400e+00, -5.656550e+00, -9.862110e+00, -1.414500e+01,
                },
                {
                            -3.727270e+01, -4.505600e+01, -4.102830e+01, -4.254590e+01,
                            -3.421890e+01, -1.099650e+01, -1.095270e+01, +4.542970e+00,
                            +1.578400e+01, +1.834200e+01, +1.811630e+01, +1.957890e+01,
                },
                {
                            -5.410440e+01, -4.648060e+01, -3.140440e+01, -2.684820e+01,
                            -2.033700e+01, -3.261490e+01, -3.339100e+01, -3.005900e+01,
                            +9.485760e+00, +5.455650e+00, +2.225290e+00, -2.183240e+00,
                },
                {
                            -1.050670e+00, -4.553400e+00, -6.473140e+00, -4.332340e+00,
                            -3.571740e+00, -6.202790e+00, -5.131880e+00, -8.485230e+00,
                            -5.193740e+01, -6.259690e+01, -6.051820e+01, -5.744500e+01,
                },
                {
                            -1.644770e+01, -1.308010e+01, -8.952010e+00, -7.887160e+00,
                            -6.195270e+00, -3.499230e+00, -3.871360e+00, -5.314910e-01,
                            -9.060200e+01, -9.888260e+01, -9.868280e+01, -9.868490e+01,
                },
                {
                            +4.168410e+00, +6.276840e+00, +8.771690e+00, +1.063680e+01,
                            +9.786690e+00, -9.290550e-01, -1.794250e+00, -5.319270e+00,
                            -2.306040e+01, -2.294620e+01, -1.803120e+01, -1.349370e+01,
                },
                {
                            +1.183420e+00, -2.525380e-01, -4.058800e+00, -2.437680e+00,
                            -1.770980e+00, -4.277490e+00, -2.740470e+00, -7.525540e+00,
                            -2.824850e+01, -2.914620e+01, -1.884490e+01, -6.399940e+00,
                },
                {
                            -4.947120e+01, -4.443750e+01, -2.293520e+01, -7.153220e+00,
                            +8.876420e+00, +1.247550e+01, +1.255090e+01, +4.640010e+00,
                            +6.237710e+00, +1.189040e+01, +1.447330e+01, +1.905380e+01,
                },
                {
                            +2.041080e+01, +1.607820e+01, +1.024790e+01, +6.926140e+00,
                            +4.336340e+00, +3.446260e+00, +3.456450e+00, -1.100670e+00,
                            +6.738590e+01, +7.688770e+01, +7.697840e+01, +7.723170e+01,
                },
                {
                            -3.398920e+01, -2.162550e+01, -1.481410e+01, -1.164420e+01,
                            -1.177600e+01, -2.101540e+01, -2.260750e+01, -3.233090e+01,
                            +9.527190e-01, +2.822280e-01, -2.881760e+00, -4.748500e+00,
                },
                {
                            +3.528740e+00, -1.050460e-01, -1.011600e+01, -1.304640e+01,
                            -1.211100e+01, -1.818790e+00, +3.105130e+00, +1.022150e+00,
                            -1.153440e+01, -1.587720e+01, -1.786980e+01, -2.341880e+01,
                },
                {
                            -2.098350e+01, -1.516720e+01, -1.074530e+01, -1.110600e+01,
                            -9.814730e+00, -8.800280e-01, +1.013480e+00, +2.658120e+00,
                            -1.134180e+01, -1.217050e+01, -9.847520e+00, -7.053460e+00,
                },
                {
                            -3.250790e+01, -2.284670e+01, -1.365930e+01, -1.206950e+01,
                            -1.139300e+01, -9.844630e+00, -1.100490e+01, -6.605450e+00,
                            -9.728860e+01, -1.036340e+02, -9.478730e+01, -8.196430e+01,
                },
                {
                            +7.263540e-01, +3.794980e-01, -5.525460e+00, -8.527880e+00,
                            -1.158120e+01, -6.458400e+00, -3.430560e+00, -6.437500e+00,
                            -1.444610e+01, -1.505000e+01, -1.684710e+01, -1.600470e+01,
                },
                {
                            +1.214770e+01, -1.329070e+01, -5.908200e+01, -7.868300e+01,
                            -1.029090e+02, -6.880460e+01, -5.927410e+01, -4.750630e+01,
                            +5.887380e+00, -1.187280e+00, -7.505680e+00, -1.573520e+01,
                },
                {
                            -7.921710e+00, -4.310390e+00, +3.552770e-01, +4.591090e+00,
                            +6.974070e+00, +5.467670e+00, +6.672390e+00, +2.481770e+00,
                            +6.447150e+01, +7.080470e+01, +6.450730e+01, +5.616120e+01,
                },
                {
                            +1.562760e+02, +1.280850e+02, +7.676410e+01, +4.491440e+01,
                            +1.421420e+00, +9.255710e+00, +9.494540e-01, +3.544750e+01,
                            +1.367650e+01, +1.666750e+01, +1.483450e+01, +1.485400e+01,
                },
                {
                            -5.567100e-01, +4.822450e+00, -4.196560e+00, -3.344820e+00,
                            -4.794810e+00, -2.422730e+01, -2.306610e+01, -6.217680e+01,
                            -9.225280e+00, -1.229720e+01, -1.542480e+01, -2.306580e+01,
                },
                {
                            -8.417040e+01, -5.913210e+01, -2.001710e+01, +2.770190e-01,
                            +1.591770e+01, +6.984190e+00, +5.060080e+00, -1.130680e-01,
                            -2.328710e+02, -2.446620e+02, -2.282950e+02, -2.068280e+02,
                },
                {
                            -5.328590e+01, -1.184790e+01, +5.602540e+01, +9.516140e+01,
                            +1.393590e+02, +1.033610e+02, +8.887900e+01, +7.421080e+01,
                            +5.057340e+01, +6.676960e+01, +7.521150e+01, +8.374790e+01,
                },
                {
                            +1.292450e+01, +8.213370e-01, -6.496930e+00, -5.083140e+00,
                            -6.934490e+00, +1.352350e+00, +3.562980e+00, +4.298860e+00,
                            -2.918680e+01, -2.804720e+01, -2.847240e+01, -2.324070e+01,
                },
                {
                            +4.534140e+01, +3.219480e+01, +1.496470e+01, +8.815850e+00,
                            +3.389160e+00, +4.343430e+00, +1.452580e+00, -8.766540e-01,
                            -4.543720e+01, -5.977730e+01, -5.697640e+01, -5.422240e+01,
                },
                {
                            -3.318660e+01, -3.409460e+01, -3.104020e+01, -2.952450e+01,
                            -2.506780e+01, -2.721060e+01, -2.944690e+01, -2.706920e+01,
                            +5.565010e+00, +3.446560e+00, -1.549620e-01, -4.807800e+00,
                },
                {
                            +6.668280e+00, +5.330130e+00, +1.108710e+01, +9.624220e+00,
                            +8.101740e+00, +1.228620e+01, +1.125190e+01, +1.552730e+01,
                            -2.150310e+01, -3.134070e+01, -3.339210e+01, -3.029190e+01,
                },
                {
                            -2.047090e+01, -1.903690e+01, -1.442160e+01, -1.261780e+01,
                            -1.123100e+01, -1.338480e+01, -1.302540e+01, -9.754070e+00,
                            +9.404340e+00, +6.676750e+00, +7.469040e+00, +6.391490e+00,
                },
                {
                            -1.238540e+01, -5.079270e+00, +4.353090e+00, +8.108710e+00,
                            +9.055730e+00, -3.016140e-01, -1.345500e+00, -1.599220e+00,
                            -7.715400e+01, -7.829140e+01, -7.112640e+01, -6.511690e+01,
                },
                {
                            +1.144680e+01, +1.158230e+01, +1.129370e+01, +1.211480e+01,
                            +1.276880e+01, -3.736540e+00, -7.083830e+00, -7.847960e+00,
                            -2.662690e+01, -2.766290e+01, -2.708530e+01, -2.675570e+01,
                },
                {
                            -1.900190e+01, -2.942390e+01, -3.760870e+01, -4.478720e+01,
                            -5.214080e+01, -5.991190e+01, -6.849090e+01, -5.558090e+01,
                            +3.411790e+01, +3.446610e+01, +2.834940e+01, +2.025210e+01,
                },
                {
                            +5.355870e+00, +1.425890e+01, +2.909040e+01, +3.354660e+01,
                            +3.275950e+01, +4.905710e+00, +2.568880e+00, -1.426710e+01,
                            +4.712500e+00, +6.191150e+00, +2.335470e+00, -7.723870e-01,
                },
                {
                            +2.235710e+00, -1.652450e+00, -7.277330e+00, -6.500200e+00,
                            -4.950270e+00, +6.410480e+00, +9.146120e+00, +8.253390e+00,
                            -1.767340e+01, -2.019160e+01, -1.667820e+01, -1.009900e+01,
                },
                {
                            +5.701830e+00, +5.672170e+00, +2.464800e+00, +8.564750e-01,
                            +3.454270e-01, +1.736650e+00, +5.703390e-01, +1.362750e+00,
                            -2.536400e+01, -2.923510e+01, -2.927040e+01, -2.887820e+01,
                },
                {
                            -1.866510e+00, -1.343380e+01, -2.160100e+01, -1.985280e+01,
                            -2.881830e+01, -3.707730e+01, -3.295910e+01, -3.271180e+01,
                            -5.301160e+00, -7.781880e+00, -1.413810e+01, -2.206740e+01,
                },
                {
                            +1.709720e+01, +9.303390e+00, +1.895630e+00, -1.136420e+00,
                            -1.380230e+00, +1.103780e+01, +1.258390e+01, +1.848450e+01,
                            -2.222960e+01, -2.221550e+01, -1.489240e+01, -9.196100e+00,
                },
                {
                            -1.010220e+01, -1.859910e+01, -2.075960e+01, -2.262400e+01,
                            -2.246860e+01, -2.144200e+01, -2.343610e+01, -1.602130e+01,
                            +4.129450e+01, +4.264910e+01, +3.777740e+01, +3.102890e+01,
                },
                {
                            -5.366300e+01, -5.294360e+01, -4.490560e+01, -4.131430e+01,
                            -4.149470e+01, -4.769890e+01, -4.343880e+01, -4.678690e+01,
                            +6.869340e+00, +3.495710e+00, +1.922960e-01, -3.748190e+00,
                },
                {
                            -2.795130e-01, +1.221450e+00, +2.834090e+00, +3.858930e+00,
                            +5.758010e+00, +6.090420e+00, +6.163540e+00, +4.557530e+00,
                            +1.132490e+02, +1.123260e+02, +1.133240e+02, +1.145590e+02,
                },
                {
                            +2.592380e+00, +3.373670e+00, +1.196860e+00, +1.070280e+00,
                            -4.108570e+00, -2.267040e+00, -3.408460e+00, +6.399110e+00,
                            -1.613040e+01, -2.442910e+01, -2.372190e+01, -2.328520e+01,
                },
                {
                            +2.628640e+01, +4.147200e+01, +6.016550e+01, +6.481190e+01,
                            +7.946550e+01, +4.208870e+01, +3.492450e+01, +2.376220e+01,
                            +2.296110e+01, +2.671970e+01, +1.536780e+01, +1.808110e+00,
                },
    };
    // Intercept and slope for output layer for run19_C2_080_nn
    private final static double[][] nodes_output_scale_run19 = new double[][]{
                {2.165420e-04, 1.360874e-02},
                {2.717660e-04, 1.727647e-02},
                {4.564810e-04, 3.382367e-02},
                {5.404690e-04, 4.228097e-02},
                {6.953720e-04, 6.373242e-02},
                {1.287310e-04, 6.218751e-02},
                {7.138520e-05, 5.158734e-02},
                {3.438400e-05, 4.081816e-02},
                {3.755230e-02, 1.229931e+00},
                {3.500440e-02, 1.078439e+00},
                {3.050430e-02, 1.048487e+00},
                {2.526080e-02, 1.018697e+00}
    };
    // Output offset factors for run19_C2_080_nn
    private final static double[] nodes_output_scale_off_run19 = new double[]{
                5.000000e-02, 5.000000e-02, 5.000000e-02, 5.000000e-02,
                5.000000e-02, 5.000000e-02, 5.000000e-02, 5.000000e-02,
                5.000000e-02, 5.000000e-02, 5.000000e-02, 5.000000e-02,
    };
    // Output scale flags for run19_C2_080_nn
    private final static int[] nodes_output_scale_flag_run19 = new int[]{
                0, 0, 0, 0,
                0, 0, 0, 0,
                0, 0, 0, 0,
    };
    // Output limits (min/max) from training data set for run19_C2_080_nn
    private final static double[][] nodes_output_scale_limits_run19 = new double[][]{
                {+2.170000e-04, +1.250000e-02,},
                {+2.720000e-04, +1.580000e-02,},
                {+4.560000e-04, +3.090000e-02,},
                {+5.400000e-04, +3.860000e-02,},
                {+6.950000e-04, +5.810000e-02,},
                {+1.290000e-04, +5.610000e-02,},
                {+7.140000e-05, +4.650000e-02,},
                {+3.440000e-05, +3.680000e-02,},
                {+3.760000e-02, +1.140000e+00,},
                {+3.500000e-02, +1.010000e+00,},
                {+3.050000e-02, +9.740000e-01,},
                {+2.530000e-02, +9.420000e-01,}
    };

    public static int compute(final float[][] in,
                              final int getNumNodesInput,
                              final float[][] out,
                              final int getNumNodesOutput,
                              final int width,
                              final int[] mask,
                              final int errmask,
                              final float[] a) {
        // (c) M. Schaale, WeW, 2002-2006
        final int rcheck[];
        final int nodes_input = 18;
        final int nodes_output = 12;
        final int nodes_input_bias = 1;
        final int nodes_input_pca = 1;
        final int nodes_hidden = 80;
        final int nodes_hidden_bias = 1;
        final double nodes_hidden_temperature = 1.000000;
        final double t_input = nodes_hidden_temperature / (double) (nodes_input);
        final double t_hidden = nodes_hidden_temperature / (double) (nodes_hidden);
        final double[] vt;
        final double[] vt1;
        //double limexp = -Math.log(Float.MIN_VALUE), dh, dhr, dhe, dhmax=Float.MAX_VALUE, expo;

        // Return dimensions on request
        if (getNumNodesInput <= 0) {
            return (nodes_input);
        }
        if (getNumNodesOutput <= 0) {
            return (nodes_output);
        }

        // Crude compatibility checks
        if (getNumNodesInput != nodes_input) {
            return (-1);
        }
        if (getNumNodesOutput != nodes_output) {
            return (-2);
        }

        vt = new double[nodes_input + nodes_input_bias];
        vt1 = new double[nodes_hidden + nodes_hidden_bias];

        // Range check ??
        rcheck = new int[width];
        for (int x = 0; x < width; x++) {
            rcheck[x] = 0;
            if (a[x] < 0.0f) {
                rcheck[x] = 1;
            }
            a[x] = 1.0f;
        }

        for (int x = 0; x < width; x++) {
            if (mask[x] == 0) {
                // Check input range
                if (rcheck[x] != 0) {
                    for (int i = 0; i < nodes_input && a[x] > 0.0f; i++) {
                        if ((in[i][x] < (float) nodes_input_scale_limits_run19[i][0]) || (in[i][x] > (float) nodes_input_scale_limits_run19[i][1])) {
                            a[x] -= 3.0f;
                        }
                    }
                    if (a[x] < 0.0f) {
                        mask[x] |= errmask;
                    }
                }

                //if(mask[x] == 0) {
                // Apply input transformation
                for (int i = 0; i < nodes_input; i++) {
                    if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -1) {
                        in[i][x] = (float) Math.log((double) in[i][x]);
                    }
                    if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -2) {
                        in[i][x] = (float) Math.exp((double) in[i][x]);
                    }
                }

                // Apply input scale layer parameters
                for (int i = 0; i < nodes_input; i++) {
                    in[i][x] = (float) NN_General.NODES_INPUT_SCALE_OFF[i] + (in[i][x] - (float) nodes_input_scale_run19[i][0]) / (float) nodes_input_scale_run19[i][1];
                }

                // Apply input PCA layer parameters
                if (nodes_input_pca != 0) {
                    for (int i = 0; i < nodes_input; i++) {
                        vt[i] = (double) in[i][x];
                        if (NN_General.NODES_INPUT_SCALE_FLAG[i] == 1) {
                            vt[i] = 0.0;
                            for (int j = 0; j < nodes_input; j++) {
                                if (NN_General.NODES_INPUT_SCALE_FLAG[j] == 1) {
                                    vt[i] += (double) in[j][x] * nodes_input_pca_evec_run19[j][i];
                                }
                            }
                        }
                    }
                    for (int i = 0; i < nodes_input; i++) {
                        in[i][x] = (float) vt[i];
                    }
                }

                // Pump through the first layer
                for (int i = 0; i < nodes_input; i++) {
                    vt[i] = (double) in[i][x];
                }
                for (int i = nodes_input; i < nodes_input + nodes_input_bias; i++) {
                    vt[i] = 1.0;
                }

                for (int i = 0; i < nodes_hidden; i++) {
                    vt1[i] = 0.0;
                    for (int j = 0; j < nodes_input + nodes_input_bias; j++) {
                        vt1[i] += vt[j] * nodes_hidden_weights_run19[j][i];
                    }
                }
                // Pump through sigmoid
                for (int i = 0; i < nodes_hidden; i++) {
                    vt1[i] = 1.0 / (1.0 + Math.exp(-t_input * vt1[i]));
                }

                // Pump through the second layer
                for (int i = nodes_hidden; i < nodes_hidden + nodes_hidden_bias; i++) {
                    vt1[i] = 1.0f;
                }
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = 0.0f;
                    for (int j = 0; j < nodes_hidden + nodes_hidden_bias; j++) {
                        out[i][x] += (float) (vt1[j] * nodes_output_weights_run19[j][i]);
                    }
                }
                // Pump through sigmoid
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = (float) (1.0 / (1.0 + Math.exp(-t_hidden * out[i][x])));
                }

                // Apply output scale layer parameters
                for (int i = 0; i < nodes_output; i++) {
                    out[i][x] = (float) nodes_output_scale_run19[i][0] + (out[i][x] - (float) nodes_output_scale_off_run19[i]) * (float) nodes_output_scale_run19[i][1];
                }

                // Apply output transformation
                for (int i = 0; i < nodes_output; i++) {
                    if (nodes_output_scale_flag_run19[i] == -1) {
                        out[i][x] = (float) Math.log((double) out[i][x]);
                    }
                    if (nodes_output_scale_flag_run19[i] == -2) {
                        out[i][x] = (float) Math.exp((double) out[i][x]);
                    }
                }

                // Check output range
                if (rcheck[x] != 0) {
                    for (int i = 0; i < nodes_output && a[x] >= -2.0f; i++) {
                        if ((out[i][x] < (float) nodes_output_scale_limits_run19[i][0]) || (out[i][x] > (float) nodes_output_scale_limits_run19[i][1])) {
                            a[x] -= 20.0f;
                        }
                    }
                    if (a[x] < 0.0f) {
                        mask[x] |= errmask;
                    }
                }

                //} // mask
            } // mask
        } // x
        return 0;
    }
}
