/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.processor.flh_mci.visat;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.esa.s3tbx.processor.flh_mci.visat.Bundle;
import org.esa.s3tbx.processor.flh_mci.visat.Presets;
import org.esa.snap.core.gpf.ui.DefaultSingleTargetProductDialog;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.ui.AppContext;

public class FlhMciAction
extends AbstractSnapAction {
    private static final String OPERATOR_ALIAS = "FlhMci";
    private static final String HELP_ID = "flhMciScientificTool";
    private static final String LOWER_BASELINE_BAND_NAME = "lowerBaselineBandName";
    private static final String UPPER_BASE_LINE_BAND_NAME = "upperBaselineBandName";
    private static final String SIGNAL_BAND_NAME = "signalBandName";

    public FlhMciAction() {
        this.putValue("ShortDescription", "Generates florescence line height (FLH) / maximum chlorophyll index (MCI) from spectral bands.");
    }

    public void actionPerformed(ActionEvent e) {
        AppContext appContext = this.getAppContext();
        DefaultSingleTargetProductDialog dialog = new DefaultSingleTargetProductDialog(OPERATOR_ALIAS, appContext, Bundle.CTL_FlhMciAction_Text(), HELP_ID);
        BindingContext bindingContext = dialog.getBindingContext();
        final PropertySet propertySet = bindingContext.getPropertySet();
        this.configurePropertySet(propertySet);
        bindingContext.bindEnabledState("slopeBandName", true, "slope", (Object)true);
        bindingContext.addPropertyChangeListener("preset", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Presets preset = (Presets)((Object)evt.getNewValue());
                if (preset != Presets.NONE) {
                    this.setValueIfValid(propertySet, FlhMciAction.LOWER_BASELINE_BAND_NAME, preset.getLowerBaselineBandName());
                    this.setValueIfValid(propertySet, FlhMciAction.UPPER_BASE_LINE_BAND_NAME, preset.getUpperBaselineBandName());
                    this.setValueIfValid(propertySet, FlhMciAction.SIGNAL_BAND_NAME, preset.getSignalBandName());
                    propertySet.setValue("lineHeightBandName", (Object)preset.getLineHeightBandName());
                    propertySet.setValue("slopeBandName", (Object)preset.getSlopeBandName());
                    propertySet.setValue("maskExpression", (Object)preset.getMaskExpression());
                }
            }

            private void setValueIfValid(PropertySet propertySet2, String propertyName, String bandName) {
                if (propertySet2.getDescriptor(propertyName).getValueSet().contains((Object)bandName)) {
                    propertySet2.setValue(propertyName, (Object)bandName);
                }
            }
        });
        dialog.setTargetProductNameSuffix("_flhmci");
        dialog.getJDialog().pack();
        dialog.show();
    }

    private void configurePropertySet(PropertySet propertySet) {
        PropertyContainer presetPropertySet = PropertyContainer.createObjectBacked((Object)new PresetContainer());
        Property[] properties = propertySet.getProperties();
        propertySet.removeProperties(properties);
        propertySet.addProperty(presetPropertySet.getProperty("preset"));
        propertySet.addProperties(properties);
    }

    private static class PresetContainer {
        private Presets preset = Presets.NONE;

        private PresetContainer() {
        }
    }
}

