/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris.internal;

import org.esa.s3tbx.dataio.chris.internal.MaskRefinement;
import org.junit.Assert;
import org.junit.Test;

public class MaskRefinementTest {
    private static final int ROW_COUNT = 2;
    private static final int COL_COUNT = 10;

    @Test
    public void testMaskRefinement() {
        int[] data = new int[20];
        short[] mask = new short[20];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 10; ++j) {
                data[i * 10 + j] = 1;
            }
        }
        MaskRefinement maskRefinement = new MaskRefinement(1.5);
        maskRefinement.refine(data, mask, 10);
        Assert.assertEquals((long)0L, (long)mask[0]);
        Assert.assertEquals((long)0L, (long)mask[1]);
        Assert.assertEquals((long)0L, (long)mask[2]);
        Assert.assertEquals((long)0L, (long)mask[3]);
        Assert.assertEquals((long)0L, (long)mask[4]);
        Assert.assertEquals((long)0L, (long)mask[5]);
        Assert.assertEquals((long)0L, (long)mask[6]);
        Assert.assertEquals((long)0L, (long)mask[7]);
        Assert.assertEquals((long)0L, (long)mask[8]);
        Assert.assertEquals((long)0L, (long)mask[9]);
        Assert.assertEquals((long)0L, (long)mask[10]);
        Assert.assertEquals((long)0L, (long)mask[11]);
        Assert.assertEquals((long)0L, (long)mask[12]);
        Assert.assertEquals((long)0L, (long)mask[13]);
        Assert.assertEquals((long)0L, (long)mask[14]);
        Assert.assertEquals((long)0L, (long)mask[15]);
        Assert.assertEquals((long)0L, (long)mask[16]);
        Assert.assertEquals((long)0L, (long)mask[17]);
        Assert.assertEquals((long)0L, (long)mask[18]);
        Assert.assertEquals((long)0L, (long)mask[19]);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (j % 2 != 0) continue;
                data[i * 10 + j] = 10;
            }
        }
        maskRefinement.refine(data, mask, 10);
        Assert.assertEquals((long)1L, (long)mask[0]);
        Assert.assertEquals((long)0L, (long)mask[1]);
        Assert.assertEquals((long)1L, (long)mask[2]);
        Assert.assertEquals((long)0L, (long)mask[3]);
        Assert.assertEquals((long)1L, (long)mask[4]);
        Assert.assertEquals((long)0L, (long)mask[5]);
        Assert.assertEquals((long)1L, (long)mask[6]);
        Assert.assertEquals((long)0L, (long)mask[7]);
        Assert.assertEquals((long)1L, (long)mask[8]);
        Assert.assertEquals((long)0L, (long)mask[9]);
        Assert.assertEquals((long)1L, (long)mask[10]);
        Assert.assertEquals((long)0L, (long)mask[11]);
        Assert.assertEquals((long)1L, (long)mask[12]);
        Assert.assertEquals((long)0L, (long)mask[13]);
        Assert.assertEquals((long)1L, (long)mask[14]);
        Assert.assertEquals((long)0L, (long)mask[15]);
        Assert.assertEquals((long)1L, (long)mask[16]);
        Assert.assertEquals((long)0L, (long)mask[17]);
        Assert.assertEquals((long)1L, (long)mask[18]);
        Assert.assertEquals((long)0L, (long)mask[19]);
    }

    @Test
    public void testAdjacentDifference() {
        int[] values = new int[]{2, 3, 5, 7, 11, 13, 17, 19};
        double[] diffs = new double[2];
        MaskRefinement.adjacentDifference((int[])values, (int)0, (int)1, (double[])diffs);
        Assert.assertEquals((double)1.0, (double)diffs[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)2, (int)1, (double[])diffs);
        Assert.assertEquals((double)2.0, (double)diffs[0], (double)0.0);
        Assert.assertEquals((double)4.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)0, (int)2, (double[])diffs);
        Assert.assertEquals((double)3.0, (double)diffs[0], (double)0.0);
        Assert.assertEquals((double)6.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)1, (int)2, (double[])diffs);
        Assert.assertEquals((double)4.0, (double)diffs[0], (double)0.0);
        Assert.assertEquals((double)6.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)0, (int)3, (double[])diffs);
        Assert.assertEquals((double)5.0, (double)diffs[0], (double)0.0);
        Assert.assertEquals((double)10.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)1, (int)3, (double[])diffs);
        Assert.assertEquals((double)8.0, (double)diffs[0], (double)0.0);
        Assert.assertEquals((double)8.0, (double)diffs[1], (double)0.0);
    }

    @Test
    public void testMedian() {
        try {
            MaskRefinement.median(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MaskRefinement.median((double[])new double[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((double)1.0, (double)MaskRefinement.median((double[])new double[]{1.0}), (double)0.0);
        Assert.assertEquals((double)2.0, (double)MaskRefinement.median((double[])new double[]{2.0, 1.0, 3.0}), (double)0.0);
        Assert.assertEquals((double)3.0, (double)MaskRefinement.median((double[])new double[]{3.0, 1.0, 4.0, 2.0, 5.0}), (double)0.0);
    }
}

