/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris.internal;

import java.awt.Rectangle;
import org.esa.s3tbx.dataio.chris.Flags;
import org.esa.s3tbx.dataio.chris.internal.DropoutCorrection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DropoutCorrectionTest {
    private int[][] data;
    private short[][] mask;

    @Before
    public void setUp() throws Exception {
        this.data = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}};
        this.mask = new short[3][9];
    }

    @After
    public void tearDown() throws Exception {
        this.data = null;
        this.mask = null;
    }

    @Test
    public void testDropoutCorrection() {
        DropoutCorrection dropoutCorrection = new DropoutCorrection();
        this.data[1][4] = 0;
        this.mask[1][4] = 1;
        Rectangle region = new Rectangle(0, 0, 3, 3);
        dropoutCorrection.compute((int[][])new int[][]{this.data[1], this.data[0], this.data[2]}, (short[][])new short[][]{this.mask[1], this.mask[0], this.mask[2]}, 3, 3, region);
        Assert.assertEquals((long)Flags.DROPOUT.getMask(), (long)this.data[1][4]);
        Assert.assertEquals((long)Flags.DROPOUT_CORRECTED.getMask(), (long)this.mask[1][4]);
        this.data[0][0] = 0;
        this.mask[0][0] = 1;
        dropoutCorrection.compute((int[][])new int[][]{this.data[0], this.data[1]}, (short[][])new short[][]{this.mask[0], this.mask[1]}, 3, 3, region);
        Assert.assertEquals((long)Flags.DROPOUT.getMask(), (long)this.data[0][0]);
        Assert.assertEquals((long)Flags.DROPOUT_CORRECTED.getMask(), (long)this.mask[0][0]);
        this.data[2][8] = 0;
        this.mask[2][8] = 1;
        dropoutCorrection.compute((int[][])new int[][]{this.data[2], this.data[1]}, (short[][])new short[][]{this.mask[2], this.mask[1]}, 3, 3, region);
        Assert.assertEquals((long)Flags.DROPOUT.getMask(), (long)this.data[2][8]);
        Assert.assertEquals((long)Flags.DROPOUT_CORRECTED.getMask(), (long)this.mask[2][8]);
    }
}

