/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris.internal;

import java.util.Arrays;
import org.esa.s3tbx.dataio.chris.internal.Sorter;

public class MaskRefinement {
    private double acceptanceThreshold;
    private double acceptanceThresholdSquareRoot;

    public MaskRefinement(double acceptanceThreshold) {
        this.setAcceptanceThreshold(acceptanceThreshold);
    }

    public final double getAcceptanceThreshold() {
        return this.acceptanceThreshold;
    }

    public final void setAcceptanceThreshold(double threshold) {
        this.acceptanceThreshold = threshold;
        this.acceptanceThresholdSquareRoot = Math.sqrt(threshold);
    }

    public void refine(int[] rciData, short[] maskData, int rasterWidth) {
        double[] hf = new double[rasterWidth - 1];
        double[] lf = new double[rasterWidth / 2 - 1];
        for (int i = 0; i < maskData.length; i += rasterWidth) {
            MaskRefinement.adjacentDifference(rciData, i, hf);
            MaskRefinement.adjacentDifferenceEven(rciData, i, lf);
            if (!(MaskRefinement.median(hf) > MaskRefinement.median(lf) * this.acceptanceThresholdSquareRoot)) continue;
            for (int j = 0; j < rasterWidth; j += 2) {
                maskData[i + j] = 1;
            }
        }
    }

    private static void adjacentDifference(int[] values, int offset, double[] diffs) {
        MaskRefinement.adjacentDifference(values, offset, 1, diffs);
    }

    private static void adjacentDifferenceEven(int[] values, int offset, double[] diffs) {
        MaskRefinement.adjacentDifference(values, offset + 1, 2, diffs);
    }

    static void adjacentDifference(int[] values, int offset, int stride, double[] diffs) {
        int i = offset;
        for (int j = 0; j < diffs.length; ++j) {
            diffs[j] = Math.abs(values[i + stride] - values[i]);
            i += stride;
        }
    }

    static double median(double[] values) {
        if (values == null) {
            throw new NullPointerException("values == null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        return Sorter.nthElement(Arrays.copyOf(values, values.length), values.length >> 1);
    }
}

