/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris;

import java.io.File;
import java.util.Locale;
import org.esa.s3tbx.dataio.chris.ChrisProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public class ChrisProductReaderPlugIn
implements ProductReaderPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecodeQualification getDecodeQualification(Object input) {
        block23: {
            File file;
            if (input instanceof String) {
                file = new File((String)input);
            } else if (input instanceof File) {
                file = (File)input;
            } else {
                return DecodeQualification.UNABLE;
            }
            if (file.isFile() && file.getPath().toLowerCase().endsWith("hdf")) {
                DecodeQualification decodeQualification;
                NetcdfFile ncFile = null;
                try {
                    ncFile = NetcdfFileOpener.open((Object)file.getAbsolutePath());
                    if (ncFile == null) {
                        DecodeQualification decodeQualification2 = DecodeQualification.UNABLE;
                        return decodeQualification2;
                    }
                    if (!ChrisProductReaderPlugIn.isSensorTypeAttributeCorrect(ncFile)) break block23;
                    decodeQualification = DecodeQualification.INTENDED;
                }
                catch (Throwable throwable) {
                    break block23;
                }
                finally {
                    if (ncFile != null) {
                        try {
                            ncFile.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                return decodeQualification;
            }
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    public ProductReader createReaderInstance() {
        return new ChrisProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        String[] formatNames = this.getFormatNames();
        String formatName = "";
        if (formatNames.length > 0) {
            formatName = formatNames[0];
        }
        return new SnapFileFilter(formatName, this.getDefaultFileExtensions(), this.getDescription(null));
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{"hdf"};
    }

    public String getDescription(Locale locale) {
        return "CHRIS/Proba HDF4 Data Products";
    }

    public String[] getFormatNames() {
        return new String[]{"CHRIS/Proba"};
    }

    private static boolean isSensorTypeAttributeCorrect(NetcdfFile ncFile) throws Exception {
        Attribute attribute = ncFile.findGlobalAttributeIgnoreCase("Sensor_Type");
        return attribute != null && attribute.getDataType() == DataType.STRING && attribute.getStringValue().equalsIgnoreCase("CHRIS");
    }

    private static void registerRGBProfiles() {
        RGBImageProfileManager profileManager = RGBImageProfileManager.getInstance();
        profileManager.addProfile(new RGBImageProfile("CHRIS/Proba - Mode 0", new String[]{"radiance_3", "radiance_2", "radiance_1"}));
        profileManager.addProfile(new RGBImageProfile("CHRIS/Proba - Mode 1", new String[]{"radiance_23", "radiance_13", "radiance_2"}));
        profileManager.addProfile(new RGBImageProfile("CHRIS/Proba - Mode 2", new String[]{"radiance_10", "radiance_6", "radiance_2"}));
        profileManager.addProfile(new RGBImageProfile("CHRIS/Proba - Mode 3", new String[]{"radiance_7", "radiance_4", "radiance_1"}));
        profileManager.addProfile(new RGBImageProfile("CHRIS/Proba - Mode 3A", new String[]{"radiance_8", "radiance_5", "radiance_2"}));
        profileManager.addProfile(new RGBImageProfile("CHRIS/Proba - Mode 4", new String[]{"radiance_4", "radiance_2", "radiance_1"}));
        profileManager.addProfile(new RGBImageProfile("CHRIS/Proba - Mode 5", new String[]{"radiance_7", "radiance_4", "radiance_1"}));
    }

    static {
        ChrisProductReaderPlugIn.registerRGBProfiles();
    }
}

