/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.esa.s3tbx.dataio.chris.ChrisFile;
import org.esa.s3tbx.dataio.chris.ChrisProductReaderPlugIn;
import org.esa.s3tbx.dataio.chris.Flags;
import org.esa.s3tbx.dataio.chris.internal.DropoutCorrection;
import org.esa.s3tbx.dataio.chris.internal.MaskRefinement;
import org.esa.s3tbx.dataio.chris.internal.SunPositionCalculator;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.util.io.FileUtils;

public class ChrisProductReader
extends AbstractProductReader {
    private static final int NEIGHBORING_BAND_COUNT = 1;
    private ChrisFile chrisFile;
    private int sceneRasterWidth;
    private int sceneRasterHeight;
    private int spectralBandCount;
    private Band[] rciBands;
    private Band[] maskBands;
    private MaskRefinement maskRefinement;
    private DropoutCorrection dropoutCorrection;

    ChrisProductReader(ChrisProductReaderPlugIn productReaderPlugIn) {
        super((ProductReaderPlugIn)productReaderPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        File inputFile = this.getInputFile();
        this.chrisFile = new ChrisFile(inputFile);
        this.chrisFile.open();
        this.sceneRasterWidth = this.chrisFile.getSceneRasterWidth();
        this.sceneRasterHeight = this.chrisFile.getSceneRasterHeight();
        this.spectralBandCount = this.chrisFile.getSpectralBandCount();
        this.rciBands = new Band[this.spectralBandCount];
        this.maskBands = new Band[this.spectralBandCount];
        this.maskRefinement = new MaskRefinement(1.5);
        this.dropoutCorrection = new DropoutCorrection(DropoutCorrection.Type.N4, true);
        return this.createProduct(inputFile);
    }

    protected synchronized void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band targetBand, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProductData targetBuffer, ProgressMonitor pm) throws IOException {
        Assert.state((sourceOffsetX == targetOffsetX ? 1 : 0) != 0, (String)"sourceOffsetX != targetOffsetX");
        Assert.state((sourceOffsetY == targetOffsetY ? 1 : 0) != 0, (String)"sourceOffsetY != targetOffsetY");
        Assert.state((sourceStepX == 1 ? 1 : 0) != 0, (String)"sourceStepX != 1");
        Assert.state((sourceStepY == 1 ? 1 : 0) != 0, (String)"sourceStepY != 1");
        Assert.state((sourceWidth == targetWidth ? 1 : 0) != 0, (String)"sourceWidth != targetWidth");
        Assert.state((sourceHeight == targetHeight ? 1 : 0) != 0, (String)"sourceHeight != targetHeight");
        int index = targetBand.getSpectralBandIndex();
        if (targetBand.equals(this.rciBands[index])) {
            this.readRciBandRasterData(index, targetBuffer, sourceOffsetX, sourceOffsetY, targetWidth, targetHeight, pm);
        } else {
            this.readMaskBandRasterData(index, targetBuffer, sourceOffsetX, sourceOffsetY, targetWidth, targetHeight, pm);
        }
    }

    public void close() throws IOException {
        this.rciBands = null;
        this.maskBands = null;
        this.chrisFile.close();
        super.close();
    }

    private Product createProduct(File inputFile) {
        String name = FileUtils.getFilenameWithoutExtension((File)inputFile);
        String type = "CHRIS_M" + this.chrisFile.getGlobalAttribute("CHRIS_Mode", 0);
        Product product = new Product(name, type, this.sceneRasterWidth, this.sceneRasterHeight, (ProductReader)this);
        product.setFileLocation(this.chrisFile.getFile());
        this.setStartAndEndTimes(product);
        this.addMetadataElements(product);
        this.addRciAndMaskBands(product);
        this.addFlagCodingsAndMasks(product);
        product.setPreferredTileSize(this.sceneRasterWidth, this.sceneRasterHeight);
        return product;
    }

    private File getInputFile() {
        Object input = this.getInput();
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unsupported input: {0}", input));
    }

    private void setStartAndEndTimes(Product product) {
        String dateStr = this.chrisFile.getGlobalAttribute("Image_Date", "2000-01-01");
        String timeStr = this.chrisFile.getGlobalAttribute("Calculated_Image_Centre_Time", "00:00:00");
        try {
            DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");
            Date date = dateFormat.parse(dateStr + " " + timeStr);
            ProductData.UTC utc = ProductData.UTC.create((Date)date, (long)0L);
            product.setStartTime(utc);
            product.setEndTime(utc);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void addMetadataElements(Product product) {
        MetadataElement mph = new MetadataElement("MPH");
        for (String name : this.chrisFile.getGlobalAttributeNames()) {
            if ("Key_to_Mask".equals(name)) continue;
            String globalAttribute = this.chrisFile.getGlobalAttribute(name);
            mph.addAttribute(new MetadataAttribute(name, ProductData.createInstance((String)globalAttribute), true));
            if (!"Solar_Zenith_Angle".equals(name)) continue;
            this.addSolarAzimuthAngleIfPossible(product, mph);
        }
        mph.addAttribute(new MetadataAttribute("Noise Reduction", ProductData.createInstance((String)"None"), true));
        MetadataElement bandInfo = this.createBandInfo();
        product.getMetadataRoot().addElement(mph);
        product.getMetadataRoot().addElement(bandInfo);
    }

    private MetadataElement createBandInfo() {
        MetadataElement bandInfo = new MetadataElement("Band_Information");
        for (int i = 0; i < this.chrisFile.getSpectralBandCount(); ++i) {
            String name = MessageFormat.format("radiance_{0}", i + 1);
            MetadataElement element = new MetadataElement(name);
            MetadataAttribute attribute = new MetadataAttribute("Cut-on Wavelength", 30);
            attribute.getData().setElemFloat(this.chrisFile.getCutOnWavelength(i));
            attribute.setDescription("Cut-on wavelength");
            attribute.setUnit("nm");
            element.addAttribute(attribute);
            attribute = new MetadataAttribute("Cut-off Wavelength", 30);
            attribute.getData().setElemFloat(this.chrisFile.getCutOffWavelength(i));
            attribute.setDescription("Cut-off wavelength");
            attribute.setUnit("nm");
            element.addAttribute(attribute);
            attribute = new MetadataAttribute("Central Wavelength", 30);
            attribute.getData().setElemFloat(this.chrisFile.getWavelength(i));
            attribute.setDescription("Central wavelength");
            attribute.setUnit("nm");
            element.addAttribute(attribute);
            attribute = new MetadataAttribute("Bandwidth", 30);
            attribute.getData().setElemFloat(this.chrisFile.getBandwidth(i));
            attribute.setDescription("Cut-off minus cut-on wavelength");
            attribute.setUnit("nm");
            element.addAttribute(attribute);
            attribute = new MetadataAttribute("Gain Setting", 12);
            attribute.getData().setElemInt(this.chrisFile.getGainSetting(i));
            attribute.setDescription("CHRIS analogue electronics gain setting");
            element.addAttribute(attribute);
            attribute = new MetadataAttribute("Gain Value", 30);
            attribute.getData().setElemFloat(this.chrisFile.getGainValue(i));
            attribute.setDescription("Relative analogue gain");
            element.addAttribute(attribute);
            attribute = new MetadataAttribute("Low Row", 12);
            attribute.getData().setElemInt(this.chrisFile.getLowRow(i));
            attribute.setDescription("CCD row number for the cut-on wavelength");
            element.addAttribute(attribute);
            attribute = new MetadataAttribute("High Row", 12);
            attribute.getData().setElemInt(this.chrisFile.getHighRow(i));
            attribute.setDescription("CCD row number for the cut-off wavelength");
            element.addAttribute(attribute);
            bandInfo.addElement(element);
        }
        return bandInfo;
    }

    private void addSolarAzimuthAngleIfPossible(Product product, MetadataElement element) {
        try {
            Calendar calendar = product.getStartTime().getAsCalendar();
            double lat = Double.parseDouble(this.chrisFile.getGlobalAttribute("Target_Latitude"));
            double lon = Double.parseDouble(this.chrisFile.getGlobalAttribute("Target_Longitude"));
            double saa = SunPositionCalculator.calculate(calendar, lat, lon).getAzimuthAngle();
            ProductData data = ProductData.createInstance((String)String.format("%05.2f", saa));
            element.addAttribute(new MetadataAttribute("Solar_Azimuth_Angle", data, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addRciAndMaskBands(Product product) {
        Band band;
        String name;
        int i;
        String units = this.chrisFile.getGlobalAttribute("Calibration_Data_Units");
        for (i = 0; i < this.spectralBandCount; ++i) {
            name = MessageFormat.format("radiance_{0}", i + 1);
            band = product.addBand(name, 12);
            band.setSpectralBandIndex(i);
            band.setSpectralWavelength(this.chrisFile.getWavelength(i));
            band.setSpectralBandwidth(this.chrisFile.getBandwidth(i));
            band.setUnit(units);
            band.setDescription(MessageFormat.format("Radiance for spectral band {0}", i + 1));
            band.setValidPixelExpression(MessageFormat.format("mask_{0} != {1}", i + 1, Flags.DROPOUT.getMask()));
            this.rciBands[i] = band;
        }
        for (i = 0; i < this.spectralBandCount; ++i) {
            name = MessageFormat.format("mask_{0}", i + 1);
            band = product.addBand(name, 11);
            band.setSpectralBandIndex(i);
            band.setSpectralWavelength(this.chrisFile.getWavelength(i));
            band.setSpectralBandwidth(this.chrisFile.getBandwidth(i));
            band.setDescription(MessageFormat.format("Quality mask for spectral band {0}", i + 1));
            this.maskBands[i] = band;
        }
        product.setAutoGrouping("radiance:mask");
    }

    private void addFlagCodingsAndMasks(Product product) {
        FlagCoding flagCoding = new FlagCoding("CHRIS");
        for (Flags flags : Flags.values()) {
            flagCoding.addFlag(flags.toString(), flags.getMask(), flags.getDescription());
        }
        product.getFlagCodingGroup().add((ProductNode)flagCoding);
        for (Flags flags : this.maskBands) {
            flags.setSampleCoding((SampleCoding)flagCoding);
        }
        this.addSpectrumMask(product, Flags.DROPOUT, "spectrum_dropout", "Spectrum contains a dropout pixel");
        this.addSpectrumMask(product, Flags.SATURATED, "spectrum_saturated", "Spectrum contains a saturated pixel");
        this.addSpectrumMask(product, Flags.DROPOUT_CORRECTED, "spectrum_dropout_corrected", "Spectrum contains a corrected dropout pixel");
        for (int i = 0; i < this.spectralBandCount; ++i) {
            for (Flags flag : Flags.values()) {
                String name = this.rciBands[i].getName() + "_" + (Object)((Object)flag);
                String expr = this.maskBands[i].getName() + "." + (Object)((Object)flag);
                product.addMask(name, expr, flag.getDescription(), flag.getColor(), (double)flag.getTransparency());
            }
        }
    }

    private void addSpectrumMask(Product product, Flags flag, String name, String description) {
        StringBuilder expression = new StringBuilder();
        for (int i = 0; i < this.spectralBandCount; ++i) {
            if (i > 0) {
                expression.append(" || ");
            }
            expression.append(this.maskBands[i].getName()).append(".").append((Object)flag);
        }
        product.addMask(name, expression.toString(), description, flag.getColor(), (double)flag.getTransparency());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRciBandRasterData(int bandIndex, ProductData targetBuffer, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProgressMonitor pm) throws IOException {
        int minBandIndex = Math.max(bandIndex - 1, 0);
        int maxBandIndex = Math.min(bandIndex + 1, this.spectralBandCount - 1);
        int bandCount = maxBandIndex - minBandIndex + 1;
        int tileOffsetY = targetOffsetY;
        int tileHeight = targetHeight;
        if (tileOffsetY > 0) {
            --tileOffsetY;
            ++tileHeight;
        }
        if (tileOffsetY + tileHeight < this.sceneRasterHeight) {
            ++tileHeight;
        }
        try {
            int i;
            pm.beginTask(MessageFormat.format("Preparing radiance band {0}...", bandIndex + 1), bandCount + 4);
            int[][] rciData = new int[bandCount][this.sceneRasterWidth * tileHeight];
            short[][] maskData = new short[bandCount][this.sceneRasterWidth * tileHeight];
            int j = 1;
            for (i = minBandIndex; i <= maxBandIndex; ++i) {
                if (i != bandIndex) {
                    this.readFullWidthTile(i, rciData[j], maskData[j], tileOffsetY, tileHeight);
                    ++j;
                } else {
                    this.readFullWidthTile(i, rciData[0], maskData[0], tileOffsetY, tileHeight);
                }
                pm.worked(1);
            }
            this.dropoutCorrection.compute(rciData, maskData, this.sceneRasterWidth, tileHeight, new Rectangle(targetOffsetX, targetOffsetY - tileOffsetY, targetWidth, targetHeight));
            pm.worked(3);
            for (i = 0; i < targetHeight; ++i) {
                System.arraycopy(rciData[0], targetOffsetX + (targetOffsetY - tileOffsetY + i) * this.sceneRasterWidth, targetBuffer.getElems(), i * targetWidth, targetWidth);
            }
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMaskBandRasterData(int bandIndex, ProductData targetBuffer, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProgressMonitor pm) throws IOException {
        try {
            pm.beginTask(MessageFormat.format("Preparing mask band {0}...", bandIndex + 1), targetHeight);
            int[] rciData = new int[this.sceneRasterWidth * targetHeight];
            short[] maskData = new short[this.sceneRasterWidth * targetHeight];
            this.readFullWidthTile(bandIndex, rciData, maskData, targetOffsetY, targetHeight);
            for (int i = 0; i < targetHeight; ++i) {
                System.arraycopy(maskData, targetOffsetX + i * this.sceneRasterWidth, targetBuffer.getElems(), i * targetWidth, targetWidth);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private void readFullWidthTile(int bandIndex, int[] rciData, short[] maskData, int tileOffsetY, int tileHeight) throws IOException {
        Band rciBand = this.rciBands[bandIndex];
        Band maskBand = this.maskBands[bandIndex];
        if (maskBand.hasRasterData()) {
            System.arraycopy(maskBand.getRasterData().getElems(), tileOffsetY * this.sceneRasterWidth, maskData, 0, maskData.length);
            if (rciBand.hasRasterData()) {
                System.arraycopy(rciBand.getRasterData().getElems(), tileOffsetY * this.sceneRasterWidth, rciData, 0, rciData.length);
            } else {
                this.chrisFile.readRciData(bandIndex, 0, tileOffsetY, 1, 1, this.sceneRasterWidth, tileHeight, rciData);
            }
        } else {
            this.chrisFile.readRciData(bandIndex, 0, tileOffsetY, 1, 1, this.sceneRasterWidth, tileHeight, rciData);
            if (this.chrisFile.hasMask()) {
                this.chrisFile.readMaskData(bandIndex, 0, tileOffsetY, 1, 1, this.sceneRasterWidth, tileHeight, maskData);
            }
            this.maskRefinement.refine(rciData, maskData, this.sceneRasterWidth);
        }
    }
}

