/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa.pod;

import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.util.RandomAccessFileIOHandler;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.esa.s3tbx.dataio.avhrr.BandReader;
import org.esa.s3tbx.dataio.avhrr.noaa.pod.PodAvhrrFile;
import org.esa.s3tbx.dataio.avhrr.noaa.pod.PodAvhrrReaderPlugIn;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;

final class PodAvhrrReader
extends AbstractProductReader {
    private PodAvhrrFile avhrrFile;
    private RandomAccessFile raf;

    PodAvhrrReader(PodAvhrrReaderPlugIn plugIn) {
        super((ProductReaderPlugIn)plugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        Product product;
        Object input = this.getInput();
        File file = PodAvhrrReaderPlugIn.getInputFile(input);
        RandomAccessFileIOHandler ioHandler = null;
        String productName = "unkown";
        if (file != null && file.exists()) {
            productName = file.getName();
            this.raf = new RandomAccessFile(file, "r");
            ioHandler = new RandomAccessFileIOHandler(this.raf);
        }
        if (ioHandler == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.avhrrFile = new PodAvhrrFile((IOHandler)ioHandler, productName);
            product = this.avhrrFile.createProduct();
            if (file != null) {
                product.setFileLocation(file);
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        return product;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band targetBand, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProductData targetBuffer, ProgressMonitor pm) throws IOException {
        BandReader bandReader = this.avhrrFile.getBandReader(targetBand);
        if (bandReader == null) {
            throw new IllegalStateException("No band reader available.");
        }
        bandReader.readBandRasterData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, targetBuffer, pm);
    }

    public void close() throws IOException {
        super.close();
        if (this.avhrrFile != null) {
            this.avhrrFile.dispose();
        }
        if (this.raf != null) {
            this.raf.close();
        }
    }
}

