/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import java.util.Map;
import org.esa.s3tbx.dataio.avhrr.HeaderUtil;
import org.esa.s3tbx.dataio.avhrr.noaa.FormatMetadata;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;

public class HeaderWrapper {
    private final CompoundData compoundData;

    public HeaderWrapper(CompoundData compoundData) {
        this.compoundData = compoundData;
    }

    public MetadataElement getAsMetadataElement() throws IOException {
        return HeaderWrapper.getAsMetadataElement(this.compoundData);
    }

    public static MetadataElement getAsMetadataElement(CompoundData compoundData) throws IOException {
        CompoundType type = compoundData.getType();
        int memberCount = type.getMemberCount();
        MetadataElement metadataElement = new MetadataElement(type.getName());
        for (int i = 0; i < memberCount; ++i) {
            MetadataAttribute attribute;
            ProductData data;
            String typeName = type.getMemberName(i);
            CompoundMember member = type.getMember(i);
            FormatMetadata formatMetadata = (FormatMetadata)member.getMetadata();
            if (typeName.equals("fill")) continue;
            if (formatMetadata != null && formatMetadata.getType().equals("string")) {
                String stringValue = HeaderWrapper.getAsString(compoundData.getSequence(i));
                Map<Object, String> map = HeaderWrapper.getMetaData(member).getItemMap();
                if (map != null) {
                    stringValue = map.get(stringValue);
                }
                data = ProductData.createInstance((String)stringValue);
                attribute = new MetadataAttribute(typeName, data, true);
                attribute.setDescription(HeaderWrapper.getDescription(member));
                attribute.setUnit(HeaderWrapper.getUnits(member));
                metadataElement.addAttribute(attribute);
                continue;
            }
            if (member.getType().getName().equals("DATE")) {
                CompoundData dateCompound = compoundData.getCompound(i);
                ProductData.UTC data2 = HeaderWrapper.createDate(dateCompound);
                MetadataAttribute attribute2 = new MetadataAttribute(typeName, (ProductData)data2, true);
                attribute2.setDescription(HeaderWrapper.getDescription(member));
                attribute2.setUnit(HeaderWrapper.getUnits(member));
                metadataElement.addAttribute(attribute2);
                continue;
            }
            if (member.getType().isSequenceType()) {
                SequenceData sequence = compoundData.getSequence(i);
                if (!sequence.getType().getElementType().isCompoundType()) continue;
                for (int j = 0; j < sequence.getType().getElementCount(); ++j) {
                    CompoundData compound = sequence.getCompound(j);
                    metadataElement.addElement(HeaderWrapper.getAsMetadataElement(compound));
                }
                continue;
            }
            if (member.getType().isCompoundType()) {
                metadataElement.addElement(HeaderWrapper.getAsMetadataElement(compoundData.getCompound(i)));
                continue;
            }
            if (member.getType().isSimpleType()) {
                int intValue = compoundData.getInt(i);
                Map<Object, String> map = HeaderWrapper.getMetaData(member).getItemMap();
                if (map != null) {
                    String stringValue = map.get(intValue);
                    data = ProductData.createInstance((String)stringValue);
                } else {
                    double scalingFactor = HeaderWrapper.getMetaData(member).getScalingFactor();
                    data = scalingFactor == 1.0 ? ProductData.createInstance((int[])new int[]{intValue}) : ProductData.createInstance((double[])new double[]{(double)intValue * scalingFactor});
                }
                attribute = new MetadataAttribute(typeName, data, true);
                attribute.setDescription(HeaderWrapper.getDescription(member));
                attribute.setUnit(HeaderWrapper.getUnits(member));
                metadataElement.addAttribute(attribute);
                continue;
            }
            System.out.println("not handled: name=" + typeName);
            System.out.println("member = " + member.getType());
        }
        return metadataElement;
    }

    static ProductData.UTC createDate(CompoundData dateCompound) throws IOException {
        int year = dateCompound.getInt("year");
        int dayOfYear = dateCompound.getInt("dayOfYear");
        int millisInDay = dateCompound.getInt("UTCmillis");
        return HeaderUtil.createUTCDate(year, dayOfYear, millisInDay);
    }

    static String getAsString(SequenceData valueSequence) throws IOException {
        byte[] data = new byte[valueSequence.getElementCount()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = valueSequence.getByte(i);
        }
        return new String(data).trim();
    }

    static double getValue(CompoundData compoundData, String name) throws IOException {
        CompoundType type = compoundData.getType();
        int memberIndex = type.getMemberIndex(name);
        double v = compoundData.getDouble(memberIndex);
        double scalingFactor = HeaderWrapper.getScalingFactor(type.getMember(memberIndex));
        return v * scalingFactor;
    }

    private static double getScalingFactor(CompoundMember member) {
        FormatMetadata metaData = HeaderWrapper.getMetaData(member);
        return metaData.getScalingFactor();
    }

    private static String getDescription(CompoundMember member) {
        FormatMetadata metaData = HeaderWrapper.getMetaData(member);
        return metaData.getDescription();
    }

    private static String getUnits(CompoundMember member) {
        FormatMetadata metaData = HeaderWrapper.getMetaData(member);
        return metaData.getUnits();
    }

    private static FormatMetadata getMetaData(CompoundMember member) {
        Object object = member.getMetadata();
        if (object != null && object instanceof FormatMetadata) {
            return (FormatMetadata)object;
        }
        return new FormatMetadata();
    }
}

