/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.metop;

import java.io.File;
import java.util.Locale;
import org.esa.s3tbx.dataio.avhrr.metop.MetopReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;

public class MetopReaderPlugIn
implements ProductReaderPlugIn {
    public static final String FORMAT_NAME = "METOP_AVHRR_3_L1B";
    private static final String[] FILE_EXTENSIONS = new String[]{""};
    private static final String DESCRIPTION = "METOP-AVHRR/3 Level-1b Data Product";
    private static final Class[] INPUT_TYPES = new Class[]{String.class, File.class};

    public static File getInputFile(Object input) {
        File file = null;
        if (input instanceof String) {
            file = new File((String)input);
        } else if (input instanceof File) {
            file = (File)input;
        }
        return file;
    }

    public DecodeQualification getDecodeQualification(Object input) {
        File file = MetopReaderPlugIn.getInputFile(input);
        if (file != null && MetopReader.canOpenFile(file)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new MetopReader(this);
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

