/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.calibration;

import org.esa.s3tbx.dataio.avhrr.AvhrrConstants;
import org.esa.s3tbx.dataio.avhrr.AvhrrReader;
import org.esa.s3tbx.dataio.avhrr.calibration.AbstractCalibrator;
import org.esa.snap.core.util.Guardian;

public class ReflectanceFactorCalibrator
extends AbstractCalibrator {
    private static final int[] OPERATIONAL_DATA_OFFSET = new int[]{0, 15, 30};
    private int operationalDataIndex;
    private double slope1;
    private double intercept1;
    private double slope2;
    private double intercept2;
    private int intersection;
    private boolean dataRequired;

    public ReflectanceFactorCalibrator(int channel) {
        super(channel);
        Guardian.assertWithinRange((String)"channel", (long)channel, (long)0L, (long)2L);
        this.operationalDataIndex = channel;
        this.dataRequired = true;
    }

    @Override
    public String getBandName() {
        return "reflec_" + AvhrrConstants.CH_STRINGS[this.channel];
    }

    @Override
    public String getBandUnit() {
        return "%";
    }

    @Override
    public String getBandDescription() {
        return AvhrrReader.format("Reflectance factor for channel {0}", AvhrrConstants.CH_STRINGS[this.channel]);
    }

    @Override
    public boolean requiresCalibrationData() {
        return this.dataRequired;
    }

    @Override
    public boolean processCalibrationData(int[] calibrationData) {
        boolean valid;
        int offset = OPERATIONAL_DATA_OFFSET[this.operationalDataIndex];
        boolean bl = valid = calibrationData[offset + 0] != 0 && calibrationData[offset + 1] != 0 && calibrationData[offset + 2] != 0 && calibrationData[offset + 3] != 0 && calibrationData[offset + 4] != 0;
        if (valid) {
            this.slope1 = (double)calibrationData[offset + 0] * 1.0E-7;
            this.intercept1 = (double)calibrationData[offset + 1] * 1.0E-6;
            this.slope2 = (double)calibrationData[offset + 2] * 1.0E-7;
            this.intercept2 = (double)calibrationData[offset + 3] * 1.0E-6;
            this.intersection = calibrationData[offset + 4];
            this.dataRequired = false;
        }
        return valid;
    }

    @Override
    public float calibrate(int counts) {
        double reflectanceFactor = counts <= this.intersection ? (double)counts * this.slope1 + this.intercept1 : (double)counts * this.slope2 + this.intercept2;
        return (float)reflectanceFactor;
    }
}

