/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr;

import java.io.File;
import java.util.Locale;
import org.esa.s3tbx.dataio.avhrr.AvhrrReader;
import org.esa.s3tbx.dataio.avhrr.noaa.KlmAvhrrFile;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.util.io.SnapFileFilter;

public class AvhrrReaderPlugIn
implements ProductReaderPlugIn {
    public static final String FORMAT_NAME = "NOAA_AVHRR_3_L1B";
    private static final String[] FILE_EXTENSIONS = new String[]{""};
    private static final String DESCRIPTION = "NOAA-AVHRR/3 Level-1b Data Product";
    private static final Class[] INPUT_TYPES = new Class[]{String.class, File.class};

    public DecodeQualification getDecodeQualification(Object input) {
        File file = AvhrrReaderPlugIn.getInputFile(input);
        if (file != null && KlmAvhrrFile.canDecode(file)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public static File getInputFile(Object input) {
        File file = null;
        if (input instanceof String) {
            file = new File((String)input);
        } else if (input instanceof File) {
            file = (File)input;
        }
        return file;
    }

    public Class[] getInputTypes() {
        return INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new AvhrrReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }

    private static void registerRGBProfiles() {
        RGBImageProfileManager profileManager = RGBImageProfileManager.getInstance();
        profileManager.addProfile(new RGBImageProfile("AVHRR/3 L1b - 3a,2,1, Day", new String[]{"radiance_3a", "radiance_2", "radiance_1"}));
        profileManager.addProfile(new RGBImageProfile("AVHRR/3 L1b - 5,4,3b, Night", new String[]{"temp_5", "temp_4", "temp_3b"}));
        profileManager.addProfile(new RGBImageProfile("AVHRR/3 L1b - 5,4,3b, Night, Inverse", new String[]{"-temp_5", "-temp_4", "-temp_3b"}));
        profileManager.addProfile(new RGBImageProfile("AVHRR/3 L1b - Ionian, Day", new String[]{"radiance_1", "radiance_2", "-radiance_4"}));
    }

    static {
        AvhrrReaderPlugIn.registerRGBProfiles();
    }
}

