/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.dataio.avhrr.AvhrrConstants;
import org.esa.s3tbx.dataio.avhrr.AvhrrFile;
import org.esa.s3tbx.dataio.avhrr.AvhrrReaderPlugIn;
import org.esa.s3tbx.dataio.avhrr.BandReader;
import org.esa.s3tbx.dataio.avhrr.noaa.KlmAvhrrFile;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.maptransf.Datum;

public class AvhrrReader
extends AbstractProductReader
implements AvhrrConstants {
    protected Product product;
    protected AvhrrFile avhrrFile;
    protected Map<Band, BandReader> bandReaders = new HashMap<Band, BandReader>();

    public AvhrrReader(ProductReaderPlugIn avhrrReaderPlugIn) {
        super(avhrrReaderPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        File dataFile = AvhrrReaderPlugIn.getInputFile(this.getInput());
        try {
            this.avhrrFile = new KlmAvhrrFile(dataFile);
            this.avhrrFile.readHeader();
            this.createProduct();
            this.product.setFileLocation(dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        return this.product;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        BandReader bandReader = this.bandReaders.get(destBand);
        if (bandReader == null) {
            throw new IllegalStateException("no band reader available");
        }
        bandReader.readBandRasterData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBuffer, pm);
    }

    public void close() throws IOException {
        super.close();
        this.avhrrFile.dispose();
        this.avhrrFile = null;
        this.product = null;
    }

    protected void createProduct() throws IOException {
        this.product = new Product(this.avhrrFile.getProductName(), "AVHRR_3_L1B", this.avhrrFile.getProductWidth(), this.avhrrFile.getProductHeight(), (ProductReader)this);
        this.product.setDescription("AVHRR/3 Level-1b Data Product");
        int channel3ab = this.avhrrFile.getChannel3abState();
        this.product.addBand(this.createVisibleRadianceBand(0));
        this.product.addBand(this.createVisibleRadianceBand(1));
        if (channel3ab == 2) {
            this.product.addBand(this.createVisibleRadianceBand(2));
            this.product.addBand(this.createZeroFilledBand(3, "radiance_"));
        } else if (channel3ab == 3) {
            this.product.addBand(this.createZeroFilledBand(2, "radiance_"));
            this.product.addBand(this.createIrRadianceBand(3));
        } else {
            this.product.addBand(this.createVisibleRadianceBand(2));
            this.product.addBand(this.createIrRadianceBand(3));
        }
        this.product.addBand(this.createIrRadianceBand(4));
        this.product.addBand(this.createIrRadianceBand(5));
        this.product.addBand(this.createReflectanceFactorBand(0));
        this.product.addBand(this.createReflectanceFactorBand(1));
        if (channel3ab == 2) {
            this.product.addBand(this.createReflectanceFactorBand(2));
            this.product.addBand(this.createZeroFilledBand(3, "temp_"));
        } else if (channel3ab == 3) {
            this.product.addBand(this.createZeroFilledBand(2, "reflec_"));
            this.product.addBand(this.createIrTemperatureBand(3));
        } else {
            this.product.addBand(this.createReflectanceFactorBand(2));
            this.product.addBand(this.createIrTemperatureBand(3));
        }
        this.product.addBand(this.createIrTemperatureBand(4));
        this.product.addBand(this.createIrTemperatureBand(5));
        this.addFlagCodingAndBitmaskDef();
        this.addCloudBand();
        this.product.setStartTime(this.avhrrFile.getStartDate());
        this.product.setEndTime(this.avhrrFile.getEndDate());
        this.avhrrFile.addMetaData(this.product.getMetadataRoot());
        this.addTiePointGrids();
    }

    protected Band createVisibleRadianceBand(int channel) throws IOException {
        BandReader bandReader = this.avhrrFile.createVisibleRadianceBandReader(channel);
        return this.createBand(bandReader, channel);
    }

    protected Band createIrRadianceBand(int channel) throws IOException {
        BandReader bandReader = this.avhrrFile.createIrRadianceBandReader(channel);
        return this.createBand(bandReader, channel);
    }

    protected Band createIrTemperatureBand(int channel) throws IOException {
        BandReader bandReader = this.avhrrFile.createIrTemperatureBandReader(channel);
        return this.createBand(bandReader, channel);
    }

    protected Band createReflectanceFactorBand(int channel) {
        BandReader bandReader = this.avhrrFile.createReflectanceFactorBandReader(channel);
        return this.createBand(bandReader, channel);
    }

    protected Band createBand(BandReader bandReader, int channel) {
        Band band = new Band(bandReader.getBandName(), bandReader.getDataType(), this.avhrrFile.getProductWidth(), this.avhrrFile.getProductHeight());
        band.setScalingFactor(bandReader.getScalingFactor());
        band.setUnit(bandReader.getBandUnit());
        band.setDescription(bandReader.getBandDescription());
        band.setSpectralBandIndex(channel);
        band.setSpectralBandwidth(CH_BANDWIDTHS[channel]);
        band.setSpectralWavelength(CH_WAVELENGTHS[channel]);
        band.setValidPixelExpression(CH_VALID_MASK_EXPRESSIONS[channel]);
        band.setNoDataValue(0.0);
        band.setNoDataValueUsed(true);
        this.bandReaders.put(band, bandReader);
        return band;
    }

    protected Band createZeroFilledBand(int channel, String namePrefix) {
        String name = namePrefix + CH_STRINGS[channel];
        VirtualBand band = new VirtualBand(name, 30, this.avhrrFile.getProductWidth(), this.avhrrFile.getProductHeight(), "0");
        band.setUnit("-");
        band.setDescription("Zero-filled placeholder for " + name + ", no data available");
        band.setSpectralBandIndex(channel);
        band.setSpectralBandwidth(CH_BANDWIDTHS[channel]);
        band.setSpectralWavelength(CH_WAVELENGTHS[channel]);
        band.setValidPixelExpression(null);
        band.setNoDataValueUsed(true);
        band.setNoDataValue(0.0);
        return band;
    }

    protected void addFlagCodingAndBitmaskDef() {
        BandReader bandReader = this.avhrrFile.createFlagBandReader();
        Band flagsBand = new Band(bandReader.getBandName(), bandReader.getDataType(), this.avhrrFile.getProductWidth(), this.avhrrFile.getProductHeight());
        FlagCoding fc = new FlagCoding(bandReader.getBandName());
        fc.setDescription("Flag coding for AVHRR data quality");
        flagsBand.setSampleCoding((SampleCoding)fc);
        this.product.getFlagCodingGroup().add((ProductNode)fc);
        this.product.addBand(flagsBand);
        this.addFlagAndBitmaskDef(fc, "QUALITY_ERROR", "Set if any of the bits from the quality indicator bit-field are set", 0);
        this.addFlagAndBitmaskDef(fc, "SCANLINE_ERROR", "Set if any of the bits from the scanline quality flags are set", 1);
        this.addFlagAndBitmaskDef(fc, "CALIB_CH_3B_ERROR", "Set if any of the bits from the scanline quality flags are set", 2);
        this.addFlagAndBitmaskDef(fc, "CALIB_CH_4_ERROR", "Set if any of the bits from the scanline quality flags are set", 3);
        this.addFlagAndBitmaskDef(fc, "CALIB_CH_5_ERROR", "Set if any of the bits from the scanline quality flags are set", 4);
        this.addFlagAndBitmaskDef(fc, "FRAME_SYNC_ERROR", "Set if there are bit errors in the frame sync", 5);
        this.bandReaders.put(flagsBand, bandReader);
    }

    protected void addCloudBand() {
        if (this.avhrrFile.hasCloudBand()) {
            BandReader cloudReader = this.avhrrFile.createCloudBandReader();
            Band cloudMaskBand = new Band(cloudReader.getBandName(), cloudReader.getDataType(), this.avhrrFile.getProductWidth(), this.avhrrFile.getProductHeight());
            this.product.addBand(cloudMaskBand);
            String cloudBandName = cloudReader.getBandName();
            this.product.addMask("clear", cloudBandName + "==0", "", Color.LIGHT_GRAY, 0.4);
            this.product.addMask("probably_clear", cloudBandName + "==1", "", Color.YELLOW, 0.4);
            this.product.addMask("probably_cloudy", cloudBandName + "==2", "", Color.ORANGE, 0.4);
            this.product.addMask("cloudy", cloudBandName + "==3", "", Color.RED, 0.4);
            this.bandReaders.put(cloudMaskBand, cloudReader);
        }
    }

    protected void addFlagAndBitmaskDef(FlagCoding fc, String flagName, String flagDesc, int shift) {
        double rf1 = 0.0;
        double gf1 = 1.0;
        double bf1 = 0.5;
        double a = Math.PI * 2 * ((double)shift / 6.0);
        float r = (float)(0.5 + 0.5 * Math.sin(a + 0.0));
        float g = (float)(0.5 + 0.5 * Math.sin(a + Math.PI));
        float b = (float)(0.5 + 0.5 * Math.sin(a + 1.5707963267948966));
        Color color = new Color(r, g, b);
        fc.addFlag(flagName, 1 << shift, flagDesc);
        this.product.addMask(flagName, fc.getName() + "." + flagName, flagDesc, color, 0.4);
    }

    protected void addTiePointGrids() throws IOException {
        int tpSubsampling = this.avhrrFile.getTiePointSubsampling();
        int gridHeight = this.avhrrFile.getProductHeight() / tpSubsampling + 1;
        String[] tiePointNames = this.avhrrFile.getTiePointNames();
        float[][] tiePointData = this.avhrrFile.getTiePointData();
        int numGrids = tiePointNames.length;
        TiePointGrid[] grid = new TiePointGrid[numGrids];
        for (int i = 0; i < grid.length; ++i) {
            grid[i] = this.createTiePointGrid(tiePointNames[i], 51, gridHeight, 0.5, 0.5, tpSubsampling, tpSubsampling, tiePointData[i]);
            grid[i].setUnit("deg");
            this.product.addTiePointGrid(grid[i]);
        }
        TiePointGeoCoding geoCoding = new TiePointGeoCoding(grid[numGrids - 2], grid[numGrids - 1], Datum.WGS_72);
        this.product.setSceneGeoCoding((GeoCoding)geoCoding);
    }

    public static String format(String pattern, String arg) {
        return new MessageFormat(pattern).format(new Object[]{arg});
    }
}

