/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa.pod;

import java.awt.Rectangle;
import java.awt.image.Raster;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.util.math.CosineDistance;
import org.esa.snap.core.util.math.DistanceMeasure;

class PodPixelFinder {
    private static final int R = 128;
    private static final boolean ROUGH = false;
    private final PlanarImage lonImage;
    private final PlanarImage latImage;
    private final PlanarImage maskImage;
    private final double tolerance;
    private final int imageW;
    private final int imageH;

    PodPixelFinder(PlanarImage lonImage, PlanarImage latImage, PlanarImage maskImage, double angularTolerance) {
        this.lonImage = lonImage;
        this.latImage = latImage;
        this.maskImage = maskImage;
        this.tolerance = 1.0 - Math.cos(Math.toRadians(angularTolerance));
        this.imageW = lonImage.getWidth();
        this.imageH = lonImage.getHeight();
    }

    void findPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        int x = (int)Math.floor(pixelPos.x);
        int y = (int)Math.floor(pixelPos.y);
        if (x < 0) {
            x = 0;
        } else if (x >= this.imageW) {
            x = this.imageW - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.imageH) {
            y = this.imageH - 1;
        }
        int minX = Math.max(x - 128, 0);
        int minY = Math.max(y - 128, 0);
        int maxX = Math.min(x + 128, this.imageW - 1);
        int maxY = Math.min(y + 128, this.imageH - 1);
        Rectangle searchRegion = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
        Raster lonData = this.lonImage.getData(searchRegion);
        Raster latData = this.latImage.getData(searchRegion);
        Raster maskData = this.maskImage != null ? this.maskImage.getData(searchRegion) : null;
        double lon = geoPos.lon;
        double lat = geoPos.lat;
        CosineDistance d = new CosineDistance(lon, lat);
        Result result = new Result(lonData, latData, maskData, (DistanceMeasure)d, x, y, 2.0, false).invoke(x, y);
        for (int r = 128; r > 0; r >>= 1) {
            int midX = result.getX();
            int midY = result.getY();
            int outerMinX = Math.max(minX, midX - r);
            int outerMaxX = Math.min(maxX, midX + r);
            int outerMinY = Math.max(minY, midY - r);
            int outerMaxY = Math.min(maxY, midY + r);
            result.invoke(outerMinX, midY);
            result.invoke(outerMaxX, midY);
            result.invoke(midX, outerMaxY);
            result.invoke(midX, outerMinY);
            result.invoke(outerMinX, outerMinY);
            result.invoke(outerMinX, outerMaxY);
            result.invoke(outerMaxX, outerMaxY);
            result.invoke(outerMaxX, outerMinY);
        }
        if (result.isFound()) {
            pixelPos.setLocation((double)((float)result.getX() + 0.5f), (double)((float)result.getY() + 0.5f));
        } else {
            pixelPos.setInvalid();
        }
    }

    private final class Result {
        private final Raster lonData;
        private final Raster latData;
        private final Raster maskData;
        private final DistanceMeasure distanceMeasure;
        private int x;
        private int y;
        private double distance;
        private boolean found;

        public Result(Raster lonData, Raster latData, Raster maskData, DistanceMeasure distanceMeasure, int x, int y, double distance, boolean found) {
            this.lonData = lonData;
            this.latData = latData;
            this.maskData = maskData;
            this.distanceMeasure = distanceMeasure;
            this.x = x;
            this.y = y;
            this.distance = distance;
            this.found = found;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean isFound() {
            return this.found;
        }

        public Result invoke(int otherX, int otherY) {
            double lat;
            double lon;
            double d;
            if ((this.maskData == null || this.maskData.getSample(otherX, otherY, 0) != 0) && (d = this.distanceMeasure.distance(lon = this.lonData.getSampleDouble(otherX, otherY, 0), lat = this.latData.getSampleDouble(otherX, otherY, 0))) < this.distance) {
                this.x = otherX;
                this.y = otherY;
                this.distance = d;
                this.found = this.found || d < PodPixelFinder.this.tolerance;
            }
            return this;
        }
    }
}

