/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa;

import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import org.esa.s3tbx.dataio.avhrr.BandReader;
import org.esa.s3tbx.dataio.avhrr.calibration.Calibrator;
import org.esa.s3tbx.dataio.avhrr.noaa.CountReader10Bit;
import org.esa.s3tbx.dataio.avhrr.noaa.CountReader16Bit;
import org.esa.s3tbx.dataio.avhrr.noaa.CountReader8Bit;
import org.esa.s3tbx.dataio.avhrr.noaa.KlmAvhrrFile;
import org.esa.s3tbx.dataio.avhrr.noaa.ProductDimension;
import org.esa.snap.core.dataio.ProductIOException;

enum ProductFormat {
    HRPT_8BIT(12288, (Type)SimpleType.BYTE, 10240, ProductDimension.HRPT){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader8Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    HRPT_10BIT(15872, (Type)SimpleType.INT, 3414, ProductDimension.HRPT){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader10Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    HRPT_16BIT(22528, (Type)SimpleType.SHORT, 10240, ProductDimension.HRPT){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader16Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    GAC_8BIT(3584, (Type)SimpleType.BYTE, 2045, ProductDimension.GAC){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader8Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    GAC_10BIT(4608, (Type)SimpleType.INT, 682, ProductDimension.GAC){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader10Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    GAC_16BIT(5632, (Type)SimpleType.SHORT, 2045, ProductDimension.GAC){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader16Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    };

    private final int blockSize;
    private final ProductDimension productDimension;
    private final Type elementType;
    private final int elementCount;

    private ProductFormat(int blockSize, Type elementType, int elementCount, ProductDimension productDimension) {
        this.blockSize = blockSize;
        this.elementType = elementType;
        this.elementCount = elementCount;
        this.productDimension = productDimension;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public ProductDimension getProductDimension() {
        return this.productDimension;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public abstract BandReader createCountReader(int var1, KlmAvhrrFile var2, Calibrator var3);

    public static ProductFormat findByBlockSize(int blockSize) throws ProductIOException {
        ProductFormat[] values;
        for (ProductFormat productFormat : values = ProductFormat.values()) {
            if (productFormat.getBlockSize() != blockSize) continue;
            return productFormat;
        }
        throw new ProductIOException("Unsupported AVHRR data record size: " + blockSize);
    }
}

