/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import java.util.ArrayList;
import org.esa.s3tbx.dataio.avhrr.noaa.ProductFormat;
import org.esa.s3tbx.dataio.avhrr.noaa.TypeUtils;

class KlmTypes {
    static CompoundType arsHeaderOrderIdType = TypeBuilder.COMPOUND((String)"ORDER_ID", (CompoundMember[])new CompoundMember[]{TypeUtils.STRING_MEMBER("COST_NUMBER", 6), TypeUtils.STRING_MEMBER("CLASS_NUMBER", 8), TypeUtils.STRING_MEMBER("ORDER_CREATION_YEAR", 4), TypeUtils.STRING_MEMBER("ORDER_CREATION_DAY_OF_YEAR", 3), TypeUtils.STRING_MEMBER("PROCESSING_SITE", 1, TypeUtils.META().addItem("A", "CLASS").addItem("S", "NCDC/Suitland").addItem("N", "NCDC/Asheville")), TypeUtils.STRING_MEMBER("PROCESSING_SOFTWARE_ID", 8)});
    static CompoundType dataSelectionCriteria = TypeBuilder.COMPOUND((String)"DATA_SELECTION_CRITERIA", (CompoundMember[])new CompoundMember[]{TypeUtils.STRING_MEMBER("DATA_SET_NAME", 42), TypeUtils.STRING_MEMBER("fill", 2), TypeUtils.STRING_MEMBER("SELECT_FLAG", 1, TypeUtils.META().addItem("T", "Total Data Set Copy").addItem("S", "Selective Data Set Copy (Subset)")), TypeUtils.STRING_MEMBER("BEGINNIG_LATITUDE", 3, TypeUtils.META().setUnits("deg")), TypeUtils.STRING_MEMBER("ENDING_LATITUDE", 3, TypeUtils.META().setUnits("deg")), TypeUtils.STRING_MEMBER("BEGINNIG_LONGITUDE", 4, TypeUtils.META().setUnits("deg")), TypeUtils.STRING_MEMBER("ENDING_LONGITUDE", 4, TypeUtils.META().setUnits("deg")), TypeUtils.STRING_MEMBER("START_HOUR", 2), TypeUtils.STRING_MEMBER("START_MINUTE", 2), TypeUtils.STRING_MEMBER("NUMBER_OF_MINUTES", 3), TypeUtils.STRING_MEMBER("APPEND_DATA_FLAG", 1), TypeUtils.STRING_MEMBER("CHANNEL_SELECT_FLAGS", 20), TypeUtils.STRING_MEMBER("SENSOR_DATA_WORD_SIZE", 2)});
    static CompoundType dataSetSummary = TypeBuilder.COMPOUND((String)"DATA_SET_SUMMARY", (CompoundMember[])new CompoundMember[]{TypeUtils.STRING_MEMBER("fill", 27), TypeUtils.STRING_MEMBER("ASCEND_DESCEND_FLAG", 1, TypeUtils.META().addItem("A", "Ascending only").addItem("D", "Descending only").addItem("B", "Both ascending and descending")), TypeUtils.STRING_MEMBER("FIRST_LATITUDE", 3, TypeUtils.META().setUnits("deg").setDescription("First latitude value in the first data record")), TypeUtils.STRING_MEMBER("LAST_LATITUDE", 3, TypeUtils.META().setUnits("deg").setDescription("Last latitude value in the last data record")), TypeUtils.STRING_MEMBER("FIRST_LONGITUDE", 4, TypeUtils.META().setUnits("deg").setDescription("First longitude value in the first data record")), TypeUtils.STRING_MEMBER("LAST_LONGITUDE", 4, TypeUtils.META().setUnits("deg").setDescription("Last longitude value in the last data record")), TypeUtils.STRING_MEMBER("DATA_FORMAT", 20), TypeUtils.STRING_MEMBER("SIZE_OF_RECORDS", 6, TypeUtils.META().setUnits("bytes")), TypeUtils.STRING_MEMBER("NUMBER_OF_RECORDS", 6, TypeUtils.META().setDescription("Total, including ARS and Data Set Header Records"))});
    static CompoundType arsHeaderType = TypeBuilder.COMPOUND((String)"ARCHIVE_RETRIEVAL_SYSTEM_HEADER", (CompoundMember[])new CompoundMember[]{KlmTypes.COMPOUND_MEMBER(arsHeaderOrderIdType), KlmTypes.COMPOUND_MEMBER(dataSelectionCriteria), KlmTypes.COMPOUND_MEMBER(dataSetSummary), TypeUtils.STRING_MEMBER("fill", 319)});
    static CompoundType date = TypeBuilder.COMPOUND((String)"DATE", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"daysSince1950", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"year", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"dayOfYear", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"UTCmillis", (Type)TypeBuilder.UINT)});
    static CompoundType fileIdentification = TypeBuilder.COMPOUND((String)"FILE_IDENTIFICATION", (CompoundMember[])new CompoundMember[]{TypeUtils.STRING_MEMBER("DATA_SET_CREATION_SITE_ID", 3), TypeUtils.FILL_MEMBER(1), TypeUtils.META_MEMBER("NOAA_LEVEL_1B_FORMAT_VERSION_NUMBER", (Type)TypeBuilder.USHORT, TypeUtils.META().addItem(1, "TIROS-N, NOAA-6 through NOAA-14").addItem(2, "NOAA-15, -16, -17 (pre-April 28, 2005)").addItem(3, "All satellites post-April 28, 2005").addItem(4, "All satellites post-April 28, 2005 (with CLAVR-x)").addItem(5, "All satellites post-November 14, 2006 (with CLAVR-x)")), TypeUtils.META_MEMBER("NOAA_LEVEL_1B_FORMAT_VERSION_YEAR", (Type)TypeBuilder.USHORT, TypeUtils.META().setUnits("year")), TypeUtils.META_MEMBER("NOAA_LEVEL_1B_FORMAT_VERSION_DAY_OF_YEAR", (Type)TypeBuilder.USHORT, TypeUtils.META().setUnits("day")), TypeBuilder.MEMBER((String)"LOGICAL_RECORD_LENGTH", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"BLOCK_SIZE", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"COUNT_OF_HEADER_RECORDS", (Type)TypeBuilder.USHORT), TypeUtils.FILL_MEMBER(6), TypeUtils.STRING_MEMBER("DATA_SET_NAME", 42), TypeUtils.STRING_MEMBER("PROCESSING_BLOCK_IDENTIFICATION", 8), TypeUtils.META_MEMBER("NOAA_SPACECRAFT_IDENTIFICATION_CODE", (Type)TypeBuilder.USHORT, TypeUtils.META().addItem(2, "NOAA-16 (NOAA-L)").addItem(4, "NOAA-15 (NOAA-K)").addItem(6, "NOAA-17 (NOAA-M)").addItem(7, "NOAA-18 (NOAA-N)").addItem(8, "(NOAA-P)").addItem(11, "MetOp-1").addItem(12, "MetOp-A")), TypeBuilder.MEMBER((String)"INSTRUMENT_ID", (Type)TypeBuilder.USHORT), TypeUtils.META_MEMBER("DATA_TYPE_CODE", (Type)TypeBuilder.USHORT, TypeUtils.META().addItem(1, "LAC").addItem(2, "GAC").addItem(3, "HRPT").addItem(13, "FRAC")), TypeBuilder.MEMBER((String)"TIP_SOURCE_CODE", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"START_OF_DATA_SET", (Type)date), TypeBuilder.MEMBER((String)"END_OF_DATA_SET", (Type)date), TypeUtils.META_MEMBER("YEAR_OF_LAST_CPIDS_UPDATE", (Type)TypeBuilder.USHORT, TypeUtils.META().setUnits("year")), TypeUtils.META_MEMBER("DAY_OF_YEAR_OF_LAST_CPIDS_UPDATE", (Type)TypeBuilder.USHORT, TypeUtils.META().setUnits("day")), TypeUtils.FILL_MEMBER(8)});
    static CompoundType datasetQualityIndicators = TypeBuilder.COMPOUND((String)"DATA_SET_QUALITY_INDICATORS", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"INSTRUMENT_STATUS", (Type)TypeBuilder.UINT), TypeUtils.FILL_MEMBER(2), TypeBuilder.MEMBER((String)"RECORD_NUMBER_OF_STATUS_CHANGE", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"SECOND_INSTRUMENT_STATUS", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"COUNT_OF_DATA_RECORDS", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"COUNT_OF_CALIBRATED_EARTH_LOCATED_SCAN_LINES", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"COUNT_OF_MISSING_SCAN_LINES", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"COUNT_OF_DATA_GAPS", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"COUNT_OF_DATA_FRAMES_WITHOUT_FRAME_SYNC_WORD_ERRORS", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"COUNT_OF_PACS_DETECTED_TIP_PARITY_ERRORS", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"COUNT_OF_ALL_AUXILIARY_SYNC_ERRORS", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"TIME_SEQUENCE_ERROR", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"TIME_SEQUENCE_ERROR_CODE", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"SOCC_CLOCK_UPDATE_INDICATOR", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"EARTH_LOCATION_ERROR_INDICATOR", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"EARTH_LOCATION_ERROR_CODE", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"PACS_STATUS_BIT_FIELD", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"PACS_DATA_SOURCE", (Type)TypeBuilder.USHORT), TypeUtils.FILL_MEMBER(4), TypeUtils.STRING_MEMBER("INGESTER", 8), TypeUtils.STRING_MEMBER("DECOMUTATION", 8), TypeUtils.FILL_MEMBER(10)});
    static CompoundType calibration = TypeBuilder.COMPOUND((String)"CALIBRATION", (CompoundMember[])new CompoundMember[]{TypeUtils.FILL_MEMBER(70)});
    static CompoundType radianceConversion = TypeBuilder.COMPOUND((String)"RADIANCE_CONVERSION", (CompoundMember[])new CompoundMember[]{TypeUtils.META_MEMBER("CHANNEL_1_SOLAR_IRRADIANCE", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(0.1)), TypeUtils.META_MEMBER("CHANNEL_1_EQUIVALENT_WIDTH", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(0.001)), TypeUtils.META_MEMBER("CHANNEL_2_SOLAR_IRRADIANCE", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(0.1)), TypeUtils.META_MEMBER("CHANNEL_2_EQUIVALENT_WIDTH", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(0.001)), TypeUtils.META_MEMBER("CHANNEL_3A_SOLAR_IRRADIANCE", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(0.1)), TypeUtils.META_MEMBER("CHANNEL_3A_EQUIVALENT_WIDTH", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(0.001)), TypeUtils.META_MEMBER("CHANNEL_3B_CENTRAL_WAVENUMBER", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(0.01).setUnits("1/cm")), TypeUtils.META_MEMBER("CHANNEL_3B_CONSTANT_1", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5)), TypeUtils.META_MEMBER("CHANNEL_3B_CONSTANT_2", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-6)), TypeUtils.META_MEMBER("CHANNEL_4_CENTRAL_WAVENUMBER", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(0.001).setUnits("1/cm")), TypeUtils.META_MEMBER("CHANNEL_4_CONSTANT_1", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5)), TypeUtils.META_MEMBER("CHANNEL_4_CONSTANT_2", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-6)), TypeUtils.META_MEMBER("CHANNEL_5_CENTRAL_WAVENUMBER", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(0.001).setUnits("1/cm")), TypeUtils.META_MEMBER("CHANNEL_5_CONSTANT_1", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5)), TypeUtils.META_MEMBER("CHANNEL_5_CONSTANT_2", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-6)), TypeUtils.FILL_MEMBER(12)});
    static CompoundType navigation = TypeBuilder.COMPOUND((String)"NAVIGATION", (CompoundMember[])new CompoundMember[]{TypeUtils.STRING_MEMBER("REFERENCE_ELIPSOID_MODEL_ID", 8), TypeUtils.META_MEMBER("NADIR_EARTH_LOCATION_TOLERANCE", (Type)TypeBuilder.USHORT, TypeUtils.META().setScalingFactor(0.1).setUnits("km")), TypeBuilder.MEMBER((String)"EARTH_LOCATION_BIT_FIELD", (Type)TypeBuilder.USHORT), TypeUtils.FILL_MEMBER(2), TypeUtils.META_MEMBER("CONSTANT_ROLL_ATTITUDE_ERROR", (Type)TypeBuilder.SHORT, TypeUtils.META().setScalingFactor(0.001).setUnits("deg")), TypeUtils.META_MEMBER("CONSTANT_PITCH_ATTITUDE_ERROR", (Type)TypeBuilder.SHORT, TypeUtils.META().setScalingFactor(0.001).setUnits("deg")), TypeUtils.META_MEMBER("CONSTANT_YAW_ATTITUDE_ERROR", (Type)TypeBuilder.SHORT, TypeUtils.META().setScalingFactor(0.001).setUnits("deg")), TypeUtils.META_MEMBER("EPOCH_YEAR_FOR_ORBIT_VECTOR", (Type)TypeBuilder.USHORT, TypeUtils.META().setUnits("year")), TypeUtils.META_MEMBER("DAY_OF_EPOCH_YEAR_FOR_ORBIT_VECTOR", (Type)TypeBuilder.USHORT, TypeUtils.META().setUnits("day")), TypeUtils.META_MEMBER("EPOCH_UTC_TIME_OF_DAY_FOR_ORBIT_VECTOR", (Type)TypeBuilder.UINT, TypeUtils.META().setUnits("ms")), TypeUtils.META_MEMBER("SEMI_MAJOR_AXIS", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("km")), TypeUtils.META_MEMBER("ECCENTRICITY", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-8)), TypeUtils.META_MEMBER("INCLINATION", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("deg")), TypeUtils.META_MEMBER("ARGUMENT_OF_PERIGEE", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("deg")), TypeUtils.META_MEMBER("RIGHT_ASCENSION_OF_THE_ASCENDING_NODE", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("deg")), TypeUtils.META_MEMBER("MEAN_ANOMALY", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("deg")), TypeUtils.META_MEMBER("POSITION_VECTOR_X_COMPONENT", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("km")), TypeUtils.META_MEMBER("POSITION_VECTOR_Y_COMPONENT", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("km")), TypeUtils.META_MEMBER("POSITION_VECTOR_Z_COMPONENT", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("km")), TypeUtils.META_MEMBER("VELOCITY_VECTOR_X_DOT_COMPONENT", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-8).setUnits("km")), TypeUtils.META_MEMBER("VELOCITY_VECTOR_Y_DOT_COMPONENT", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-8).setUnits("km")), TypeUtils.META_MEMBER("VELOCITY_VECTOR_Z_DOT_COMPONENT", (Type)TypeBuilder.INT, TypeUtils.META().setScalingFactor(1.0E-8).setUnits("km")), TypeUtils.META_MEMBER("EARTH_SUN_DISTANCE_RATIO", (Type)TypeBuilder.UINT, TypeUtils.META().setScalingFactor(1.0E-6)), TypeUtils.FILL_MEMBER(16)});

    KlmTypes() {
    }

    private static CompoundMember COMPOUND_MEMBER(CompoundType compoundType) {
        return TypeBuilder.MEMBER((String)compoundType.getName(), (Type)compoundType);
    }

    private static CompoundType getHeaderRecordType(int blockSize) {
        int headFill = blockSize - fileIdentification.getSize() - datasetQualityIndicators.getSize() - calibration.getSize() - radianceConversion.getSize() - navigation.getSize() - 528 - 36 - 2;
        return TypeBuilder.COMPOUND((String)"HeaderRecord", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"FILE_IDENTIFICATION", (Type)fileIdentification), TypeBuilder.MEMBER((String)"DATA_SET_QUALITY_INDICATORS", (Type)datasetQualityIndicators), TypeBuilder.MEMBER((String)"CALIBRATION", (Type)calibration), TypeBuilder.MEMBER((String)"RADIANCE_CONVERSION", (Type)radianceConversion), TypeBuilder.MEMBER((String)"NAVIGATION", (Type)navigation), TypeUtils.FILL_MEMBER(528), TypeUtils.FILL_MEMBER(36), TypeBuilder.MEMBER((String)"CLAVR_STATUS", (Type)TypeBuilder.USHORT), TypeUtils.FILL_MEMBER(headFill)});
    }

    private static CompoundType getDataRecordType(ProductFormat productFormat) {
        int endFillBytes = productFormat.getBlockSize() - 14 - 10 - 16 - 8 - TypeBuilder.INT.getSize() * 63 - 12 - 16 - TypeBuilder.SHORT.getSize() * 153 - 6 - 408 - 8 - 208 - productFormat.getElementType().getSize() * productFormat.getElementCount() - 8 - 16 - 32 - 4 - 4 - productFormat.getProductDimension().getCloudBytes();
        return TypeBuilder.COMPOUND((String)"DataRecord", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"SCANLINE_NUMBER", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"SCANLINE_YEAR", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"SCANLINE_DAY_OF_YEAR", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"SATELLITE _CLOCK_DRIFT_DELTA", (Type)TypeBuilder.SHORT), TypeBuilder.MEMBER((String)"SCANLINE_UTC_TIME_OF_DAY", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"SCANLINE_BIT_FIELD", (Type)TypeBuilder.USHORT), TypeUtils.FILL_MEMBER(10), TypeBuilder.MEMBER((String)"QUALITY_INDICATOR_BIT_FIELD", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"SCANLINE_QUALITY_FLAGS", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"CALIBRATION_QUALITY_FLAGS_3B", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"CALIBRATION_QUALITY_FLAGS_4", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"CALIBRATION_QUALITY_FLAGS_5", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"COUNT_OF_BIT_ERRORS_IN_FRAME_SYNC", (Type)TypeBuilder.USHORT), TypeUtils.FILL_MEMBER(8), TypeBuilder.MEMBER((String)"CALIBRATION_COEFFICIENTS", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.INT, (int)63)), TypeUtils.FILL_MEMBER(12), TypeBuilder.MEMBER((String)"NAVIGATION_STATUS_BIT_FIELD", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"TIP_EULER_ANGLES_TIME", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"TIP_EULER_ANGLES", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.SHORT, (int)3)), TypeBuilder.MEMBER((String)"SPACECRAFT_ALTITUDE", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"ANGULAR_RELATIONSHIPS", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.SHORT, (int)153)), TypeUtils.FILL_MEMBER(6), TypeBuilder.MEMBER((String)"EARTH_LOCATION", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.INT, (int)102)), TypeUtils.FILL_MEMBER(8), TypeUtils.FILL_MEMBER(208), TypeBuilder.MEMBER((String)"AVHRR_SENSOR_DATA", (Type)TypeBuilder.SEQUENCE((Type)productFormat.getElementType(), (int)productFormat.getElementCount())), TypeUtils.FILL_MEMBER(8), TypeUtils.FILL_MEMBER(16), TypeUtils.FILL_MEMBER(32), TypeBuilder.MEMBER((String)"CLAVR_STATUS_BIT_FIELD", (Type)TypeBuilder.UINT), TypeUtils.FILL_MEMBER(4), TypeBuilder.MEMBER((String)"CCM", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.UBYTE, (int)productFormat.getProductDimension().getCloudBytes())), TypeUtils.FILL_MEMBER(endFillBytes)});
    }

    static CompoundType getFileType(boolean hasArsHeader, ProductFormat productFormat, int dataRecordcount) {
        ArrayList<CompoundMember> members = new ArrayList<CompoundMember>(3);
        if (hasArsHeader) {
            members.add(TypeBuilder.MEMBER((String)"ArsRecord", (Type)arsHeaderType));
        }
        members.add(TypeBuilder.MEMBER((String)"HeaderRecord", (Type)KlmTypes.getHeaderRecordType(productFormat.getBlockSize())));
        CompoundType dataRecordType = KlmTypes.getDataRecordType(productFormat);
        members.add(TypeBuilder.MEMBER((String)"DataRecord", (Type)TypeBuilder.SEQUENCE((Type)dataRecordType, (int)dataRecordcount)));
        return TypeBuilder.COMPOUND((String)"NOAA", (CompoundMember[])members.toArray(new CompoundMember[members.size()]));
    }
}

