/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import com.bc.ceres.binio.util.RandomAccessFileIOHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.esa.s3tbx.dataio.avhrr.noaa.HeaderWrapper;
import org.esa.s3tbx.dataio.avhrr.noaa.ProductFormat;
import org.esa.snap.core.dataio.DecodeQualification;

class KlmFormatDetector {
    private static final List<String> DATASET_CREATION_SITES = Arrays.asList("CMS", "DSS", "NSS", "UKM");
    private static final CompoundType ARS_HEADER_DETECTOR_TYPE = TypeBuilder.COMPOUND((String)"test", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"no_ars_dscs", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.BYTE, (int)3)), TypeBuilder.MEMBER((String)"fill", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.BYTE, (int)509)), TypeBuilder.MEMBER((String)"ars_dscs", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.BYTE, (int)3))});
    private DecodeQualification decodeQualification = DecodeQualification.UNABLE;
    private boolean hasArsHeader;
    private RandomAccessFile raf;
    private IOHandler ioHandler;

    KlmFormatDetector(File file) throws FileNotFoundException {
        this.raf = new RandomAccessFile(file, "r");
        this.ioHandler = new RandomAccessFileIOHandler(this.raf);
        this.detectArsHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProductFormat getProductFormat() throws IOException {
        CompoundType type = this.hasArsHeader ? TypeBuilder.COMPOUND((String)"test", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"arsHeader", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.BYTE, (int)512)), TypeBuilder.MEMBER((String)"dataHeader", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.SHORT, (int)15000))}) : TypeBuilder.COMPOUND((String)"test", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"dataHeader", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.SHORT, (int)15000))});
        DataFormat dataFormat = new DataFormat(type, ByteOrder.BIG_ENDIAN);
        DataContext context = null;
        try {
            context = dataFormat.createContext(this.ioHandler);
            CompoundData data = context.getData();
            SequenceData dataHeader = data.getSequence("dataHeader");
            int index = 500;
            while ((long)index < dataHeader.getSize() - 4L) {
                if (dataHeader.getShort(index) != 0) {
                    short year = dataHeader.getShort(index + 1);
                    short dayOfYear = dataHeader.getShort(index + 2);
                    if (year > 1970 && year < 2050 && dayOfYear > 0 && dayOfYear < 367) {
                        ProductFormat productFormat = ProductFormat.findByBlockSize(index * 2);
                        return productFormat;
                    }
                }
                ++index;
            }
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
        throw new IOException("Could not detect AVHRR data record size.");
    }

    public void dispose() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.raf = null;
            this.ioHandler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectArsHeader() {
        DataFormat dataFormat = new DataFormat(ARS_HEADER_DETECTOR_TYPE, ByteOrder.BIG_ENDIAN);
        DataContext context = null;
        try {
            context = dataFormat.createContext(this.ioHandler);
            CompoundData data = context.getData();
            String s1 = HeaderWrapper.getAsString(data.getSequence(0));
            String s2 = HeaderWrapper.getAsString(data.getSequence(2));
            if (DATASET_CREATION_SITES.contains(s1)) {
                this.hasArsHeader = false;
                this.decodeQualification = DecodeQualification.INTENDED;
            } else if (DATASET_CREATION_SITES.contains(s2)) {
                this.decodeQualification = DecodeQualification.INTENDED;
                this.hasArsHeader = true;
            }
        }
        catch (Throwable ignore) {
            this.decodeQualification = DecodeQualification.UNABLE;
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
    }

    public boolean canDecode() {
        return this.decodeQualification == DecodeQualification.INTENDED;
    }

    boolean hasArsHeader() {
        return this.hasArsHeader;
    }
}

