/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import org.esa.s3tbx.dataio.avhrr.AvhrrConstants;
import org.esa.s3tbx.dataio.avhrr.calibration.Calibrator;
import org.esa.s3tbx.dataio.avhrr.noaa.CountReader;
import org.esa.s3tbx.dataio.avhrr.noaa.KlmAvhrrFile;

class CountReader8Bit
extends CountReader {
    private byte[] scanLineBuffer;

    public CountReader8Bit(int channel, KlmAvhrrFile noaaFile, Calibrator calibrator, int elementCount, int dataWidth) {
        super(channel, noaaFile, calibrator, dataWidth);
        this.scanLineBuffer = new byte[elementCount];
    }

    @Override
    protected void readData(int rawY) throws IOException {
        CompoundData dataRecord = this.noaaFile.getDataRecord(rawY);
        SequenceData avhrr_sensor_data = dataRecord.getSequence("AVHRR_SENSOR_DATA");
        for (int i = 0; i < this.scanLineBuffer.length; ++i) {
            this.scanLineBuffer[i] = avhrr_sensor_data.getByte(i);
        }
        this.extractCounts(this.scanLineBuffer);
    }

    private void extractCounts(byte[] rawData) {
        int indexRaw = AvhrrConstants.CH_DATASET_INDEXES[this.channel];
        for (int i = 0; i < this.lineOfCounts.length; ++i) {
            this.lineOfCounts[i] = rawData[indexRaw] & 0xFF;
            indexRaw += 5;
        }
    }
}

