/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import org.esa.s3tbx.dataio.avhrr.AvhrrConstants;
import org.esa.s3tbx.dataio.avhrr.calibration.Calibrator;
import org.esa.s3tbx.dataio.avhrr.noaa.CountReader;
import org.esa.s3tbx.dataio.avhrr.noaa.KlmAvhrrFile;

class CountReader10Bit
extends CountReader {
    private static final int TEN_BITS = 1023;
    private static final int[] FIRST = new int[]{0, 0, 0, 1, 1};
    private static final int[][] INCREMENT = new int[][]{{1, 2, 2}, {2, 1, 2}, {2, 2, 1}, {1, 2, 2}, {2, 1, 2}};
    private static final int[][] SHIFT = new int[][]{{20, 0, 10}, {10, 20, 0}, {0, 10, 20}, {20, 0, 10}, {10, 20, 0}};
    private int[] scanLineBuffer;
    private final int elementCount;

    public CountReader10Bit(int channel, KlmAvhrrFile noaaFile, Calibrator calibrator, int elementCount, int dataWidth) {
        super(channel, noaaFile, calibrator, dataWidth);
        this.elementCount = elementCount;
        this.scanLineBuffer = new int[elementCount];
    }

    @Override
    protected void readData(int rawY) throws IOException {
        CompoundData dataRecord = this.noaaFile.getDataRecord(rawY);
        SequenceData avhrr_sensor_data = dataRecord.getSequence("AVHRR_SENSOR_DATA");
        for (int i = 0; i < this.scanLineBuffer.length; ++i) {
            this.scanLineBuffer[i] = avhrr_sensor_data.getInt(i);
        }
        this.extractCounts(this.scanLineBuffer);
    }

    private void extractCounts(int[] rawData) {
        int j = 0;
        int bandNo = AvhrrConstants.CH_DATASET_INDEXES[this.channel];
        int indexRaw = FIRST[bandNo];
        for (int i = 0; i < this.lineOfCounts.length; ++i) {
            this.lineOfCounts[i] = (rawData[indexRaw] & 1023 << SHIFT[bandNo][j]) >> SHIFT[bandNo][j];
            indexRaw += INCREMENT[bandNo][j];
            j = j == 2 ? 0 : j + 1;
        }
    }

    private void extractCountsSlowButSimple(int[] rawData) {
        int bandNo = AvhrrConstants.CH_DATASET_INDEXES[this.channel];
        int indexInBand = 0;
        int bandNum = 0;
        int[] c = new int[3];
        block0: for (int i = 0; i < this.elementCount; ++i) {
            int rawValue = rawData[i];
            c[0] = (rawValue & 0x3FF00000) >> 20;
            c[1] = (rawValue & 0xFFC00) >> 10;
            c[2] = rawValue & 0x3FF;
            for (int ci = 0; ci < 3; ++ci) {
                if (bandNum == bandNo) {
                    this.lineOfCounts[indexInBand] = c[ci];
                }
                if (++bandNum == 5) {
                    bandNum = 0;
                    ++indexInBand;
                }
                if (i == this.elementCount - 1) continue block0;
            }
        }
    }
}

