/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.metop;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.datamodel.ProductData;

class GenericRecordHeader {
    public RecordClass recordClass;
    public InstrumentGroup instrumentGroup;
    public int recordSubclass;
    public int recordSubclassVersion;
    public long recordSize;
    public ProductData.UTC recordStartTime;
    public ProductData.UTC recordEndTime;

    GenericRecordHeader() {
    }

    public boolean readGenericRecordHeader(ImageInputStream imageInputStream) throws IOException {
        byte rc = imageInputStream.readByte();
        if (!RecordClass.isValid(rc)) {
            return false;
        }
        this.recordClass = RecordClass.values()[rc];
        byte ig = imageInputStream.readByte();
        if (!InstrumentGroup.isValid(ig)) {
            return false;
        }
        this.instrumentGroup = InstrumentGroup.values()[ig];
        this.recordSubclass = imageInputStream.readByte();
        this.recordSubclassVersion = imageInputStream.readByte();
        this.recordSize = imageInputStream.readUnsignedInt();
        int day = imageInputStream.readUnsignedShort();
        long millis = imageInputStream.readUnsignedInt();
        long seconds = millis / 1000L;
        long micros = (millis - seconds * 1000L) * 1000L;
        this.recordStartTime = new ProductData.UTC(day, (int)seconds, (int)micros);
        day = imageInputStream.readUnsignedShort();
        millis = imageInputStream.readUnsignedInt();
        seconds = millis / 1000L;
        micros = (millis - seconds * 1000L) * 1000L;
        this.recordEndTime = new ProductData.UTC(day, (int)seconds, (int)micros);
        return true;
    }

    public void printGRH() {
        System.out.println("GRH");
        System.out.println("recordClass: " + (Object)((Object)this.recordClass));
        System.out.println("instrumentGroup: " + (Object)((Object)this.instrumentGroup));
        System.out.println("recordSubclass: " + this.recordSubclass);
        System.out.println("recordSubclassVersion: " + this.recordSubclassVersion);
        System.out.println("recordSize: " + this.recordSize);
    }

    public static enum InstrumentGroup {
        GENERIC,
        AMSU_A,
        ASCAT,
        ATOVS,
        AVHRR_3,
        GOME,
        GRAS,
        HIRS_4,
        IASI,
        MHS,
        SEM,
        ADCS,
        SBUV,
        DUMMY,
        ARCHIVE,
        IASI_L2;


        public static boolean isValid(int index) {
            return index >= 0 && index <= 15;
        }
    }

    public static enum RecordClass {
        RESERVED,
        MPHR,
        SPHR,
        IPR,
        GEADR,
        GIADR,
        VEADR,
        VIADR,
        MDR;


        public static boolean isValid(int index) {
            return index >= 0 && index <= 8;
        }
    }
}

