/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa.pod;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import javax.media.jai.PlanarImage;
import org.esa.s3tbx.dataio.avhrr.noaa.pod.PodPixelFinder;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.GeoApproximation;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PixelPosEstimator;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;

final class PodGeoCoding
extends TiePointGeoCoding {
    private transient PixelPosEstimator pixelPosEstimator;
    private transient PodPixelFinder pixelFinder;
    private transient GeoApproximation[] approximations;
    private transient PlanarImage latImage;

    PodGeoCoding(TiePointGrid latGrid, TiePointGrid lonGrid) {
        this(latGrid, lonGrid, PodGeoCoding.createApproximations((PlanarImage)lonGrid.getGeophysicalImage(), (PlanarImage)latGrid.getGeophysicalImage()));
    }

    private PodGeoCoding(TiePointGrid latGrid, TiePointGrid lonGrid, GeoApproximation[] approximations) {
        super(latGrid, lonGrid);
        this.approximations = approximations;
        MultiLevelImage lonImage = lonGrid.getGeophysicalImage();
        this.latImage = latGrid.getGeophysicalImage();
        Rectangle bounds = new Rectangle(0, 0, lonGrid.getRasterWidth(), lonGrid.getRasterHeight());
        this.pixelPosEstimator = new PixelPosEstimator(approximations, bounds);
        this.pixelFinder = new PodPixelFinder((PlanarImage)lonImage, this.latImage, null, 0.01);
    }

    public boolean canGetPixelPos() {
        return this.pixelPosEstimator.canGetPixelPos();
    }

    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (this.pixelPosEstimator.canGetPixelPos()) {
            if (pixelPos == null) {
                pixelPos = new PixelPos();
            }
            this.pixelPosEstimator.getPixelPos(geoPos, pixelPos);
            if (pixelPos.isValid()) {
                int x = (int)Math.floor(pixelPos.x);
                int y = (int)Math.floor(pixelPos.y);
                try {
                    double lat = this.latImage.getData(new Rectangle(x, y, 1, 1)).getSampleDouble(x, y, 0);
                    if (Math.abs(lat - geoPos.getLat()) > 0.5) {
                        pixelPos.setInvalid();
                    }
                }
                catch (IllegalArgumentException iae) {
                    this.pixelPosEstimator.getPixelPos(geoPos, pixelPos);
                }
            }
        } else {
            super.getPixelPos(geoPos, pixelPos);
        }
        return pixelPos;
    }

    private static GeoApproximation[] createApproximations(PlanarImage lonImage, PlanarImage latImage) {
        return GeoApproximation.createApproximations((PlanarImage)lonImage, (PlanarImage)latImage, null, (double)0.5);
    }

    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        TiePointGrid lonGrid;
        String latGridName = this.getLatGrid().getName();
        String lonGridName = this.getLonGrid().getName();
        Product destProduct = destScene.getProduct();
        TiePointGrid latGrid = destProduct.getTiePointGrid(latGridName);
        if (latGrid == null) {
            latGrid = TiePointGrid.createSubset((TiePointGrid)this.getLatGrid(), (ProductSubsetDef)subsetDef);
            destProduct.addTiePointGrid(latGrid);
        }
        if ((lonGrid = destProduct.getTiePointGrid(lonGridName)) == null) {
            lonGrid = TiePointGrid.createSubset((TiePointGrid)this.getLonGrid(), (ProductSubsetDef)subsetDef);
            destProduct.addTiePointGrid(lonGrid);
        }
        if (latGrid != null && lonGrid != null) {
            if (subsetDef == null || subsetDef.getRegion() == null) {
                destScene.setGeoCoding((GeoCoding)new PodGeoCoding(latGrid, lonGrid, this.approximations));
            } else {
                destScene.setGeoCoding((GeoCoding)new PodGeoCoding(latGrid, lonGrid));
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        this.pixelFinder = null;
        this.pixelPosEstimator = null;
        this.approximations = null;
        this.latImage = null;
    }
}

