/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.metop;

import org.esa.s3tbx.dataio.avhrr.calibration.RadianceCalibrator;

public class MetopRad2ReflFactorCalibrator
implements RadianceCalibrator {
    private float conversionFactor;

    public MetopRad2ReflFactorCalibrator(double solarIrradiance, double earthSunDistance) {
        this.conversionFactor = (float)(solarIrradiance / (314.1592653589793 * earthSunDistance * earthSunDistance));
    }

    @Override
    public float calibrate(float radiances) {
        return radiances / this.conversionFactor;
    }

    public float getConversionFactor() {
        return this.conversionFactor;
    }
}

