/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.metop;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.stream.ImageInputStream;
import org.esa.s3tbx.dataio.avhrr.AvhrrConstants;
import org.esa.s3tbx.dataio.avhrr.AvhrrFile;
import org.esa.s3tbx.dataio.avhrr.calibration.RadianceCalibrator;
import org.esa.s3tbx.dataio.avhrr.metop.MetopFile;
import org.esa.s3tbx.dataio.avhrr.metop.PlainBandReader;
import org.esa.snap.core.datamodel.ProductData;

class CalibratedBandReader
extends PlainBandReader {
    private final RadianceCalibrator calibrator;

    public CalibratedBandReader(int channel, MetopFile metopFile, ImageInputStream inputStream, RadianceCalibrator radianceCalibrator) {
        super(channel, metopFile, inputStream);
        this.calibrator = radianceCalibrator;
    }

    @Override
    public String getBandName() {
        if (this.isVisibleBand()) {
            return "reflec_" + AvhrrConstants.CH_STRINGS[this.channel];
        }
        return "temp_" + AvhrrConstants.CH_STRINGS[this.channel];
    }

    @Override
    public String getBandUnit() {
        if (this.isVisibleBand()) {
            return "%";
        }
        return "K";
    }

    @Override
    public String getBandDescription() {
        if (this.isVisibleBand()) {
            return CalibratedBandReader.format("Reflectance factor for channel {0}", AvhrrConstants.CH_STRINGS[this.channel]);
        }
        return CalibratedBandReader.format("Blackbody temperature for channel {0}", AvhrrConstants.CH_STRINGS[this.channel]);
    }

    @Override
    public double getScalingFactor() {
        return 1.0;
    }

    @Override
    public int getDataType() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        AvhrrFile.RawCoordinates rawCoord = this.metopFile.getRawCoordinates(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight);
        float[] targetData = (float[])destBuffer.getElems();
        float scalingFactor = (float)super.getScalingFactor();
        pm.beginTask(MessageFormat.format("Reading AVHRR band ''{0}''...", this.getBandName()), rawCoord.maxY - rawCoord.minY);
        int targetIdx = rawCoord.targetStart;
        for (int sourceY = rawCoord.minY; sourceY <= rawCoord.maxY && !pm.isCanceled(); sourceY += sourceStepY) {
            if (this.hasData(sourceY)) {
                int dataOffset = this.getDataOffset(sourceOffsetX, sourceY);
                ImageInputStream imageInputStream = this.inputStream;
                synchronized (imageInputStream) {
                    short[] radianceScanLine = new short[this.metopFile.getProductWidth()];
                    this.inputStream.seek(dataOffset);
                    this.inputStream.readFully(radianceScanLine, 0, sourceWidth);
                    for (int sourceX = 0; sourceX <= sourceWidth - 1; ++sourceX) {
                        targetData[targetIdx] = this.calibrator.calibrate((float)radianceScanLine[sourceX] * scalingFactor);
                        targetIdx += rawCoord.targetIncrement;
                    }
                }
            } else {
                for (int sourceX = rawCoord.minX; sourceX <= rawCoord.maxX; sourceX += sourceStepX) {
                    targetData[targetIdx] = 0.0f;
                    targetIdx += rawCoord.targetIncrement;
                }
            }
            pm.worked(1);
        }
        pm.done();
    }

    private static String format(String pattern, String arg) {
        return new MessageFormat(pattern).format(new Object[]{arg});
    }
}

