/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.calibration;

import org.esa.s3tbx.dataio.avhrr.AvhrrConstants;
import org.esa.s3tbx.dataio.avhrr.AvhrrReader;
import org.esa.s3tbx.dataio.avhrr.calibration.IrRadianceCalibrator;
import org.esa.s3tbx.dataio.avhrr.calibration.Radiance2TemperatureCalibrator;

public class IrTemperatureCalibrator
extends IrRadianceCalibrator {
    private Radiance2TemperatureCalibrator radianceCalibrator;

    public IrTemperatureCalibrator(int channel) {
        super(channel);
    }

    @Override
    public String getBandName() {
        return "temp_" + AvhrrConstants.CH_STRINGS[this.channel];
    }

    @Override
    public String getBandUnit() {
        return "K";
    }

    @Override
    public String getBandDescription() {
        return AvhrrReader.format("Blackbody temperature for channel {0}", AvhrrConstants.CH_STRINGS[this.channel]);
    }

    public void setHeaderConstants(double constant1, double constant2, double vc) {
        this.radianceCalibrator = new Radiance2TemperatureCalibrator(constant1, constant2, vc);
    }

    @Override
    public float calibrate(int counts) {
        float radiance = super.calibrate(counts);
        return this.radianceCalibrator.calibrate(radiance);
    }
}

