/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.calibration;

import org.esa.s3tbx.dataio.avhrr.AvhrrConstants;
import org.esa.s3tbx.dataio.avhrr.AvhrrReader;
import org.esa.s3tbx.dataio.avhrr.calibration.AbstractCalibrator;

public class CountsCalibrator
extends AbstractCalibrator {
    public CountsCalibrator(int channel) {
        super(channel);
    }

    @Override
    public String getBandName() {
        return "counts_" + AvhrrConstants.CH_STRINGS[this.channel];
    }

    @Override
    public String getBandUnit() {
        return "DL";
    }

    @Override
    public String getBandDescription() {
        return AvhrrReader.format("Raw counts for channel {0}", AvhrrConstants.CH_STRINGS[this.channel]);
    }

    @Override
    public boolean requiresCalibrationData() {
        return false;
    }

    @Override
    public boolean processCalibrationData(int[] calibrationData) {
        return true;
    }

    @Override
    public float calibrate(int counts) {
        return counts;
    }
}

